/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor;

import java.util.List;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cmd.UnlockJobCmd;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.ExecuteJobHelper;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutorContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutorLogger;

public class ExecuteJobsRunnable
implements Runnable {
    private static final JobExecutorLogger LOG = ProcessEngineLogger.JOB_EXECUTOR_LOGGER;
    protected final List<String> jobIds;
    protected JobExecutor jobExecutor;
    protected ProcessEngineImpl processEngine;

    public ExecuteJobsRunnable(List<String> jobIds, ProcessEngineImpl processEngine) {
        this.jobIds = jobIds;
        this.processEngine = processEngine;
        this.jobExecutor = processEngine.getProcessEngineConfiguration().getJobExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block10: {
            JobExecutorContext jobExecutorContext = new JobExecutorContext();
            List<String> currentProcessorJobQueue = jobExecutorContext.getCurrentProcessorJobQueue();
            CommandExecutor commandExecutor = this.processEngine.getProcessEngineConfiguration().getCommandExecutorTxRequired();
            currentProcessorJobQueue.addAll(this.jobIds);
            Context.setJobExecutorContext(jobExecutorContext);
            block7: while (true) {
                while (!currentProcessorJobQueue.isEmpty()) {
                    String nextJobId = currentProcessorJobQueue.remove(0);
                    if (this.jobExecutor.isActive()) {
                        try {
                            ExecuteJobHelper.executeJob(nextJobId, commandExecutor);
                            continue block7;
                        }
                        catch (Throwable t) {
                            LOG.exceptionWhileExecutingJob(nextJobId, t);
                            continue;
                        }
                    }
                    try {
                        this.unlockJob(nextJobId, commandExecutor);
                        continue block7;
                    }
                    catch (Throwable t) {
                        LOG.exceptionWhileUnlockingJob(nextJobId, t);
                    }
                }
                break block10;
                {
                    continue block7;
                    break;
                }
                break;
            }
            finally {
                Context.removeJobExecutorContext();
            }
        }
    }

    protected void unlockJob(String nextJobId, CommandExecutor commandExecutor) {
        commandExecutor.execute(new UnlockJobCmd(nextJobId));
    }
}

