/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.application.impl.el;

import org.camunda.bpm.application.impl.el.CalledProcessApplication;
import org.camunda.bpm.application.impl.el.CallingProcessApplication;
import org.camunda.bpm.container.RuntimeContainerDelegate;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;

public class ProcessApplicationElResolverTest
extends PluggableProcessEngineTestCase {
    RuntimeContainerDelegate runtimeContainerDelegate = null;
    CallingProcessApplication callingApp;
    CalledProcessApplication calledApp;

    protected void setUp() throws Exception {
        this.runtimeContainerDelegate = RuntimeContainerDelegate.INSTANCE.get();
        this.runtimeContainerDelegate.registerProcessEngine(this.processEngine);
        this.callingApp = new CallingProcessApplication();
        this.calledApp = new CalledProcessApplication();
        this.callingApp.deploy();
        this.calledApp.deploy();
    }

    public void tearDown() {
        this.callingApp.undeploy();
        this.calledApp.undeploy();
        if (this.runtimeContainerDelegate != null) {
            this.runtimeContainerDelegate.unregisterProcessEngine(this.processEngine);
        }
    }

    public void testCallActivityOutputExpression() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        Task calledProcessTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(calledProcessTask.getId());
        String outVariable = (String)this.runtimeService.getVariable(instance.getId(), "outVar");
        ProcessApplicationElResolverTest.assertEquals((String)"aVariableValue", (String)outVariable);
    }

    public void testCallActivityConditionalOutgoingFlow() {
        this.runtimeService.startProcessInstanceByKey("callingProcessConditionalFlow");
        Task calledProcessTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(calledProcessTask.getId());
        Task afterCallActivityTask = (Task)this.taskService.createTaskQuery().singleResult();
        ProcessApplicationElResolverTest.assertNotNull((Object)afterCallActivityTask);
        ProcessApplicationElResolverTest.assertEquals((String)"afterCallActivityTask", (String)afterCallActivityTask.getTaskDefinitionKey());
    }
}

