/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.application.ProcessApplicationRegistration;
import org.camunda.bpm.application.impl.EmbeddedProcessApplication;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.AuthorizationQuery;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentQuery;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;

public class DeploymentAuthorizationTest
extends AuthorizationTest {
    protected static final String FIRST_RESOURCE = "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml";
    protected static final String SECOND_RESOURCE = "org/camunda/bpm/engine/test/api/authorization/messageBoundaryEventProcess.bpmn20.xml";

    public void testSimpleDeploymentQueryWithoutAuthorization() {
        String deploymentId = this.createDeployment(null);
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        this.verifyQueryResults(query, 0);
        this.deleteDeployment(deploymentId);
    }

    public void testSimpleDeploymentQueryWithReadPermissionOnDeployment() {
        String deploymentId = this.createDeployment(null);
        this.createGrantAuthorization((Resource)Resources.DEPLOYMENT, deploymentId, this.userId, new Permission[]{Permissions.READ});
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        this.verifyQueryResults(query, 1);
        this.deleteDeployment(deploymentId);
    }

    public void testSimpleDeploymentQueryWithReadPermissionOnAnyDeployment() {
        String deploymentId = this.createDeployment(null);
        this.createGrantAuthorization((Resource)Resources.DEPLOYMENT, "*", this.userId, new Permission[]{Permissions.READ});
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        this.verifyQueryResults(query, 1);
        this.deleteDeployment(deploymentId);
    }

    public void testSimpleDeploymentQueryWithMultiple() {
        String deploymentId = this.createDeployment(null);
        this.createGrantAuthorization((Resource)Resources.DEPLOYMENT, deploymentId, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.DEPLOYMENT, "*", this.userId, new Permission[]{Permissions.READ});
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        this.verifyQueryResults(query, 1);
        this.deleteDeployment(deploymentId);
    }

    public void testDeploymentQueryWithoutAuthorization() {
        String deploymentId1 = this.createDeployment("first");
        String deploymentId2 = this.createDeployment("second");
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        this.verifyQueryResults(query, 0);
        this.deleteDeployment(deploymentId1);
        this.deleteDeployment(deploymentId2);
    }

    public void testDeploymentQueryWithReadPermissionOnDeployment() {
        String deploymentId1 = this.createDeployment("first");
        String deploymentId2 = this.createDeployment("second");
        this.createGrantAuthorization((Resource)Resources.DEPLOYMENT, deploymentId1, this.userId, new Permission[]{Permissions.READ});
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        this.verifyQueryResults(query, 1);
        this.deleteDeployment(deploymentId1);
        this.deleteDeployment(deploymentId2);
    }

    public void testDeploymentQueryWithReadPermissionOnAnyDeployment() {
        String deploymentId1 = this.createDeployment("first");
        String deploymentId2 = this.createDeployment("second");
        this.createGrantAuthorization((Resource)Resources.DEPLOYMENT, "*", this.userId, new Permission[]{Permissions.READ});
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        this.verifyQueryResults(query, 2);
        this.deleteDeployment(deploymentId1);
        this.deleteDeployment(deploymentId2);
    }

    public void testCreateDeploymentWithoutAuthoriatzion() {
        try {
            this.repositoryService.createDeployment().addClasspathResource(FIRST_RESOURCE).deploy();
            DeploymentAuthorizationTest.fail((String)"Exception expected: It should not be possible to create a new deployment");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.CREATE.getName(), message);
            this.assertTextPresent(Resources.DEPLOYMENT.resourceName(), message);
        }
    }

    public void testCreateDeployment() {
        this.createGrantAuthorization((Resource)Resources.DEPLOYMENT, "*", this.userId, new Permission[]{Permissions.CREATE});
        Deployment deployment = this.repositoryService.createDeployment().addClasspathResource(FIRST_RESOURCE).deploy();
        this.disableAuthorization();
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
        this.deleteDeployment(deployment.getId());
    }

    public void testDeleteDeploymentWithoutAuthorization() {
        String deploymentId = this.createDeployment(null);
        try {
            this.repositoryService.deleteDeployment(deploymentId);
            DeploymentAuthorizationTest.fail((String)"Exception expected: it should not be possible to delete a deployment");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.DELETE.getName(), message);
            this.assertTextPresent(Resources.DEPLOYMENT.resourceName(), message);
        }
        this.deleteDeployment(deploymentId);
    }

    public void testDeleteDeploymentWithDeletePermissionOnDeployment() {
        String deploymentId = this.createDeployment(null);
        this.createGrantAuthorization((Resource)Resources.DEPLOYMENT, deploymentId, this.userId, new Permission[]{Permissions.DELETE});
        this.repositoryService.deleteDeployment(deploymentId);
        this.disableAuthorization();
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
        this.deleteDeployment(deploymentId);
    }

    public void testDeleteDeploymentWithDeletePermissionOnAnyDeployment() {
        String deploymentId = this.createDeployment(null);
        this.createGrantAuthorization((Resource)Resources.DEPLOYMENT, "*", this.userId, new Permission[]{Permissions.DELETE});
        this.repositoryService.deleteDeployment(deploymentId);
        this.disableAuthorization();
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
        this.deleteDeployment(deploymentId);
    }

    public void testGetDeploymentResourceNamesWithoutAuthorization() {
        String deploymentId = this.createDeployment(null);
        try {
            this.repositoryService.getDeploymentResourceNames(deploymentId);
            DeploymentAuthorizationTest.fail((String)"Exception expected: it should not be possible to retrieve deployment resource names");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(Resources.DEPLOYMENT.resourceName(), message);
        }
        this.deleteDeployment(deploymentId);
    }

    public void testGetDeploymentResourceNamesWithReadPermissionOnDeployment() {
        String deploymentId = this.createDeployment(null);
        this.createGrantAuthorization((Resource)Resources.DEPLOYMENT, deploymentId, this.userId, new Permission[]{Permissions.READ});
        List names = this.repositoryService.getDeploymentResourceNames(deploymentId);
        DeploymentAuthorizationTest.assertFalse((boolean)names.isEmpty());
        DeploymentAuthorizationTest.assertEquals((int)2, (int)names.size());
        DeploymentAuthorizationTest.assertTrue((boolean)names.contains(FIRST_RESOURCE));
        DeploymentAuthorizationTest.assertTrue((boolean)names.contains(SECOND_RESOURCE));
        this.deleteDeployment(deploymentId);
    }

    public void testGetDeploymentResourceNamesWithReadPermissionOnAnyDeployment() {
        String deploymentId = this.createDeployment(null);
        this.createGrantAuthorization((Resource)Resources.DEPLOYMENT, "*", this.userId, new Permission[]{Permissions.READ});
        List names = this.repositoryService.getDeploymentResourceNames(deploymentId);
        DeploymentAuthorizationTest.assertFalse((boolean)names.isEmpty());
        DeploymentAuthorizationTest.assertEquals((int)2, (int)names.size());
        DeploymentAuthorizationTest.assertTrue((boolean)names.contains(FIRST_RESOURCE));
        DeploymentAuthorizationTest.assertTrue((boolean)names.contains(SECOND_RESOURCE));
        this.deleteDeployment(deploymentId);
    }

    public void testGetDeploymentResourcesWithoutAuthorization() {
        String deploymentId = this.createDeployment(null);
        try {
            this.repositoryService.getDeploymentResources(deploymentId);
            DeploymentAuthorizationTest.fail((String)"Exception expected: it should not be possible to retrieve deployment resources");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(Resources.DEPLOYMENT.resourceName(), message);
        }
        this.deleteDeployment(deploymentId);
    }

    public void testGetDeploymentResourcesWithReadPermissionOnDeployment() {
        String deploymentId = this.createDeployment(null);
        this.createGrantAuthorization((Resource)Resources.DEPLOYMENT, deploymentId, this.userId, new Permission[]{Permissions.READ});
        List resources = this.repositoryService.getDeploymentResources(deploymentId);
        DeploymentAuthorizationTest.assertFalse((boolean)resources.isEmpty());
        DeploymentAuthorizationTest.assertEquals((int)2, (int)resources.size());
        this.deleteDeployment(deploymentId);
    }

    public void testGetDeploymentResourcesWithReadPermissionOnAnyDeployment() {
        String deploymentId = this.createDeployment(null);
        this.createGrantAuthorization((Resource)Resources.DEPLOYMENT, "*", this.userId, new Permission[]{Permissions.READ});
        List resources = this.repositoryService.getDeploymentResources(deploymentId);
        DeploymentAuthorizationTest.assertFalse((boolean)resources.isEmpty());
        DeploymentAuthorizationTest.assertEquals((int)2, (int)resources.size());
        this.deleteDeployment(deploymentId);
    }

    public void testGetResourceAsStreamWithoutAuthorization() {
        String deploymentId = this.createDeployment(null);
        try {
            this.repositoryService.getResourceAsStream(deploymentId, FIRST_RESOURCE);
            DeploymentAuthorizationTest.fail((String)"Exception expected: it should not be possible to retrieve a resource as stream");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(Resources.DEPLOYMENT.resourceName(), message);
        }
        this.deleteDeployment(deploymentId);
    }

    public void testGetResourceAsStreamWithReadPermissionOnDeployment() {
        String deploymentId = this.createDeployment(null);
        this.createGrantAuthorization((Resource)Resources.DEPLOYMENT, deploymentId, this.userId, new Permission[]{Permissions.READ});
        InputStream stream = this.repositoryService.getResourceAsStream(deploymentId, FIRST_RESOURCE);
        DeploymentAuthorizationTest.assertNotNull((Object)stream);
        this.deleteDeployment(deploymentId);
    }

    public void testGetResourceAsStreamWithReadPermissionOnAnyDeployment() {
        String deploymentId = this.createDeployment(null);
        this.createGrantAuthorization((Resource)Resources.DEPLOYMENT, "*", this.userId, new Permission[]{Permissions.READ});
        InputStream stream = this.repositoryService.getResourceAsStream(deploymentId, FIRST_RESOURCE);
        DeploymentAuthorizationTest.assertNotNull((Object)stream);
        this.deleteDeployment(deploymentId);
    }

    public void testGetResourceAsStreamByIdWithoutAuthorization() {
        String deploymentId = this.createDeployment(null);
        this.disableAuthorization();
        List resources = this.repositoryService.getDeploymentResources(deploymentId);
        this.enableAuthorization();
        String resourceId = ((org.camunda.bpm.engine.repository.Resource)resources.get(0)).getId();
        try {
            this.repositoryService.getResourceAsStreamById(deploymentId, resourceId);
            DeploymentAuthorizationTest.fail((String)"Exception expected: it should not be possible to retrieve a resource as stream");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(Resources.DEPLOYMENT.resourceName(), message);
        }
        this.deleteDeployment(deploymentId);
    }

    public void testGetResourceAsStreamByIdWithReadPermissionOnDeployment() {
        String deploymentId = this.createDeployment(null);
        this.createGrantAuthorization((Resource)Resources.DEPLOYMENT, deploymentId, this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        List resources = this.repositoryService.getDeploymentResources(deploymentId);
        this.enableAuthorization();
        String resourceId = ((org.camunda.bpm.engine.repository.Resource)resources.get(0)).getId();
        InputStream stream = this.repositoryService.getResourceAsStreamById(deploymentId, resourceId);
        DeploymentAuthorizationTest.assertNotNull((Object)stream);
        this.deleteDeployment(deploymentId);
    }

    public void testGetResourceAsStreamByIdWithReadPermissionOnAnyDeployment() {
        String deploymentId = this.createDeployment(null);
        this.createGrantAuthorization((Resource)Resources.DEPLOYMENT, "*", this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        List resources = this.repositoryService.getDeploymentResources(deploymentId);
        this.enableAuthorization();
        String resourceId = ((org.camunda.bpm.engine.repository.Resource)resources.get(0)).getId();
        InputStream stream = this.repositoryService.getResourceAsStreamById(deploymentId, resourceId);
        DeploymentAuthorizationTest.assertNotNull((Object)stream);
        this.deleteDeployment(deploymentId);
    }

    public void testCreateAuthorizationOnDeploy() {
        this.createGrantAuthorization((Resource)Resources.DEPLOYMENT, "*", this.userId, new Permission[]{Permissions.CREATE});
        Deployment deployment = this.repositoryService.createDeployment().addClasspathResource(FIRST_RESOURCE).deploy();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{this.userId}).resourceId(deployment.getId()).singleResult();
        DeploymentAuthorizationTest.assertNotNull((Object)authorization);
        DeploymentAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        DeploymentAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.DELETE));
        DeploymentAuthorizationTest.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
        this.deleteDeployment(deployment.getId());
    }

    public void testClearAuthorizationOnDeleteDeployment() {
        this.createGrantAuthorization((Resource)Resources.DEPLOYMENT, "*", this.userId, new Permission[]{Permissions.CREATE});
        Deployment deployment = this.repositoryService.createDeployment().addClasspathResource(FIRST_RESOURCE).deploy();
        String deploymentId = deployment.getId();
        AuthorizationQuery query = this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{this.userId}).resourceId(deploymentId);
        Authorization authorization = (Authorization)query.singleResult();
        DeploymentAuthorizationTest.assertNotNull((Object)authorization);
        this.repositoryService.deleteDeployment(deploymentId);
        authorization = (Authorization)query.singleResult();
        DeploymentAuthorizationTest.assertNull((Object)authorization);
        this.deleteDeployment(deploymentId);
    }

    public void testRegisterProcessApplicationWithoutAuthorization() {
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication();
        ProcessApplicationReference reference = processApplication.getReference();
        String deploymentId = this.createDeployment(null, FIRST_RESOURCE).getId();
        try {
            this.managementService.registerProcessApplication(deploymentId, reference);
            DeploymentAuthorizationTest.fail((String)"Exception expected: It should not be possible to register a process application");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent("ENGINE-03029 Required authenticated group 'camunda-admin'", message);
        }
        this.deleteDeployment(deploymentId);
    }

    public void testRegisterProcessApplicationAsCamundaAdmin() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication();
        ProcessApplicationReference reference = processApplication.getReference();
        String deploymentId = this.createDeployment(null, FIRST_RESOURCE).getId();
        ProcessApplicationRegistration registration = this.managementService.registerProcessApplication(deploymentId, reference);
        DeploymentAuthorizationTest.assertNotNull((Object)registration);
        DeploymentAuthorizationTest.assertNotNull((Object)this.getProcessApplicationForDeployment(deploymentId));
        this.deleteDeployment(deploymentId);
    }

    public void testUnregisterProcessApplicationWithoutAuthorization() {
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication();
        String deploymentId = this.createDeployment(null, FIRST_RESOURCE).getId();
        ProcessApplicationReference reference = processApplication.getReference();
        this.registerProcessApplication(deploymentId, reference);
        try {
            this.managementService.unregisterProcessApplication(deploymentId, true);
            DeploymentAuthorizationTest.fail((String)"Exception expected: It should not be possible to unregister a process application");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent("ENGINE-03029 Required authenticated group 'camunda-admin'", message);
        }
        this.deleteDeployment(deploymentId);
    }

    public void testUnregisterProcessApplicationAsCamundaAdmin() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication();
        String deploymentId = this.createDeployment(null, FIRST_RESOURCE).getId();
        ProcessApplicationReference reference = processApplication.getReference();
        this.registerProcessApplication(deploymentId, reference);
        this.managementService.unregisterProcessApplication(deploymentId, true);
        DeploymentAuthorizationTest.assertNull((Object)this.getProcessApplicationForDeployment(deploymentId));
        this.deleteDeployment(deploymentId);
    }

    public void testGetProcessApplicationForDeploymentWithoutAuthorization() {
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication();
        String deploymentId = this.createDeployment(null, FIRST_RESOURCE).getId();
        ProcessApplicationReference reference = processApplication.getReference();
        this.registerProcessApplication(deploymentId, reference);
        try {
            this.managementService.getProcessApplicationForDeployment(deploymentId);
            DeploymentAuthorizationTest.fail((String)"Exception expected: It should not be possible to get the process application");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent("ENGINE-03029 Required authenticated group 'camunda-admin'", message);
        }
        this.deleteDeployment(deploymentId);
    }

    public void testGetProcessApplicationForDeploymentAsCamundaAdmin() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication();
        String deploymentId = this.createDeployment(null, FIRST_RESOURCE).getId();
        ProcessApplicationReference reference = processApplication.getReference();
        this.registerProcessApplication(deploymentId, reference);
        String application = this.managementService.getProcessApplicationForDeployment(deploymentId);
        DeploymentAuthorizationTest.assertNotNull((Object)application);
        this.deleteDeployment(deploymentId);
    }

    public void testGetRegisteredDeploymentsWithoutAuthorization() {
        String deploymentId = this.createDeployment(null, FIRST_RESOURCE).getId();
        try {
            this.managementService.getRegisteredDeployments();
            DeploymentAuthorizationTest.fail((String)"Exception expected: It should not be possible to get the registered deployments");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent("ENGINE-03029 Required authenticated group 'camunda-admin'", message);
        }
        this.deleteDeployment(deploymentId);
    }

    public void testGetRegisteredDeploymentsAsCamundaAdmin() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        String deploymentId = this.createDeployment(null, FIRST_RESOURCE).getId();
        Set deployments = this.managementService.getRegisteredDeployments();
        DeploymentAuthorizationTest.assertTrue((boolean)deployments.contains(deploymentId));
        this.deleteDeployment(deploymentId);
    }

    public void testRegisterDeploymentForJobExecutorWithoutAuthorization() {
        String deploymentId = this.createDeployment(null, FIRST_RESOURCE).getId();
        try {
            this.managementService.registerDeploymentForJobExecutor(deploymentId);
            DeploymentAuthorizationTest.fail((String)"Exception expected: It should not be possible to register the deployment");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent("ENGINE-03029 Required authenticated group 'camunda-admin'", message);
        }
        this.deleteDeployment(deploymentId);
    }

    public void testRegisterDeploymentForJobExecutorAsCamundaAdmin() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        String deploymentId = this.createDeployment(null, FIRST_RESOURCE).getId();
        this.managementService.registerDeploymentForJobExecutor(deploymentId);
        DeploymentAuthorizationTest.assertTrue((boolean)this.getRegisteredDeployments().contains(deploymentId));
        this.deleteDeployment(deploymentId);
    }

    public void testUnregisterDeploymentForJobExecutorWithoutAuthorization() {
        String deploymentId = this.createDeployment(null, FIRST_RESOURCE).getId();
        try {
            this.managementService.unregisterDeploymentForJobExecutor(deploymentId);
            DeploymentAuthorizationTest.fail((String)"Exception expected: It should not be possible to unregister the deployment");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent("ENGINE-03029 Required authenticated group 'camunda-admin'", message);
        }
        this.deleteDeployment(deploymentId);
    }

    public void testUnregisterDeploymentForJobExecutorAsCamundaAdmin() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        String deploymentId = this.createDeployment(null, FIRST_RESOURCE).getId();
        this.managementService.unregisterDeploymentForJobExecutor(deploymentId);
        DeploymentAuthorizationTest.assertFalse((boolean)this.getRegisteredDeployments().contains(deploymentId));
        this.deleteDeployment(deploymentId);
    }

    protected void verifyQueryResults(DeploymentQuery query, int countExpected) {
        this.verifyQueryResults((Query<?, ?>)((AbstractQuery)query), countExpected);
    }

    protected String createDeployment(String name) {
        return this.createDeployment(name, FIRST_RESOURCE, SECOND_RESOURCE).getId();
    }

    protected void registerProcessApplication(String deploymentId, ProcessApplicationReference reference) {
        this.disableAuthorization();
        this.managementService.registerProcessApplication(deploymentId, reference);
        this.enableAuthorization();
    }

    protected String getProcessApplicationForDeployment(String deploymentId) {
        this.disableAuthorization();
        String applications = this.managementService.getProcessApplicationForDeployment(deploymentId);
        this.enableAuthorization();
        return applications;
    }

    protected Set<String> getRegisteredDeployments() {
        this.disableAuthorization();
        Set deployments = this.managementService.getRegisteredDeployments();
        this.enableAuthorization();
        return deployments;
    }
}

