/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.cfg;

import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.persistence.deploy.CacheFactory;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.cfg.MyCacheFactory;
import org.camunda.bpm.engine.test.api.cfg.MyCacheImplementation;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.commons.utils.cache.Cache;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class DeploymentCacheCfgTest {
    protected ProcessEngineBootstrapRule cacheFactoryBootstrapRule = new ProcessEngineBootstrapRule(){

        @Override
        public ProcessEngineConfiguration configureEngine(ProcessEngineConfigurationImpl configuration) {
            configuration.setCacheCapacity(2);
            configuration.setCacheFactory((CacheFactory)new MyCacheFactory());
            return configuration;
        }
    };
    protected ProvidedProcessEngineRule cacheFactoryEngineRule = new ProvidedProcessEngineRule(this.cacheFactoryBootstrapRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.cacheFactoryBootstrapRule).around((TestRule)this.cacheFactoryEngineRule);
    RepositoryService repositoryService;
    ProcessEngineConfigurationImpl processEngineConfiguration;

    @Before
    public void initialize() {
        this.repositoryService = this.cacheFactoryEngineRule.getRepositoryService();
        this.processEngineConfiguration = this.cacheFactoryEngineRule.getProcessEngineConfiguration();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cfg/DeploymentCacheCfgTest.testDefaultCacheRemovesLRUElementWhenMaxSizeIsExceeded.bpmn20.xml"})
    public void testPlugInOwnCacheImplementation() {
        DeploymentCache deploymentCache = this.processEngineConfiguration.getDeploymentCache();
        Cache cache = deploymentCache.getProcessDefinitionCache();
        Assert.assertThat((Object)cache, (Matcher)CoreMatchers.instanceOf(MyCacheImplementation.class));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cfg/DeploymentCacheCfgTest.testDefaultCacheRemovesLRUElementWhenMaxSizeIsExceeded.bpmn20.xml"})
    public void testDefaultCacheRemovesLRUElementWhenMaxSizeIsExceeded() {
        String processDefinitionIdOne = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("one").singleResult()).getId();
        String processDefinitionIdTwo = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("two").singleResult()).getId();
        String processDefinitionIdThree = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("three").singleResult()).getId();
        DeploymentCache deploymentCache = this.processEngineConfiguration.getDeploymentCache();
        int numberOfProcessesInCache = 0;
        numberOfProcessesInCache += deploymentCache.getProcessDefinitionCache().get((Object)processDefinitionIdOne) == null ? 0 : 1;
        numberOfProcessesInCache += deploymentCache.getProcessDefinitionCache().get((Object)processDefinitionIdTwo) == null ? 0 : 1;
        Assert.assertEquals((long)2L, (long)(numberOfProcessesInCache += deploymentCache.getProcessDefinitionCache().get((Object)processDefinitionIdThree) == null ? 0 : 1));
    }
}

