/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.cfg;

import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.StandaloneInMemProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class HistoryLevelTest {
    protected ProcessEngine processEngine;

    @Test
    public void shouldInitHistoryLevelByObject() throws Exception {
        ProcessEngineConfigurationImpl config = this.createConfig();
        config.setHistoryLevel(HistoryLevel.HISTORY_LEVEL_FULL);
        ProcessEngineConfigurationImpl processEngineConfiguration = this.buildProcessEngine(config);
        Assert.assertThat((Object)processEngineConfiguration.getHistoryLevels().size(), (Matcher)CoreMatchers.is((Object)4));
        Assert.assertThat((Object)processEngineConfiguration.getHistoryLevel(), (Matcher)CoreMatchers.is((Object)HistoryLevel.HISTORY_LEVEL_FULL));
        Assert.assertThat((Object)processEngineConfiguration.getHistory(), (Matcher)CoreMatchers.is((Object)HistoryLevel.HISTORY_LEVEL_FULL.getName()));
    }

    @Test
    public void shouldInitHistoryLevelByString() throws Exception {
        ProcessEngineConfigurationImpl config = this.createConfig();
        config.setHistory(HistoryLevel.HISTORY_LEVEL_FULL.getName());
        ProcessEngineConfigurationImpl processEngineConfiguration = this.buildProcessEngine(config);
        Assert.assertThat((Object)processEngineConfiguration.getHistoryLevels().size(), (Matcher)CoreMatchers.is((Object)4));
        Assert.assertThat((Object)processEngineConfiguration.getHistoryLevel(), (Matcher)CoreMatchers.is((Object)HistoryLevel.HISTORY_LEVEL_FULL));
        Assert.assertThat((Object)processEngineConfiguration.getHistory(), (Matcher)CoreMatchers.is((Object)HistoryLevel.HISTORY_LEVEL_FULL.getName()));
    }

    protected ProcessEngineConfigurationImpl createConfig() {
        StandaloneInMemProcessEngineConfiguration configuration = new StandaloneInMemProcessEngineConfiguration();
        configuration.setProcessEngineName("process-engine-HistoryTest");
        configuration.setJdbcUrl("jdbc:h2:mem:HistoryTest");
        return configuration;
    }

    protected ProcessEngineConfigurationImpl buildProcessEngine(ProcessEngineConfigurationImpl config) {
        this.processEngine = config.buildProcessEngine();
        return (ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration();
    }

    @After
    public void closeEngine() {
        this.processEngine.close();
    }
}

