/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.filter.Filter;
import org.camunda.bpm.engine.filter.FilterQuery;
import org.camunda.bpm.engine.impl.persistence.entity.FilterEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.task.NativeTaskQuery;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.beans.HasPropertyWithValue;
import org.junit.Assert;

public class FilterQueryTest
extends PluggableProcessEngineTestCase {
    protected List<String> filterIds = new ArrayList<String>();

    public void setUp() {
        this.saveFilter("b", "b");
        this.saveFilter("d", "d");
        this.saveFilter("a", "a");
        this.saveFilter("c", "c");
    }

    protected void saveFilter(String name, String owner) {
        Filter filter = this.filterService.newTaskFilter().setName(name).setOwner(owner);
        this.filterService.saveFilter(filter);
        this.filterIds.add(filter.getId());
    }

    public void tearDown() {
        for (Filter filter : this.filterService.createFilterQuery().list()) {
            this.filterService.deleteFilter(filter.getId());
        }
    }

    public void testQueryNoCriteria() {
        FilterQuery query = this.filterService.createFilterQuery();
        FilterQueryTest.assertEquals((long)4L, (long)query.count());
        FilterQueryTest.assertEquals((int)4, (int)query.list().size());
        try {
            query.singleResult();
            FilterQueryTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByFilterId() {
        FilterQuery query = this.filterService.createFilterQuery().filterId(this.filterIds.get(0));
        FilterQueryTest.assertNotNull((Object)query.singleResult());
        FilterQueryTest.assertEquals((int)1, (int)query.list().size());
        FilterQueryTest.assertEquals((long)1L, (long)query.count());
    }

    public void testQueryByInvalidFilterId() {
        FilterQuery query = this.filterService.createFilterQuery().filterId("invalid");
        FilterQueryTest.assertNull((Object)query.singleResult());
        FilterQueryTest.assertEquals((int)0, (int)query.list().size());
        FilterQueryTest.assertEquals((long)0L, (long)query.count());
        try {
            this.filterService.createFilterQuery().filterId(null);
            FilterQueryTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByResourceType() {
        FilterQuery query = this.filterService.createFilterQuery().filterResourceType("Task");
        try {
            query.singleResult();
            FilterQueryTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        FilterQueryTest.assertEquals((int)4, (int)query.list().size());
        FilterQueryTest.assertEquals((long)4L, (long)query.count());
    }

    public void testQueryByInvalidResourceType() {
        FilterQuery query = this.filterService.createFilterQuery().filterResourceType("invalid");
        FilterQueryTest.assertNull((Object)query.singleResult());
        FilterQueryTest.assertEquals((int)0, (int)query.list().size());
        FilterQueryTest.assertEquals((long)0L, (long)query.count());
        try {
            this.filterService.createFilterQuery().filterResourceType(null);
            FilterQueryTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByName() {
        FilterQuery query = this.filterService.createFilterQuery().filterName("a");
        FilterQueryTest.assertNotNull((Object)query.singleResult());
        FilterQueryTest.assertEquals((int)1, (int)query.list().size());
        FilterQueryTest.assertEquals((long)1L, (long)query.count());
    }

    public void testQueryByInvalidName() {
        FilterQuery query = this.filterService.createFilterQuery().filterName("invalid");
        FilterQueryTest.assertNull((Object)query.singleResult());
        FilterQueryTest.assertEquals((int)0, (int)query.list().size());
        FilterQueryTest.assertEquals((long)0L, (long)query.count());
        try {
            this.filterService.createFilterQuery().filterName(null);
            FilterQueryTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByOwner() {
        FilterQuery query = this.filterService.createFilterQuery().filterOwner("a");
        FilterQueryTest.assertNotNull((Object)query.singleResult());
        FilterQueryTest.assertEquals((int)1, (int)query.list().size());
        FilterQueryTest.assertEquals((long)1L, (long)query.count());
    }

    public void testQueryByInvalidOwner() {
        FilterQuery query = this.filterService.createFilterQuery().filterOwner("invalid");
        FilterQueryTest.assertNull((Object)query.singleResult());
        FilterQueryTest.assertEquals((int)0, (int)query.list().size());
        FilterQueryTest.assertEquals((long)0L, (long)query.count());
        try {
            this.filterService.createFilterQuery().filterOwner(null);
            FilterQueryTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryPaging() {
        FilterQuery query = this.filterService.createFilterQuery();
        FilterQueryTest.assertEquals((int)4, (int)query.listPage(0, Integer.MAX_VALUE).size());
        FilterQueryTest.assertEquals((long)4L, (long)query.count());
        FilterQueryTest.assertEquals((int)4, (int)query.list().size());
        FilterQueryTest.assertEquals((int)2, (int)query.listPage(0, 2).size());
        FilterQueryTest.assertEquals((int)2, (int)query.listPage(2, 2).size());
        FilterQueryTest.assertEquals((int)1, (int)query.listPage(3, 1).size());
        FilterQueryTest.assertEquals((int)0, (int)query.listPage(-1, -1).size());
        FilterQueryTest.assertEquals((int)0, (int)query.listPage(4, 2).size());
        FilterQueryTest.assertEquals((int)4, (int)query.listPage(0, 15).size());
    }

    public void testQuerySorting() {
        ArrayList<String> sortedIds = new ArrayList<String>(this.filterIds);
        Collections.sort(sortedIds);
        FilterQueryTest.assertEquals((int)4, (int)((FilterQuery)this.filterService.createFilterQuery().orderByFilterId().asc()).list().size());
        Assert.assertThat((Object)((FilterQuery)this.filterService.createFilterQuery().orderByFilterId().asc()).list(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{HasPropertyWithValue.hasProperty((String)"id", (Matcher)Matchers.equalTo(sortedIds.get(0))), HasPropertyWithValue.hasProperty((String)"id", (Matcher)Matchers.equalTo(sortedIds.get(1))), HasPropertyWithValue.hasProperty((String)"id", (Matcher)Matchers.equalTo(sortedIds.get(2))), HasPropertyWithValue.hasProperty((String)"id", (Matcher)Matchers.equalTo(sortedIds.get(3)))}));
        FilterQueryTest.assertEquals((int)4, (int)((FilterQuery)this.filterService.createFilterQuery().orderByFilterResourceType().asc()).list().size());
        Assert.assertThat((Object)((FilterQuery)this.filterService.createFilterQuery().orderByFilterResourceType().asc()).list(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{HasPropertyWithValue.hasProperty((String)"resourceType", (Matcher)Matchers.equalTo((Object)"Task")), HasPropertyWithValue.hasProperty((String)"resourceType", (Matcher)Matchers.equalTo((Object)"Task")), HasPropertyWithValue.hasProperty((String)"resourceType", (Matcher)Matchers.equalTo((Object)"Task")), HasPropertyWithValue.hasProperty((String)"resourceType", (Matcher)Matchers.equalTo((Object)"Task"))}));
        FilterQueryTest.assertEquals((int)4, (int)((FilterQuery)this.filterService.createFilterQuery().orderByFilterName().asc()).list().size());
        Assert.assertThat((Object)((FilterQuery)this.filterService.createFilterQuery().orderByFilterName().asc()).list(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{HasPropertyWithValue.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)"a")), HasPropertyWithValue.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)"b")), HasPropertyWithValue.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)"c")), HasPropertyWithValue.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)"d"))}));
        FilterQueryTest.assertEquals((int)4, (int)((FilterQuery)this.filterService.createFilterQuery().orderByFilterOwner().asc()).list().size());
        Assert.assertThat((Object)((FilterQuery)this.filterService.createFilterQuery().orderByFilterOwner().asc()).list(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{HasPropertyWithValue.hasProperty((String)"owner", (Matcher)Matchers.equalTo((Object)"a")), HasPropertyWithValue.hasProperty((String)"owner", (Matcher)Matchers.equalTo((Object)"b")), HasPropertyWithValue.hasProperty((String)"owner", (Matcher)Matchers.equalTo((Object)"c")), HasPropertyWithValue.hasProperty((String)"owner", (Matcher)Matchers.equalTo((Object)"d"))}));
        FilterQueryTest.assertEquals((int)4, (int)((FilterQuery)this.filterService.createFilterQuery().orderByFilterId().desc()).list().size());
        Assert.assertThat((Object)((FilterQuery)this.filterService.createFilterQuery().orderByFilterId().desc()).list(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{HasPropertyWithValue.hasProperty((String)"id", (Matcher)Matchers.equalTo(sortedIds.get(3))), HasPropertyWithValue.hasProperty((String)"id", (Matcher)Matchers.equalTo(sortedIds.get(2))), HasPropertyWithValue.hasProperty((String)"id", (Matcher)Matchers.equalTo(sortedIds.get(1))), HasPropertyWithValue.hasProperty((String)"id", (Matcher)Matchers.equalTo(sortedIds.get(0)))}));
        FilterQueryTest.assertEquals((int)4, (int)((FilterQuery)this.filterService.createFilterQuery().orderByFilterResourceType().desc()).list().size());
        Assert.assertThat((Object)((FilterQuery)this.filterService.createFilterQuery().orderByFilterResourceType().desc()).list(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{HasPropertyWithValue.hasProperty((String)"resourceType", (Matcher)Matchers.equalTo((Object)"Task")), HasPropertyWithValue.hasProperty((String)"resourceType", (Matcher)Matchers.equalTo((Object)"Task")), HasPropertyWithValue.hasProperty((String)"resourceType", (Matcher)Matchers.equalTo((Object)"Task")), HasPropertyWithValue.hasProperty((String)"resourceType", (Matcher)Matchers.equalTo((Object)"Task"))}));
        FilterQueryTest.assertEquals((int)4, (int)((FilterQuery)this.filterService.createFilterQuery().orderByFilterName().desc()).list().size());
        Assert.assertThat((Object)((FilterQuery)this.filterService.createFilterQuery().orderByFilterName().desc()).list(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{HasPropertyWithValue.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)"d")), HasPropertyWithValue.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)"c")), HasPropertyWithValue.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)"b")), HasPropertyWithValue.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)"a"))}));
        FilterQueryTest.assertEquals((int)4, (int)((FilterQuery)this.filterService.createFilterQuery().orderByFilterOwner().desc()).list().size());
        Assert.assertThat((Object)((FilterQuery)this.filterService.createFilterQuery().orderByFilterOwner().desc()).list(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{HasPropertyWithValue.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)"d")), HasPropertyWithValue.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)"c")), HasPropertyWithValue.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)"b")), HasPropertyWithValue.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)"a"))}));
        FilterQueryTest.assertEquals((int)1, (int)((FilterQuery)this.filterService.createFilterQuery().orderByFilterId().filterName("a").asc()).list().size());
        FilterQueryTest.assertEquals((int)1, (int)((FilterQuery)this.filterService.createFilterQuery().orderByFilterId().filterName("a").desc()).list().size());
    }

    public void testNativeQuery() {
        String tablePrefix = this.processEngineConfiguration.getDatabaseTablePrefix();
        FilterQueryTest.assertEquals((String)(tablePrefix + "ACT_RU_FILTER"), (String)this.managementService.getTableName(Filter.class));
        FilterQueryTest.assertEquals((String)(tablePrefix + "ACT_RU_FILTER"), (String)this.managementService.getTableName(FilterEntity.class));
        FilterQueryTest.assertEquals((int)4, (int)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT * FROM " + this.managementService.getTableName(Filter.class))).list().size());
        FilterQueryTest.assertEquals((long)4L, (long)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT count(*) FROM " + this.managementService.getTableName(Filter.class))).count());
        FilterQueryTest.assertEquals((long)16L, (long)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT count(*) FROM " + tablePrefix + "ACT_RU_FILTER F1, " + tablePrefix + "ACT_RU_FILTER F2")).count());
        FilterQueryTest.assertEquals((int)4, (int)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT F1.* FROM " + tablePrefix + "ACT_RU_FILTER F1")).list().size());
        FilterQueryTest.assertEquals((long)1L, (long)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT count(*) FROM " + this.managementService.getTableName(Filter.class) + " F WHERE F.NAME_ = 'a'")).count());
        FilterQueryTest.assertEquals((int)1, (int)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT * FROM " + this.managementService.getTableName(Filter.class) + " F WHERE F.NAME_ = 'a'")).list().size());
        FilterQueryTest.assertEquals((long)1L, (long)((NativeTaskQuery)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT count(*) FROM " + this.managementService.getTableName(Filter.class) + " F WHERE F.NAME_ = #{filterName}")).parameter("filterName", (Object)"a")).count());
    }

    public void testNativeQueryPaging() {
        String tablePrefix = this.processEngineConfiguration.getDatabaseTablePrefix();
        FilterQueryTest.assertEquals((String)(tablePrefix + "ACT_RU_FILTER"), (String)this.managementService.getTableName(Filter.class));
        FilterQueryTest.assertEquals((String)(tablePrefix + "ACT_RU_FILTER"), (String)this.managementService.getTableName(FilterEntity.class));
        FilterQueryTest.assertEquals((int)3, (int)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT * FROM " + this.managementService.getTableName(Filter.class))).listPage(0, 3).size());
        FilterQueryTest.assertEquals((int)2, (int)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT * FROM " + this.managementService.getTableName(Filter.class))).listPage(2, 2).size());
    }
}

