/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.AbstractAsyncOperationsTest;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class RuntimeServiceAsyncOperationsTest
extends AbstractAsyncOperationsTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Override
    @Before
    public void initServices() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
        this.historyService = this.engineRule.getHistoryService();
    }

    @After
    public void cleanBatch() {
        HistoricBatch historicBatch;
        Batch batch = (Batch)this.managementService.createBatchQuery().singleResult();
        if (batch != null) {
            this.managementService.deleteBatch(batch.getId(), true);
        }
        if ((historicBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().singleResult()) != null) {
            this.historyService.deleteHistoricBatch(historicBatch.getId());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstancesAsyncWithList() throws Exception {
        List<String> processIds = this.startTestProcesses(2);
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(processIds, null, "testing instance delete");
        this.executeSeedJob(batch);
        this.executeBatchJobs(batch);
        this.assertHistoricTaskDeletionPresent(processIds, "testing instance delete", this.testRule);
        this.assertHistoricBatchExists(this.testRule);
        this.assertProcessInstancesAreDeleted();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstancesAsyncWithListOnly() throws Exception {
        List<String> processIds = this.startTestProcesses(2);
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(processIds, "testing instance delete");
        this.executeSeedJob(batch);
        this.executeBatchJobs(batch);
        this.assertHistoricTaskDeletionPresent(processIds, "testing instance delete", this.testRule);
        this.assertHistoricBatchExists(this.testRule);
        this.assertProcessInstancesAreDeleted();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstancesAsyncWithNonExistingId() throws Exception {
        List<String> processIds = this.startTestProcesses(2);
        processIds.add("unknown");
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(processIds, null, "testing instance delete");
        this.executeSeedJob(batch);
        List<Exception> exceptions = this.executeBatchJobs(batch);
        Assert.assertEquals((long)1L, (long)exceptions.size());
        Exception e = exceptions.get(0);
        Assert.assertTrue((boolean)e.getMessage().startsWith("No process instance found for id 'unknown'"));
        Assert.assertThat((Object)this.managementService.createJobQuery().withException().list().size(), (Matcher)CoreMatchers.is((Object)1));
        processIds.remove("unknown");
        this.assertHistoricTaskDeletionPresent(processIds, "testing instance delete", this.testRule);
        this.assertHistoricBatchExists(this.testRule);
        this.assertProcessInstancesAreDeleted();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstancesAsyncWithNullList() throws Exception {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("processInstanceIds is empty");
        this.runtimeService.deleteProcessInstancesAsync(null, null, "testing instance delete");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstancesAsyncWithEmptyList() throws Exception {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("processInstanceIds is empty");
        this.runtimeService.deleteProcessInstancesAsync(new ArrayList(), null, "testing instance delete");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstancesAsyncWithQuery() throws Exception {
        List<String> processIds = this.startTestProcesses(2);
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceIds(new HashSet<String>(processIds));
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(null, processInstanceQuery, "testing instance delete");
        this.executeSeedJob(batch);
        this.executeBatchJobs(batch);
        this.assertHistoricTaskDeletionPresent(processIds, "testing instance delete", this.testRule);
        this.assertHistoricBatchExists(this.testRule);
        this.assertProcessInstancesAreDeleted();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstancesAsyncWithQueryOnly() throws Exception {
        List<String> processIds = this.startTestProcesses(2);
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceIds(new HashSet<String>(processIds));
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(processInstanceQuery, "testing instance delete");
        this.executeSeedJob(batch);
        this.executeBatchJobs(batch);
        this.assertHistoricTaskDeletionPresent(processIds, "testing instance delete", this.testRule);
        this.assertHistoricBatchExists(this.testRule);
        this.assertProcessInstancesAreDeleted();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstancesAsyncWithQueryWithoutDeleteReason() throws Exception {
        List<String> processIds = this.startTestProcesses(2);
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceIds(new HashSet<String>(processIds));
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(null, processInstanceQuery, null);
        this.executeSeedJob(batch);
        this.executeBatchJobs(batch);
        this.assertHistoricTaskDeletionPresent(processIds, "deleted", this.testRule);
        this.assertHistoricBatchExists(this.testRule);
        this.assertProcessInstancesAreDeleted();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstancesAsyncWithNullQueryParameter() throws Exception {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("processInstanceIds is empty");
        this.runtimeService.deleteProcessInstancesAsync(null, null, "testing instance delete");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstancesAsyncWithInvalidQueryParameter() throws Exception {
        this.startTestProcesses(2);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey("invalid");
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("processInstanceIds is empty");
        this.runtimeService.deleteProcessInstancesAsync(null, query, "testing instance delete");
    }

    protected void assertProcessInstancesAreDeleted() {
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().list().size(), (Matcher)CoreMatchers.is((Object)0));
    }
}

