/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.Comparator;
import java.util.Date;
import java.util.List;
import junit.framework.TestCase;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.BatchStatistics;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.history.HistoricJobLog;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricJobLogEventEntity;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;

public class TestOrderingUtil {
    public static NullTolerantComparator<Execution> executionByProcessInstanceId() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<Execution, String>(){

            @Override
            public String getProperty(Execution obj) {
                return obj.getProcessInstanceId();
            }
        });
    }

    public static NullTolerantComparator<Execution> executionByProcessDefinitionId() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<Execution, String>(){

            @Override
            public String getProperty(Execution obj) {
                return ((ExecutionEntity)obj).getProcessDefinitionId();
            }
        });
    }

    public static NullTolerantComparator<Execution> executionByProcessDefinitionKey(ProcessEngine processEngine) {
        final RuntimeService runtimeService = processEngine.getRuntimeService();
        final RepositoryService repositoryService = processEngine.getRepositoryService();
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<Execution, String>(){

            @Override
            public String getProperty(Execution obj) {
                ProcessInstance processInstance = (ProcessInstance)runtimeService.createProcessInstanceQuery().processInstanceId(obj.getProcessInstanceId()).singleResult();
                ProcessDefinition processDefinition = repositoryService.getProcessDefinition(processInstance.getProcessDefinitionId());
                return processDefinition.getKey();
            }
        });
    }

    public static NullTolerantComparator<CaseExecution> caseExecutionByDefinitionId() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<CaseExecution, String>(){

            @Override
            public String getProperty(CaseExecution obj) {
                return obj.getCaseDefinitionId();
            }
        });
    }

    public static NullTolerantComparator<CaseExecution> caseExecutionByDefinitionKey(ProcessEngine processEngine) {
        final RepositoryService repositoryService = processEngine.getRepositoryService();
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<CaseExecution, String>(){

            @Override
            public String getProperty(CaseExecution obj) {
                CaseDefinition caseDefinition = repositoryService.getCaseDefinition(obj.getCaseDefinitionId());
                return caseDefinition.getKey();
            }
        });
    }

    public static NullTolerantComparator<CaseExecution> caseExecutionById() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<CaseExecution, String>(){

            @Override
            public String getProperty(CaseExecution obj) {
                return obj.getId();
            }
        });
    }

    public static NullTolerantComparator<Task> taskById() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<Task, String>(){

            @Override
            public String getProperty(Task obj) {
                return obj.getId();
            }
        });
    }

    public static NullTolerantComparator<Task> taskByName() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<Task, String>(){

            @Override
            public String getProperty(Task obj) {
                return obj.getName();
            }
        });
    }

    public static NullTolerantComparator<Task> taskByPriority() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<Task, Integer>(){

            @Override
            public Integer getProperty(Task obj) {
                return obj.getPriority();
            }
        });
    }

    public static NullTolerantComparator<Task> taskByAssignee() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<Task, String>(){

            @Override
            public String getProperty(Task obj) {
                return obj.getAssignee();
            }
        });
    }

    public static NullTolerantComparator<Task> taskByDescription() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<Task, String>(){

            @Override
            public String getProperty(Task obj) {
                return obj.getDescription();
            }
        });
    }

    public static NullTolerantComparator<Task> taskByProcessInstanceId() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<Task, String>(){

            @Override
            public String getProperty(Task obj) {
                return obj.getProcessInstanceId();
            }
        });
    }

    public static NullTolerantComparator<Task> taskByExecutionId() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<Task, String>(){

            @Override
            public String getProperty(Task obj) {
                return obj.getExecutionId();
            }
        });
    }

    public static NullTolerantComparator<Task> taskByCreateTime() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<Task, Date>(){

            @Override
            public Date getProperty(Task obj) {
                return obj.getCreateTime();
            }
        });
    }

    public static NullTolerantComparator<Task> taskByDueDate() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<Task, Date>(){

            @Override
            public Date getProperty(Task obj) {
                return obj.getDueDate();
            }
        });
    }

    public static NullTolerantComparator<Task> taskByFollowUpDate() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<Task, Date>(){

            @Override
            public Date getProperty(Task obj) {
                return obj.getFollowUpDate();
            }
        });
    }

    public static NullTolerantComparator<Task> taskByCaseInstanceId() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<Task, String>(){

            @Override
            public String getProperty(Task obj) {
                return obj.getCaseInstanceId();
            }
        });
    }

    public static NullTolerantComparator<Task> taskByCaseExecutionId() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<Task, String>(){

            @Override
            public String getProperty(Task obj) {
                return obj.getCaseExecutionId();
            }
        });
    }

    public static NullTolerantComparator<HistoricJobLog> historicJobLogByTimestamp() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<HistoricJobLog, Date>(){

            @Override
            public Date getProperty(HistoricJobLog obj) {
                return obj.getTimestamp();
            }
        });
    }

    public static NullTolerantComparator<HistoricJobLog> historicJobLogByJobId() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<HistoricJobLog, String>(){

            @Override
            public String getProperty(HistoricJobLog obj) {
                return obj.getJobId();
            }
        });
    }

    public static NullTolerantComparator<HistoricJobLog> historicJobLogByJobDefinitionId() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<HistoricJobLog, String>(){

            @Override
            public String getProperty(HistoricJobLog obj) {
                return obj.getJobDefinitionId();
            }
        });
    }

    public static NullTolerantComparator<HistoricJobLog> historicJobLogByJobDueDate() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<HistoricJobLog, Date>(){

            @Override
            public Date getProperty(HistoricJobLog obj) {
                return obj.getJobDueDate();
            }
        });
    }

    public static NullTolerantComparator<HistoricJobLog> historicJobLogByJobRetries() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<HistoricJobLog, Integer>(){

            @Override
            public Integer getProperty(HistoricJobLog obj) {
                return obj.getJobRetries();
            }
        });
    }

    public static NullTolerantComparator<HistoricJobLog> historicJobLogByActivityId() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<HistoricJobLog, String>(){

            @Override
            public String getProperty(HistoricJobLog obj) {
                return obj.getActivityId();
            }
        });
    }

    public static NullTolerantComparator<HistoricJobLog> historicJobLogByExecutionId() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<HistoricJobLog, String>(){

            @Override
            public String getProperty(HistoricJobLog obj) {
                return obj.getExecutionId();
            }
        });
    }

    public static NullTolerantComparator<HistoricJobLog> historicJobLogByProcessInstanceId() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<HistoricJobLog, String>(){

            @Override
            public String getProperty(HistoricJobLog obj) {
                return obj.getProcessInstanceId();
            }
        });
    }

    public static NullTolerantComparator<HistoricJobLog> historicJobLogByProcessDefinitionId() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<HistoricJobLog, String>(){

            @Override
            public String getProperty(HistoricJobLog obj) {
                return obj.getProcessDefinitionId();
            }
        });
    }

    public static NullTolerantComparator<HistoricJobLog> historicJobLogByProcessDefinitionKey(ProcessEngine processEngine) {
        final RepositoryService repositoryService = processEngine.getRepositoryService();
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<HistoricJobLog, String>(){

            @Override
            public String getProperty(HistoricJobLog obj) {
                ProcessDefinition processDefinition = repositoryService.getProcessDefinition(obj.getProcessDefinitionId());
                return processDefinition.getKey();
            }
        });
    }

    public static NullTolerantComparator<HistoricJobLog> historicJobLogByDeploymentId() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<HistoricJobLog, String>(){

            @Override
            public String getProperty(HistoricJobLog obj) {
                return obj.getDeploymentId();
            }
        });
    }

    public static NullTolerantComparator<HistoricJobLog> historicJobLogByJobPriority() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<HistoricJobLog, Long>(){

            @Override
            public Long getProperty(HistoricJobLog obj) {
                return obj.getJobPriority();
            }
        });
    }

    public static NullTolerantComparator<HistoricJobLog> historicJobLogPartiallyByOccurence() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<HistoricJobLog, Long>(){

            @Override
            public Long getProperty(HistoricJobLog obj) {
                return ((HistoricJobLogEventEntity)obj).getSequenceCounter();
            }
        });
    }

    public static NullTolerantComparator<Job> jobByPriority() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<Job, Long>(){

            @Override
            public Long getProperty(Job obj) {
                return obj.getPriority();
            }
        });
    }

    public static NullTolerantComparator<ExternalTask> externalTaskById() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<ExternalTask, String>(){

            @Override
            public String getProperty(ExternalTask obj) {
                return obj.getId();
            }
        });
    }

    public static NullTolerantComparator<ExternalTask> externalTaskByProcessInstanceId() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<ExternalTask, String>(){

            @Override
            public String getProperty(ExternalTask obj) {
                return obj.getProcessInstanceId();
            }
        });
    }

    public static NullTolerantComparator<ExternalTask> externalTaskByProcessDefinitionId() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<ExternalTask, String>(){

            @Override
            public String getProperty(ExternalTask obj) {
                return obj.getProcessDefinitionId();
            }
        });
    }

    public static NullTolerantComparator<ExternalTask> externalTaskByProcessDefinitionKey() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<ExternalTask, String>(){

            @Override
            public String getProperty(ExternalTask obj) {
                return obj.getProcessDefinitionKey();
            }
        });
    }

    public static NullTolerantComparator<ExternalTask> externalTaskByLockExpirationTime() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<ExternalTask, Date>(){

            @Override
            public Date getProperty(ExternalTask obj) {
                return obj.getLockExpirationTime();
            }
        });
    }

    public static NullTolerantComparator<ExternalTask> externalTaskByPriority() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<ExternalTask, Long>(){

            @Override
            public Long getProperty(ExternalTask obj) {
                return obj.getPriority();
            }
        });
    }

    public static NullTolerantComparator<Batch> batchById() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<Batch, String>(){

            @Override
            public String getProperty(Batch obj) {
                return obj.getId();
            }
        });
    }

    public static NullTolerantComparator<Batch> batchByTenantId() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<Batch, String>(){

            @Override
            public String getProperty(Batch obj) {
                return obj.getTenantId();
            }
        });
    }

    public static NullTolerantComparator<HistoricBatch> historicBatchById() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<HistoricBatch, String>(){

            @Override
            public String getProperty(HistoricBatch obj) {
                return obj.getId();
            }
        });
    }

    public static NullTolerantComparator<HistoricBatch> historicBatchByTenantId() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<HistoricBatch, String>(){

            @Override
            public String getProperty(HistoricBatch obj) {
                return obj.getTenantId();
            }
        });
    }

    public static NullTolerantComparator<HistoricBatch> historicBatchByStartTime() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<HistoricBatch, Date>(){

            @Override
            public Date getProperty(HistoricBatch obj) {
                return obj.getStartTime();
            }
        });
    }

    public static NullTolerantComparator<HistoricBatch> historicBatchByEndTime() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<HistoricBatch, Date>(){

            @Override
            public Date getProperty(HistoricBatch obj) {
                return obj.getEndTime();
            }
        });
    }

    public static NullTolerantComparator<BatchStatistics> batchStatisticsById() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<BatchStatistics, String>(){

            @Override
            public String getProperty(BatchStatistics obj) {
                return obj.getId();
            }
        });
    }

    public static NullTolerantComparator<BatchStatistics> batchStatisticsByTenantId() {
        return TestOrderingUtil.propertyComparator(new PropertyAccessor<BatchStatistics, String>(){

            @Override
            public String getProperty(BatchStatistics obj) {
                return obj.getTenantId();
            }
        });
    }

    public static <T, P extends Comparable<P>> NullTolerantComparator<T> propertyComparator(final PropertyAccessor<T, P> accessor) {
        return new NullTolerantComparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                Object prop1 = accessor.getProperty(o1);
                Object prop2 = accessor.getProperty(o2);
                return prop1.compareTo(prop2);
            }

            @Override
            public boolean hasNullProperty(T object) {
                return accessor.getProperty(object) == null;
            }
        };
    }

    public static <T> NullTolerantComparator<T> inverted(final NullTolerantComparator<T> comparator) {
        return new NullTolerantComparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return -comparator.compare(o1, o2);
            }

            @Override
            public boolean hasNullProperty(T object) {
                return comparator.hasNullProperty(object);
            }
        };
    }

    public static <T> NullTolerantComparator<T> hierarchical(final NullTolerantComparator<T> baseComparator, final NullTolerantComparator<T> ... minorOrderings) {
        return new NullTolerantComparator<T>(){

            @Override
            public int compare(T o1, T o2, boolean nullPrecedes) {
                int comparison = baseComparator.compare(o1, o2, nullPrecedes);
                for (int i = 0; comparison == 0 && i < minorOrderings.length; ++i) {
                    NullTolerantComparator comparator = minorOrderings[i];
                    comparison = comparator.compare(o1, o2, nullPrecedes);
                }
                return comparison;
            }

            @Override
            public int compare(T o1, T o2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNullProperty(T object) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> void verifySorting(List<T> actualElements, NullTolerantComparator<T> expectedOrdering) {
        boolean leadingNullOrdering = TestOrderingUtil.orderingConsistent(actualElements, expectedOrdering, true);
        if (leadingNullOrdering) {
            return;
        }
        boolean trailingNullOrdering = TestOrderingUtil.orderingConsistent(actualElements, expectedOrdering, false);
        TestCase.assertTrue((String)"Ordering not consistent with comparator", (boolean)trailingNullOrdering);
    }

    public static <T> boolean orderingConsistent(List<T> actualElements, NullTolerantComparator<T> expectedOrdering, boolean nullPrecedes) {
        for (int i = 0; i < actualElements.size() - 1; ++i) {
            T nextExecution;
            T currentExecution = actualElements.get(i);
            int comparison = expectedOrdering.compare(currentExecution, nextExecution = actualElements.get(i + 1), nullPrecedes);
            if (comparison <= 0) continue;
            return false;
        }
        return true;
    }

    public static <T> void verifySortingAndCount(Query<?, T> query, int expectedCount, NullTolerantComparator<T> expectedOrdering) {
        List elements = query.list();
        TestCase.assertEquals((int)expectedCount, (int)elements.size());
        TestOrderingUtil.verifySorting(elements, expectedOrdering);
    }

    public static abstract class NullTolerantComparator<T>
    implements Comparator<T> {
        public int compare(T o1, T o2, boolean nullPrecedes) {
            boolean o1Null = this.hasNullProperty(o1);
            boolean o2Null = this.hasNullProperty(o2);
            if (o1Null) {
                if (o2Null) {
                    return 0;
                }
                if (nullPrecedes) {
                    return -1;
                }
                return 1;
            }
            if (o2Null) {
                if (nullPrecedes) {
                    return 1;
                }
                return -1;
            }
            return this.compare(o1, o2);
        }

        public abstract boolean hasNullProperty(T var1);
    }

    protected static interface PropertyAccessor<T, P extends Comparable<P>> {
        public P getProperty(T var1);
    }
}

