/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.variables;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.digest._apacheCommonsCodec.Base64;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.StringUtil;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.variables.FailingJavaSerializable;
import org.camunda.bpm.engine.test.api.variables.JavaSerializable;
import org.camunda.bpm.engine.test.util.TypedValueAssert;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.ObjectValue;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class JavaSerializationTest
extends PluggableProcessEngineTestCase {
    protected static final String ONE_TASK_PROCESS = "org/camunda/bpm/engine/test/api/variables/oneTaskProcess.bpmn20.xml";
    protected static final String JAVA_DATA_FORMAT = Variables.SerializationDataFormats.JAVA.getName();
    protected String originalSerializationFormat;

    @Deployment(resources={"org/camunda/bpm/engine/test/api/variables/oneTaskProcess.bpmn20.xml"})
    public void testSerializationAsJava() throws Exception {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        JavaSerializable javaSerializable = new JavaSerializable("foo");
        this.runtimeService.setVariable(instance.getId(), "simpleBean", (Object)Variables.objectValue((Object)javaSerializable).serializationDataFormat(JAVA_DATA_FORMAT).create());
        JavaSerializable value = (JavaSerializable)this.runtimeService.getVariable(instance.getId(), "simpleBean");
        JavaSerializationTest.assertEquals((Object)javaSerializable, (Object)value);
        ObjectValue typedValue = (ObjectValue)this.runtimeService.getVariableTyped(instance.getId(), "simpleBean");
        TypedValueAssert.assertObjectValueDeserialized(typedValue, javaSerializable);
        TypedValueAssert.assertObjectValueSerializedJava(typedValue, javaSerializable);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/variables/oneTaskProcess.bpmn20.xml"})
    public void testSetJavaOjectSerialized() throws Exception {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        JavaSerializable javaSerializable = new JavaSerializable("foo");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new ObjectOutputStream(baos).writeObject(javaSerializable);
        String serializedObject = StringUtil.fromBytes((byte[])Base64.encodeBase64((byte[])baos.toByteArray()), (ProcessEngine)this.processEngine);
        this.runtimeService.setVariable(instance.getId(), "simpleBean", (Object)Variables.serializedObjectValue((String)serializedObject).serializationDataFormat(JAVA_DATA_FORMAT).objectTypeName(JavaSerializable.class.getName()).create());
        JavaSerializable value = (JavaSerializable)this.runtimeService.getVariable(instance.getId(), "simpleBean");
        JavaSerializationTest.assertEquals((Object)javaSerializable, (Object)value);
        ObjectValue typedValue = (ObjectValue)this.runtimeService.getVariableTyped(instance.getId(), "simpleBean");
        TypedValueAssert.assertObjectValueDeserialized(typedValue, javaSerializable);
        TypedValueAssert.assertObjectValueSerializedJava(typedValue, javaSerializable);
    }

    @Deployment
    public void testJavaObjectDeserializedInFirstCommand() throws Exception {
        JavaSerializable javaSerializable = new JavaSerializable("foo");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new ObjectOutputStream(baos).writeObject(javaSerializable);
        String serializedObject = StringUtil.fromBytes((byte[])Base64.encodeBase64((byte[])baos.toByteArray()), (ProcessEngine)this.processEngine);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("varName", (Object)Variables.serializedObjectValue((String)serializedObject).serializationDataFormat(JAVA_DATA_FORMAT).objectTypeName(JavaSerializable.class.getName()).create()));
    }

    @Deployment
    public void testJavaObjectNotDeserializedIfNotRequested() throws Exception {
        FailingJavaSerializable javaSerializable = new FailingJavaSerializable("foo");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new ObjectOutputStream(baos).writeObject(javaSerializable);
        byte[] serializedObjectBytes = baos.toByteArray();
        String serializedObject = StringUtil.fromBytes((byte[])Base64.encodeBase64((byte[])serializedObjectBytes), (ProcessEngine)this.processEngine);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(serializedObjectBytes));
            objectInputStream.readObject();
            JavaSerializationTest.fail((String)"Exception expected");
        }
        catch (RuntimeException e) {
            this.assertTextPresent("Exception while deserializing object", e.getMessage());
        }
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("varName", (Object)Variables.serializedObjectValue((String)serializedObject).serializationDataFormat(JAVA_DATA_FORMAT).objectTypeName(JavaSerializable.class.getName()).create()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/variables/oneTaskProcess.bpmn20.xml"})
    public void testSetJavaOjectNullDeserialized() throws Exception {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.setVariable(instance.getId(), "nullObject", (Object)Variables.objectValue(null).serializationDataFormat(JAVA_DATA_FORMAT).create());
        JavaSerializationTest.assertNull((Object)this.runtimeService.getVariable(instance.getId(), "nullObject"));
        ObjectValue typedValue = (ObjectValue)this.runtimeService.getVariableTyped(instance.getId(), "nullObject");
        TypedValueAssert.assertObjectValueDeserializedNull(typedValue);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/variables/oneTaskProcess.bpmn20.xml"})
    public void testSetJavaOjectNullSerialized() throws Exception {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.setVariable(instance.getId(), "nullObject", (Object)Variables.serializedObjectValue().serializationDataFormat(JAVA_DATA_FORMAT).create());
        JavaSerializationTest.assertNull((Object)this.runtimeService.getVariable(instance.getId(), "nullObject"));
        ObjectValue deserializedTypedValue = (ObjectValue)this.runtimeService.getVariableTyped(instance.getId(), "nullObject");
        TypedValueAssert.assertObjectValueDeserializedNull(deserializedTypedValue);
        ObjectValue serializedTypedValue = (ObjectValue)this.runtimeService.getVariableTyped(instance.getId(), "nullObject", false);
        TypedValueAssert.assertObjectValueSerializedNull(serializedTypedValue);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/variables/oneTaskProcess.bpmn20.xml"})
    public void testSetJavaOjectNullSerializedObjectTypeName() throws Exception {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String typeName = "some.type.Name";
        this.runtimeService.setVariable(instance.getId(), "nullObject", (Object)Variables.serializedObjectValue().serializationDataFormat(JAVA_DATA_FORMAT).objectTypeName(typeName).create());
        JavaSerializationTest.assertNull((Object)this.runtimeService.getVariable(instance.getId(), "nullObject"));
        ObjectValue deserializedTypedValue = (ObjectValue)this.runtimeService.getVariableTyped(instance.getId(), "nullObject");
        JavaSerializationTest.assertNotNull((Object)deserializedTypedValue);
        JavaSerializationTest.assertTrue((boolean)deserializedTypedValue.isDeserialized());
        JavaSerializationTest.assertEquals((String)JAVA_DATA_FORMAT, (String)deserializedTypedValue.getSerializationDataFormat());
        JavaSerializationTest.assertNull((Object)deserializedTypedValue.getValue());
        JavaSerializationTest.assertNull((Object)deserializedTypedValue.getValueSerialized());
        JavaSerializationTest.assertNull((Object)deserializedTypedValue.getObjectType());
        JavaSerializationTest.assertEquals((String)typeName, (String)deserializedTypedValue.getObjectTypeName());
        ObjectValue serializedTypedValue = (ObjectValue)this.runtimeService.getVariableTyped(instance.getId(), "nullObject", false);
        JavaSerializationTest.assertNotNull((Object)serializedTypedValue);
        JavaSerializationTest.assertFalse((boolean)serializedTypedValue.isDeserialized());
        JavaSerializationTest.assertEquals((String)JAVA_DATA_FORMAT, (String)serializedTypedValue.getSerializationDataFormat());
        JavaSerializationTest.assertNull((Object)serializedTypedValue.getValueSerialized());
        JavaSerializationTest.assertEquals((String)typeName, (String)serializedTypedValue.getObjectTypeName());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/variables/oneTaskProcess.bpmn20.xml"})
    public void testSetUntypedNullForExistingVariable() throws Exception {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        JavaSerializable javaSerializable = new JavaSerializable("foo");
        this.runtimeService.setVariable(instance.getId(), "varName", (Object)Variables.objectValue((Object)javaSerializable).serializationDataFormat(JAVA_DATA_FORMAT).create());
        JavaSerializationTest.assertEquals((Object)javaSerializable, (Object)this.runtimeService.getVariable(instance.getId(), "varName"));
        this.runtimeService.setVariable(instance.getId(), "varName", null);
        TypedValue nullValue = this.runtimeService.getVariableTyped(instance.getId(), "varName");
        TypedValueAssert.assertUntypedNullValue(nullValue);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/variables/oneTaskProcess.bpmn20.xml"})
    public void testSetTypedNullForExistingVariable() throws Exception {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        JavaSerializable javaSerializable = new JavaSerializable("foo");
        this.runtimeService.setVariable(instance.getId(), "varName", (Object)Variables.objectValue((Object)javaSerializable).serializationDataFormat(JAVA_DATA_FORMAT).create());
        JavaSerializationTest.assertEquals((Object)javaSerializable, (Object)this.runtimeService.getVariable(instance.getId(), "varName"));
        this.runtimeService.setVariable(instance.getId(), "varName", (Object)Variables.objectValue(null));
        ObjectValue typedValue = (ObjectValue)this.runtimeService.getVariableTyped(instance.getId(), "varName");
        TypedValueAssert.assertObjectValueDeserializedNull(typedValue);
    }
}

