/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.conditional;

import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.bpmn.event.conditional.AbstractConditionalEventTestCase;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.camunda.bpm.model.bpmn.builder.ConditionalEventDefinitionBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.Test;

public class BoundaryConditionalEventTest
extends AbstractConditionalEventTestCase {
    protected static final String TASK_WITH_CONDITION = "Task with condition";
    protected static final String TASK_WITH_CONDITION_ID = "taskWithCondition";
    protected static final String TASK_IN_SUBPROCESS = "Task in Subprocess";

    @Test
    @Deployment
    public void testTrueCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)TASK_WITH_CONDITION, (String)task.getName());
        Assert.assertEquals((int)1, (int)this.conditionEventSubscriptionQuery.list().size());
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"After Condition", (String)task.getName());
        Assert.assertEquals((int)0, (int)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    @Deployment
    public void testNonInterruptingTrueCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)TASK_WITH_CONDITION, (String)task.getName());
        Assert.assertEquals((int)1, (int)this.conditionEventSubscriptionQuery.list().size());
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        List tasklist = taskQuery.list();
        Assert.assertEquals((int)2, (int)tasklist.size());
        Assert.assertEquals((int)1, (int)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    @Deployment
    public void testFalseCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task task = (Task)taskQuery.processInstanceId(procInst.getId()).singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)TASK_WITH_CONDITION, (String)task.getName());
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId(TASK_WITH_CONDITION_ID).singleResult();
        Assert.assertNotNull((Object)execution);
    }

    @Test
    @Deployment
    public void testVariableCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)TASK_WITH_CONDITION, (String)task.getName());
        this.taskService.setVariableLocal(task.getId(), "variable", (Object)1);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId(TASK_WITH_CONDITION_ID).singleResult();
        Assert.assertNotNull((Object)execution);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/BoundaryConditionalEventTest.testVariableCondition.bpmn20.xml"})
    public void testVariableSetOnExecutionCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)TASK_WITH_CONDITION, (String)task.getName());
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId(TASK_WITH_CONDITION_ID).singleResult();
        Assert.assertNull((Object)execution);
        task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"After Condition", (String)task.getName());
    }

    @Test
    @Deployment
    public void testNonInterruptingVariableCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)TASK_WITH_CONDITION, (String)task.getName());
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        List tasklist = taskQuery.list();
        Assert.assertEquals((int)2, (int)tasklist.size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/BoundaryConditionalEventTest.testVariableCondition.bpmn20.xml"})
    public void testWrongVariableCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)TASK_WITH_CONDITION, (String)task.getName());
        Assert.assertEquals((int)1, (int)this.conditionEventSubscriptionQuery.list().size());
        this.taskService.setVariable(task.getId(), "variable1", (Object)1);
        task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)TASK_WITH_CONDITION, (String)task.getName());
        Assert.assertEquals((int)1, (int)this.conditionEventSubscriptionQuery.list().size());
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"After Condition", (String)task.getName());
        Assert.assertEquals((int)0, (int)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    @Deployment
    public void testParallelVariableCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        List tasks = taskQuery.list();
        Assert.assertEquals((int)2, (int)tasks.size());
        Assert.assertEquals((int)2, (int)this.conditionEventSubscriptionQuery.list().size());
        Task task = (Task)tasks.get(0);
        this.taskService.setVariableLocal(task.getId(), "variable", (Object)1);
        tasks = taskQuery.list();
        Assert.assertEquals((int)2, (int)tasks.size());
        this.runtimeService.setVariableLocal(task.getExecutionId(), "variable", (Object)1);
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).list();
        Assert.assertEquals((int)2, (int)executions.size());
        tasks = taskQuery.list();
        Assert.assertEquals((int)1, (int)tasks.size());
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId(task.getId()).singleResult();
        Assert.assertNull((Object)execution);
        Assert.assertEquals((int)1, (int)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/BoundaryConditionalEventTest.testParallelVariableCondition.bpmn20.xml"})
    public void testParallelSetVariableOnTaskCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        List tasks = taskQuery.list();
        Assert.assertEquals((int)2, (int)tasks.size());
        Task task = (Task)tasks.get(0);
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).list();
        Assert.assertEquals((int)0, (int)executions.size());
        tasks = taskQuery.list();
        Assert.assertEquals((int)0, (int)tasks.size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/BoundaryConditionalEventTest.testParallelVariableCondition.bpmn20.xml"})
    public void testParallelSetVariableOnExecutionCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        List tasks = taskQuery.list();
        Assert.assertEquals((int)2, (int)tasks.size());
        this.runtimeService.setVariable(procInst.getId(), "variable", (Object)1);
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).list();
        Assert.assertEquals((int)0, (int)executions.size());
        tasks = taskQuery.list();
        Assert.assertEquals((int)0, (int)tasks.size());
    }

    @Test
    @Deployment
    public void testSubProcessVariableCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)TASK_IN_SUBPROCESS, (String)task.getName());
        Assert.assertEquals((int)1, (int)this.conditionEventSubscriptionQuery.list().size());
        this.taskService.setVariableLocal(task.getId(), "variable", (Object)1);
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).list();
        Assert.assertEquals((int)2, (int)executions.size());
        Assert.assertEquals((int)1, (int)this.conditionEventSubscriptionQuery.list().size());
        this.runtimeService.setVariableLocal(task.getExecutionId(), "variable", (Object)1);
        executions = this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).list();
        Assert.assertEquals((int)0, (int)executions.size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/BoundaryConditionalEventTest.testSubProcessVariableCondition.bpmn20.xml"})
    public void testSubProcessSetVariableOnTaskCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)TASK_IN_SUBPROCESS, (String)task.getName());
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).list();
        Assert.assertEquals((int)0, (int)executions.size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/BoundaryConditionalEventTest.testSubProcessVariableCondition.bpmn20.xml"})
    public void testSubProcessSetVariableOnExecutionCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)TASK_IN_SUBPROCESS, (String)task.getName());
        this.runtimeService.setVariable(task.getExecutionId(), "variable", (Object)1);
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).list();
        Assert.assertEquals((int)0, (int)executions.size());
    }

    @Test
    @Deployment
    public void testNonInterruptingSubProcessVariableCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)TASK_IN_SUBPROCESS, (String)task.getName());
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        List tasks = taskQuery.list();
        Assert.assertEquals((int)2, (int)tasks.size());
    }

    @Test
    @Deployment
    public void testCleanUpConditionalEventSubscriptions() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertEquals((int)1, (int)this.conditionEventSubscriptionQuery.list().size());
        this.taskService.complete(task.getId());
        Assert.assertEquals((int)0, (int)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    public void testVariableConditionWithVariableName() {
        this.deployBoundaryEventProcessWithVarName(true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.setVariable(task.getId(), "variable1", (Object)1);
        task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"Before Condition", (String)task.getName());
        Assert.assertEquals((int)1, (int)this.conditionEventSubscriptionQuery.list().size());
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        task = (Task)taskQuery.singleResult();
        Assert.assertEquals((String)"After Condition", (String)task.getName());
        Assert.assertEquals((int)0, (int)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    public void testVariableConditionWithVariableNameAndEvent() {
        this.deployBoundaryEventProcessWithVarNameAndEvents(true, "update");
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"Before Condition", (String)task.getName());
        Assert.assertEquals((int)1, (int)this.conditionEventSubscriptionQuery.list().size());
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        task = (Task)taskQuery.singleResult();
        Assert.assertEquals((String)"After Condition", (String)task.getName());
        Assert.assertEquals((int)0, (int)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    public void testNonInterruptingVariableConditionWithVariableName() {
        this.deployBoundaryEventProcessWithVarName(false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.setVariable(task.getId(), "variable1", (Object)1);
        task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"Before Condition", (String)task.getName());
        Assert.assertEquals((int)1, (int)this.conditionEventSubscriptionQuery.list().size());
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        this.taskService.removeVariable(task.getId(), "variable");
        List tasks = taskQuery.taskName("After Condition").list();
        Assert.assertEquals((int)3, (int)tasks.size());
        Assert.assertEquals((int)1, (int)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    public void testNonInterruptingVariableConditionWithVariableNameAndEvents() {
        this.deployBoundaryEventProcessWithVarNameAndEvents(false, "create, update");
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        this.taskService.removeVariable(task.getId(), "variable");
        List tasks = taskQuery.taskName("After Condition").list();
        Assert.assertEquals((int)2, (int)tasks.size());
        Assert.assertEquals((int)1, (int)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    public void testVariableConditionWithVariableEvent() {
        this.deployBoundaryEventProcessWithVarEvents(true, "update");
        VariableMap variables = Variables.createVariables();
        variables.put("variable1", 0);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess", (Map)variables);
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        this.runtimeService.setVariable(procInst.getId(), "variable", (Object)1);
        task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"Before Condition", (String)task.getName());
        Assert.assertEquals((int)1, (int)this.conditionEventSubscriptionQuery.list().size());
        this.runtimeService.setVariable(procInst.getId(), "variable1", (Object)1);
        task = (Task)taskQuery.singleResult();
        Assert.assertEquals((String)"After Condition", (String)task.getName());
        Assert.assertEquals((int)0, (int)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    public void testNonInterruptingVariableConditionWithVariableEvent() {
        this.deployBoundaryEventProcessWithVarEvents(false, "update");
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        List tasks = taskQuery.taskName("After Condition").list();
        Assert.assertEquals((int)2, (int)tasks.size());
        Assert.assertEquals((int)1, (int)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    @Deployment
    public void testTrueConditionWithExecutionListener() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)TASK_WITH_CONDITION, (String)task.getName());
        Assert.assertEquals((int)1, (int)this.conditionEventSubscriptionQuery.list().size());
        this.taskService.complete(task.getId());
        task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"After Condition", (String)task.getName());
        Assert.assertEquals((int)0, (int)this.conditionEventSubscriptionQuery.list().size());
    }

    protected void deployBoundaryEventProcessWithVarName(boolean interrupting) {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((ConditionalEventDefinitionBuilder)((ConditionalEventDefinitionBuilder)((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(TASK_MODEL).userTaskBuilder("beforeConditionId").boundaryEvent().cancelActivity(Boolean.valueOf(interrupting))).conditionalEventDefinition("conditionalEvent").condition("${true}")).camundaVariableName("variable")).conditionalEventDefinitionDone().userTask().name("After Condition")).endEvent().done();
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
    }

    protected void deployBoundaryEventProcessWithVarNameAndEvents(boolean interrupting, String varEvent) {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((ConditionalEventDefinitionBuilder)((ConditionalEventDefinitionBuilder)((ConditionalEventDefinitionBuilder)((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(TASK_MODEL).userTaskBuilder("beforeConditionId").boundaryEvent().cancelActivity(Boolean.valueOf(interrupting))).conditionalEventDefinition("conditionalEvent").condition("${variable == 1}")).camundaVariableName("variable")).camundaVariableEvents(varEvent)).conditionalEventDefinitionDone().userTask().name("After Condition")).endEvent().done();
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
    }

    protected void deployBoundaryEventProcessWithVarEvents(boolean interrupting, String varEvent) {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((ConditionalEventDefinitionBuilder)((ConditionalEventDefinitionBuilder)((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(TASK_MODEL).userTaskBuilder("beforeConditionId").boundaryEvent().cancelActivity(Boolean.valueOf(interrupting))).conditionalEventDefinition("conditionalEvent").condition("${variable == 1}")).camundaVariableEvents(varEvent)).conditionalEventDefinitionDone().userTask().name("After Condition")).endEvent().done();
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
    }
}

