/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.conditional;

import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.bpmn.event.conditional.AbstractConditionalEventTestCase;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ConditionalEventDefinitionBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.builder.SubProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.Ignore;
import org.junit.Test;

public class EventSubProcessStartConditionalEventTest
extends AbstractConditionalEventTestCase {
    @Test
    @Deployment
    public void testTrueCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"Before Condition", (String)task.getName());
        Assert.assertEquals((int)1, (int)this.conditionEventSubscriptionQuery.list().size());
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        task = (Task)taskQuery.singleResult();
        Assert.assertEquals((String)"After Condition", (String)task.getName());
        Assert.assertEquals((int)0, (int)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    @Deployment
    public void testFalseCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"Before Condition", (String)task.getName());
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        task = (Task)taskQuery.singleResult();
        Assert.assertEquals((String)"Before Condition", (String)task.getName());
    }

    @Test
    @Deployment
    public void testVariableCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"Before Condition", (String)task.getName());
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        task = (Task)taskQuery.singleResult();
        Assert.assertEquals((String)"After Condition", (String)task.getName());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/EventSubProcessStartConditionalEventTest.testVariableCondition.bpmn20.xml"})
    public void testWrongVariableCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"Before Condition", (String)task.getName());
        Assert.assertEquals((int)1, (int)this.conditionEventSubscriptionQuery.list().size());
        this.taskService.setVariable(task.getId(), "variable1", (Object)1);
        task = (Task)taskQuery.singleResult();
        Assert.assertEquals((String)"Before Condition", (String)task.getName());
        Assert.assertEquals((int)1, (int)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    @Deployment
    public void testNonInterruptingVariableCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"Before Condition", (String)task.getName());
        Assert.assertEquals((int)1, (int)this.conditionEventSubscriptionQuery.list().size());
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        List tasks = taskQuery.list();
        Assert.assertEquals((int)2, (int)tasks.size());
        Assert.assertEquals((int)1, (int)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    @Deployment
    public void testSubProcessVariableCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"Before Condition", (String)task.getName());
        this.taskService.setVariableLocal(task.getId(), "variable", (Object)1);
        task = (Task)taskQuery.singleResult();
        Assert.assertEquals((String)"Before Condition", (String)task.getName());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/EventSubProcessStartConditionalEventTest.testSubProcessVariableCondition.bpmn20.xml"})
    public void testSubProcessSetVariableOnTaskCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"Before Condition", (String)task.getName());
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        task = (Task)taskQuery.singleResult();
        Assert.assertEquals((String)"After Condition", (String)task.getName());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/EventSubProcessStartConditionalEventTest.testSubProcessVariableCondition.bpmn20.xml"})
    public void testSubProcessSetVariableOnExecutionCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"Before Condition", (String)task.getName());
        this.runtimeService.setVariableLocal(task.getExecutionId(), "variable", (Object)1);
        task = (Task)taskQuery.singleResult();
        Assert.assertEquals((String)"Before Condition", (String)task.getName());
    }

    @Ignore
    @Deployment
    public void testSetVariableInDelegate() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"Before Condition", (String)task.getName());
        this.taskService.complete(task.getId());
        task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"After Condition", (String)task.getName());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/EventSubProcessStartConditionalEventTest.testSubProcessVariableCondition.bpmn20.xml"})
    public void testSubProcessSetVariableOnProcessInstanceCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"Before Condition", (String)task.getName());
        this.runtimeService.setVariable(procInst.getId(), "variable", (Object)1);
        task = (Task)taskQuery.singleResult();
        Assert.assertEquals((String)"After Condition", (String)task.getName());
    }

    @Test
    public void testVariableConditionWithVariableName() {
        this.deployEventSubProcessWithVarName(true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.setVariable(task.getId(), "variable1", (Object)1);
        task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"Before Condition", (String)task.getName());
        Assert.assertEquals((int)1, (int)this.conditionEventSubscriptionQuery.list().size());
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        task = (Task)taskQuery.singleResult();
        Assert.assertEquals((String)"After Condition", (String)task.getName());
        Assert.assertEquals((int)0, (int)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    public void testVariableConditionWithVariableNameAndEvent() {
        this.deployEventSubProcessWithVarNameAndEvents(true, "update");
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"Before Condition", (String)task.getName());
        Assert.assertEquals((int)1, (int)this.conditionEventSubscriptionQuery.list().size());
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        task = (Task)taskQuery.singleResult();
        Assert.assertEquals((String)"After Condition", (String)task.getName());
        Assert.assertEquals((int)0, (int)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    public void testNonInterruptingVariableConditionWithVariableName() {
        this.deployEventSubProcessWithVarName(false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.setVariable(task.getId(), "variable1", (Object)1);
        task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"Before Condition", (String)task.getName());
        Assert.assertEquals((int)1, (int)this.conditionEventSubscriptionQuery.list().size());
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        this.taskService.removeVariable(task.getId(), "variable");
        List tasks = taskQuery.taskName("After Condition").list();
        Assert.assertEquals((int)3, (int)tasks.size());
        Assert.assertEquals((int)1, (int)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    public void testNonInterruptingVariableConditionWithVariableNameAndEvents() {
        this.deployEventSubProcessWithVarNameAndEvents(false, "create, update");
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        this.taskService.removeVariable(task.getId(), "variable");
        List tasks = taskQuery.taskName("After Condition").list();
        Assert.assertEquals((int)2, (int)tasks.size());
        Assert.assertEquals((int)1, (int)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    public void testVariableConditionWithVariableEvent() {
        this.deployEventSubProcessWithVarEvent(true, "update");
        VariableMap variables = Variables.createVariables();
        variables.put("variable1", 0);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess", (Map)variables);
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        this.runtimeService.setVariable(procInst.getId(), "variable", (Object)1);
        task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"Before Condition", (String)task.getName());
        Assert.assertEquals((int)1, (int)this.conditionEventSubscriptionQuery.list().size());
        this.runtimeService.setVariable(procInst.getId(), "variable1", (Object)1);
        task = (Task)taskQuery.singleResult();
        Assert.assertEquals((String)"After Condition", (String)task.getName());
        Assert.assertEquals((int)0, (int)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    public void testNonInterruptingVariableConditionWithVariableEvent() {
        this.deployEventSubProcessWithVarEvent(false, "update");
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        List tasks = taskQuery.taskName("After Condition").list();
        Assert.assertEquals((int)2, (int)tasks.size());
        Assert.assertEquals((int)1, (int)this.conditionEventSubscriptionQuery.list().size());
    }

    protected void deployEventSubProcessWithVarName(boolean interrupting) {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((ConditionalEventDefinitionBuilder)((ConditionalEventDefinitionBuilder)((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(TASK_MODEL).addSubProcessTo("conditionalEventProcess").triggerByEvent()).embeddedSubProcess().startEvent().interrupting(interrupting)).conditionalEventDefinition("conditionalEvent").condition("${true}")).camundaVariableName("variable")).conditionalEventDefinitionDone().userTask().name("After Condition")).endEvent().done();
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
    }

    protected void deployEventSubProcessWithVarNameAndEvents(boolean interrupting, String varEvent) {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((ConditionalEventDefinitionBuilder)((ConditionalEventDefinitionBuilder)((ConditionalEventDefinitionBuilder)((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(TASK_MODEL).addSubProcessTo("conditionalEventProcess").triggerByEvent()).embeddedSubProcess().startEvent().interrupting(interrupting)).conditionalEventDefinition("conditionalEvent").condition("${variable == 1}")).camundaVariableName("variable")).camundaVariableEvents(varEvent)).conditionalEventDefinitionDone().userTask().name("After Condition")).endEvent().done();
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
    }

    protected void deployEventSubProcessWithVarEvent(boolean interrupting, String varEvent) {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((ConditionalEventDefinitionBuilder)((ConditionalEventDefinitionBuilder)((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(TASK_MODEL).addSubProcessTo("conditionalEventProcess").triggerByEvent()).embeddedSubProcess().startEvent().interrupting(interrupting)).conditionalEventDefinition("conditionalEvent").condition("${variable == 1}")).camundaVariableEvents(varEvent)).conditionalEventDefinitionDone().userTask().name("After Condition")).endEvent().done();
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
    }
}

