/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.conditional;

import java.util.Map;
import junit.framework.Assert;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.event.conditional.AbstractConditionalEventTestCase;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ConditionalEventDefinitionBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.Test;

public class IntermediateConditionalEventTest
extends AbstractConditionalEventTestCase {
    @Test
    @Deployment
    public void testFalseCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task task = (Task)taskQuery.processInstanceId(procInst.getId()).singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"Before Condition", (String)task.getName());
        this.taskService.complete(task.getId());
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId("conditionalEvent").singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((int)1, (int)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    @Deployment
    public void testTrueCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"Before Condition", (String)task.getName());
        this.taskService.complete(task.getId());
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId("conditionalEvent").singleResult();
        Assert.assertNull((Object)execution);
        task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"After Condition", (String)task.getName());
    }

    @Test
    @Deployment
    public void testVariableValue() {
        VariableMap variables = Variables.createVariables();
        variables.put("variable", 0);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess", (Map)variables);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId("conditionalEvent").singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((int)1, (int)this.conditionEventSubscriptionQuery.list().size());
        this.runtimeService.setVariable(execution.getId(), "variable", (Object)1);
        execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId("conditionalEvent").singleResult();
        Assert.assertNull((Object)execution);
        procInst = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("conditionalEventProcess").singleResult();
        Assert.assertNull((Object)procInst);
        Assert.assertEquals((int)0, (int)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    @Deployment
    public void testParallelVariableValue() {
        VariableMap variables = Variables.createVariables();
        variables.put("variable", 0);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess", (Map)variables);
        Execution execution1 = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId("conditionalEvent1").singleResult();
        Execution execution2 = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId("conditionalEvent2").singleResult();
        Assert.assertEquals((int)2, (int)this.conditionEventSubscriptionQuery.list().size());
        this.runtimeService.setVariable(execution1.getId(), "variable", (Object)1);
        execution1 = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId("conditionalEvent1").singleResult();
        Assert.assertNull((Object)execution1);
        Assert.assertEquals((int)1, (int)this.conditionEventSubscriptionQuery.list().size());
        this.runtimeService.setVariable(execution2.getId(), "variable", (Object)2);
        execution2 = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId("conditionalEvent2").singleResult();
        Assert.assertNull((Object)execution2);
        procInst = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("conditionalEventProcess").singleResult();
        Assert.assertNull((Object)procInst);
        Assert.assertEquals((int)0, (int)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    @Deployment
    public void testParallelVariableValueEqualConditions() {
        VariableMap variables = Variables.createVariables();
        variables.put("variable", 0);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess", (Map)variables);
        this.runtimeService.setVariable(procInst.getId(), "variable", (Object)1);
        procInst = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("conditionalEventProcess").singleResult();
        Assert.assertNull((Object)procInst);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/IntermediateConditionalEventTest.testParallelVariableValue.bpmn20.xml"})
    public void testParallelVariableSetValueOnParent() {
        VariableMap variables = Variables.createVariables();
        variables.put("variable", 0);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess", (Map)variables);
        this.runtimeService.setVariable(procInst.getId(), "variable", (Object)1);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId("conditionalEvent1").singleResult();
        Assert.assertNull((Object)execution);
        this.runtimeService.setVariable(procInst.getId(), "variable", (Object)2);
        execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId("conditionalEvent2").singleResult();
        Assert.assertNull((Object)execution);
        procInst = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("conditionalEventProcess").singleResult();
        Assert.assertNull((Object)procInst);
    }

    @Test
    @Deployment
    public void testSubProcessVariableValue() {
        VariableMap variables = Variables.createVariables();
        variables.put("variable", 0);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess", (Map)variables);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId("conditionalEvent").singleResult();
        Assert.assertNotNull((Object)execution);
        this.runtimeService.setVariableLocal(execution.getId(), "variable", (Object)1);
        execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId("conditionalEvent").singleResult();
        Assert.assertNull((Object)execution);
        procInst = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("conditionalEventProcess").singleResult();
        Assert.assertNull((Object)procInst);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/IntermediateConditionalEventTest.testSubProcessVariableValue.bpmn20.xml"})
    public void testSubProcessVariableSetValueOnParent() {
        VariableMap variables = Variables.createVariables();
        variables.put("variable", 0);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess", (Map)variables);
        this.runtimeService.setVariable(procInst.getId(), "variable", (Object)1);
        procInst = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("conditionalEventProcess").singleResult();
        Assert.assertNull((Object)procInst);
    }

    @Test
    @Deployment
    public void testCleanUpConditionalEventSubscriptions() {
        VariableMap variables = Variables.createVariables();
        variables.put("variable", 0);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess", (Map)variables);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId("conditionalEvent").singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((int)1, (int)this.conditionEventSubscriptionQuery.list().size());
        this.runtimeService.setVariable(execution.getId(), "variable", (Object)1);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(procInst.getId()).singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"After Condition", (String)task.getName());
        Assert.assertEquals((int)0, (int)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    public void testVariableConditionWithVariableName() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((ConditionalEventDefinitionBuilder)((ConditionalEventDefinitionBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().intermediateCatchEvent("conditionalEvent").conditionalEventDefinition().condition("${variable == 1}")).camundaVariableName("variable")).conditionalEventDefinitionDone().userTask().name("After Condition")).endEvent().done();
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId("conditionalEvent").singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((int)1, (int)this.conditionEventSubscriptionQuery.list().size());
        this.runtimeService.setVariable(procInst.getId(), "variable1", (Object)1);
        execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId("conditionalEvent").singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((int)1, (int)this.conditionEventSubscriptionQuery.list().size());
        this.runtimeService.setVariable(procInst.getId(), "variable", (Object)1);
        Task task = (Task)taskQuery.singleResult();
        Assert.assertEquals((String)"After Condition", (String)task.getName());
        Assert.assertEquals((int)0, (int)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    public void testVariableConditionWithVariableEvent() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((ConditionalEventDefinitionBuilder)((ConditionalEventDefinitionBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().intermediateCatchEvent("conditionalEvent").conditionalEventDefinition().condition("${variable == 1}")).camundaVariableEvents("update")).conditionalEventDefinitionDone().userTask().name("After Condition")).endEvent().done();
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        VariableMap variables = Variables.createVariables();
        variables.put("variable1", 0);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess", (Map)variables);
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId("conditionalEvent").singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((int)1, (int)this.conditionEventSubscriptionQuery.list().size());
        this.runtimeService.setVariable(procInst.getId(), "variable", (Object)1);
        execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId("conditionalEvent").singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((int)1, (int)this.conditionEventSubscriptionQuery.list().size());
        this.runtimeService.setVariable(procInst.getId(), "variable1", (Object)1);
        Task task = (Task)taskQuery.singleResult();
        Assert.assertEquals((String)"After Condition", (String)task.getName());
        Assert.assertEquals((int)0, (int)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    public void testVariableConditionWithVariableNameAndEvent() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((ConditionalEventDefinitionBuilder)((ConditionalEventDefinitionBuilder)((ConditionalEventDefinitionBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().intermediateCatchEvent("conditionalEvent").conditionalEventDefinition().condition("${variable == 1}")).camundaVariableName("variable")).camundaVariableEvents("update")).conditionalEventDefinitionDone().userTask().name("After Condition")).endEvent().done();
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId("conditionalEvent").singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((int)1, (int)this.conditionEventSubscriptionQuery.list().size());
        this.runtimeService.setVariable(procInst.getId(), "variable", (Object)1);
        execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId("conditionalEvent").singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((int)1, (int)this.conditionEventSubscriptionQuery.list().size());
        this.runtimeService.setVariable(procInst.getId(), "variable", (Object)1);
        Task task = (Task)taskQuery.singleResult();
        Assert.assertEquals((String)"After Condition", (String)task.getName());
        Assert.assertEquals((int)0, (int)this.conditionEventSubscriptionQuery.list().size());
    }
}

