/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.parse;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.bpmn.behavior.BoundaryConditionalEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.BoundaryEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.CompensationEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.EventSubProcessStartConditionalEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.EventSubProcessStartEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.IntermediateConditionalEventBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.NoneStartEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.ThrowEscalationEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.helper.BpmnProperties;
import org.camunda.bpm.engine.impl.bpmn.parser.BpmnParse;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.PvmTransition;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.process.TransitionImpl;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.test.TestHelper;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.test.Deployment;
import org.junit.Test;

public class BpmnParseTest
extends PluggableProcessEngineTestCase {
    public void testInvalidSubProcessWithTimerStartEvent() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(((Object)((Object)this)).getClass(), (String)"testInvalidSubProcessWithTimerStartEvent");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            BpmnParseTest.fail((String)"Exception expected: Process definition could be parsed, although the sub process contains a timer start event.");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("timerEventDefinition is not allowed on start event within a subprocess", e.getMessage());
        }
    }

    public void testInvalidSubProcessWithMessageStartEvent() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(((Object)((Object)this)).getClass(), (String)"testInvalidSubProcessWithMessageStartEvent");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            BpmnParseTest.fail((String)"Process definition could be parsed, although the sub process contains not a blanco start event.");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("messageEventDefinition only allowed on start event if subprocess is an event subprocess", e.getMessage());
        }
    }

    public void testInvalidSubProcessWithConditionalStartEvent() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(((Object)((Object)this)).getClass(), (String)"testInvalidSubProcessWithConditionalStartEvent");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            BpmnParseTest.fail((String)"Exception expected: Process definition could be parsed, although the sub process contains a conditional start event.");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("conditionalEventDefinition is not allowed on start event within a subprocess", e.getMessage());
        }
    }

    public void testInvalidSubProcessWithSignalStartEvent() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(((Object)((Object)this)).getClass(), (String)"testInvalidSubProcessWithSignalStartEvent");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            BpmnParseTest.fail((String)"Exception expected: Process definition could be parsed, although the sub process contains a signal start event.");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("signalEventDefintion only allowed on start event if subprocess is an event subprocess", e.getMessage());
        }
    }

    public void testInvalidSubProcessWithErrorStartEvent() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(((Object)((Object)this)).getClass(), (String)"testInvalidSubProcessWithErrorStartEvent");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            BpmnParseTest.fail((String)"Exception expected: Process definition could be parsed, although the sub process contains a error start event.");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("errorEventDefinition only allowed on start event if subprocess is an event subprocess", e.getMessage());
        }
    }

    public void testInvalidSubProcessWithEscalationStartEvent() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(((Object)((Object)this)).getClass(), (String)"testInvalidSubProcessWithEscalationStartEvent");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            BpmnParseTest.fail((String)"Exception expected: Process definition could be parsed, although the sub process contains a escalation start event.");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("escalationEventDefinition is not allowed on start event within a subprocess", e.getMessage());
        }
    }

    public void testInvalidSubProcessWithCompensationStartEvent() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(((Object)((Object)this)).getClass(), (String)"testInvalidSubProcessWithCompensationStartEvent");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            BpmnParseTest.fail((String)"Exception expected: Process definition could be parsed, although the sub process contains a compensation start event.");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("compensateEventDefinition is not allowed on start event within a subprocess", e.getMessage());
        }
    }

    public void testInvalidTransactionWithMessageStartEvent() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(((Object)((Object)this)).getClass(), (String)"testInvalidTransactionWithMessageStartEvent");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            BpmnParseTest.fail((String)"Process definition could be parsed, although the sub process contains not a blanco start event.");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("messageEventDefinition only allowed on start event if subprocess is an event subprocess", e.getMessage());
        }
    }

    public void testInvalidTransactionWithTimerStartEvent() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(((Object)((Object)this)).getClass(), (String)"testInvalidTransactionWithTimerStartEvent");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            BpmnParseTest.fail((String)"Exception expected: Process definition could be parsed, although the sub process contains a timer start event.");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("timerEventDefinition is not allowed on start event within a subprocess", e.getMessage());
        }
    }

    public void testInvalidTransactionWithConditionalStartEvent() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(((Object)((Object)this)).getClass(), (String)"testInvalidTransactionWithConditionalStartEvent");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            BpmnParseTest.fail((String)"Exception expected: Process definition could be parsed, although the sub process contains a conditional start event.");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("conditionalEventDefinition is not allowed on start event within a subprocess", e.getMessage());
        }
    }

    public void testInvalidTransactionWithSignalStartEvent() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(((Object)((Object)this)).getClass(), (String)"testInvalidTransactionWithSignalStartEvent");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            BpmnParseTest.fail((String)"Exception expected: Process definition could be parsed, although the sub process contains a signal start event.");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("signalEventDefintion only allowed on start event if subprocess is an event subprocess", e.getMessage());
        }
    }

    public void testInvalidTransactionWithErrorStartEvent() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(((Object)((Object)this)).getClass(), (String)"testInvalidTransactionWithErrorStartEvent");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            BpmnParseTest.fail((String)"Exception expected: Process definition could be parsed, although the sub process contains a error start event.");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("errorEventDefinition only allowed on start event if subprocess is an event subprocess", e.getMessage());
        }
    }

    public void testInvalidTransactionWithEscalationStartEvent() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(((Object)((Object)this)).getClass(), (String)"testInvalidTransactionWithEscalationStartEvent");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            BpmnParseTest.fail((String)"Exception expected: Process definition could be parsed, although the sub process contains a escalation start event.");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("escalationEventDefinition is not allowed on start event within a subprocess", e.getMessage());
        }
    }

    public void testInvalidTransactionWithCompensationStartEvent() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(((Object)((Object)this)).getClass(), (String)"testInvalidTransactionWithCompensationStartEvent");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            BpmnParseTest.fail((String)"Exception expected: Process definition could be parsed, although the sub process contains a compensation start event.");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("compensateEventDefinition is not allowed on start event within a subprocess", e.getMessage());
        }
    }

    public void testInvalidProcessDefinition() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(((Object)((Object)this)).getClass(), (String)"testInvalidProcessDefinition");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            BpmnParseTest.fail();
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("cvc-complex-type.3.2.2:", e.getMessage());
            this.assertTextPresent("invalidAttribute", e.getMessage());
            this.assertTextPresent("process", e.getMessage());
        }
    }

    public void testInvalidSequenceFlowInAndOutEventSubProcess() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(((Object)((Object)this)).getClass(), (String)"testInvalidSequenceFlowInAndOutEventSubProcess");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            BpmnParseTest.fail((String)"Exception expected: Process definition could be parsed, although the sub process has incoming and outgoing sequence flows");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Invalid incoming sequence flow of event subprocess", e.getMessage());
            this.assertTextPresent("Invalid outgoing sequence flow of event subprocess", e.getMessage());
        }
    }

    public void testParseMultipleStartEvent() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(((Object)((Object)this)).getClass(), (String)"testParseMultipleStartEvent");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            BpmnParseTest.fail();
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("timerEventDefinition is not allowed on start event within a subprocess", e.getMessage());
            this.assertTextPresent("messageEventDefinition only allowed on start event if subprocess is an event subprocess", e.getMessage());
        }
    }

    public void testParseWithBpmnNamespacePrefix() {
        this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/parse/BpmnParseTest.testParseWithBpmnNamespacePrefix.bpmn20.xml").deploy();
        BpmnParseTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        this.repositoryService.deleteDeployment(((org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId(), true);
    }

    public void testParseWithMultipleDocumentation() {
        this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/parse/BpmnParseTest.testParseWithMultipleDocumentation.bpmn20.xml").deploy();
        BpmnParseTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        this.repositoryService.deleteDeployment(((org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId(), true);
    }

    public void testParseCollaborationPlane() {
        this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/parse/BpmnParseTest.testParseCollaborationPlane.bpmn").deploy();
        BpmnParseTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        this.repositoryService.deleteDeployment(((org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId(), true);
    }

    public void testInvalidAsyncAfterEventBasedGateway() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(((Object)((Object)this)).getClass(), (String)"testInvalidAsyncAfterEventBasedGateway");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            BpmnParseTest.fail();
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("'asyncAfter' not supported for", e.getMessage());
        }
    }

    @Deployment
    public void testParseDiagramInterchangeElements() {
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        ProcessDefinitionEntity processDefinitionEntity = (ProcessDefinitionEntity)commandExecutor.execute((Command)new Command<ProcessDefinitionEntity>(){

            public ProcessDefinitionEntity execute(CommandContext commandContext) {
                return Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedLatestProcessDefinitionByKey("myProcess");
            }
        });
        BpmnParseTest.assertNotNull((Object)processDefinitionEntity);
        BpmnParseTest.assertEquals((int)7, (int)processDefinitionEntity.getActivities().size());
        List resourceNames = this.repositoryService.getDeploymentResourceNames(processDefinitionEntity.getDeploymentId());
        if (this.processEngineConfiguration.isCreateDiagramOnDeploy()) {
            BpmnParseTest.assertEquals((int)2, (int)resourceNames.size());
        } else {
            BpmnParseTest.assertEquals((int)1, (int)resourceNames.size());
        }
        for (ActivityImpl activity : processDefinitionEntity.getActivities()) {
            if (activity.getId().equals("theStart")) {
                this.assertActivityBounds(activity, 70, 255, 30, 30);
            } else if (activity.getId().equals("task1")) {
                this.assertActivityBounds(activity, 176, 230, 100, 80);
            } else if (activity.getId().equals("gateway1")) {
                this.assertActivityBounds(activity, 340, 250, 40, 40);
            } else if (activity.getId().equals("task2")) {
                this.assertActivityBounds(activity, 445, 138, 100, 80);
            } else if (activity.getId().equals("gateway2")) {
                this.assertActivityBounds(activity, 620, 250, 40, 40);
            } else if (activity.getId().equals("task3")) {
                this.assertActivityBounds(activity, 453, 304, 100, 80);
            } else if (activity.getId().equals("theEnd")) {
                this.assertActivityBounds(activity, 713, 256, 28, 28);
            }
            for (PvmTransition sequenceFlow : activity.getOutgoingTransitions()) {
                BpmnParseTest.assertTrue((((TransitionImpl)sequenceFlow).getWaypoints().size() >= 4 ? 1 : 0) != 0);
                TransitionImpl transitionImpl = (TransitionImpl)sequenceFlow;
                if (transitionImpl.getId().equals("flowStartToTask1")) {
                    this.assertSequenceFlowWayPoints(transitionImpl, 100, 270, 176, 270);
                    continue;
                }
                if (transitionImpl.getId().equals("flowTask1ToGateway1")) {
                    this.assertSequenceFlowWayPoints(transitionImpl, 276, 270, 340, 270);
                    continue;
                }
                if (transitionImpl.getId().equals("flowGateway1ToTask2")) {
                    this.assertSequenceFlowWayPoints(transitionImpl, 360, 250, 360, 178, 445, 178);
                    continue;
                }
                if (transitionImpl.getId().equals("flowGateway1ToTask3")) {
                    this.assertSequenceFlowWayPoints(transitionImpl, 360, 290, 360, 344, 453, 344);
                    continue;
                }
                if (transitionImpl.getId().equals("flowTask2ToGateway2")) {
                    this.assertSequenceFlowWayPoints(transitionImpl, 545, 178, 640, 178, 640, 250);
                    continue;
                }
                if (transitionImpl.getId().equals("flowTask3ToGateway2")) {
                    this.assertSequenceFlowWayPoints(transitionImpl, 553, 344, 640, 344, 640, 290);
                    continue;
                }
                if (!transitionImpl.getId().equals("flowGateway2ToEnd")) continue;
                this.assertSequenceFlowWayPoints(transitionImpl, 660, 270, 713, 270);
            }
        }
    }

    @Deployment
    public void testParseNamespaceInConditionExpressionType() {
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        ProcessDefinitionEntity processDefinitionEntity = (ProcessDefinitionEntity)commandExecutor.execute((Command)new Command<ProcessDefinitionEntity>(){

            public ProcessDefinitionEntity execute(CommandContext commandContext) {
                return Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedLatestProcessDefinitionByKey("resolvableNamespacesProcess");
            }
        });
        BpmnParseTest.assertNotNull((Object)processDefinitionEntity);
        ActivityImpl activity = processDefinitionEntity.findActivity("ExclusiveGateway_1");
        BpmnParseTest.assertNotNull((Object)activity);
        for (PvmTransition transition : activity.getOutgoingTransitions()) {
            if (transition.getDestination().getId().equals("Task_2")) {
                BpmnParseTest.assertTrue((boolean)transition.getProperty("conditionText").equals("#{approved}"));
                continue;
            }
            if (transition.getDestination().getId().equals("Task_3")) {
                BpmnParseTest.assertTrue((boolean)transition.getProperty("conditionText").equals("#{!approved}"));
                continue;
            }
            BpmnParseTest.fail((String)"Something went wrong");
        }
    }

    @Deployment
    public void testParseDiagramInterchangeElementsForUnknownModelElements() {
    }

    @Test
    @Deployment
    public void testParseDefinitionWithDeprecatedActivitiNamespace() {
    }

    @Test
    @Deployment
    public void testParseDefinitionWithCamundaNamespace() {
    }

    @Deployment
    public void testParseCompensationEndEvent() {
        ActivityImpl endEvent = this.findActivityInDeployedProcessDefinition("end");
        BpmnParseTest.assertEquals((Object)"compensationEndEvent", (Object)endEvent.getProperty("type"));
        BpmnParseTest.assertEquals((Object)Boolean.TRUE, (Object)endEvent.getProperty("throwsCompensation"));
        BpmnParseTest.assertEquals(CompensationEventActivityBehavior.class, endEvent.getActivityBehavior().getClass());
    }

    @Deployment
    public void testParseCompensationStartEvent() {
        ActivityImpl compensationStartEvent = this.findActivityInDeployedProcessDefinition("compensationStartEvent");
        BpmnParseTest.assertEquals((Object)"compensationStartEvent", (Object)compensationStartEvent.getProperty("type"));
        BpmnParseTest.assertEquals(EventSubProcessStartEventActivityBehavior.class, compensationStartEvent.getActivityBehavior().getClass());
        ActivityImpl compensationEventSubProcess = (ActivityImpl)compensationStartEvent.getFlowScope();
        BpmnParseTest.assertEquals((Object)Boolean.TRUE, (Object)compensationEventSubProcess.getProperty("isForCompensation"));
        ScopeImpl subprocess = compensationEventSubProcess.getFlowScope();
        BpmnParseTest.assertEquals((Object)compensationEventSubProcess.getActivityId(), (Object)subprocess.getProperty("compensationHandler"));
    }

    @Deployment
    public void testParseAsyncMultiInstanceBody() {
        ActivityImpl innerTask = this.findActivityInDeployedProcessDefinition("miTask");
        ActivityImpl miBody = innerTask.getParentFlowScopeActivity();
        BpmnParseTest.assertTrue((boolean)miBody.isAsyncBefore());
        BpmnParseTest.assertTrue((boolean)miBody.isAsyncAfter());
        BpmnParseTest.assertFalse((boolean)innerTask.isAsyncBefore());
        BpmnParseTest.assertFalse((boolean)innerTask.isAsyncAfter());
    }

    @Deployment
    public void testParseAsyncActivityWrappedInMultiInstanceBody() {
        ActivityImpl innerTask = this.findActivityInDeployedProcessDefinition("miTask");
        BpmnParseTest.assertTrue((boolean)innerTask.isAsyncBefore());
        BpmnParseTest.assertTrue((boolean)innerTask.isAsyncAfter());
        ActivityImpl miBody = innerTask.getParentFlowScopeActivity();
        BpmnParseTest.assertFalse((boolean)miBody.isAsyncBefore());
        BpmnParseTest.assertFalse((boolean)miBody.isAsyncAfter());
    }

    @Deployment
    public void testParseAsyncActivityWrappedInMultiInstanceBodyWithAsyncMultiInstance() {
        ActivityImpl innerTask = this.findActivityInDeployedProcessDefinition("miTask");
        BpmnParseTest.assertEquals((boolean)true, (boolean)innerTask.isAsyncBefore());
        BpmnParseTest.assertEquals((boolean)false, (boolean)innerTask.isAsyncAfter());
        ActivityImpl miBody = innerTask.getParentFlowScopeActivity();
        BpmnParseTest.assertEquals((boolean)false, (boolean)miBody.isAsyncBefore());
        BpmnParseTest.assertEquals((boolean)true, (boolean)miBody.isAsyncAfter());
    }

    public void testParseSwitchedSourceAndTargetRefsForAssociations() {
        this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/parse/BpmnParseTest.testParseSwitchedSourceAndTargetRefsForAssociations.bpmn20.xml").deploy();
        BpmnParseTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        this.repositoryService.deleteDeployment(((org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId(), true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.compensationMiActivity.bpmn20.xml"})
    public void testParseCompensationHandlerOfMiActivity() {
        ActivityImpl miActivity = this.findActivityInDeployedProcessDefinition("undoBookHotel");
        ScopeImpl flowScope = miActivity.getFlowScope();
        BpmnParseTest.assertEquals((Object)"multiInstanceBody", (Object)flowScope.getProperty(BpmnParse.PROPERTYNAME_TYPE));
        BpmnParseTest.assertEquals((String)"bookHotel#multiInstanceBody", (String)((ActivityImpl)flowScope).getActivityId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.compensationMiSubprocess.bpmn20.xml"})
    public void testParseCompensationHandlerOfMiSubprocess() {
        ActivityImpl miActivity = this.findActivityInDeployedProcessDefinition("undoBookHotel");
        ScopeImpl flowScope = miActivity.getFlowScope();
        BpmnParseTest.assertEquals((Object)"multiInstanceBody", (Object)flowScope.getProperty(BpmnParse.PROPERTYNAME_TYPE));
        BpmnParseTest.assertEquals((String)"scope#multiInstanceBody", (String)((ActivityImpl)flowScope).getActivityId());
    }

    @Deployment
    public void testParseSignalStartEvent() {
        ActivityImpl signalStartActivity = this.findActivityInDeployedProcessDefinition("start");
        BpmnParseTest.assertEquals((Object)"signalStartEvent", (Object)signalStartActivity.getProperty("type"));
        BpmnParseTest.assertEquals(NoneStartEventActivityBehavior.class, signalStartActivity.getActivityBehavior().getClass());
    }

    @Deployment
    public void testParseEscalationBoundaryEvent() {
        ActivityImpl escalationBoundaryEvent = this.findActivityInDeployedProcessDefinition("escalationBoundaryEvent");
        BpmnParseTest.assertEquals((String)"boundaryEscalation", (String)((String)escalationBoundaryEvent.getProperties().get(BpmnProperties.TYPE)));
        BpmnParseTest.assertEquals(BoundaryEventActivityBehavior.class, escalationBoundaryEvent.getActivityBehavior().getClass());
    }

    @Deployment
    public void testParseEscalationIntermediateThrowingEvent() {
        ActivityImpl escalationThrowingEvent = this.findActivityInDeployedProcessDefinition("escalationThrowingEvent");
        BpmnParseTest.assertEquals((String)"intermediateEscalationThrowEvent", (String)((String)escalationThrowingEvent.getProperties().get(BpmnProperties.TYPE)));
        BpmnParseTest.assertEquals(ThrowEscalationEventActivityBehavior.class, escalationThrowingEvent.getActivityBehavior().getClass());
    }

    @Deployment
    public void testParseEscalationEndEvent() {
        ActivityImpl escalationEndEvent = this.findActivityInDeployedProcessDefinition("escalationEndEvent");
        BpmnParseTest.assertEquals((String)"escalationEndEvent", (String)((String)escalationEndEvent.getProperties().get(BpmnProperties.TYPE)));
        BpmnParseTest.assertEquals(ThrowEscalationEventActivityBehavior.class, escalationEndEvent.getActivityBehavior().getClass());
    }

    @Deployment
    public void testParseEscalationStartEvent() {
        ActivityImpl escalationStartEvent = this.findActivityInDeployedProcessDefinition("escalationStartEvent");
        BpmnParseTest.assertEquals((String)"escalationStartEvent", (String)((String)escalationStartEvent.getProperties().get(BpmnProperties.TYPE)));
        BpmnParseTest.assertEquals(EventSubProcessStartEventActivityBehavior.class, escalationStartEvent.getActivityBehavior().getClass());
    }

    public void parseInvalidConditionalEvent(String processDefinitionResource) {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(((Object)((Object)this)).getClass(), (String)processDefinitionResource);
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            BpmnParseTest.fail((String)"Exception expected: Process definition could be parsed, conditional event definition contains no condition.");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Conditional event must contain an expression for evaluation.", e.getMessage());
        }
    }

    public void testParseInvalidConditionalBoundaryEvent() {
        this.parseInvalidConditionalEvent("testParseInvalidConditionalBoundaryEvent");
    }

    @Deployment
    public void testParseConditionalBoundaryEvent() {
        ActivityImpl conditionalBoundaryEvent = this.findActivityInDeployedProcessDefinition("conditionalBoundaryEvent");
        BpmnParseTest.assertEquals((String)"boundaryConditional", (String)((String)conditionalBoundaryEvent.getProperties().get(BpmnProperties.TYPE)));
        BpmnParseTest.assertEquals(BoundaryConditionalEventActivityBehavior.class, conditionalBoundaryEvent.getActivityBehavior().getClass());
    }

    public void testParseInvalidIntermediateConditionalEvent() {
        this.parseInvalidConditionalEvent("testParseInvalidIntermediateConditionalEvent");
    }

    @Deployment
    public void testParseIntermediateConditionalEvent() {
        ActivityImpl intermediateConditionalEvent = this.findActivityInDeployedProcessDefinition("intermediateConditionalEvent");
        BpmnParseTest.assertEquals((String)"intermediateConditional", (String)((String)intermediateConditionalEvent.getProperties().get(BpmnProperties.TYPE)));
        BpmnParseTest.assertEquals(IntermediateConditionalEventBehavior.class, intermediateConditionalEvent.getActivityBehavior().getClass());
    }

    public void testParseInvalidEventSubprocessConditionalStartEvent() {
        this.parseInvalidConditionalEvent("testParseInvalidEventSubprocessConditionalStartEvent");
    }

    @Deployment
    public void testParseEventSubprocessConditionalStartEvent() {
        ActivityImpl conditionalStartEventSubProcess = this.findActivityInDeployedProcessDefinition("conditionalStartEventSubProcess");
        BpmnParseTest.assertEquals((String)"conditionalStartEvent", (String)((String)conditionalStartEventSubProcess.getProperties().get(BpmnProperties.TYPE)));
        BpmnParseTest.assertEquals(EventSubProcessStartConditionalEventActivityBehavior.class, conditionalStartEventSubProcess.getActivityBehavior().getClass());
    }

    protected void assertActivityBounds(ActivityImpl activity, int x, int y, int width, int height) {
        BpmnParseTest.assertEquals((int)x, (int)activity.getX());
        BpmnParseTest.assertEquals((int)y, (int)activity.getY());
        BpmnParseTest.assertEquals((int)width, (int)activity.getWidth());
        BpmnParseTest.assertEquals((int)height, (int)activity.getHeight());
    }

    protected void assertSequenceFlowWayPoints(TransitionImpl sequenceFlow, Integer ... waypoints) {
        BpmnParseTest.assertEquals((int)waypoints.length, (int)sequenceFlow.getWaypoints().size());
        for (int i = 0; i < waypoints.length; ++i) {
            BpmnParseTest.assertEquals((Object)waypoints[i], sequenceFlow.getWaypoints().get(i));
        }
    }

    protected ActivityImpl findActivityInDeployedProcessDefinition(String activityId) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        BpmnParseTest.assertNotNull((Object)processDefinition);
        ProcessDefinitionEntity cachedProcessDefinition = (ProcessDefinitionEntity)this.processEngineConfiguration.getDeploymentCache().getProcessDefinitionCache().get((Object)processDefinition.getId());
        return cachedProcessDefinition.findActivity(activityId);
    }
}

