/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.parse;

import org.camunda.bpm.engine.impl.bpmn.parser.FoxFailedJobParseListener;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessInstanceWithVariablesImpl;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;

public class FoxFailedJobParseListenerTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/parse/FoxFailedJobParseListenerTest.testUserTask.bpmn20.xml"})
    public void testUserTaskParseFailedJobRetryTimeCycle() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("asyncUserTaskFailedJobRetryTimeCycle");
        ActivityImpl userTask = this.findActivity(pi, "task");
        this.checkFoxFailedJobConfig(userTask);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/parse/CamundaFailedJobParseListenerTest.testUserTask.bpmn20.xml"})
    public void testUserTaskParseFailedJobRetryTimeCycleInActivitiNamespace() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("asyncUserTaskFailedJobRetryTimeCycle");
        ActivityImpl userTask = this.findActivity(pi, "task");
        this.checkFoxFailedJobConfig(userTask);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/parse/FoxFailedJobParseListenerTest.testUserTask.bpmn20.xml"})
    public void testNotAsyncUserTaskParseFailedJobRetryTimeCycle() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("notAsyncUserTaskFailedJobRetryTimeCycle");
        ActivityImpl userTask = this.findActivity(pi, "notAsyncTask");
        this.checkNotContainingFoxFailedJobConfig(userTask);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/parse/FoxFailedJobParseListenerTest.testUserTask.bpmn20.xml"})
    public void testAsyncUserTaskButWithoutParseFailedJobRetryTimeCycle() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("asyncUserTaskButWithoutFailedJobRetryTimeCycle");
        ActivityImpl userTask = this.findActivity(pi, "asyncTaskWithoutFailedJobRetryTimeCycle");
        this.checkNotContainingFoxFailedJobConfig(userTask);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/parse/FoxFailedJobParseListenerTest.testTimer.bpmn20.xml"})
    public void testTimerBoundaryEventWithFailedJobRetryTimeCycle() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("boundaryEventWithFailedJobRetryTimeCycle");
        ActivityImpl boundaryActivity = this.findActivity(pi, "boundaryTimerWithFailedJobRetryTimeCycle");
        this.checkFoxFailedJobConfig(boundaryActivity);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/parse/FoxFailedJobParseListenerTest.testTimer.bpmn20.xml"})
    public void testTimerBoundaryEventWithoutFailedJobRetryTimeCycle() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("boundaryEventWithoutFailedJobRetryTimeCycle");
        ActivityImpl boundaryActivity = this.findActivity(pi, "boundaryTimerWithoutFailedJobRetryTimeCycle");
        this.checkNotContainingFoxFailedJobConfig(boundaryActivity);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/parse/FoxFailedJobParseListenerTest.testTimer.bpmn20.xml"})
    public void testTimerStartEventWithFailedJobRetryTimeCycle() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("startEventWithFailedJobRetryTimeCycle");
        ActivityImpl startEvent = this.findActivity(pi, "startEventFailedJobRetryTimeCycle");
        this.checkFoxFailedJobConfig(startEvent);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/parse/FoxFailedJobParseListenerTest.testTimer.bpmn20.xml"})
    public void testIntermediateCatchTimerEventWithFailedJobRetryTimeCycle() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("intermediateTimerEventWithFailedJobRetryTimeCycle");
        ActivityImpl timer = this.findActivity(pi, "timerEventWithFailedJobRetryTimeCycle");
        this.checkFoxFailedJobConfig(timer);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/parse/FoxFailedJobParseListenerTest.testSignal.bpmn20.xml"})
    public void testSignalEventWithFailedJobRetryTimeCycle() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("signalEventWithFailedJobRetryTimeCycle");
        ActivityImpl signal = this.findActivity(pi, "signalWithFailedJobRetryTimeCycle");
        this.checkFoxFailedJobConfig(signal);
    }

    @Deployment
    public void testMultiInstanceBodyWithFailedJobRetryTimeCycle() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        ActivityImpl miBody = this.findMultiInstanceBody(pi, "task");
        this.checkFoxFailedJobConfig(miBody);
        ActivityImpl innerActivity = this.findActivity(pi, "task");
        this.checkNotContainingFoxFailedJobConfig(innerActivity);
    }

    @Deployment
    public void testInnerMultiInstanceActivityWithFailedJobRetryTimeCycle() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        ActivityImpl miBody = this.findMultiInstanceBody(pi, "task");
        this.checkNotContainingFoxFailedJobConfig(miBody);
        ActivityImpl innerActivity = this.findActivity(pi, "task");
        this.checkFoxFailedJobConfig(innerActivity);
    }

    @Deployment
    public void testMultiInstanceBodyAndInnerActivityWithFailedJobRetryTimeCycle() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        ActivityImpl miBody = this.findMultiInstanceBody(pi, "task");
        this.checkFoxFailedJobConfig(miBody);
        ActivityImpl innerActivity = this.findActivity(pi, "task");
        this.checkFoxFailedJobConfig(innerActivity);
    }

    protected ActivityImpl findActivity(ProcessInstance pi, String activityId) {
        ProcessInstanceWithVariablesImpl entity = (ProcessInstanceWithVariablesImpl)pi;
        ProcessDefinitionEntity processDefEntity = entity.getExecutionEntity().getProcessDefinition();
        FoxFailedJobParseListenerTest.assertNotNull((Object)processDefEntity);
        ActivityImpl activity = processDefEntity.findActivity(activityId);
        FoxFailedJobParseListenerTest.assertNotNull((Object)activity);
        return activity;
    }

    protected ActivityImpl findMultiInstanceBody(ProcessInstance pi, String activityId) {
        return this.findActivity(pi, activityId + "#multiInstanceBody");
    }

    protected void checkFoxFailedJobConfig(ActivityImpl activity) {
        FoxFailedJobParseListenerTest.assertNotNull((Object)activity);
        FoxFailedJobParseListenerTest.assertTrue((boolean)activity.getProperties().contains(FoxFailedJobParseListener.FOX_FAILED_JOB_CONFIGURATION));
        Object value = activity.getProperties().get(FoxFailedJobParseListener.FOX_FAILED_JOB_CONFIGURATION);
        FoxFailedJobParseListenerTest.assertEquals((Object)"R5/PT5M", (Object)value);
    }

    protected void checkNotContainingFoxFailedJobConfig(ActivityImpl activity) {
        FoxFailedJobParseListenerTest.assertFalse((boolean)activity.getProperties().contains(FoxFailedJobParseListener.FOX_FAILED_JOB_CONFIGURATION));
    }
}

