/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.decisiontask;

import org.camunda.bpm.engine.exception.dmn.DecisionDefinitionNotFoundException;
import org.camunda.bpm.engine.impl.test.CmmnProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.cmmn.decisiontask.TestPojo;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;

public class DmnDecisionTaskTest
extends CmmnProcessEngineTestCase {
    public static final String CMMN_CALL_DECISION_CONSTANT = "org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskTest.testCallDecisionAsConstant.cmmn";
    public static final String CMMN_CALL_DECISION_CONSTANT_WITH_MANUAL_ACTIVATION = "org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskTest.testCallDecisionAsConstantWithManualActiovation.cmmn";
    public static final String CMMN_CALL_DECISION_EXPRESSION = "org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskTest.testCallDecisionAsExpressionStartsWithDollar.cmmn";
    public static final String CMMN_CALL_DECISION_EXPRESSION_WITH_MANUAL_ACTIVATION = "org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskTest.testCallDecisionAsExpressionStartsWithDollarWithManualActiovation.cmmn";
    public static final String DECISION_OKAY_DMN = "org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskTest.testDecisionOkay.dmn11.xml";
    public static final String DECISION_NOT_OKAY_DMN = "org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskTest.testDecisionNotOkay.dmn11.xml";
    public static final String DECISION_POJO_DMN = "org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskTest.testPojo.dmn11.xml";
    public static final String DECISION_LITERAL_EXPRESSION_DMN = "org/camunda/bpm/engine/test/dmn/deployment/DecisionWithLiteralExpression.dmn";
    public static final String DRD_DISH_RESOURCE = "org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml";
    protected final String CASE_KEY = "case";
    protected final String DECISION_TASK = "PI_DecisionTask_1";
    protected final String DECISION_KEY = "testDecision";

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskTest.testCallDecisionAsConstant.cmmn", "org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskTest.testDecisionOkay.dmn11.xml"})
    public void testCallDecisionAsConstant() {
        CaseInstance caseInstance = this.createCaseInstanceByKey("case");
        DmnDecisionTaskTest.assertNull((Object)this.queryCaseExecutionByActivityId("PI_DecisionTask_1"));
        DmnDecisionTaskTest.assertEquals((Object)"okay", (Object)this.getDecisionResult(caseInstance));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskTest.testCallDecisionAsExpressionStartsWithDollar.cmmn", "org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskTest.testDecisionOkay.dmn11.xml"})
    public void testCallDecisionAsExpressionStartsWithDollar() {
        CaseInstance caseInstance = this.createCaseInstanceByKey("case", Variables.createVariables().putValue("testDecision", (Object)"testDecision"));
        DmnDecisionTaskTest.assertNull((Object)this.queryCaseExecutionByActivityId("PI_DecisionTask_1"));
        DmnDecisionTaskTest.assertEquals((Object)"okay", (Object)this.getDecisionResult(caseInstance));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskTest.testCallDecisionAsExpressionStartsWithHash.cmmn", "org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskTest.testDecisionOkay.dmn11.xml"})
    public void testCallDecisionAsExpressionStartsWithHash() {
        CaseInstance caseInstance = this.createCaseInstanceByKey("case", Variables.createVariables().putValue("testDecision", (Object)"testDecision"));
        DmnDecisionTaskTest.assertNull((Object)this.queryCaseExecutionByActivityId("PI_DecisionTask_1"));
        DmnDecisionTaskTest.assertEquals((Object)"okay", (Object)this.getDecisionResult(caseInstance));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskTest.testCallLatestDecision.cmmn", "org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskTest.testDecisionOkay.dmn11.xml"})
    public void testCallLatestCase() {
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource(DECISION_NOT_OKAY_DMN).deploy().getId();
        CaseInstance caseInstance = this.createCaseInstanceByKey("case");
        DmnDecisionTaskTest.assertNull((Object)this.queryCaseExecutionByActivityId("PI_DecisionTask_1"));
        DmnDecisionTaskTest.assertEquals((Object)"not okay", (Object)this.getDecisionResult(caseInstance));
        this.repositoryService.deleteDeployment(deploymentId, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskTest.testCallDecisionByDeployment.cmmn", "org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskTest.testDecisionOkay.dmn11.xml"})
    public void testCallDecisionByDeployment() {
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource(DECISION_NOT_OKAY_DMN).deploy().getId();
        CaseInstance caseInstance = this.createCaseInstanceByKey("case");
        DmnDecisionTaskTest.assertNull((Object)this.queryCaseExecutionByActivityId("PI_DecisionTask_1"));
        DmnDecisionTaskTest.assertEquals((Object)"okay", (Object)this.getDecisionResult(caseInstance));
        this.repositoryService.deleteDeployment(deploymentId, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskTest.testCallDecisionByVersion.cmmn", "org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskTest.testDecisionOkay.dmn11.xml"})
    public void testCallDecisionByVersion() {
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource(DECISION_NOT_OKAY_DMN).deploy().getId();
        CaseInstance caseInstance = this.createCaseInstanceByKey("case");
        DmnDecisionTaskTest.assertNull((Object)this.queryCaseExecutionByActivityId("PI_DecisionTask_1"));
        DmnDecisionTaskTest.assertEquals((Object)"not okay", (Object)this.getDecisionResult(caseInstance));
        this.repositoryService.deleteDeployment(deploymentId, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskTest.testCallDecisionByVersionAsExpressionStartsWithDollar.cmmn", "org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskTest.testDecisionOkay.dmn11.xml"})
    public void testCallDecisionByVersionAsExpressionStartsWithDollar() {
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource(DECISION_NOT_OKAY_DMN).deploy().getId();
        CaseInstance caseInstance = this.createCaseInstanceByKey("case", Variables.createVariables().putValue("myVersion", (Object)2));
        DmnDecisionTaskTest.assertNull((Object)this.queryCaseExecutionByActivityId("PI_DecisionTask_1"));
        DmnDecisionTaskTest.assertEquals((Object)"not okay", (Object)this.getDecisionResult(caseInstance));
        this.repositoryService.deleteDeployment(deploymentId, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskTest.testCallDecisionByVersionAsExpressionStartsWithHash.cmmn", "org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskTest.testDecisionOkay.dmn11.xml"})
    public void testCallDecisionByVersionAsExpressionStartsWithHash() {
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource(DECISION_NOT_OKAY_DMN).deploy().getId();
        CaseInstance caseInstance = this.createCaseInstanceByKey("case", Variables.createVariables().putValue("myVersion", (Object)2));
        DmnDecisionTaskTest.assertNull((Object)this.queryCaseExecutionByActivityId("PI_DecisionTask_1"));
        DmnDecisionTaskTest.assertEquals((Object)"not okay", (Object)this.getDecisionResult(caseInstance));
        this.repositoryService.deleteDeployment(deploymentId, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskTest.testCallDecisionAsConstantWithManualActiovation.cmmn"})
    public void testDecisionNotFound() {
        this.createCaseInstanceByKey("case");
        String decisionTaskId = this.queryCaseExecutionByActivityId("PI_DecisionTask_1").getId();
        try {
            this.caseService.withCaseExecution(decisionTaskId).manualStart();
            DmnDecisionTaskTest.fail((String)"It should not be possible to evaluate a not existing decision.");
        }
        catch (DecisionDefinitionNotFoundException decisionDefinitionNotFoundException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskTest.testCallDecisionAsConstant.cmmn", "org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskTest.testPojo.dmn11.xml"})
    public void testPojo() {
        VariableMap variables = Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37));
        CaseInstance caseInstance = this.createCaseInstanceByKey("case", variables);
        DmnDecisionTaskTest.assertEquals((Object)"okay", (Object)this.getDecisionResult(caseInstance));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskTest.testCallDecisionAsConstant.cmmn", "org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskTest.testDecisionOkay.dmn11.xml"})
    public void testIgnoreNonBlockingFlag() {
        CaseInstance caseInstance = this.createCaseInstanceByKey("case");
        DmnDecisionTaskTest.assertNull((Object)this.queryCaseExecutionByActivityId("PI_DecisionTask_1"));
        DmnDecisionTaskTest.assertEquals((Object)"okay", (Object)this.getDecisionResult(caseInstance));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskTest.testCallDecisionAsExpressionStartsWithDollarWithManualActiovation.cmmn", "org/camunda/bpm/engine/test/dmn/deployment/DecisionWithLiteralExpression.dmn"})
    public void testCallDecisionWithLiteralExpression() {
        CaseInstance caseInstance = this.createCaseInstanceByKey("case", Variables.createVariables().putValue("testDecision", (Object)"decisionLiteralExpression").putValue("a", (Object)2).putValue("b", (Object)3));
        String decisionTaskId = this.queryCaseExecutionByActivityId("PI_DecisionTask_1").getId();
        this.caseService.withCaseExecution(decisionTaskId).manualStart();
        DmnDecisionTaskTest.assertNull((Object)this.queryCaseExecutionByActivityId("PI_DecisionTask_1"));
        DmnDecisionTaskTest.assertEquals((Object)5, (Object)this.getDecisionResult(caseInstance));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskTest.testCallDecisionAsExpressionStartsWithDollar.cmmn", "org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void testCallDecisionWithRequiredDecisions() {
        CaseInstance caseInstance = this.createCaseInstanceByKey("case", Variables.createVariables().putValue("testDecision", (Object)"dish-decision").putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        DmnDecisionTaskTest.assertNull((Object)this.queryCaseExecutionByActivityId("PI_DecisionTask_1"));
        DmnDecisionTaskTest.assertEquals((Object)"Light salad", (Object)this.getDecisionResult(caseInstance));
    }

    protected Object getDecisionResult(CaseInstance caseInstance) {
        return this.caseService.getVariable(caseInstance.getId(), "result");
    }
}

