/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.stage;

import org.camunda.bpm.engine.impl.test.CmmnProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseExecutionQuery;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.CaseInstanceQuery;
import org.camunda.bpm.engine.test.Deployment;

public class AutoCompleteTest
extends CmmnProcessEngineTestCase {
    protected static final String CASE_DEFINITION_KEY = "case";

    @Deployment
    public void testCasePlanModel() {
        String caseInstanceId = this.createCaseInstanceByKey(CASE_DEFINITION_KEY).getId();
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        AutoCompleteTest.assertNotNull((Object)caseInstance);
        AutoCompleteTest.assertTrue((boolean)caseInstance.isCompleted());
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        AutoCompleteTest.assertNull((Object)query.activityId("PI_HumanTask_1").singleResult());
        AutoCompleteTest.assertNull((Object)query.activityId("PI_HumanTask_2").singleResult());
    }

    @Deployment
    public void testStage() {
        String caseInstanceId = this.createCaseInstanceByKey(CASE_DEFINITION_KEY).getId();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1");
        String stageId = ((CaseExecution)query.singleResult()).getId();
        this.caseService.manuallyStartCaseExecution(stageId);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        AutoCompleteTest.assertNotNull((Object)caseInstance);
        AutoCompleteTest.assertTrue((boolean)caseInstance.isActive());
        AutoCompleteTest.assertNotNull((Object)query.activityId("PI_HumanTask_1").singleResult());
        AutoCompleteTest.assertNull((Object)query.activityId("PI_Stage_1").singleResult());
        AutoCompleteTest.assertNull((Object)query.activityId("PI_HumanTask_2").singleResult());
        AutoCompleteTest.assertNull((Object)query.activityId("PI_HumanTask_3").singleResult());
    }

    @Deployment
    public void testManualActivationDisabled() {
        String caseInstanceId = this.createCaseInstanceByKey(CASE_DEFINITION_KEY).getId();
        CaseInstanceQuery instanceQuery = this.caseService.createCaseInstanceQuery().caseInstanceId(caseInstanceId);
        CaseInstance caseInstance = (CaseInstance)instanceQuery.singleResult();
        AutoCompleteTest.assertNotNull((Object)caseInstance);
        AutoCompleteTest.assertTrue((boolean)caseInstance.isActive());
        CaseExecutionQuery executionQuery = this.caseService.createCaseExecutionQuery();
        String humanTask2Id = ((CaseExecution)executionQuery.activityId("PI_HumanTask_2").singleResult()).getId();
        this.caseService.completeCaseExecution(humanTask2Id);
        caseInstance = (CaseInstance)instanceQuery.singleResult();
        AutoCompleteTest.assertNotNull((Object)caseInstance);
        AutoCompleteTest.assertTrue((boolean)caseInstance.isCompleted());
        AutoCompleteTest.assertNull((Object)executionQuery.activityId("PI_HumanTask_1").singleResult());
        AutoCompleteTest.assertNull((Object)executionQuery.activityId("PI_HumanTask_2").singleResult());
    }

    @Deployment
    public void testManualActivationDisabledInsideStage() {
        String caseInstanceId = this.createCaseInstanceByKey(CASE_DEFINITION_KEY).getId();
        CaseExecutionQuery executionQuery = this.caseService.createCaseExecutionQuery();
        String stageId = ((CaseExecution)executionQuery.activityId("PI_Stage_1").singleResult()).getId();
        CaseExecution stage = (CaseExecution)executionQuery.activityId("PI_Stage_1").singleResult();
        AutoCompleteTest.assertNotNull((Object)stage);
        AutoCompleteTest.assertTrue((boolean)stage.isActive());
        String humanTask2Id = ((CaseExecution)executionQuery.activityId("PI_HumanTask_2").singleResult()).getId();
        this.complete(humanTask2Id);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        AutoCompleteTest.assertNotNull((Object)caseInstance);
        AutoCompleteTest.assertTrue((boolean)caseInstance.isActive());
        AutoCompleteTest.assertNotNull((Object)executionQuery.activityId("PI_HumanTask_1").singleResult());
        AutoCompleteTest.assertNull((Object)executionQuery.activityId("PI_Stage_1").singleResult());
        AutoCompleteTest.assertNull((Object)executionQuery.activityId("PI_HumanTask_2").singleResult());
        AutoCompleteTest.assertNull((Object)executionQuery.activityId("PI_HumanTask_3").singleResult());
    }

    @Deployment
    public void testNested() {
        CaseExecutionQuery executionQuery = this.caseService.createCaseExecutionQuery();
        String caseInstanceId = this.createCaseInstanceByKey(CASE_DEFINITION_KEY).getId();
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        AutoCompleteTest.assertNotNull((Object)caseInstance);
        AutoCompleteTest.assertTrue((boolean)caseInstance.isCompleted());
        AutoCompleteTest.assertNull((Object)executionQuery.activityId("PI_Stage_1").singleResult());
        AutoCompleteTest.assertNull((Object)executionQuery.activityId("PI_HumanTask_1").singleResult());
        AutoCompleteTest.assertNull((Object)executionQuery.activityId("PI_HumanTask_2").singleResult());
        AutoCompleteTest.assertNull((Object)executionQuery.activityId("PI_HumanTask_3").singleResult());
    }

    @Deployment
    public void testRequiredEnabled() {
        CaseExecutionQuery executionQuery = this.caseService.createCaseExecutionQuery();
        CaseInstanceQuery instanceQuery = this.caseService.createCaseInstanceQuery();
        String caseInstanceId = this.createCaseInstanceByKey(CASE_DEFINITION_KEY).getId();
        CaseInstance caseInstance = (CaseInstance)instanceQuery.caseInstanceId(caseInstanceId).singleResult();
        AutoCompleteTest.assertNotNull((Object)caseInstance);
        AutoCompleteTest.assertTrue((boolean)caseInstance.isActive());
        String humanTask1Id = ((CaseExecution)executionQuery.activityId("PI_HumanTask_1").singleResult()).getId();
        this.manualStart(humanTask1Id);
        this.complete(humanTask1Id);
        caseInstance = (CaseInstance)instanceQuery.singleResult();
        AutoCompleteTest.assertNotNull((Object)caseInstance);
        AutoCompleteTest.assertTrue((boolean)caseInstance.isActive());
        String humanTask2Id = ((CaseExecution)executionQuery.activityId("PI_HumanTask_2").singleResult()).getId();
        this.manualStart(humanTask2Id);
        this.complete(humanTask2Id);
        caseInstance = (CaseInstance)instanceQuery.singleResult();
        AutoCompleteTest.assertNotNull((Object)caseInstance);
        AutoCompleteTest.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Deployment
    public void testRequiredEnabledInsideStage() {
        String caseInstanceId = this.createCaseInstanceByKey(CASE_DEFINITION_KEY).getId();
        CaseExecutionQuery executionQuery = this.caseService.createCaseExecutionQuery();
        String humanTask3Id = ((CaseExecution)executionQuery.activityId("PI_HumanTask_3").singleResult()).getId();
        this.complete(humanTask3Id);
        CaseExecution stage = (CaseExecution)executionQuery.activityId("PI_Stage_1").singleResult();
        AutoCompleteTest.assertNotNull((Object)stage);
        AutoCompleteTest.assertTrue((boolean)stage.isActive());
        String humanTask2Id = ((CaseExecution)executionQuery.activityId("PI_HumanTask_2").singleResult()).getId();
        this.complete(humanTask2Id);
        AutoCompleteTest.assertNull((Object)executionQuery.activityId("PI_Stage_1").singleResult());
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        AutoCompleteTest.assertNotNull((Object)caseInstance);
        AutoCompleteTest.assertTrue((boolean)caseInstance.isActive());
    }

    @Deployment
    public void testEntryCriteriaAndManualActivationDisabled() {
        String caseInstanceId = this.createCaseInstanceByKey(CASE_DEFINITION_KEY).getId();
        CaseExecutionQuery executionQuery = this.caseService.createCaseExecutionQuery();
        String humanTask1Id = ((CaseExecution)executionQuery.activityId("PI_HumanTask_1").singleResult()).getId();
        this.complete(humanTask1Id);
        CaseInstanceQuery instanceQuery = this.caseService.createCaseInstanceQuery().caseInstanceId(caseInstanceId);
        CaseInstance caseInstance = (CaseInstance)instanceQuery.singleResult();
        AutoCompleteTest.assertNotNull((Object)caseInstance);
        AutoCompleteTest.assertTrue((boolean)caseInstance.isActive());
        String humanTask2Id = ((CaseExecution)executionQuery.activityId("PI_HumanTask_2").singleResult()).getId();
        this.complete(humanTask2Id);
        caseInstance = (CaseInstance)instanceQuery.singleResult();
        AutoCompleteTest.assertNotNull((Object)caseInstance);
        AutoCompleteTest.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Deployment
    public void testExitCriteriaAndRequiredEnabled() {
        String caseInstanceId = this.createCaseInstanceByKey(CASE_DEFINITION_KEY).getId();
        CaseExecutionQuery executionQuery = this.caseService.createCaseExecutionQuery();
        String humanTask1Id = ((CaseExecution)executionQuery.activityId("PI_HumanTask_1").singleResult()).getId();
        CaseExecution humanTask2 = (CaseExecution)executionQuery.activityId("PI_HumanTask_2").singleResult();
        this.manualStart(humanTask2.getId());
        this.complete(humanTask1Id);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        AutoCompleteTest.assertNotNull((Object)caseInstance);
        AutoCompleteTest.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/stage/AutoCompleteTest.testRequiredEnabled.cmmn"})
    public void testTerminate() {
        String caseInstanceId = this.createCaseInstanceByKey(CASE_DEFINITION_KEY).getId();
        CaseExecutionQuery executionQuery = this.caseService.createCaseExecutionQuery();
        CaseInstanceQuery instanceQuery = this.caseService.createCaseInstanceQuery().caseInstanceId(caseInstanceId);
        String humanTask2Id = ((CaseExecution)executionQuery.activityId("PI_HumanTask_2").singleResult()).getId();
        this.manualStart(humanTask2Id);
        this.terminate(humanTask2Id);
        CaseInstance caseInstance = (CaseInstance)instanceQuery.singleResult();
        AutoCompleteTest.assertNotNull((Object)caseInstance);
        AutoCompleteTest.assertTrue((boolean)caseInstance.isCompleted());
    }
}

