/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.dmn.businessruletask;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class DmnBusinessRuleTaskResultMappingTest
extends PluggableProcessEngineTestCase {
    protected static final String TEST_DECISION = "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.dmn11.xml";
    protected static final String CUSTOM_MAPPING_BPMN = "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testCustomOutputMapping.bpmn20.xml";
    protected static final String SINGLE_ENTRY_BPMN = "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testSingleEntry.bpmn20.xml";
    protected static final String SINGLE_RESULT_BPMN = "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testSingleResult.bpmn20.xml";
    protected static final String COLLECT_ENTRIES_BPMN = "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testCollectEntries.bpmn20.xml";
    protected static final String RESULT_LIST_BPMN = "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testResultList.bpmn20.xml";
    protected static final String DEFAULT_MAPPING_BPMN = "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testDefaultMapping.bpmn20.xml";
    protected static final String INVALID_MAPPING_BPMN = "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testInvalidMapping.bpmn20.xml";
    protected static final String OVERRIDE_DECISION_RESULT_BPMN = "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testOverrideVariable.bpmn20.xml";

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testCustomOutputMapping.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.dmn11.xml"})
    public void testCustomOutputMapping() {
        ProcessInstance processInstance = this.startTestProcess("multiple entries");
        DmnBusinessRuleTaskResultMappingTest.assertEquals((Object)"foo", (Object)this.runtimeService.getVariable(processInstance.getId(), "result1"));
        DmnBusinessRuleTaskResultMappingTest.assertEquals((Object)Variables.stringValue((String)"foo"), (Object)this.runtimeService.getVariableTyped(processInstance.getId(), "result1"));
        DmnBusinessRuleTaskResultMappingTest.assertEquals((Object)"bar", (Object)this.runtimeService.getVariable(processInstance.getId(), "result2"));
        DmnBusinessRuleTaskResultMappingTest.assertEquals((Object)Variables.stringValue((String)"bar"), (Object)this.runtimeService.getVariableTyped(processInstance.getId(), "result2"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testSingleEntry.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.dmn11.xml"})
    public void testSingleEntryMapping() {
        ProcessInstance processInstance = this.startTestProcess("single entry");
        DmnBusinessRuleTaskResultMappingTest.assertEquals((Object)"foo", (Object)this.runtimeService.getVariable(processInstance.getId(), "result"));
        DmnBusinessRuleTaskResultMappingTest.assertEquals((Object)Variables.stringValue((String)"foo"), (Object)this.runtimeService.getVariableTyped(processInstance.getId(), "result"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testSingleResult.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.dmn11.xml"})
    public void testSingleResultMapping() {
        ProcessInstance processInstance = this.startTestProcess("multiple entries");
        Map output = (Map)this.runtimeService.getVariable(processInstance.getId(), "result");
        DmnBusinessRuleTaskResultMappingTest.assertEquals((int)2, (int)output.size());
        DmnBusinessRuleTaskResultMappingTest.assertEquals((Object)"foo", output.get("result1"));
        DmnBusinessRuleTaskResultMappingTest.assertEquals((Object)"bar", output.get("result2"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testCollectEntries.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.dmn11.xml"})
    public void testCollectEntriesMapping() {
        ProcessInstance processInstance = this.startTestProcess("single entry list");
        List output = (List)this.runtimeService.getVariable(processInstance.getId(), "result");
        DmnBusinessRuleTaskResultMappingTest.assertEquals((int)2, (int)output.size());
        DmnBusinessRuleTaskResultMappingTest.assertEquals((String)"foo", (String)((String)output.get(0)));
        DmnBusinessRuleTaskResultMappingTest.assertEquals((String)"foo", (String)((String)output.get(1)));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testResultList.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.dmn11.xml"})
    public void testResultListMapping() {
        ProcessInstance processInstance = this.startTestProcess("multiple entries list");
        List resultList = (List)this.runtimeService.getVariable(processInstance.getId(), "result");
        DmnBusinessRuleTaskResultMappingTest.assertEquals((int)2, (int)resultList.size());
        for (Map valueMap : resultList) {
            DmnBusinessRuleTaskResultMappingTest.assertEquals((int)2, (int)valueMap.size());
            DmnBusinessRuleTaskResultMappingTest.assertEquals((Object)"foo", valueMap.get("result1"));
            DmnBusinessRuleTaskResultMappingTest.assertEquals((Object)"bar", valueMap.get("result2"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testDefaultMapping.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.dmn11.xml"})
    public void testDefaultResultMapping() {
        ProcessInstance processInstance = this.startTestProcess("multiple entries list");
        List resultList = (List)this.runtimeService.getVariable(processInstance.getId(), "result");
        DmnBusinessRuleTaskResultMappingTest.assertEquals((int)2, (int)resultList.size());
        for (Map valueMap : resultList) {
            DmnBusinessRuleTaskResultMappingTest.assertEquals((int)2, (int)valueMap.size());
            DmnBusinessRuleTaskResultMappingTest.assertEquals((Object)"foo", valueMap.get("result1"));
            DmnBusinessRuleTaskResultMappingTest.assertEquals((Object)"bar", valueMap.get("result2"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testSingleEntry.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.dmn11.xml"})
    public void testSingleEntryMappingFailureMultipleOutputs() {
        try {
            this.startTestProcess("single entry list");
            DmnBusinessRuleTaskResultMappingTest.fail((String)"expect exception");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("ENGINE-22001", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testSingleEntry.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.dmn11.xml"})
    public void testSingleEntryMappingFailureMultipleValues() {
        try {
            this.startTestProcess("multiple entries");
            DmnBusinessRuleTaskResultMappingTest.fail((String)"expect exception");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("ENGINE-22001", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testSingleResult.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.dmn11.xml"})
    public void testSingleResultMappingFailure() {
        try {
            this.startTestProcess("single entry list");
            DmnBusinessRuleTaskResultMappingTest.fail((String)"expect exception");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("ENGINE-22001", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testCollectEntries.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.dmn11.xml"})
    public void testCollectEntriesMappingFailure() {
        try {
            this.startTestProcess("multiple entries");
            DmnBusinessRuleTaskResultMappingTest.fail((String)"expect exception");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("ENGINE-22002", e.getMessage());
        }
    }

    public void testInvalidMapping() {
        try {
            this.deploymentId = this.repositoryService.createDeployment().addClasspathResource(INVALID_MAPPING_BPMN).deploy().getId();
            DmnBusinessRuleTaskResultMappingTest.fail((String)"expect parse exception");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("No decision result mapper found for name 'invalid'", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testDefaultMapping.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.dmn11.xml"})
    public void testTransientDecisionResult() {
        ProcessInstance processInstance = this.startTestProcess("single entry");
        DmnBusinessRuleTaskResultMappingTest.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "decisionResult"));
        DmnBusinessRuleTaskResultMappingTest.assertNull((Object)this.historyService.createHistoricVariableInstanceQuery().variableName("decisionResult").singleResult());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testOverrideVariable.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.dmn11.xml"})
    public void testFailedToOverrideDecisionResultVariable() {
        try {
            this.startTestProcess("single entry");
            DmnBusinessRuleTaskResultMappingTest.fail((String)"expect exception");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("variable with name 'decisionResult' can not be updated", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testSingleEntry.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.dmn11.xml"})
    public void testSingleEntryEmptyResult() {
        ProcessInstance processInstance = this.startTestProcess("empty result");
        Object result = this.runtimeService.getVariable(processInstance.getId(), "result");
        DmnBusinessRuleTaskResultMappingTest.assertNull((Object)result);
        TypedValue resultTyped = this.runtimeService.getVariableTyped(processInstance.getId(), "result");
        DmnBusinessRuleTaskResultMappingTest.assertEquals((Object)Variables.untypedNullValue(), (Object)resultTyped);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testSingleResult.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.dmn11.xml"})
    public void testSingleResultEmptyResult() {
        ProcessInstance processInstance = this.startTestProcess("empty result");
        Object result = this.runtimeService.getVariable(processInstance.getId(), "result");
        DmnBusinessRuleTaskResultMappingTest.assertNull((Object)result);
        TypedValue resultTyped = this.runtimeService.getVariableTyped(processInstance.getId(), "result");
        DmnBusinessRuleTaskResultMappingTest.assertEquals((Object)Variables.untypedNullValue(), (Object)resultTyped);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testCollectEntries.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.dmn11.xml"})
    public void testCollectEntriesEmptyResult() {
        ProcessInstance processInstance = this.startTestProcess("empty result");
        List result = (List)this.runtimeService.getVariable(processInstance.getId(), "result");
        DmnBusinessRuleTaskResultMappingTest.assertTrue((boolean)result.isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testResultList.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.dmn11.xml"})
    public void testResultListEmptyResult() {
        ProcessInstance processInstance = this.startTestProcess("empty result");
        List result = (List)this.runtimeService.getVariable(processInstance.getId(), "result");
        DmnBusinessRuleTaskResultMappingTest.assertTrue((boolean)result.isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testDefaultMapping.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.dmn11.xml"})
    public void testDefaultMappingEmptyResult() {
        ProcessInstance processInstance = this.startTestProcess("empty result");
        List result = (List)this.runtimeService.getVariable(processInstance.getId(), "result");
        DmnBusinessRuleTaskResultMappingTest.assertTrue((boolean)result.isEmpty());
    }

    protected ProcessInstance startTestProcess(String input) {
        return this.runtimeService.startProcessInstanceByKey("testProcess", Collections.singletonMap("input", input));
    }
}

