/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class ProcessEngineTestRule
extends TestWatcher {
    public static final String DEFAULT_BPMN_RESOURCE_NAME = "process.bpmn20.xml";
    protected ProcessEngineRule processEngineRule;
    protected ProcessEngine processEngine;

    public ProcessEngineTestRule(ProcessEngineRule processEngineRule) {
        this.processEngineRule = processEngineRule;
    }

    protected void starting(Description description) {
        this.processEngine = this.processEngineRule.getProcessEngine();
    }

    protected void finished(Description description) {
        this.processEngine = null;
    }

    public void assertProcessEnded(String processInstanceId) {
        ProcessInstance processInstance = (ProcessInstance)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        Assert.assertThat((String)("Process instance with id " + processInstanceId + " is not finished"), (Object)processInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    public void assertCaseEnded(String caseInstanceId) {
        CaseInstance caseInstance = (CaseInstance)this.processEngine.getCaseService().createCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        Assert.assertThat((String)("Case instance with id " + caseInstanceId + " is not finished"), (Object)caseInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    public Deployment deploy(BpmnModelInstance ... bpmnModelInstances) {
        return this.deploy(this.createDeploymentBuilder(), Arrays.asList(bpmnModelInstances), Collections.<String>emptyList());
    }

    public Deployment deploy(String ... resources) {
        return this.deploy(this.createDeploymentBuilder(), Collections.<BpmnModelInstance>emptyList(), Arrays.asList(resources));
    }

    public Deployment deploy(DeploymentBuilder deploymentBuilder) {
        Deployment deployment = deploymentBuilder.deploy();
        this.processEngineRule.manageDeployment(deployment);
        return deployment;
    }

    public Deployment deploy(BpmnModelInstance bpmnModelInstance, String resource) {
        return this.deploy(this.createDeploymentBuilder(), Collections.singletonList(bpmnModelInstance), Collections.singletonList(resource));
    }

    public Deployment deployForTenant(String tenantId, BpmnModelInstance ... bpmnModelInstances) {
        return this.deploy(this.createDeploymentBuilder().tenantId(tenantId), Arrays.asList(bpmnModelInstances), Collections.<String>emptyList());
    }

    public Deployment deployForTenant(String tenantId, String ... resources) {
        return this.deploy(this.createDeploymentBuilder().tenantId(tenantId), Collections.<BpmnModelInstance>emptyList(), Arrays.asList(resources));
    }

    public Deployment deployForTenant(String tenant, BpmnModelInstance bpmnModelInstance, String resource) {
        return this.deploy(this.createDeploymentBuilder().tenantId(tenant), Collections.singletonList(bpmnModelInstance), Collections.singletonList(resource));
    }

    public ProcessDefinition deployAndGetDefinition(BpmnModelInstance bpmnModel) {
        return this.deployForTenantAndGetDefinition(null, bpmnModel);
    }

    public ProcessDefinition deployForTenantAndGetDefinition(String tenant, BpmnModelInstance bpmnModel) {
        Deployment deployment = this.deploy(this.createDeploymentBuilder().tenantId(tenant), Collections.singletonList(bpmnModel), Collections.<String>emptyList());
        return (ProcessDefinition)this.processEngineRule.getRepositoryService().createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
    }

    protected Deployment deploy(DeploymentBuilder deploymentBuilder, List<BpmnModelInstance> bpmnModelInstances, List<String> resources) {
        int i = 0;
        for (BpmnModelInstance bpmnModelInstance : bpmnModelInstances) {
            deploymentBuilder.addModelInstance(i + "_" + DEFAULT_BPMN_RESOURCE_NAME, bpmnModelInstance);
            ++i;
        }
        for (String resource : resources) {
            deploymentBuilder.addClasspathResource(resource);
        }
        return this.deploy(deploymentBuilder);
    }

    protected DeploymentBuilder createDeploymentBuilder() {
        return this.processEngine.getRepositoryService().createDeployment();
    }

    public void waitForJobExecutorToProcessAllJobs() {
        this.waitForJobExecutorToProcessAllJobs(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForJobExecutorToProcessAllJobs(long maxMillisToWait) {
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration();
        JobExecutor jobExecutor = processEngineConfiguration.getJobExecutor();
        jobExecutor.start();
        long intervalMillis = 1000L;
        int jobExecutorWaitTime = jobExecutor.getWaitTimeInMillis() * 2;
        if (maxMillisToWait < (long)jobExecutorWaitTime) {
            maxMillisToWait = jobExecutorWaitTime;
        }
        try {
            Timer timer = new Timer();
            InterruptTask task = new InterruptTask(Thread.currentThread());
            timer.schedule((TimerTask)task, maxMillisToWait);
            boolean areJobsAvailable = true;
            try {
                while (areJobsAvailable && !task.isTimeLimitExceeded()) {
                    Thread.sleep(intervalMillis);
                    try {
                        areJobsAvailable = this.areJobsAvailable();
                    }
                    catch (Throwable t) {}
                }
            }
            catch (InterruptedException e) {
            }
            finally {
                timer.cancel();
            }
            if (areJobsAvailable) {
                throw new AssertionError((Object)("time limit of " + maxMillisToWait + " was exceeded"));
            }
        }
        finally {
            jobExecutor.shutdown();
        }
    }

    protected boolean areJobsAvailable() {
        List list = this.processEngine.getManagementService().createJobQuery().list();
        for (Job job : list) {
            if (job.isSuspended() || job.getRetries() <= 0 || job.getDuedate() != null && !ClockUtil.getCurrentTime().after(job.getDuedate())) continue;
            return true;
        }
        return false;
    }

    public void executeAvailableJobs() {
        this.executeAvailableJobs(0, Integer.MAX_VALUE);
    }

    public void executeAvailableJobs(int expectedExecutions) {
        this.executeAvailableJobs(0, expectedExecutions);
    }

    private void executeAvailableJobs(int jobsExecuted, int expectedExecutions) {
        List jobs = this.processEngine.getManagementService().createJobQuery().withRetriesLeft().list();
        if (jobs.isEmpty()) {
            if (expectedExecutions != Integer.MAX_VALUE) {
                Assert.assertThat((String)"executed less jobs than expected.", (Object)jobsExecuted, (Matcher)CoreMatchers.is((Object)expectedExecutions));
            }
            return;
        }
        for (Job job : jobs) {
            try {
                this.processEngine.getManagementService().executeJob(job.getId());
                ++jobsExecuted;
            }
            catch (Exception e) {}
        }
        Assert.assertThat((String)"executed more jobs than expected.", (Object)jobsExecuted, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(expectedExecutions)));
        this.executeAvailableJobs(jobsExecuted, expectedExecutions);
    }

    public void completeTask(String taskKey) {
        TaskService taskService = this.processEngine.getTaskService();
        Task task = (Task)taskService.createTaskQuery().taskDefinitionKey(taskKey).singleResult();
        Assert.assertNotNull((String)("Expected a task with key '" + taskKey + "' to exist"), (Object)task);
        taskService.complete(task.getId());
    }

    public void completeAnyTask(String taskKey) {
        TaskService taskService = this.processEngine.getTaskService();
        List tasks = taskService.createTaskQuery().taskDefinitionKey(taskKey).list();
        Assert.assertTrue((!tasks.isEmpty() ? 1 : 0) != 0);
        taskService.complete(((Task)tasks.get(0)).getId());
    }

    public void correlateMessage(String messageName) {
        this.processEngine.getRuntimeService().createMessageCorrelation(messageName).correlate();
    }

    public void sendSignal(String signalName) {
        this.processEngine.getRuntimeService().signalEventReceived(signalName);
    }

    public boolean isHistoryLevelNone() {
        HistoryLevel historyLevel = this.processEngineRule.getProcessEngineConfiguration().getHistoryLevel();
        return HistoryLevel.HISTORY_LEVEL_NONE.equals(historyLevel);
    }

    public boolean isHistoryLevelActivity() {
        HistoryLevel historyLevel = this.processEngineRule.getProcessEngineConfiguration().getHistoryLevel();
        return HistoryLevel.HISTORY_LEVEL_ACTIVITY.equals(historyLevel);
    }

    public boolean isHistoryLevelAudit() {
        HistoryLevel historyLevel = this.processEngineRule.getProcessEngineConfiguration().getHistoryLevel();
        return HistoryLevel.HISTORY_LEVEL_AUDIT.equals(historyLevel);
    }

    public boolean isHistoryLevelFull() {
        HistoryLevel historyLevel = this.processEngineRule.getProcessEngineConfiguration().getHistoryLevel();
        return HistoryLevel.HISTORY_LEVEL_FULL.equals(historyLevel);
    }

    protected static class InterruptTask
    extends TimerTask {
        protected boolean timeLimitExceeded = false;
        protected Thread thread;

        public InterruptTask(Thread thread) {
            this.thread = thread;
        }

        public boolean isTimeLimitExceeded() {
            return this.timeLimitExceeded;
        }

        @Override
        public void run() {
            this.timeLimitExceeded = true;
            this.thread.interrupt();
        }
    }
}

