/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.behavior;

import java.util.List;
import org.camunda.bpm.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.helper.CompensationUtil;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class CancelEndEventActivityBehavior
extends AbstractBpmnActivityBehavior {
    protected PvmActivity cancelBoundaryEvent;

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        EnsureUtil.ensureNotNull("Could not find cancel boundary event for cancel end event " + execution.getActivity(), "cancelBoundaryEvent", (Object)this.cancelBoundaryEvent);
        List<EventSubscriptionEntity> compensateEventSubscriptions = CompensationUtil.collectCompensateEventSubscriptionsForScope(execution);
        if (compensateEventSubscriptions.isEmpty()) {
            this.leave(execution);
        } else {
            CompensationUtil.throwCompensationEvent(compensateEventSubscriptions, execution, false);
        }
    }

    @Override
    protected void leave(ActivityExecution execution) {
        ScopeImpl eventScope = (ScopeImpl)this.cancelBoundaryEvent.getEventScope();
        ActivityExecution boundaryEventScopeExecution = execution.findExecutionForFlowScope(eventScope);
        boundaryEventScopeExecution.executeActivity(this.cancelBoundaryEvent);
    }

    @Override
    public void signal(ActivityExecution execution, String signalName, Object signalData) throws Exception {
        if (!execution.hasChildren()) {
            this.leave(execution);
        } else {
            ((ExecutionEntity)execution).forceUpdate();
        }
    }

    public void setCancelBoundaryEvent(PvmActivity cancelBoundaryEvent) {
        this.cancelBoundaryEvent = cancelBoundaryEvent;
    }

    public PvmActivity getCancelBoundaryEvent() {
        return this.cancelBoundaryEvent;
    }
}

