/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.parser;

import java.io.Serializable;
import java.util.Set;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.impl.Condition;
import org.camunda.bpm.engine.impl.bpmn.parser.EventSubscriptionDeclaration;
import org.camunda.bpm.engine.impl.core.variable.event.VariableEvent;
import org.camunda.bpm.engine.impl.event.EventType;

public class ConditionalEventDefinition
extends EventSubscriptionDeclaration
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Condition condition;
    protected boolean interrupting;
    protected String variableName;
    protected Set<String> variableEvents;

    public ConditionalEventDefinition(Condition condition, String activityId) {
        super(null, EventType.CONDITONAL);
        this.activityId = activityId;
        this.condition = condition;
    }

    public Condition getConditionalExpression() {
        return this.condition;
    }

    public boolean isInterrupting() {
        return this.interrupting;
    }

    public void setInterrupting(boolean interrupting) {
        this.interrupting = interrupting;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public Set<String> getVariableEvents() {
        return this.variableEvents;
    }

    public void setVariableEvents(Set<String> variableEvents) {
        this.variableEvents = variableEvents;
    }

    public boolean shouldEvaluateForVariableEvent(VariableEvent event) {
        return !(this.variableName != null && !event.getVariableInstance().getName().equals(this.variableName) || this.variableEvents != null && !this.variableEvents.isEmpty() && !this.variableEvents.contains(event.getEventName()));
    }

    public boolean evaluate(DelegateExecution execution) {
        if (this.condition != null) {
            return this.condition.evaluate(execution, execution);
        }
        throw new IllegalStateException("Condtional event must have a condition!");
    }

    public boolean tryEvaluate(DelegateExecution execution) {
        if (this.condition != null) {
            return this.condition.tryEvaluate(execution, execution);
        }
        throw new IllegalStateException("Condtional event must have a condition!");
    }

    public boolean tryEvaluate(VariableEvent variableEvent, DelegateExecution execution) {
        return this.shouldEvaluateForVariableEvent(variableEvent) && this.tryEvaluate(execution);
    }
}

