/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd.batch;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.impl.HistoricProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.batch.BatchConfiguration;
import org.camunda.bpm.engine.impl.batch.BatchEntity;
import org.camunda.bpm.engine.impl.batch.BatchJobHandler;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmd.batch.AbstractIDBasedBatchCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class DeleteHistoricProcessInstancesBatchCmd
extends AbstractIDBasedBatchCmd<Batch> {
    protected final String deleteReason;
    protected List<String> historicProcessInstanceIds;
    protected HistoricProcessInstanceQuery historicProcessInstanceQuery;

    public DeleteHistoricProcessInstancesBatchCmd(List<String> historicProcessInstanceIds, HistoricProcessInstanceQuery historicProcessInstanceQuery, String deleteReason) {
        this.historicProcessInstanceIds = historicProcessInstanceIds;
        this.historicProcessInstanceQuery = historicProcessInstanceQuery;
        this.deleteReason = deleteReason;
    }

    protected List<String> collectHistoricProcessInstanceIds() {
        HistoricProcessInstanceQueryImpl processInstanceQuery;
        HashSet<String> collectedProcessInstanceIds = new HashSet<String>();
        List<String> processInstanceIds = this.getHistoricProcessInstanceIds();
        if (processInstanceIds != null) {
            collectedProcessInstanceIds.addAll(processInstanceIds);
        }
        if ((processInstanceQuery = (HistoricProcessInstanceQueryImpl)this.historicProcessInstanceQuery) != null) {
            for (HistoricProcessInstance hpi : processInstanceQuery.list()) {
                collectedProcessInstanceIds.add(hpi.getId());
            }
        }
        return new ArrayList<String>(collectedProcessInstanceIds);
    }

    public List<String> getHistoricProcessInstanceIds() {
        return this.historicProcessInstanceIds;
    }

    @Override
    public Batch execute(CommandContext commandContext) {
        List<String> processInstanceIds = this.collectHistoricProcessInstanceIds();
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "historicProcessInstanceIds", processInstanceIds);
        this.checkAuthorizations(commandContext);
        this.writeUserOperationLog(commandContext, this.deleteReason, processInstanceIds.size(), true);
        BatchEntity batch = this.createBatch(commandContext, processInstanceIds);
        batch.createSeedJobDefinition();
        batch.createMonitorJobDefinition();
        batch.createBatchJobDefinition();
        batch.fireHistoricStartEvent();
        batch.createSeedJob();
        return batch;
    }

    protected void writeUserOperationLog(CommandContext commandContext, String deleteReason, int numInstances, boolean async) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("nrOfInstances", null, numInstances));
        propertyChanges.add(new PropertyChange("async", null, async));
        propertyChanges.add(new PropertyChange("type", null, "history"));
        propertyChanges.add(new PropertyChange("deleteReason", null, deleteReason));
        commandContext.getOperationLogManager().logProcessInstanceOperation("Delete", null, null, null, propertyChanges);
    }

    @Override
    protected BatchConfiguration getAbstractIdsBatchConfiguration(List<String> processInstanceIds, String deleteReason) {
        return new BatchConfiguration(processInstanceIds);
    }

    @Override
    protected BatchJobHandler<BatchConfiguration> getBatchJobHandler(ProcessEngineConfigurationImpl processEngineConfiguration) {
        return processEngineConfiguration.getBatchHandlers().get("historic-instance-deletion");
    }
}

