/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.event;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.bpmn.behavior.ConditionalEventBehavior;
import org.camunda.bpm.engine.impl.core.variable.event.VariableEvent;
import org.camunda.bpm.engine.impl.event.EventHandler;
import org.camunda.bpm.engine.impl.event.EventType;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;

public class ConditionalEventHandler
implements EventHandler {
    @Override
    public String getEventHandlerType() {
        return EventType.CONDITONAL.name();
    }

    @Override
    public void handleEvent(EventSubscriptionEntity eventSubscription, Object payload, CommandContext commandContext) {
        if (!(payload instanceof VariableEvent)) {
            throw new ProcessEngineException("Payload have to be " + VariableEvent.class.getName() + ", to evaluate condition.");
        }
        VariableEvent variableEvent = (VariableEvent)payload;
        ActivityImpl activity = eventSubscription.getActivity();
        ActivityBehavior activityBehavior = activity.getActivityBehavior();
        if (!(activityBehavior instanceof ConditionalEventBehavior)) {
            throw new ProcessEngineException("Conditional Event has not correct behavior: " + activityBehavior);
        }
        ConditionalEventBehavior conditionalBehavior = (ConditionalEventBehavior)((Object)activityBehavior);
        conditionalBehavior.leaveOnSatisfiedCondition(eventSubscription, variableEvent, commandContext);
    }
}

