/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.camunda.bpm.application.ProcessApplicationRegistration;
import org.camunda.bpm.application.impl.EmbeddedProcessApplication;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentQuery;
import org.camunda.bpm.engine.repository.ProcessApplicationDeployment;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.repository.Resource;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ScriptTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;

public class RedeploymentTest
extends PluggableProcessEngineTestCase {
    public static final String DEPLOYMENT_NAME = "my-deployment";
    public static final String PROCESS_KEY = "process";
    public static final String PROCESS_1_KEY = "process-1";
    public static final String PROCESS_2_KEY = "process-2";
    public static final String PROCESS_3_KEY = "process-3";
    public static final String RESOURCE_NAME = "path/to/my/process.bpmn";
    public static final String RESOURCE_1_NAME = "path/to/my/process1.bpmn";
    public static final String RESOURCE_2_NAME = "path/to/my/process2.bpmn";
    public static final String RESOURCE_3_NAME = "path/to/my/process3.bpmn";

    public void testRedeployInvalidDeployment() {
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources("not-existing").deploy();
            RedeploymentTest.fail((String)"It should not be able to re-deploy an unexisting deployment");
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourceById("not-existing", "an-id").deploy();
            RedeploymentTest.fail((String)"It should not be able to re-deploy an unexisting deployment");
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourcesById("not-existing", Arrays.asList("an-id")).deploy();
            RedeploymentTest.fail((String)"It should not be able to re-deploy an unexisting deployment");
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourceByName("not-existing", "a-name").deploy();
            RedeploymentTest.fail((String)"It should not be able to re-deploy an unexisting deployment");
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourcesByName("not-existing", Arrays.asList("a-name")).deploy();
            RedeploymentTest.fail((String)"It should not be able to re-deploy an unexisting deployment");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    public void testNotValidDeploymentId() {
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(null);
            RedeploymentTest.fail((String)"It should not be possible to pass a null deployment id");
        }
        catch (NotValidException e) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourceById(null, "an-id");
            RedeploymentTest.fail((String)"It should not be possible to pass a null deployment id");
        }
        catch (NotValidException e) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourcesById(null, Arrays.asList("an-id"));
            RedeploymentTest.fail((String)"It should not be possible to pass a null deployment id");
        }
        catch (NotValidException e) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourceByName(null, "a-name");
            RedeploymentTest.fail((String)"It should not be possible to pass a null deployment id");
        }
        catch (NotValidException e) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourcesByName(null, Arrays.asList("a-name"));
            RedeploymentTest.fail((String)"It should not be possible to pass a null deployment id");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    public void testRedeployUnexistingDeploymentResource() {
        BpmnModelInstance model = this.createProcessWithServiceTask(PROCESS_KEY);
        Deployment deployment = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, model).deploy();
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourceByName(deployment.getId(), "not-existing-resource.bpmn").deploy();
            RedeploymentTest.fail((String)"It should not be possible to re-deploy a not existing deployment resource");
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourcesByName(deployment.getId(), Arrays.asList("not-existing-resource.bpmn")).deploy();
            RedeploymentTest.fail((String)"It should not be possible to re-deploy a not existing deployment resource");
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourceById(deployment.getId(), "not-existing-resource-id").deploy();
            RedeploymentTest.fail((String)"It should not be possible to re-deploy a not existing deployment resource");
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourcesById(deployment.getId(), Arrays.asList("not-existing-resource-id")).deploy();
            RedeploymentTest.fail((String)"It should not be possible to re-deploy a not existing deployment resource");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.deleteDeployments(deployment);
    }

    public void testNotValidResource() {
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourceById("an-id", null);
            RedeploymentTest.fail((String)"It should not be possible to pass a null resource id");
        }
        catch (NotValidException e) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourcesById("an-id", null);
            RedeploymentTest.fail((String)"It should not be possible to pass a null resource id");
        }
        catch (NotValidException e) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourcesById("an-id", Arrays.asList(new String[]{null}));
            RedeploymentTest.fail((String)"It should not be possible to pass a null resource id");
        }
        catch (NotValidException e) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourcesById("an-id", new ArrayList());
            RedeploymentTest.fail((String)"It should not be possible to pass a null resource id");
        }
        catch (NotValidException e) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourceByName("an-id", null);
            RedeploymentTest.fail((String)"It should not be possible to pass a null resource name");
        }
        catch (NotValidException e) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourcesByName("an-id", null);
            RedeploymentTest.fail((String)"It should not be possible to pass a null resource name");
        }
        catch (NotValidException e) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourcesByName("an-id", Arrays.asList(new String[]{null}));
            RedeploymentTest.fail((String)"It should not be possible to pass a null resource name");
        }
        catch (NotValidException e) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourcesByName("an-id", new ArrayList());
            RedeploymentTest.fail((String)"It should not be possible to pass a null resource name");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    public void testRedeployNewDeployment() {
        BpmnModelInstance model = this.createProcessWithServiceTask(PROCESS_KEY);
        Deployment deployment1 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, model).deploy();
        DeploymentQuery query = this.repositoryService.createDeploymentQuery().deploymentName(DEPLOYMENT_NAME);
        RedeploymentTest.assertNotNull((Object)deployment1.getId());
        this.verifyQueryResults((Query<?, ?>)query, 1);
        Deployment deployment2 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        RedeploymentTest.assertNotNull((Object)deployment2);
        RedeploymentTest.assertNotNull((Object)deployment2.getId());
        RedeploymentTest.assertFalse((boolean)deployment1.getId().equals(deployment2.getId()));
        this.verifyQueryResults((Query<?, ?>)query, 2);
        this.deleteDeployments(deployment1, deployment2);
    }

    public void testFailingDeploymentName() {
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).nameFromDeployment("a-deployment-id");
            RedeploymentTest.fail((String)"Cannot set name() and nameFromDeployment().");
        }
        catch (NotValidException e) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().nameFromDeployment("a-deployment-id").name(DEPLOYMENT_NAME);
            RedeploymentTest.fail((String)"Cannot set name() and nameFromDeployment().");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    public void testRedeployDeploymentName() {
        BpmnModelInstance model = this.createProcessWithServiceTask(PROCESS_KEY);
        Deployment deployment1 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, model).deploy();
        RedeploymentTest.assertEquals((String)DEPLOYMENT_NAME, (String)deployment1.getName());
        Deployment deployment2 = this.repositoryService.createDeployment().nameFromDeployment(deployment1.getId()).addDeploymentResources(deployment1.getId()).deploy();
        RedeploymentTest.assertNotNull((Object)deployment2);
        RedeploymentTest.assertEquals((String)deployment1.getName(), (String)deployment2.getName());
        this.deleteDeployments(deployment1, deployment2);
    }

    public void testRedeployDeploymentDifferentName() {
        BpmnModelInstance model = this.createProcessWithServiceTask(PROCESS_KEY);
        Deployment deployment1 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, model).deploy();
        RedeploymentTest.assertEquals((String)DEPLOYMENT_NAME, (String)deployment1.getName());
        Deployment deployment2 = this.repositoryService.createDeployment().name("my-another-deployment").addDeploymentResources(deployment1.getId()).deploy();
        RedeploymentTest.assertNotNull((Object)deployment2);
        RedeploymentTest.assertFalse((boolean)deployment1.getName().equals(deployment2.getName()));
        this.deleteDeployments(deployment1, deployment2);
    }

    public void testRedeployDeploymentSourcePropertyNotSet() {
        BpmnModelInstance model = this.createProcessWithServiceTask(PROCESS_KEY);
        Deployment deployment1 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).source("my-deployment-source").addModelInstance(RESOURCE_NAME, model).deploy();
        RedeploymentTest.assertEquals((String)"my-deployment-source", (String)deployment1.getSource());
        Deployment deployment2 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        RedeploymentTest.assertNotNull((Object)deployment2);
        RedeploymentTest.assertNull((Object)deployment2.getSource());
        this.deleteDeployments(deployment1, deployment2);
    }

    public void testRedeploySetDeploymentSourceProperty() {
        BpmnModelInstance model = this.createProcessWithServiceTask(PROCESS_KEY);
        Deployment deployment1 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).source("my-deployment-source").addModelInstance(RESOURCE_NAME, model).deploy();
        RedeploymentTest.assertEquals((String)"my-deployment-source", (String)deployment1.getSource());
        Deployment deployment2 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).source("my-another-deployment-source").deploy();
        RedeploymentTest.assertNotNull((Object)deployment2);
        RedeploymentTest.assertEquals((String)"my-another-deployment-source", (String)deployment2.getSource());
        this.deleteDeployments(deployment1, deployment2);
    }

    public void testRedeployDeploymentResource() {
        BpmnModelInstance model = this.createProcessWithServiceTask(PROCESS_KEY);
        Deployment deployment1 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, model).deploy();
        Resource resource1 = this.getResourceByName(deployment1.getId(), RESOURCE_NAME);
        model = this.createProcessWithUserTask(PROCESS_KEY);
        Deployment deployment2 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, model).deploy();
        Resource resource2 = this.getResourceByName(deployment2.getId(), RESOURCE_NAME);
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        Resource resource3 = this.getResourceByName(deployment3.getId(), RESOURCE_NAME);
        RedeploymentTest.assertNotNull((Object)resource3);
        RedeploymentTest.assertNotNull((Object)resource3.getId());
        RedeploymentTest.assertFalse((boolean)resource1.getId().equals(resource3.getId()));
        RedeploymentTest.assertEquals((String)deployment3.getId(), (String)resource3.getDeploymentId());
        RedeploymentTest.assertEquals((String)resource1.getName(), (String)resource3.getName());
        byte[] bytes1 = ((ResourceEntity)resource1).getBytes();
        byte[] bytes2 = ((ResourceEntity)resource2).getBytes();
        byte[] bytes3 = ((ResourceEntity)resource3).getBytes();
        RedeploymentTest.assertTrue((boolean)Arrays.equals(bytes1, bytes3));
        RedeploymentTest.assertFalse((boolean)Arrays.equals(bytes2, bytes3));
        this.deleteDeployments(deployment1, deployment2, deployment3);
    }

    public void testRedeployAllDeploymentResources() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        BpmnModelInstance model1 = this.createProcessWithServiceTask(PROCESS_1_KEY);
        BpmnModelInstance model2 = this.createProcessWithUserTask(PROCESS_2_KEY);
        Deployment deployment1 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2).deploy();
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 1);
        Deployment deployment2 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model2).addModelInstance(RESOURCE_2_NAME, model1).deploy();
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 3);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 3);
        this.deleteDeployments(deployment1, deployment2, deployment3);
    }

    public void testRedeployOneDeploymentResourcesByName() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        BpmnModelInstance model1 = this.createProcessWithServiceTask(PROCESS_1_KEY);
        BpmnModelInstance model2 = this.createProcessWithUserTask(PROCESS_2_KEY);
        Deployment deployment1 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2).deploy();
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 1);
        model1 = this.createProcessWithScriptTask(PROCESS_1_KEY);
        model2 = this.createProcessWithReceiveTask(PROCESS_2_KEY);
        Deployment deployment2 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2).deploy();
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourceByName(deployment1.getId(), RESOURCE_1_NAME).deploy();
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 3);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        this.deleteDeployments(deployment1, deployment2, deployment3);
    }

    public void testRedeployMultipleDeploymentResourcesByName() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        BpmnModelInstance model1 = this.createProcessWithServiceTask(PROCESS_1_KEY);
        BpmnModelInstance model2 = this.createProcessWithUserTask(PROCESS_2_KEY);
        BpmnModelInstance model3 = this.createProcessWithScriptTask(PROCESS_3_KEY);
        Deployment deployment1 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2).addModelInstance(RESOURCE_3_NAME, model3).deploy();
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_3_KEY), 1);
        model1 = this.createProcessWithScriptTask(PROCESS_1_KEY);
        model2 = this.createProcessWithReceiveTask(PROCESS_2_KEY);
        model3 = this.createProcessWithUserTask(PROCESS_3_KEY);
        Deployment deployment2 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2).addModelInstance(RESOURCE_3_NAME, model3).deploy();
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_3_KEY), 2);
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourceByName(deployment1.getId(), RESOURCE_1_NAME).addDeploymentResourceByName(deployment1.getId(), RESOURCE_3_NAME).deploy();
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 3);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_3_KEY), 3);
        Deployment deployment4 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourcesByName(deployment2.getId(), Arrays.asList(RESOURCE_1_NAME, RESOURCE_3_NAME)).deploy();
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 4);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_3_KEY), 4);
        this.deleteDeployments(deployment1, deployment2, deployment3, deployment4);
    }

    public void testRedeployOneAndMultipleDeploymentResourcesByName() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        BpmnModelInstance model1 = this.createProcessWithServiceTask(PROCESS_1_KEY);
        BpmnModelInstance model2 = this.createProcessWithUserTask(PROCESS_2_KEY);
        BpmnModelInstance model3 = this.createProcessWithScriptTask(PROCESS_3_KEY);
        Deployment deployment1 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2).addModelInstance(RESOURCE_3_NAME, model3).deploy();
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_3_KEY), 1);
        model1 = this.createProcessWithScriptTask(PROCESS_1_KEY);
        model2 = this.createProcessWithReceiveTask(PROCESS_2_KEY);
        model3 = this.createProcessWithUserTask(PROCESS_3_KEY);
        Deployment deployment2 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2).addModelInstance(RESOURCE_3_NAME, model3).deploy();
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_3_KEY), 2);
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourceByName(deployment1.getId(), RESOURCE_1_NAME).addDeploymentResourcesByName(deployment1.getId(), Arrays.asList(RESOURCE_2_NAME, RESOURCE_3_NAME)).deploy();
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 3);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 3);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_3_KEY), 3);
        this.deleteDeployments(deployment1, deployment2, deployment3);
    }

    public void testSameDeploymentResourceByName() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        BpmnModelInstance model1 = this.createProcessWithServiceTask(PROCESS_1_KEY);
        BpmnModelInstance model2 = this.createProcessWithUserTask(PROCESS_2_KEY);
        Deployment deployment1 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2).deploy();
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 1);
        model1 = this.createProcessWithScriptTask(PROCESS_1_KEY);
        model2 = this.createProcessWithReceiveTask(PROCESS_2_KEY);
        Deployment deployment2 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2).deploy();
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourceByName(deployment1.getId(), RESOURCE_1_NAME).addDeploymentResourcesByName(deployment1.getId(), Arrays.asList(RESOURCE_1_NAME)).deploy();
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 3);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        this.deleteDeployments(deployment1, deployment2, deployment3);
    }

    public void testRedeployOneDeploymentResourcesById() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        BpmnModelInstance model1 = this.createProcessWithServiceTask(PROCESS_1_KEY);
        BpmnModelInstance model2 = this.createProcessWithUserTask(PROCESS_2_KEY);
        Deployment deployment1 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2).deploy();
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 1);
        Resource resource = this.getResourceByName(deployment1.getId(), RESOURCE_1_NAME);
        model1 = this.createProcessWithScriptTask(PROCESS_1_KEY);
        model2 = this.createProcessWithReceiveTask(PROCESS_2_KEY);
        Deployment deployment2 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2).deploy();
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourceById(deployment1.getId(), resource.getId()).deploy();
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 3);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        this.deleteDeployments(deployment1, deployment2, deployment3);
    }

    public void testRedeployMultipleDeploymentResourcesById() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        BpmnModelInstance model1 = this.createProcessWithServiceTask(PROCESS_1_KEY);
        BpmnModelInstance model2 = this.createProcessWithUserTask(PROCESS_2_KEY);
        BpmnModelInstance model3 = this.createProcessWithScriptTask(PROCESS_3_KEY);
        Deployment deployment1 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2).addModelInstance(RESOURCE_3_NAME, model3).deploy();
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_3_KEY), 1);
        Resource resource11 = this.getResourceByName(deployment1.getId(), RESOURCE_1_NAME);
        Resource resource13 = this.getResourceByName(deployment1.getId(), RESOURCE_3_NAME);
        model1 = this.createProcessWithScriptTask(PROCESS_1_KEY);
        model2 = this.createProcessWithReceiveTask(PROCESS_2_KEY);
        model3 = this.createProcessWithUserTask(PROCESS_3_KEY);
        Deployment deployment2 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2).addModelInstance(RESOURCE_3_NAME, model3).deploy();
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_3_KEY), 2);
        Resource resource21 = this.getResourceByName(deployment2.getId(), RESOURCE_1_NAME);
        Resource resource23 = this.getResourceByName(deployment2.getId(), RESOURCE_3_NAME);
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourceById(deployment1.getId(), resource11.getId()).addDeploymentResourceById(deployment1.getId(), resource13.getId()).deploy();
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 3);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_3_KEY), 3);
        Deployment deployment4 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourcesById(deployment2.getId(), Arrays.asList(resource21.getId(), resource23.getId())).deploy();
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 4);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_3_KEY), 4);
        this.deleteDeployments(deployment1, deployment2, deployment3, deployment4);
    }

    public void testRedeployOneAndMultipleDeploymentResourcesById() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        BpmnModelInstance model1 = this.createProcessWithServiceTask(PROCESS_1_KEY);
        BpmnModelInstance model2 = this.createProcessWithUserTask(PROCESS_2_KEY);
        BpmnModelInstance model3 = this.createProcessWithScriptTask(PROCESS_3_KEY);
        Deployment deployment1 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2).addModelInstance(RESOURCE_3_NAME, model3).deploy();
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_3_KEY), 1);
        Resource resource1 = this.getResourceByName(deployment1.getId(), RESOURCE_1_NAME);
        Resource resource2 = this.getResourceByName(deployment1.getId(), RESOURCE_2_NAME);
        Resource resource3 = this.getResourceByName(deployment1.getId(), RESOURCE_3_NAME);
        model1 = this.createProcessWithScriptTask(PROCESS_1_KEY);
        model2 = this.createProcessWithReceiveTask(PROCESS_2_KEY);
        model3 = this.createProcessWithUserTask(PROCESS_3_KEY);
        Deployment deployment2 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2).addModelInstance(RESOURCE_3_NAME, model3).deploy();
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_3_KEY), 2);
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourceById(deployment1.getId(), resource1.getId()).addDeploymentResourcesById(deployment1.getId(), Arrays.asList(resource2.getId(), resource3.getId())).deploy();
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 3);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 3);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_3_KEY), 3);
        this.deleteDeployments(deployment1, deployment2, deployment3);
    }

    public void testRedeploySameDeploymentResourceById() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        BpmnModelInstance model1 = this.createProcessWithServiceTask(PROCESS_1_KEY);
        BpmnModelInstance model2 = this.createProcessWithUserTask(PROCESS_2_KEY);
        Deployment deployment1 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2).deploy();
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 1);
        Resource resource1 = this.getResourceByName(deployment1.getId(), RESOURCE_1_NAME);
        model1 = this.createProcessWithScriptTask(PROCESS_1_KEY);
        model2 = this.createProcessWithReceiveTask(PROCESS_2_KEY);
        Deployment deployment2 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2).deploy();
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourceById(deployment1.getId(), resource1.getId()).addDeploymentResourcesById(deployment1.getId(), Arrays.asList(resource1.getId())).deploy();
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 3);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        this.deleteDeployments(deployment1, deployment2, deployment3);
    }

    public void testRedeployDeploymentResourceByIdAndName() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        BpmnModelInstance model1 = this.createProcessWithServiceTask(PROCESS_1_KEY);
        BpmnModelInstance model2 = this.createProcessWithUserTask(PROCESS_2_KEY);
        Deployment deployment1 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2).deploy();
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 1);
        Resource resource1 = this.getResourceByName(deployment1.getId(), RESOURCE_1_NAME);
        Resource resource2 = this.getResourceByName(deployment1.getId(), RESOURCE_2_NAME);
        model1 = this.createProcessWithScriptTask(PROCESS_1_KEY);
        model2 = this.createProcessWithReceiveTask(PROCESS_2_KEY);
        Deployment deployment2 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2).deploy();
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourceById(deployment1.getId(), resource1.getId()).addDeploymentResourceByName(deployment1.getId(), resource2.getName()).deploy();
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 3);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 3);
        this.deleteDeployments(deployment1, deployment2, deployment3);
    }

    public void testRedeployDeploymentResourceByIdAndNameMultiple() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        BpmnModelInstance model1 = this.createProcessWithServiceTask(PROCESS_1_KEY);
        BpmnModelInstance model2 = this.createProcessWithUserTask(PROCESS_2_KEY);
        Deployment deployment1 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2).deploy();
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 1);
        Resource resource1 = this.getResourceByName(deployment1.getId(), RESOURCE_1_NAME);
        Resource resource2 = this.getResourceByName(deployment1.getId(), RESOURCE_2_NAME);
        model1 = this.createProcessWithScriptTask(PROCESS_1_KEY);
        model2 = this.createProcessWithReceiveTask(PROCESS_2_KEY);
        Deployment deployment2 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2).deploy();
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        Deployment deployment3 = this.repositoryService.createDeployment().addDeploymentResourcesById(deployment1.getId(), Arrays.asList(resource1.getId())).addDeploymentResourcesByName(deployment1.getId(), Arrays.asList(resource2.getName())).deploy();
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 3);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 3);
        this.deleteDeployments(deployment1, deployment2, deployment3);
    }

    public void testRedeployFormDifferentDeployments() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        BpmnModelInstance model1 = this.createProcessWithServiceTask(PROCESS_1_KEY);
        Deployment deployment1 = this.repositoryService.createDeployment().name("my-deployment-1").addModelInstance(RESOURCE_1_NAME, model1).deploy();
        RedeploymentTest.assertEquals((int)1, (int)this.repositoryService.getDeploymentResources(deployment1.getId()).size());
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        BpmnModelInstance model2 = this.createProcessWithReceiveTask(PROCESS_2_KEY);
        Deployment deployment2 = this.repositoryService.createDeployment().name("my-deployment-2").addModelInstance(RESOURCE_2_NAME, model2).deploy();
        RedeploymentTest.assertEquals((int)1, (int)this.repositoryService.getDeploymentResources(deployment2.getId()).size());
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 1);
        Deployment deployment3 = this.repositoryService.createDeployment().name("my-deployment-3").addDeploymentResources(deployment1.getId()).addDeploymentResources(deployment2.getId()).deploy();
        RedeploymentTest.assertEquals((int)2, (int)this.repositoryService.getDeploymentResources(deployment3.getId()).size());
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        this.deleteDeployments(deployment1, deployment2, deployment3);
    }

    public void testRedeployFormDifferentDeploymentsById() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        BpmnModelInstance model1 = this.createProcessWithServiceTask(PROCESS_1_KEY);
        Deployment deployment1 = this.repositoryService.createDeployment().name("my-deployment-1").addModelInstance(RESOURCE_1_NAME, model1).deploy();
        RedeploymentTest.assertEquals((int)1, (int)this.repositoryService.getDeploymentResources(deployment1.getId()).size());
        Resource resource1 = this.getResourceByName(deployment1.getId(), RESOURCE_1_NAME);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        BpmnModelInstance model2 = this.createProcessWithReceiveTask(PROCESS_2_KEY);
        Deployment deployment2 = this.repositoryService.createDeployment().name("my-deployment-2").addModelInstance(RESOURCE_2_NAME, model2).deploy();
        RedeploymentTest.assertEquals((int)1, (int)this.repositoryService.getDeploymentResources(deployment2.getId()).size());
        Resource resource2 = this.getResourceByName(deployment2.getId(), RESOURCE_2_NAME);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 1);
        Deployment deployment3 = this.repositoryService.createDeployment().name("my-deployment-3").addDeploymentResourceById(deployment1.getId(), resource1.getId()).addDeploymentResourceById(deployment2.getId(), resource2.getId()).deploy();
        RedeploymentTest.assertEquals((int)2, (int)this.repositoryService.getDeploymentResources(deployment3.getId()).size());
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        this.deleteDeployments(deployment1, deployment2, deployment3);
    }

    public void testRedeployFormDifferentDeploymentsByName() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        BpmnModelInstance model1 = this.createProcessWithServiceTask(PROCESS_1_KEY);
        Deployment deployment1 = this.repositoryService.createDeployment().name("my-deployment-1").addModelInstance(RESOURCE_1_NAME, model1).deploy();
        RedeploymentTest.assertEquals((int)1, (int)this.repositoryService.getDeploymentResources(deployment1.getId()).size());
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        BpmnModelInstance model2 = this.createProcessWithReceiveTask(PROCESS_2_KEY);
        Deployment deployment2 = this.repositoryService.createDeployment().name("my-deployment-2").addModelInstance(RESOURCE_2_NAME, model2).deploy();
        RedeploymentTest.assertEquals((int)1, (int)this.repositoryService.getDeploymentResources(deployment2.getId()).size());
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 1);
        Deployment deployment3 = this.repositoryService.createDeployment().name("my-deployment-3").addDeploymentResourceByName(deployment1.getId(), RESOURCE_1_NAME).addDeploymentResourceByName(deployment2.getId(), RESOURCE_2_NAME).deploy();
        RedeploymentTest.assertEquals((int)2, (int)this.repositoryService.getDeploymentResources(deployment3.getId()).size());
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        this.deleteDeployments(deployment1, deployment2, deployment3);
    }

    public void testRedeployFormDifferentDeploymentsByNameAndId() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        BpmnModelInstance model1 = this.createProcessWithServiceTask(PROCESS_1_KEY);
        Deployment deployment1 = this.repositoryService.createDeployment().name("my-deployment-1").addModelInstance(RESOURCE_1_NAME, model1).deploy();
        RedeploymentTest.assertEquals((int)1, (int)this.repositoryService.getDeploymentResources(deployment1.getId()).size());
        Resource resource1 = this.getResourceByName(deployment1.getId(), RESOURCE_1_NAME);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        BpmnModelInstance model2 = this.createProcessWithReceiveTask(PROCESS_2_KEY);
        Deployment deployment2 = this.repositoryService.createDeployment().name("my-deployment-2").addModelInstance(RESOURCE_2_NAME, model2).deploy();
        RedeploymentTest.assertEquals((int)1, (int)this.repositoryService.getDeploymentResources(deployment2.getId()).size());
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 1);
        Deployment deployment3 = this.repositoryService.createDeployment().name("my-deployment-3").addDeploymentResourceById(deployment1.getId(), resource1.getId()).addDeploymentResourceByName(deployment2.getId(), RESOURCE_2_NAME).deploy();
        RedeploymentTest.assertEquals((int)2, (int)this.repositoryService.getDeploymentResources(deployment3.getId()).size());
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        this.deleteDeployments(deployment1, deployment2, deployment3);
    }

    public void testRedeployFormDifferentDeploymentsAddsNewSource() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        BpmnModelInstance model1 = this.createProcessWithServiceTask(PROCESS_1_KEY);
        Deployment deployment1 = this.repositoryService.createDeployment().name("my-deployment-1").addModelInstance(RESOURCE_1_NAME, model1).deploy();
        RedeploymentTest.assertEquals((int)1, (int)this.repositoryService.getDeploymentResources(deployment1.getId()).size());
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        BpmnModelInstance model2 = this.createProcessWithReceiveTask(PROCESS_2_KEY);
        Deployment deployment2 = this.repositoryService.createDeployment().name("my-deployment-2").addModelInstance(RESOURCE_2_NAME, model2).deploy();
        RedeploymentTest.assertEquals((int)1, (int)this.repositoryService.getDeploymentResources(deployment2.getId()).size());
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 1);
        BpmnModelInstance model3 = this.createProcessWithUserTask(PROCESS_3_KEY);
        Deployment deployment3 = this.repositoryService.createDeployment().name("my-deployment-3").addDeploymentResources(deployment1.getId()).addDeploymentResources(deployment2.getId()).addModelInstance(RESOURCE_3_NAME, model3).deploy();
        RedeploymentTest.assertEquals((int)3, (int)this.repositoryService.getDeploymentResources(deployment3.getId()).size());
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_3_KEY), 1);
        this.deleteDeployments(deployment1, deployment2, deployment3);
    }

    public void testRedeployFormDifferentDeploymentsSameResourceName() {
        BpmnModelInstance model1 = this.createProcessWithServiceTask(PROCESS_1_KEY);
        Deployment deployment1 = this.repositoryService.createDeployment().name("my-deployment-1").addModelInstance(RESOURCE_1_NAME, model1).deploy();
        BpmnModelInstance model2 = this.createProcessWithReceiveTask(PROCESS_2_KEY);
        Deployment deployment2 = this.repositoryService.createDeployment().name("my-deployment-2").addModelInstance(RESOURCE_1_NAME, model2).deploy();
        try {
            this.repositoryService.createDeployment().name("my-deployment-3").addDeploymentResources(deployment1.getId()).addDeploymentResources(deployment2.getId()).deploy();
            RedeploymentTest.fail((String)"It should not be possible to deploy different resources with same name.");
        }
        catch (NotValidException e) {
            // empty catch block
        }
        this.deleteDeployments(deployment1, deployment2);
    }

    public void testRedeployAndAddNewResourceWithSameName() {
        BpmnModelInstance model1 = this.createProcessWithServiceTask(PROCESS_1_KEY);
        Deployment deployment1 = this.repositoryService.createDeployment().name("my-deployment-1").addModelInstance(RESOURCE_1_NAME, model1).deploy();
        BpmnModelInstance model2 = this.createProcessWithReceiveTask(PROCESS_2_KEY);
        try {
            this.repositoryService.createDeployment().name("my-deployment-2").addModelInstance(RESOURCE_1_NAME, model2).addDeploymentResourceByName(deployment1.getId(), RESOURCE_1_NAME).deploy();
            RedeploymentTest.fail((String)"It should not be possible to deploy different resources with same name.");
        }
        catch (NotValidException e) {
            // empty catch block
        }
        this.deleteDeployments(deployment1);
    }

    public void testRedeployEnableDuplcateChecking() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        BpmnModelInstance model1 = this.createProcessWithServiceTask(PROCESS_1_KEY);
        Deployment deployment1 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).deploy();
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        Deployment deployment2 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).enableDuplicateFiltering(true).deploy();
        RedeploymentTest.assertEquals((String)deployment1.getId(), (String)deployment2.getId());
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        this.deleteDeployments(deployment1);
    }

    public void testSimpleProcessApplicationDeployment() {
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication();
        BpmnModelInstance model = this.createProcessWithServiceTask(PROCESS_KEY);
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(processApplication.getReference()).name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, model).enableDuplicateFiltering(true).deploy();
        Resource resource1 = this.getResourceByName(deployment1.getId(), RESOURCE_NAME);
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(processApplication.getReference()).name(DEPLOYMENT_NAME).addDeploymentResourceById(deployment1.getId(), resource1.getId()).deploy();
        ProcessApplicationRegistration registration = deployment2.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        RedeploymentTest.assertEquals((int)1, (int)deploymentIds.size());
        RedeploymentTest.assertTrue((boolean)deploymentIds.contains(deployment2.getId()));
        this.deleteDeployments(new Deployment[]{deployment1, deployment2});
    }

    public void testRedeployProcessApplicationDeploymentResumePreviousVersions() {
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication();
        BpmnModelInstance model = this.createProcessWithServiceTask(PROCESS_KEY);
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(processApplication.getReference()).name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, model).enableDuplicateFiltering(true).deploy();
        Resource resource1 = this.getResourceByName(deployment1.getId(), RESOURCE_NAME);
        model = this.createProcessWithUserTask(PROCESS_KEY);
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(processApplication.getReference()).name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, model).enableDuplicateFiltering(true).deploy();
        ProcessApplicationDeployment deployment3 = this.repositoryService.createDeployment(processApplication.getReference()).name(DEPLOYMENT_NAME).resumePreviousVersions().addDeploymentResourceById(deployment1.getId(), resource1.getId()).deploy();
        ProcessApplicationRegistration registration = deployment3.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        RedeploymentTest.assertEquals((int)3, (int)deploymentIds.size());
        this.deleteDeployments(new Deployment[]{deployment1, deployment2, deployment3});
    }

    public void testProcessApplicationDeploymentResumePreviousVersionsByDeploymentName() {
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication();
        BpmnModelInstance model = this.createProcessWithServiceTask(PROCESS_KEY);
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(processApplication.getReference()).name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, model).enableDuplicateFiltering(true).deploy();
        Resource resource1 = this.getResourceByName(deployment1.getId(), RESOURCE_NAME);
        model = this.createProcessWithUserTask(PROCESS_KEY);
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(processApplication.getReference()).name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, model).enableDuplicateFiltering(true).deploy();
        ProcessApplicationDeployment deployment3 = this.repositoryService.createDeployment(processApplication.getReference()).name(DEPLOYMENT_NAME).resumePreviousVersions().resumePreviousVersionsBy("deployment-name").addDeploymentResourceById(deployment1.getId(), resource1.getId()).deploy();
        ProcessApplicationRegistration registration = deployment3.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        RedeploymentTest.assertEquals((int)3, (int)deploymentIds.size());
        this.deleteDeployments(new Deployment[]{deployment1, deployment2, deployment3});
    }

    protected void verifyQueryResults(Query<?, ?> query, int countExpected) {
        RedeploymentTest.assertEquals((long)countExpected, (long)query.count());
    }

    protected Resource getResourceByName(String deploymentId, String resourceName) {
        List resources = this.repositoryService.getDeploymentResources(deploymentId);
        for (Resource resource : resources) {
            if (!resource.getName().equals(resourceName)) continue;
            return resource;
        }
        return null;
    }

    protected void deleteDeployments(Deployment ... deployments) {
        for (Deployment deployment : deployments) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    protected BpmnModelInstance createProcessWithServiceTask(String key) {
        return ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)key).startEvent().serviceTask().camundaExpression("${true}")).endEvent().done();
    }

    protected BpmnModelInstance createProcessWithUserTask(String key) {
        return Bpmn.createExecutableProcess((String)key).startEvent().userTask().endEvent().done();
    }

    protected BpmnModelInstance createProcessWithReceiveTask(String key) {
        return Bpmn.createExecutableProcess((String)key).startEvent().receiveTask().endEvent().done();
    }

    protected BpmnModelInstance createProcessWithScriptTask(String key) {
        return ((ScriptTaskBuilder)((ScriptTaskBuilder)Bpmn.createExecutableProcess((String)key).startEvent().scriptTask().scriptFormat("javascript")).scriptText("return true")).userTask().endEvent().done();
    }
}

