/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.List;
import org.camunda.bpm.engine.history.HistoricIdentityLinkLogQuery;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;

@RequiredHistoryLevel(value="full")
public class HistoricIdentityLinkLogTest
extends PluggableProcessEngineTestCase {
    private static final String A_USER_ID = "aUserId";
    private static final String B_USER_ID = "bUserId";
    private static final String C_USER_ID = "cUserId";
    private static final int numberOfUsers = 3;
    private static final String A_GROUP_ID = "aGroupId";
    private static final String INVALID_USER_ID = "InvalidUserId";
    private static final String A_ASSIGNER_ID = "aAssignerId";
    private static String PROCESS_DEFINITION_KEY = "oneTaskProcess";
    private static final String GROUP_1 = "Group1";
    private static final String USER_1 = "User1";
    private static final String OWNER_1 = "Owner1";
    private static final String IDENTITY_LINK_ADD = "add";
    private static final String IDENTITY_LINK_DELETE = "delete";

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testShouldAddTaskCandidateforAddIdentityLink() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogTest.assertEquals((int)historicIdentityLinks.size(), (int)0);
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId(A_ASSIGNER_ID);
        this.taskService.addCandidateUser(taskId, A_USER_ID);
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogTest.assertEquals((int)historicIdentityLinks.size(), (int)1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testShouldAddDelegateTaskCandidateforAddIdentityLink() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogTest.assertEquals((int)historicIdentityLinks.size(), (int)0);
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId(A_ASSIGNER_ID);
        this.taskService.addUserIdentityLink(taskId, A_USER_ID, "assignee");
        this.taskService.delegateTask(taskId, B_USER_ID);
        this.taskService.deleteUserIdentityLink(taskId, B_USER_ID, "assignee");
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogTest.assertEquals((int)historicIdentityLinks.size(), (int)5);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogTest.assertEquals((long)query.userId(A_USER_ID).count(), (long)3L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogTest.assertEquals((long)query.userId(B_USER_ID).count(), (long)2L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogTest.assertEquals((long)query.operationType(IDENTITY_LINK_ADD).count(), (long)3L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogTest.assertEquals((long)query.operationType(IDENTITY_LINK_DELETE).count(), (long)2L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogTest.assertEquals((long)query.type("assignee").count(), (long)4L);
        HistoricIdentityLinkLogTest.assertEquals((long)query.type("owner").count(), (long)1L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testShouldAddClaimTaskCandidateforAddIdentityLink() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogTest.assertEquals((int)historicIdentityLinks.size(), (int)0);
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.claim(taskId, A_USER_ID);
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogTest.assertEquals((int)historicIdentityLinks.size(), (int)1);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogTest.assertEquals((long)query.userId(A_USER_ID).count(), (long)1L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogTest.assertEquals((long)query.operationType(IDENTITY_LINK_ADD).count(), (long)1L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogTest.assertEquals((long)query.operationType(IDENTITY_LINK_DELETE).count(), (long)0L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogTest.assertEquals((long)query.type("assignee").count(), (long)1L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testShouldAddMultipleDelegateTaskCandidateforAddIdentityLink() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogTest.assertEquals((int)historicIdentityLinks.size(), (int)0);
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId(A_ASSIGNER_ID);
        this.taskService.addUserIdentityLink(taskId, A_USER_ID, "assignee");
        this.taskService.delegateTask(taskId, B_USER_ID);
        this.taskService.delegateTask(taskId, C_USER_ID);
        this.taskService.deleteUserIdentityLink(taskId, C_USER_ID, "assignee");
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogTest.assertEquals((int)historicIdentityLinks.size(), (int)7);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogTest.assertEquals((long)query.userId(A_USER_ID).count(), (long)3L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogTest.assertEquals((long)query.userId(B_USER_ID).count(), (long)2L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogTest.assertEquals((long)query.userId(C_USER_ID).count(), (long)2L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogTest.assertEquals((long)query.operationType(IDENTITY_LINK_ADD).count(), (long)4L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogTest.assertEquals((long)query.operationType(IDENTITY_LINK_DELETE).count(), (long)3L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogTest.assertEquals((long)query.type("assignee").count(), (long)6L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogTest.assertEquals((long)query.type("owner").count(), (long)1L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testShouldAddTaskCandidateForAddAndDeleteIdentityLink() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogTest.assertEquals((int)historicIdentityLinks.size(), (int)0);
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId(A_ASSIGNER_ID);
        this.taskService.addCandidateUser(taskId, A_USER_ID);
        this.taskService.deleteCandidateUser(taskId, A_USER_ID);
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogTest.assertEquals((int)historicIdentityLinks.size(), (int)2);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testShouldAddGroupCandidateForAddAndDeleteIdentityLink() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogTest.assertEquals((int)historicIdentityLinks.size(), (int)0);
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId(A_ASSIGNER_ID);
        this.taskService.addCandidateGroup(taskId, A_GROUP_ID);
        this.taskService.deleteCandidateGroup(taskId, A_GROUP_ID);
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogTest.assertEquals((int)historicIdentityLinks.size(), (int)2);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogTest.assertEquals((long)query.groupId(A_GROUP_ID).count(), (long)2L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testShouldNotAddTaskCandidateForInvalidIdentityLinkDelete() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogTest.assertEquals((int)historicIdentityLinks.size(), (int)0);
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId(A_ASSIGNER_ID);
        this.taskService.deleteCandidateUser(taskId, INVALID_USER_ID);
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogTest.assertEquals((int)historicIdentityLinks.size(), (int)0);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testShouldAddTaskAssigneeForAddandDeleteIdentityLink() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogTest.assertEquals((int)historicIdentityLinks.size(), (int)0);
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.addAndDeleteUserWithAssigner(taskId, "assignee");
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogTest.assertEquals((int)historicIdentityLinks.size(), (int)2);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogTest.assertEquals((long)query.type("assignee").count(), (long)2L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testShouldAddAndRemoveIdentityLinksForProcessDefinition() throws Exception {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogTest.assertEquals((int)historicIdentityLinks.size(), (int)0);
        ProcessDefinition latestProcessDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).singleResult();
        HistoricIdentityLinkLogTest.assertNotNull((Object)latestProcessDef);
        List links = this.repositoryService.getIdentityLinksForProcessDefinition(latestProcessDef.getId());
        HistoricIdentityLinkLogTest.assertEquals((int)0, (int)links.size());
        this.repositoryService.addCandidateStarterGroup(latestProcessDef.getId(), GROUP_1);
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogTest.assertEquals((int)historicIdentityLinks.size(), (int)1);
        this.repositoryService.addCandidateStarterUser(latestProcessDef.getId(), USER_1);
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogTest.assertEquals((int)historicIdentityLinks.size(), (int)2);
        this.repositoryService.deleteCandidateStarterGroup(latestProcessDef.getId(), GROUP_1);
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogTest.assertEquals((int)historicIdentityLinks.size(), (int)3);
        this.repositoryService.deleteCandidateStarterUser(latestProcessDef.getId(), USER_1);
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogTest.assertEquals((int)historicIdentityLinks.size(), (int)4);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testShouldAddTaskOwnerForAddandDeleteIdentityLink() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogTest.assertEquals((int)historicIdentityLinks.size(), (int)0);
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.addAndDeleteUserWithAssigner(taskId, "owner");
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogTest.assertEquals((int)historicIdentityLinks.size(), (int)2);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogTest.assertEquals((long)query.type("owner").count(), (long)2L);
    }

    public void testShouldAddIdentityLinkForTaskCreationWithAssigneeAndOwner() {
        String taskAssigneeId = "Assigneee";
        String taskOwnerId = "Owner";
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogTest.assertEquals((int)historicIdentityLinks.size(), (int)0);
        Task taskAssignee = this.taskService.newTask(taskAssigneeId);
        taskAssignee.setAssignee(USER_1);
        this.taskService.saveTask(taskAssignee);
        Task taskOwner = this.taskService.newTask(taskOwnerId);
        taskOwner.setOwner(OWNER_1);
        this.taskService.saveTask(taskOwner);
        Task taskEmpty = this.taskService.newTask();
        this.taskService.saveTask(taskEmpty);
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogTest.assertEquals((int)historicIdentityLinks.size(), (int)2);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogTest.assertEquals((long)query.type("assignee").count(), (long)1L);
        HistoricIdentityLinkLogTest.assertEquals((long)query.userId(USER_1).count(), (long)1L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogTest.assertEquals((long)query.type("owner").count(), (long)1L);
        HistoricIdentityLinkLogTest.assertEquals((long)query.userId(OWNER_1).count(), (long)1L);
        this.taskService.deleteTask(taskAssigneeId, true);
        this.taskService.deleteTask(taskOwnerId, true);
        this.taskService.deleteTask(taskEmpty.getId(), true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testShouldAddIdentityLinkByProcessDefinitionAndStandalone() {
        String taskAssigneeId = "Assigneee";
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogTest.assertEquals((int)historicIdentityLinks.size(), (int)0);
        ProcessInstance processInstance = this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        Task taskAssignee = this.taskService.newTask(taskAssigneeId);
        taskAssignee.setAssignee(USER_1);
        this.taskService.saveTask(taskAssignee);
        this.addAndDeleteUserWithAssigner(taskId, "assignee");
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        HistoricIdentityLinkLogTest.assertEquals((int)historicIdentityLinks.size(), (int)3);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogTest.assertEquals((long)query.type("assignee").count(), (long)3L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLogTest.assertEquals((long)query.processDefinitionId(processInstance.getProcessDefinitionId()).count(), (long)2L);
        HistoricIdentityLinkLogTest.assertEquals((long)query.processDefinitionKey(PROCESS_DEFINITION_KEY).count(), (long)2L);
        this.taskService.deleteTask(taskAssigneeId, true);
    }

    public void addAndDeleteUserWithAssigner(String taskId, String identityLinkType) {
        this.identityService.setAuthenticatedUserId(A_ASSIGNER_ID);
        this.taskService.addUserIdentityLink(taskId, A_USER_ID, identityLinkType);
        this.taskService.deleteUserIdentityLink(taskId, A_USER_ID, identityLinkType);
    }

    public void addUserIdentityLinks(String taskId) {
        for (int userIndex = 1; userIndex <= 3; ++userIndex) {
            this.taskService.addUserIdentityLink(taskId, A_USER_ID + userIndex, "owner");
        }
    }

    public void deleteUserIdentityLinks(String taskId) {
        for (int userIndex = 1; userIndex <= 3; ++userIndex) {
            this.taskService.deleteUserIdentityLink(taskId, A_USER_ID + userIndex, "owner");
        }
    }

    protected ProcessInstance startProcessInstance(String key) {
        return this.runtimeService.startProcessInstanceByKey(key);
    }
}

