/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.util;

import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngines;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class ProcessEngineBootstrapRule
extends TestWatcher {
    private ProcessEngine processEngine;

    public ProcessEngineBootstrapRule() {
        this("camunda.cfg.xml");
    }

    public ProcessEngineBootstrapRule(String configurationResource) {
        this.processEngine = this.bootstrapEngine(configurationResource);
    }

    public ProcessEngine bootstrapEngine(String configurationResource) {
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)configurationResource);
        this.configureEngine(processEngineConfiguration);
        return processEngineConfiguration.buildProcessEngine();
    }

    public ProcessEngineConfiguration configureEngine(ProcessEngineConfigurationImpl configuration) {
        return configuration;
    }

    public ProcessEngine getProcessEngine() {
        return this.processEngine;
    }

    protected void finished(Description description) {
        this.processEngine.close();
        ProcessEngines.unregister((ProcessEngine)this.processEngine);
        this.processEngine = null;
    }
}

