/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.deploy;

import java.io.InputStream;
import java.util.List;
import java.util.concurrent.Callable;
import org.camunda.bpm.engine.exception.cmmn.CaseDefinitionNotFoundException;
import org.camunda.bpm.engine.exception.dmn.DecisionDefinitionNotFoundException;
import org.camunda.bpm.engine.impl.ProcessDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cmd.GetDeploymentResourceCmd;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.EnginePersistenceLogger;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionEntity;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionRequirementsDefinitionEntity;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionRequirementsDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.CacheFactory;
import org.camunda.bpm.engine.impl.persistence.deploy.Deployer;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.cmmn.Cmmn;
import org.camunda.bpm.model.cmmn.CmmnModelInstance;
import org.camunda.bpm.model.dmn.Dmn;
import org.camunda.bpm.model.dmn.DmnModelInstance;
import org.camunda.commons.utils.cache.Cache;

public class DeploymentCache {
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;
    protected Cache<String, ProcessDefinitionEntity> processDefinitionEntityCache;
    protected Cache<String, CaseDefinitionEntity> caseDefinitionCache;
    protected Cache<String, DecisionDefinitionEntity> decisionDefinitionCache;
    protected Cache<String, DecisionRequirementsDefinitionEntity> decisionRequirementsDefinitionCache;
    protected Cache<String, BpmnModelInstance> bpmnModelInstanceCache;
    protected Cache<String, CmmnModelInstance> cmmnModelInstanceCache;
    protected Cache<String, DmnModelInstance> dmnModelInstanceCache;
    protected List<Deployer> deployers;

    public DeploymentCache(CacheFactory factory, int cacheCapacity) {
        this.processDefinitionEntityCache = factory.createCache(cacheCapacity);
        this.caseDefinitionCache = factory.createCache(cacheCapacity);
        this.decisionDefinitionCache = factory.createCache(cacheCapacity);
        this.decisionRequirementsDefinitionCache = factory.createCache(cacheCapacity);
        this.bpmnModelInstanceCache = factory.createCache(cacheCapacity);
        this.cmmnModelInstanceCache = factory.createCache(cacheCapacity);
        this.dmnModelInstanceCache = factory.createCache(cacheCapacity);
    }

    public void deploy(final DeploymentEntity deployment) {
        Context.getCommandContext().runWithoutAuthorization(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                for (Deployer deployer : DeploymentCache.this.deployers) {
                    deployer.deploy(deployment);
                }
                return null;
            }
        });
    }

    protected void initDeployment(DeploymentEntity deployment, String resourceName) {
        deployment.clearResources();
        ResourceEntity resource = Context.getCommandContext().getResourceManager().findResourceByDeploymentIdAndResourceName(deployment.getId(), resourceName);
        deployment.addResource(resource);
    }

    public ProcessDefinitionEntity findProcessDefinitionFromCache(String processDefinitionId) {
        return (ProcessDefinitionEntity)this.processDefinitionEntityCache.get((Object)processDefinitionId);
    }

    public ProcessDefinitionEntity findDeployedProcessDefinitionById(String processDefinitionId) {
        EnsureUtil.ensureNotNull("Invalid process definition id", "processDefinitionId", (Object)processDefinitionId);
        CommandContext commandContext = Context.getCommandContext();
        ProcessDefinitionEntity processDefinition = commandContext.getDbEntityManager().getCachedEntity(ProcessDefinitionEntity.class, processDefinitionId);
        if (processDefinition == null) {
            processDefinition = commandContext.getProcessDefinitionManager().findLatestProcessDefinitionById(processDefinitionId);
        }
        EnsureUtil.ensureNotNull("no deployed process definition found with id '" + processDefinitionId + "'", "processDefinition", (Object)processDefinition);
        processDefinition = this.resolveProcessDefinition(processDefinition);
        return processDefinition;
    }

    public ProcessDefinitionEntity findDeployedLatestProcessDefinitionByKey(String processDefinitionKey) {
        ProcessDefinitionEntity processDefinition = Context.getCommandContext().getProcessDefinitionManager().findLatestProcessDefinitionByKey(processDefinitionKey);
        EnsureUtil.ensureNotNull("no processes deployed with key '" + processDefinitionKey + "'", "processDefinition", (Object)processDefinition);
        processDefinition = this.resolveProcessDefinition(processDefinition);
        return processDefinition;
    }

    public ProcessDefinitionEntity findDeployedLatestProcessDefinitionByKeyAndTenantId(String processDefinitionKey, String tenantId) {
        ProcessDefinitionEntity processDefinition = Context.getCommandContext().getProcessDefinitionManager().findLatestProcessDefinitionByKeyAndTenantId(processDefinitionKey, tenantId);
        EnsureUtil.ensureNotNull("no processes deployed with key '" + processDefinitionKey + "' and tenant-id '" + tenantId + "'", "processDefinition", (Object)processDefinition);
        processDefinition = this.resolveProcessDefinition(processDefinition);
        return processDefinition;
    }

    public ProcessDefinitionEntity findDeployedProcessDefinitionByKeyVersionAndTenantId(final String processDefinitionKey, final Integer processDefinitionVersion, final String tenantId) {
        final CommandContext commandContext = Context.getCommandContext();
        ProcessDefinitionEntity processDefinition = commandContext.runWithoutAuthorization(new Callable<ProcessDefinitionEntity>(){

            @Override
            public ProcessDefinitionEntity call() throws Exception {
                return (ProcessDefinitionEntity)commandContext.getProcessDefinitionManager().findProcessDefinitionByKeyVersionAndTenantId(processDefinitionKey, processDefinitionVersion, tenantId);
            }
        });
        EnsureUtil.ensureNotNull("no processes deployed with key = '" + processDefinitionKey + "', version = '" + processDefinitionVersion + "' and tenant-id = '" + tenantId + "'", "processDefinition", (Object)processDefinition);
        processDefinition = this.resolveProcessDefinition(processDefinition);
        return processDefinition;
    }

    public ProcessDefinitionEntity findDeployedProcessDefinitionByDeploymentAndKey(String deploymentId, String processDefinitionKey) {
        ProcessDefinitionEntity processDefinition = Context.getCommandContext().getProcessDefinitionManager().findProcessDefinitionByDeploymentAndKey(deploymentId, processDefinitionKey);
        EnsureUtil.ensureNotNull("no processes deployed with key = '" + processDefinitionKey + "' in deployment = '" + deploymentId + "'", "processDefinition", (Object)processDefinition);
        processDefinition = this.resolveProcessDefinition(processDefinition);
        return processDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessDefinitionEntity resolveProcessDefinition(ProcessDefinitionEntity processDefinition) {
        String processDefinitionId = processDefinition.getId();
        String deploymentId = processDefinition.getDeploymentId();
        ProcessDefinitionEntity cachedProcessDefinition = (ProcessDefinitionEntity)this.processDefinitionEntityCache.get((Object)processDefinitionId);
        if (cachedProcessDefinition == null) {
            DeploymentCache deploymentCache = this;
            synchronized (deploymentCache) {
                cachedProcessDefinition = (ProcessDefinitionEntity)this.processDefinitionEntityCache.get((Object)processDefinitionId);
                if (cachedProcessDefinition == null) {
                    DeploymentEntity deployment = Context.getCommandContext().getDeploymentManager().findDeploymentById(deploymentId);
                    deployment.setNew(false);
                    this.initDeployment(deployment, processDefinition.getResourceName());
                    this.deploy(deployment);
                    cachedProcessDefinition = (ProcessDefinitionEntity)this.processDefinitionEntityCache.get((Object)processDefinitionId);
                }
            }
            EnsureUtil.ensureNotNull("deployment '" + deploymentId + "' didn't put process definition '" + processDefinitionId + "' in the cache", "cachedProcessDefinition", (Object)cachedProcessDefinition);
        } else {
            cachedProcessDefinition.updateModifiedFieldsFromEntity(processDefinition);
        }
        return cachedProcessDefinition;
    }

    public BpmnModelInstance findBpmnModelInstanceForProcessDefinition(ProcessDefinitionEntity processDefinitionEntity) {
        BpmnModelInstance bpmnModelInstance = (BpmnModelInstance)this.bpmnModelInstanceCache.get((Object)processDefinitionEntity.getId());
        if (bpmnModelInstance == null) {
            bpmnModelInstance = this.loadAndCacheBpmnModelInstance(processDefinitionEntity);
        }
        return bpmnModelInstance;
    }

    public BpmnModelInstance findBpmnModelInstanceForProcessDefinition(String processDefinitionId) {
        BpmnModelInstance bpmnModelInstance = (BpmnModelInstance)this.bpmnModelInstanceCache.get((Object)processDefinitionId);
        if (bpmnModelInstance == null) {
            ProcessDefinitionEntity processDefinition = this.findDeployedProcessDefinitionById(processDefinitionId);
            bpmnModelInstance = this.loadAndCacheBpmnModelInstance(processDefinition);
        }
        return bpmnModelInstance;
    }

    protected BpmnModelInstance loadAndCacheBpmnModelInstance(final ProcessDefinitionEntity processDefinitionEntity) {
        final CommandContext commandContext = Context.getCommandContext();
        InputStream bpmnResourceInputStream = commandContext.runWithoutAuthorization(new Callable<InputStream>(){

            @Override
            public InputStream call() throws Exception {
                return new GetDeploymentResourceCmd(processDefinitionEntity.getDeploymentId(), processDefinitionEntity.getResourceName()).execute(commandContext);
            }
        });
        try {
            BpmnModelInstance bpmnModelInstance = Bpmn.readModelFromStream((InputStream)bpmnResourceInputStream);
            this.bpmnModelInstanceCache.put((Object)processDefinitionEntity.getId(), (Object)bpmnModelInstance);
            return bpmnModelInstance;
        }
        catch (Exception e) {
            throw LOG.loadModelException("BPMN", "process", processDefinitionEntity.getId(), e);
        }
    }

    public void addProcessDefinition(ProcessDefinitionEntity processDefinition) {
        this.processDefinitionEntityCache.put((Object)processDefinition.getId(), (Object)processDefinition);
    }

    public void removeProcessDefinition(String processDefinitionId) {
        this.processDefinitionEntityCache.remove((Object)processDefinitionId);
        this.bpmnModelInstanceCache.remove((Object)processDefinitionId);
    }

    public void discardProcessDefinitionCache() {
        this.processDefinitionEntityCache.clear();
        this.bpmnModelInstanceCache.clear();
    }

    public CaseDefinitionEntity findCaseDefinitionFromCache(String caseDefinitionId) {
        return (CaseDefinitionEntity)this.caseDefinitionCache.get((Object)caseDefinitionId);
    }

    public CaseDefinitionEntity findDeployedCaseDefinitionById(String caseDefinitionId) {
        EnsureUtil.ensureNotNull("Invalid case definition id", "caseDefinitionId", (Object)caseDefinitionId);
        CommandContext commandContext = Context.getCommandContext();
        CaseDefinitionEntity caseDefinition = commandContext.getDbEntityManager().getCachedEntity(CaseDefinitionEntity.class, caseDefinitionId);
        if (caseDefinition == null) {
            caseDefinition = commandContext.getCaseDefinitionManager().findCaseDefinitionById(caseDefinitionId);
        }
        EnsureUtil.ensureNotNull(CaseDefinitionNotFoundException.class, "no deployed case definition found with id '" + caseDefinitionId + "'", "caseDefinition", (Object)caseDefinition);
        caseDefinition = this.resolveCaseDefinition(caseDefinition);
        return caseDefinition;
    }

    public CaseDefinitionEntity findDeployedLatestCaseDefinitionByKey(String caseDefinitionKey) {
        EnsureUtil.ensureNotNull("Invalid case definition key", "caseDefinitionKey", (Object)caseDefinitionKey);
        CaseDefinitionEntity caseDefinition = Context.getCommandContext().getCaseDefinitionManager().findLatestCaseDefinitionByKey(caseDefinitionKey);
        EnsureUtil.ensureNotNull(CaseDefinitionNotFoundException.class, "no case definition deployed with key '" + caseDefinitionKey + "'", "caseDefinition", (Object)caseDefinition);
        caseDefinition = this.resolveCaseDefinition(caseDefinition);
        return caseDefinition;
    }

    public CaseDefinitionEntity findDeployedLatestCaseDefinitionByKeyAndTenantId(String caseDefinitionKey, String tenantId) {
        EnsureUtil.ensureNotNull("Invalid case definition key", "caseDefinitionKey", (Object)caseDefinitionKey);
        CaseDefinitionEntity caseDefinition = Context.getCommandContext().getCaseDefinitionManager().findLatestCaseDefinitionByKeyAndTenantId(caseDefinitionKey, tenantId);
        EnsureUtil.ensureNotNull(CaseDefinitionNotFoundException.class, "no case definition deployed with key '" + caseDefinitionKey + "' and tenant-id '" + tenantId + "'", "caseDefinition", (Object)caseDefinition);
        caseDefinition = this.resolveCaseDefinition(caseDefinition);
        return caseDefinition;
    }

    public CaseDefinitionEntity findDeployedCaseDefinitionByKeyVersionAndTenantId(String caseDefinitionKey, Integer caseDefinitionVersion, String tenantId) {
        CaseDefinitionEntity caseDefinition = Context.getCommandContext().getCaseDefinitionManager().findCaseDefinitionByKeyVersionAndTenantId(caseDefinitionKey, caseDefinitionVersion, tenantId);
        EnsureUtil.ensureNotNull(CaseDefinitionNotFoundException.class, "no case definition deployed with key = '" + caseDefinitionKey + "', version = '" + caseDefinitionVersion + "'" + " and tenant-id = '" + tenantId + "'", "caseDefinition", (Object)caseDefinition);
        caseDefinition = this.resolveCaseDefinition(caseDefinition);
        return caseDefinition;
    }

    public CaseDefinitionEntity findDeployedCaseDefinitionByDeploymentAndKey(String deploymentId, String caseDefinitionKey) {
        CaseDefinitionEntity caseDefinition = Context.getCommandContext().getCaseDefinitionManager().findCaseDefinitionByDeploymentAndKey(deploymentId, caseDefinitionKey);
        EnsureUtil.ensureNotNull(CaseDefinitionNotFoundException.class, "no case definition deployed with key = '" + caseDefinitionKey + "' in deployment = '" + deploymentId + "'", "caseDefinition", (Object)caseDefinition);
        caseDefinition = this.resolveCaseDefinition(caseDefinition);
        return caseDefinition;
    }

    public CaseDefinitionEntity getCaseDefinitionById(String caseDefinitionId) {
        EnsureUtil.ensureNotNull("caseDefinitionId", (Object)caseDefinitionId);
        CaseDefinitionEntity caseDefinition = (CaseDefinitionEntity)this.caseDefinitionCache.get((Object)caseDefinitionId);
        if (caseDefinition == null) {
            caseDefinition = this.findDeployedCaseDefinitionById(caseDefinitionId);
        }
        return caseDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CaseDefinitionEntity resolveCaseDefinition(CaseDefinitionEntity caseDefinition) {
        String caseDefinitionId = caseDefinition.getId();
        String deploymentId = caseDefinition.getDeploymentId();
        CaseDefinitionEntity cachedCaseDefinition = (CaseDefinitionEntity)this.caseDefinitionCache.get((Object)caseDefinitionId);
        if (cachedCaseDefinition == null) {
            DeploymentCache deploymentCache = this;
            synchronized (deploymentCache) {
                cachedCaseDefinition = (CaseDefinitionEntity)this.caseDefinitionCache.get((Object)caseDefinitionId);
                if (cachedCaseDefinition == null) {
                    DeploymentEntity deployment = Context.getCommandContext().getDeploymentManager().findDeploymentById(deploymentId);
                    deployment.setNew(false);
                    this.initDeployment(deployment, caseDefinition.getResourceName());
                    this.deploy(deployment);
                    cachedCaseDefinition = (CaseDefinitionEntity)this.caseDefinitionCache.get((Object)caseDefinitionId);
                }
            }
            EnsureUtil.ensureNotNull("deployment '" + deploymentId + "' didn't put case definition '" + caseDefinitionId + "' in the cache", "cachedCaseDefinition", (Object)cachedCaseDefinition);
        }
        return cachedCaseDefinition;
    }

    public CmmnModelInstance findCmmnModelInstanceForCaseDefinition(String caseDefinitionId) {
        CmmnModelInstance cmmnModelInstance = (CmmnModelInstance)this.cmmnModelInstanceCache.get((Object)caseDefinitionId);
        if (cmmnModelInstance == null) {
            CaseDefinitionEntity caseDefinition = this.findDeployedCaseDefinitionById(caseDefinitionId);
            final String deploymentId = caseDefinition.getDeploymentId();
            final String resourceName = caseDefinition.getResourceName();
            final CommandContext commandContext = Context.getCommandContext();
            InputStream cmmnResourceInputStream = commandContext.runWithoutAuthorization(new Callable<InputStream>(){

                @Override
                public InputStream call() throws Exception {
                    return new GetDeploymentResourceCmd(deploymentId, resourceName).execute(commandContext);
                }
            });
            try {
                cmmnModelInstance = Cmmn.readModelFromStream((InputStream)cmmnResourceInputStream);
            }
            catch (Exception e) {
                throw LOG.loadModelException("CMMN", "case", caseDefinitionId, e);
            }
            this.cmmnModelInstanceCache.put((Object)caseDefinitionId, (Object)cmmnModelInstance);
        }
        return cmmnModelInstance;
    }

    public void addCaseDefinition(CaseDefinitionEntity caseDefinition) {
        this.caseDefinitionCache.put((Object)caseDefinition.getId(), (Object)caseDefinition);
    }

    public void removeCaseDefinition(String caseDefinitionId) {
        this.caseDefinitionCache.remove((Object)caseDefinitionId);
        this.cmmnModelInstanceCache.remove((Object)caseDefinitionId);
    }

    public void discardCaseDefinitionCache() {
        this.caseDefinitionCache.clear();
        this.cmmnModelInstanceCache.clear();
    }

    public DecisionDefinitionEntity findDecisionDefinitionFromCache(String decisionDefinitionId) {
        return (DecisionDefinitionEntity)this.decisionDefinitionCache.get((Object)decisionDefinitionId);
    }

    public DecisionDefinitionEntity findDeployedDecisionDefinitionById(String decisionDefinitionId) {
        EnsureUtil.ensureNotNull("Invalid decision definition id", "decisionDefinitionId", (Object)decisionDefinitionId);
        CommandContext commandContext = Context.getCommandContext();
        DecisionDefinitionEntity decisionDefinition = commandContext.getDbEntityManager().getCachedEntity(DecisionDefinitionEntity.class, decisionDefinitionId);
        if (decisionDefinition == null) {
            decisionDefinition = commandContext.getDecisionDefinitionManager().findDecisionDefinitionById(decisionDefinitionId);
        }
        EnsureUtil.ensureNotNull(DecisionDefinitionNotFoundException.class, "no deployed decision definition found with id '" + decisionDefinitionId + "'", "decisionDefinition", (Object)decisionDefinition);
        decisionDefinition = this.resolveDecisionDefinition(decisionDefinition);
        return decisionDefinition;
    }

    public DecisionDefinition findDeployedLatestDecisionDefinitionByKey(String decisionDefinitionKey) {
        EnsureUtil.ensureNotNull("Invalid decision definition key", "decisionDefinitionKey", (Object)decisionDefinitionKey);
        DecisionDefinitionEntity decisionDefinition = Context.getCommandContext().getDecisionDefinitionManager().findLatestDecisionDefinitionByKey(decisionDefinitionKey);
        EnsureUtil.ensureNotNull(DecisionDefinitionNotFoundException.class, "no decision definition deployed with key '" + decisionDefinitionKey + "'", "decisionDefinition", (Object)decisionDefinition);
        decisionDefinition = this.resolveDecisionDefinition(decisionDefinition);
        return decisionDefinition;
    }

    public DecisionDefinition findDeployedLatestDecisionDefinitionByKeyAndTenantId(String decisionDefinitionKey, String tenantId) {
        EnsureUtil.ensureNotNull("Invalid decision definition key", "decisionDefinitionKey", (Object)decisionDefinitionKey);
        DecisionDefinitionEntity decisionDefinition = Context.getCommandContext().getDecisionDefinitionManager().findLatestDecisionDefinitionByKeyAndTenantId(decisionDefinitionKey, tenantId);
        EnsureUtil.ensureNotNull(DecisionDefinitionNotFoundException.class, "no decision definition deployed with key '" + decisionDefinitionKey + "' and tenant-id '" + tenantId + "'", "decisionDefinition", (Object)decisionDefinition);
        decisionDefinition = this.resolveDecisionDefinition(decisionDefinition);
        return decisionDefinition;
    }

    public DecisionDefinition findDeployedDecisionDefinitionByDeploymentAndKey(String deploymentId, String decisionDefinitionKey) {
        DecisionDefinitionEntity decisionDefinition = Context.getCommandContext().getDecisionDefinitionManager().findDecisionDefinitionByDeploymentAndKey(deploymentId, decisionDefinitionKey);
        EnsureUtil.ensureNotNull(DecisionDefinitionNotFoundException.class, "no decision definition deployed with key = '" + decisionDefinitionKey + "' in deployment = '" + deploymentId + "'", "decisionDefinition", (Object)decisionDefinition);
        decisionDefinition = this.resolveDecisionDefinition(decisionDefinition);
        return decisionDefinition;
    }

    public DecisionDefinition findDeployedDecisionDefinitionByKeyAndVersion(String decisionDefinitionKey, Integer decisionDefinitionVersion) {
        DecisionDefinitionEntity decisionDefinition = Context.getCommandContext().getDecisionDefinitionManager().findDecisionDefinitionByKeyAndVersion(decisionDefinitionKey, decisionDefinitionVersion);
        EnsureUtil.ensureNotNull(DecisionDefinitionNotFoundException.class, "no decision definition deployed with key = '" + decisionDefinitionKey + "' and version = '" + decisionDefinitionVersion + "'", "decisionDefinition", (Object)decisionDefinition);
        decisionDefinition = this.resolveDecisionDefinition(decisionDefinition);
        return decisionDefinition;
    }

    public DecisionDefinition findDeployedDecisionDefinitionByKeyVersionAndTenantId(String decisionDefinitionKey, Integer decisionDefinitionVersion, String tenantId) {
        DecisionDefinitionEntity decisionDefinition = Context.getCommandContext().getDecisionDefinitionManager().findDecisionDefinitionByKeyVersionAndTenantId(decisionDefinitionKey, decisionDefinitionVersion, tenantId);
        EnsureUtil.ensureNotNull(DecisionDefinitionNotFoundException.class, "no decision definition deployed with key = '" + decisionDefinitionKey + "', version = '" + decisionDefinitionVersion + "' and tenant-id '" + tenantId + "'", "decisionDefinition", (Object)decisionDefinition);
        decisionDefinition = this.resolveDecisionDefinition(decisionDefinition);
        return decisionDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DecisionDefinitionEntity resolveDecisionDefinition(DecisionDefinitionEntity decisionDefinition) {
        String decisionDefinitionId = decisionDefinition.getId();
        String deploymentId = decisionDefinition.getDeploymentId();
        DecisionDefinitionEntity cachedDecisionDefinition = (DecisionDefinitionEntity)this.decisionDefinitionCache.get((Object)decisionDefinitionId);
        if (cachedDecisionDefinition == null) {
            DeploymentCache deploymentCache = this;
            synchronized (deploymentCache) {
                cachedDecisionDefinition = (DecisionDefinitionEntity)this.decisionDefinitionCache.get((Object)decisionDefinitionId);
                if (cachedDecisionDefinition == null) {
                    DeploymentEntity deployment = Context.getCommandContext().getDeploymentManager().findDeploymentById(deploymentId);
                    deployment.setNew(false);
                    this.initDeployment(deployment, decisionDefinition.getResourceName());
                    this.deploy(deployment);
                    cachedDecisionDefinition = (DecisionDefinitionEntity)this.decisionDefinitionCache.get((Object)decisionDefinitionId);
                }
            }
            EnsureUtil.ensureNotNull("deployment '" + deploymentId + "' didn't put decision definition '" + decisionDefinitionId + "' in the cache", "cachedDecisionDefinition", (Object)cachedDecisionDefinition);
        }
        return cachedDecisionDefinition;
    }

    public DmnModelInstance findDmnModelInstanceForDecisionDefinition(String decisionDefinitionId) {
        DmnModelInstance dmnModelInstance = (DmnModelInstance)this.dmnModelInstanceCache.get((Object)decisionDefinitionId);
        if (dmnModelInstance == null) {
            DecisionDefinitionEntity decisionDefinition = this.findDeployedDecisionDefinitionById(decisionDefinitionId);
            final String deploymentId = decisionDefinition.getDeploymentId();
            final String resourceName = decisionDefinition.getResourceName();
            final CommandContext commandContext = Context.getCommandContext();
            InputStream dmnResourceInputStream = commandContext.runWithoutAuthorization(new Callable<InputStream>(){

                @Override
                public InputStream call() throws Exception {
                    return new GetDeploymentResourceCmd(deploymentId, resourceName).execute(commandContext);
                }
            });
            try {
                dmnModelInstance = Dmn.readModelFromStream((InputStream)dmnResourceInputStream);
            }
            catch (Exception e) {
                throw LOG.loadModelException("DMN", "decision", decisionDefinitionId, e);
            }
            this.dmnModelInstanceCache.put((Object)decisionDefinitionId, (Object)dmnModelInstance);
        }
        return dmnModelInstance;
    }

    public void addDecisionDefinition(DecisionDefinitionEntity decisionDefinition) {
        this.decisionDefinitionCache.put((Object)decisionDefinition.getId(), (Object)decisionDefinition);
    }

    public void removeDecisionDefinition(String decisionDefinitionId) {
        this.decisionDefinitionCache.remove((Object)decisionDefinitionId);
        this.dmnModelInstanceCache.remove((Object)decisionDefinitionId);
    }

    public void discardDecisionDefinitionCache() {
        this.decisionDefinitionCache.clear();
        this.dmnModelInstanceCache.clear();
    }

    public void addDecisionRequirementsDefinition(DecisionRequirementsDefinitionEntity decisionRequirementsDefinition) {
        this.decisionRequirementsDefinitionCache.put((Object)decisionRequirementsDefinition.getId(), (Object)decisionRequirementsDefinition);
    }

    public DecisionRequirementsDefinitionEntity findDecisionRequirementsDefinitionFromCache(String decisionRequirementsDefinitionId) {
        return (DecisionRequirementsDefinitionEntity)this.decisionRequirementsDefinitionCache.get((Object)decisionRequirementsDefinitionId);
    }

    public DecisionRequirementsDefinitionEntity findDeployedDecisionRequirementsDefinitionById(String decisionRequirementsDefinitionId) {
        EnsureUtil.ensureNotNull("Invalid decision requirements definition id", "decisionRequirementsDefinitionId", (Object)decisionRequirementsDefinitionId);
        CommandContext commandContext = Context.getCommandContext();
        DecisionRequirementsDefinitionEntity decisionRequirementsDefinition = commandContext.getDbEntityManager().getCachedEntity(DecisionRequirementsDefinitionEntity.class, decisionRequirementsDefinitionId);
        if (decisionRequirementsDefinition == null) {
            decisionRequirementsDefinition = commandContext.getDecisionDefinitionManager().findDecisionRequirementsDefinitionById(decisionRequirementsDefinitionId);
        }
        EnsureUtil.ensureNotNull("no deployed decision requirements definition found with id '" + decisionRequirementsDefinitionId + "'", "decisionRequirementsDefinition", (Object)decisionRequirementsDefinition);
        decisionRequirementsDefinition = this.resolveDecisionRequirementsDefinition(decisionRequirementsDefinition);
        return decisionRequirementsDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DecisionRequirementsDefinitionEntity resolveDecisionRequirementsDefinition(DecisionRequirementsDefinitionEntity decisionRequirementsDefinition) {
        String decisionRequirementsDefinitionId = decisionRequirementsDefinition.getId();
        String deploymentId = decisionRequirementsDefinition.getDeploymentId();
        DecisionRequirementsDefinitionEntity cachedDecisionRequirementsDefinition = (DecisionRequirementsDefinitionEntity)this.decisionRequirementsDefinitionCache.get((Object)decisionRequirementsDefinitionId);
        if (cachedDecisionRequirementsDefinition == null) {
            DeploymentCache deploymentCache = this;
            synchronized (deploymentCache) {
                cachedDecisionRequirementsDefinition = (DecisionRequirementsDefinitionEntity)this.decisionRequirementsDefinitionCache.get((Object)decisionRequirementsDefinitionId);
                if (cachedDecisionRequirementsDefinition == null) {
                    DeploymentEntity deployment = Context.getCommandContext().getDeploymentManager().findDeploymentById(deploymentId);
                    deployment.setNew(false);
                    this.initDeployment(deployment, decisionRequirementsDefinition.getResourceName());
                    this.deploy(deployment);
                    cachedDecisionRequirementsDefinition = (DecisionRequirementsDefinitionEntity)this.decisionRequirementsDefinitionCache.get((Object)decisionRequirementsDefinitionId);
                }
            }
            EnsureUtil.ensureNotNull("deployment '" + deploymentId + "' didn't put decision requirements definition '" + decisionRequirementsDefinitionId + "' in the cache", "cachedDecisionRequirementsDefinition", (Object)cachedDecisionRequirementsDefinition);
        }
        return cachedDecisionRequirementsDefinition;
    }

    public void discardDecisionRequirementsDefinitionCache() {
        this.decisionDefinitionCache.clear();
    }

    public void removeDecisionRequirementsDefinition(String decisionRequirementsDefinitionId) {
        this.decisionRequirementsDefinitionCache.remove((Object)decisionRequirementsDefinitionId);
    }

    public Cache<String, BpmnModelInstance> getBpmnModelInstanceCache() {
        return this.bpmnModelInstanceCache;
    }

    public Cache<String, CmmnModelInstance> getCmmnModelInstanceCache() {
        return this.cmmnModelInstanceCache;
    }

    public Cache<String, DmnModelInstance> getDmnModelInstanceCache() {
        return this.dmnModelInstanceCache;
    }

    public Cache<String, ProcessDefinitionEntity> getProcessDefinitionCache() {
        return this.processDefinitionEntityCache;
    }

    public void setProcessDefinitionCache(Cache<String, ProcessDefinitionEntity> processDefinitionEntityCache) {
        this.processDefinitionEntityCache = processDefinitionEntityCache;
    }

    public Cache<String, CaseDefinitionEntity> getCaseDefinitionCache() {
        return this.caseDefinitionCache;
    }

    public void setCaseDefinitionCache(Cache<String, CaseDefinitionEntity> caseDefinitionCache) {
        this.caseDefinitionCache = caseDefinitionCache;
    }

    public List<Deployer> getDeployers() {
        return this.deployers;
    }

    public void setDeployers(List<Deployer> deployers) {
        this.deployers = deployers;
    }

    public void removeDeployment(String deploymentId) {
        this.removeAllProcessDefinitionsByDeploymentId(deploymentId);
        this.removeAllCaseDefinitionsByDeploymentId(deploymentId);
        this.removeAllDecisionDefinitionsByDeploymentId(deploymentId);
        this.removeAllDecisionRequirementsDefinitionsByDeploymentId(deploymentId);
    }

    protected void removeAllProcessDefinitionsByDeploymentId(final String deploymentId) {
        CommandContext commandContext = Context.getCommandContext();
        List<ProcessDefinition> allDefinitionsForDeployment = commandContext.runWithoutAuthorization(new Callable<List<ProcessDefinition>>(){

            @Override
            public List<ProcessDefinition> call() throws Exception {
                return new ProcessDefinitionQueryImpl().deploymentId(deploymentId).list();
            }
        });
        for (ProcessDefinition processDefinition : allDefinitionsForDeployment) {
            try {
                this.removeProcessDefinition(processDefinition.getId());
            }
            catch (Exception e) {
                LOG.removeEntryFromDeploymentCacheFailure("process", processDefinition.getId(), e);
            }
        }
    }

    protected void removeAllCaseDefinitionsByDeploymentId(String deploymentId) {
        List allDefinitionsForDeployment = new CaseDefinitionQueryImpl().deploymentId(deploymentId).list();
        for (CaseDefinition caseDefinition : allDefinitionsForDeployment) {
            try {
                this.removeCaseDefinition(caseDefinition.getId());
            }
            catch (Exception e) {
                LOG.removeEntryFromDeploymentCacheFailure("case", caseDefinition.getId(), e);
            }
        }
    }

    protected void removeAllDecisionDefinitionsByDeploymentId(String deploymentId) {
        List allDefinitionsForDeployment = new DecisionDefinitionQueryImpl().deploymentId(deploymentId).list();
        for (DecisionDefinition decisionDefinition : allDefinitionsForDeployment) {
            try {
                this.removeDecisionDefinition(decisionDefinition.getId());
            }
            catch (Exception e) {
                LOG.removeEntryFromDeploymentCacheFailure("decision", decisionDefinition.getId(), e);
            }
        }
    }

    protected void removeAllDecisionRequirementsDefinitionsByDeploymentId(String deploymentId) {
        List allDefinitionsForDeployment = new DecisionRequirementsDefinitionQueryImpl().deploymentId(deploymentId).list();
        for (DecisionRequirementsDefinition decisionRequirementsDefinition : allDefinitionsForDeployment) {
            try {
                this.removeDecisionDefinition(decisionRequirementsDefinition.getId());
            }
            catch (Exception e) {
                LOG.removeEntryFromDeploymentCacheFailure("decision requirement", decisionRequirementsDefinition.getId(), e);
            }
        }
    }
}

