/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.List;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.batch.BatchStatistics;
import org.camunda.bpm.engine.history.HistoricDecisionInstanceStatistics;
import org.camunda.bpm.engine.impl.ActivityStatisticsQueryImpl;
import org.camunda.bpm.engine.impl.DeploymentStatisticsQueryImpl;
import org.camunda.bpm.engine.impl.HistoricDecisionInstanceStatisticsQueryImpl;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.ProcessDefinitionStatisticsQueryImpl;
import org.camunda.bpm.engine.impl.batch.BatchStatisticsQueryImpl;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionRequirementsDefinitionEntity;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.AbstractManager;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.management.ActivityStatistics;
import org.camunda.bpm.engine.management.DeploymentStatistics;
import org.camunda.bpm.engine.management.ProcessDefinitionStatistics;

public class StatisticsManager
extends AbstractManager {
    public List<ProcessDefinitionStatistics> getStatisticsGroupedByProcessDefinitionVersion(ProcessDefinitionStatisticsQueryImpl query, Page page) {
        this.configureQuery(query);
        return this.getDbEntityManager().selectList("selectProcessDefinitionStatistics", query, page);
    }

    public long getStatisticsCountGroupedByProcessDefinitionVersion(ProcessDefinitionStatisticsQueryImpl query) {
        this.configureQuery(query);
        return (Long)this.getDbEntityManager().selectOne("selectProcessDefinitionStatisticsCount", query);
    }

    public List<ActivityStatistics> getStatisticsGroupedByActivity(ActivityStatisticsQueryImpl query, Page page) {
        this.configureQuery(query);
        return this.getDbEntityManager().selectList("selectActivityStatistics", query, page);
    }

    public long getStatisticsCountGroupedByActivity(ActivityStatisticsQueryImpl query) {
        this.configureQuery(query);
        return (Long)this.getDbEntityManager().selectOne("selectActivityStatisticsCount", query);
    }

    public List<DeploymentStatistics> getStatisticsGroupedByDeployment(DeploymentStatisticsQueryImpl query, Page page) {
        this.configureQuery(query);
        return this.getDbEntityManager().selectList("selectDeploymentStatistics", query, page);
    }

    public long getStatisticsCountGroupedByDeployment(DeploymentStatisticsQueryImpl query) {
        this.configureQuery(query);
        return (Long)this.getDbEntityManager().selectOne("selectDeploymentStatisticsCount", query);
    }

    public List<BatchStatistics> getStatisticsGroupedByBatch(BatchStatisticsQueryImpl query, Page page) {
        this.configureQuery(query);
        return this.getDbEntityManager().selectList("selectBatchStatistics", query, page);
    }

    public long getStatisticsCountGroupedByBatch(BatchStatisticsQueryImpl query) {
        this.configureQuery(query);
        return (Long)this.getDbEntityManager().selectOne("selectBatchStatisticsCount", query);
    }

    protected void configureQuery(DeploymentStatisticsQueryImpl query) {
        this.getAuthorizationManager().configureDeploymentStatisticsQuery(query);
        this.getTenantManager().configureQuery(query);
    }

    protected void configureQuery(ProcessDefinitionStatisticsQueryImpl query) {
        this.getAuthorizationManager().configureProcessDefinitionStatisticsQuery(query);
        this.getTenantManager().configureQuery(query);
    }

    protected void configureQuery(ActivityStatisticsQueryImpl query) {
        this.checkReadProcessDefinition(query);
        this.getAuthorizationManager().configureActivityStatisticsQuery(query);
        this.getTenantManager().configureQuery(query);
    }

    protected void configureQuery(BatchStatisticsQueryImpl batchQuery) {
        this.getAuthorizationManager().configureBatchStatisticsQuery(batchQuery);
        this.getTenantManager().configureQuery(batchQuery);
    }

    protected void checkReadProcessDefinition(ActivityStatisticsQueryImpl query) {
        CommandContext commandContext = this.getCommandContext();
        if (this.isAuthorizationEnabled() && this.getCurrentAuthentication() != null && commandContext.isAuthorizationCheckEnabled()) {
            String processDefinitionId = query.getProcessDefinitionId();
            ProcessDefinitionEntity definition = this.getProcessDefinitionManager().findLatestProcessDefinitionById(processDefinitionId);
            EnsureUtil.ensureNotNull("no deployed process definition found with id '" + processDefinitionId + "'", "processDefinition", (Object)definition);
            this.getAuthorizationManager().checkAuthorization(Permissions.READ, Resources.PROCESS_DEFINITION, definition.getKey());
        }
    }

    public long getStatisticsCountGroupedByDecisionRequirementsDefinition(HistoricDecisionInstanceStatisticsQueryImpl decisionRequirementsDefinitionStatisticsQuery) {
        this.configureQuery(decisionRequirementsDefinitionStatisticsQuery);
        return (Long)this.getDbEntityManager().selectOne("selectDecisionDefinitionStatisticsCount", decisionRequirementsDefinitionStatisticsQuery);
    }

    protected void configureQuery(HistoricDecisionInstanceStatisticsQueryImpl decisionRequirementsDefinitionStatisticsQuery) {
        this.checkReadDecisionRequirementsDefinition(decisionRequirementsDefinitionStatisticsQuery);
        this.getTenantManager().configureQuery(decisionRequirementsDefinitionStatisticsQuery);
    }

    protected void checkReadDecisionRequirementsDefinition(HistoricDecisionInstanceStatisticsQueryImpl query) {
        CommandContext commandContext = this.getCommandContext();
        if (this.isAuthorizationEnabled() && this.getCurrentAuthentication() != null && commandContext.isAuthorizationCheckEnabled()) {
            String decisionRequirementsDefinitionId = query.getDecisionRequirementsDefinitionId();
            DecisionRequirementsDefinitionEntity definition = this.getDecisionDefinitionManager().findDecisionRequirementsDefinitionById(decisionRequirementsDefinitionId);
            EnsureUtil.ensureNotNull("no deployed decision requirements definition found with id '" + decisionRequirementsDefinitionId + "'", "decisionRequirementsDefinition", (Object)definition);
            this.getAuthorizationManager().checkAuthorization(Permissions.READ, Resources.DECISION_REQUIREMENTS_DEFINITION, definition.getKey());
        }
    }

    public List<HistoricDecisionInstanceStatistics> getStatisticsGroupedByDecisionRequirementsDefinition(HistoricDecisionInstanceStatisticsQueryImpl query, Page page) {
        this.configureQuery(query);
        return this.getDbEntityManager().selectList("selectDecisionDefinitionStatistics", query, page);
    }
}

