/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.cmmn;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.exception.NotAllowedException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.variable.Variables;

public class CaseServiceCaseTaskTest
extends PluggableProcessEngineTestCase {
    protected final String DEFINITION_KEY = "oneCaseTaskCase";
    protected final String DEFINITION_KEY_2 = "oneTaskCase";
    protected final String CASE_TASK_KEY = "PI_CaseTask_1";

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCaseWithManualActivation.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testManualStart() {
        this.createCaseInstance("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        CaseInstance subCaseInstance = this.queryCaseInstanceByKey("oneTaskCase");
        CaseServiceCaseTaskTest.assertNull((Object)subCaseInstance);
        this.caseService.withCaseExecution(caseTaskId).manualStart();
        subCaseInstance = this.queryCaseInstanceByKey("oneTaskCase");
        CaseServiceCaseTaskTest.assertNotNull((Object)subCaseInstance);
        CaseServiceCaseTaskTest.assertTrue((boolean)subCaseInstance.isActive());
        CaseExecution caseTask = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        CaseServiceCaseTaskTest.assertTrue((boolean)caseTask.isActive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCaseWithManualActivation.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testManualStartWithVariable() {
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        CaseInstance subCaseInstance = this.queryCaseInstanceByKey("oneTaskCase");
        CaseServiceCaseTaskTest.assertNull((Object)subCaseInstance);
        this.caseService.withCaseExecution(caseTaskId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).manualStart();
        subCaseInstance = this.queryCaseInstanceByKey("oneTaskCase");
        CaseServiceCaseTaskTest.assertNotNull((Object)subCaseInstance);
        CaseServiceCaseTaskTest.assertTrue((boolean)subCaseInstance.isActive());
        CaseExecution caseTask = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        CaseServiceCaseTaskTest.assertTrue((boolean)caseTask.isActive());
        List result = this.runtimeService.createVariableInstanceQuery().list();
        CaseServiceCaseTaskTest.assertFalse((boolean)result.isEmpty());
        CaseServiceCaseTaskTest.assertEquals((int)2, (int)result.size());
        this.verifyVariables(superCaseInstanceId, result);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCaseWithManualActivation.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testManualStartWithVariables() {
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        CaseInstance subCaseInstance = this.queryCaseInstanceByKey("oneTaskCase");
        CaseServiceCaseTaskTest.assertNull((Object)subCaseInstance);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "abc");
        variables.put("anotherVariableName", 999);
        this.caseService.withCaseExecution(caseTaskId).setVariables(variables).manualStart();
        subCaseInstance = this.queryCaseInstanceByKey("oneTaskCase");
        CaseServiceCaseTaskTest.assertNotNull((Object)subCaseInstance);
        CaseServiceCaseTaskTest.assertTrue((boolean)subCaseInstance.isActive());
        CaseExecution caseTask = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        CaseServiceCaseTaskTest.assertTrue((boolean)caseTask.isActive());
        List result = this.runtimeService.createVariableInstanceQuery().list();
        CaseServiceCaseTaskTest.assertFalse((boolean)result.isEmpty());
        CaseServiceCaseTaskTest.assertEquals((int)2, (int)result.size());
        this.verifyVariables(superCaseInstanceId, result);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testStart() {
        this.createCaseInstance("oneCaseTaskCase").getId();
        this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        CaseInstance subCaseInstance = this.queryCaseInstanceByKey("oneTaskCase");
        CaseServiceCaseTaskTest.assertNotNull((Object)subCaseInstance);
        CaseServiceCaseTaskTest.assertTrue((boolean)subCaseInstance.isActive());
        CaseExecution caseTask = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        CaseServiceCaseTaskTest.assertTrue((boolean)caseTask.isActive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testStartWithVariable() {
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase", (Map<String, Object>)Variables.createVariables().putValue("aVariableName", (Object)"abc").putValue("anotherVariableName", (Object)999)).getId();
        CaseInstance subCaseInstance = this.queryCaseInstanceByKey("oneTaskCase");
        CaseServiceCaseTaskTest.assertNotNull((Object)subCaseInstance);
        CaseServiceCaseTaskTest.assertTrue((boolean)subCaseInstance.isActive());
        CaseExecution caseTask = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        CaseServiceCaseTaskTest.assertTrue((boolean)caseTask.isActive());
        List result = this.runtimeService.createVariableInstanceQuery().list();
        CaseServiceCaseTaskTest.assertFalse((boolean)result.isEmpty());
        CaseServiceCaseTaskTest.assertEquals((int)2, (int)result.size());
        this.verifyVariables(superCaseInstanceId, result);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testStartWithVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "abc");
        variables.put("anotherVariableName", 999);
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase", variables).getId();
        CaseInstance subCaseInstance = this.queryCaseInstanceByKey("oneTaskCase");
        CaseServiceCaseTaskTest.assertNotNull((Object)subCaseInstance);
        CaseServiceCaseTaskTest.assertTrue((boolean)subCaseInstance.isActive());
        CaseExecution caseTask = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        CaseServiceCaseTaskTest.assertTrue((boolean)caseTask.isActive());
        List result = this.runtimeService.createVariableInstanceQuery().list();
        CaseServiceCaseTaskTest.assertFalse((boolean)result.isEmpty());
        CaseServiceCaseTaskTest.assertEquals((int)2, (int)result.size());
        this.verifyVariables(superCaseInstanceId, result);
    }

    protected void verifyVariables(String superCaseInstanceId, List<VariableInstance> result) {
        for (VariableInstance variable : result) {
            CaseServiceCaseTaskTest.assertEquals((String)superCaseInstanceId, (String)variable.getCaseExecutionId());
            CaseServiceCaseTaskTest.assertEquals((String)superCaseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceCaseTaskTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceCaseTaskTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceCaseTaskTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceCaseTaskTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseServiceCaseTaskTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCaseWithManualActivation.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testManualStartWithLocalVariable() {
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        CaseInstance subCaseInstance = this.queryCaseInstanceByKey("oneTaskCase");
        CaseServiceCaseTaskTest.assertNull((Object)subCaseInstance);
        this.caseService.withCaseExecution(caseTaskId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).manualStart();
        subCaseInstance = this.queryCaseInstanceByKey("oneTaskCase");
        CaseServiceCaseTaskTest.assertNotNull((Object)subCaseInstance);
        CaseServiceCaseTaskTest.assertTrue((boolean)subCaseInstance.isActive());
        CaseExecution caseTask = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        CaseServiceCaseTaskTest.assertTrue((boolean)caseTask.isActive());
        List result = this.runtimeService.createVariableInstanceQuery().list();
        CaseServiceCaseTaskTest.assertFalse((boolean)result.isEmpty());
        CaseServiceCaseTaskTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceCaseTaskTest.assertEquals((String)caseTaskId, (String)variable.getCaseExecutionId());
            CaseServiceCaseTaskTest.assertEquals((String)superCaseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceCaseTaskTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceCaseTaskTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceCaseTaskTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceCaseTaskTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseServiceCaseTaskTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCaseWithManualActivation.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testManualStartWithLocalVariables() {
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        CaseInstance subCaseInstance = this.queryCaseInstanceByKey("oneTaskCase");
        CaseServiceCaseTaskTest.assertNull((Object)subCaseInstance);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "abc");
        variables.put("anotherVariableName", 999);
        this.caseService.withCaseExecution(caseTaskId).setVariablesLocal(variables).manualStart();
        subCaseInstance = this.queryCaseInstanceByKey("oneTaskCase");
        CaseServiceCaseTaskTest.assertNotNull((Object)subCaseInstance);
        CaseServiceCaseTaskTest.assertTrue((boolean)subCaseInstance.isActive());
        CaseExecution caseTask = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        CaseServiceCaseTaskTest.assertTrue((boolean)caseTask.isActive());
        List result = this.runtimeService.createVariableInstanceQuery().list();
        CaseServiceCaseTaskTest.assertFalse((boolean)result.isEmpty());
        CaseServiceCaseTaskTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceCaseTaskTest.assertEquals((String)caseTaskId, (String)variable.getCaseExecutionId());
            CaseServiceCaseTaskTest.assertEquals((String)superCaseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceCaseTaskTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceCaseTaskTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceCaseTaskTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceCaseTaskTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseServiceCaseTaskTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCaseWithManualActivation.cmmn"})
    public void testReenableAnEnabledCaseTask() {
        this.createCaseInstance("oneCaseTaskCase");
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        CaseInstance subCaseInstance = this.queryCaseInstanceByKey("oneTaskCase");
        CaseServiceCaseTaskTest.assertNull((Object)subCaseInstance);
        try {
            this.caseService.withCaseExecution(caseTaskId).reenable();
            CaseServiceCaseTaskTest.fail((String)"It should not be possible to re-enable an enabled case task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskAndOneHumanTaskCaseWithManualActivation.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testReenableADisabledCaseTask() {
        this.createCaseInstance("oneCaseTaskCase");
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        CaseInstance subCaseInstance = this.queryCaseInstanceByKey("oneTaskCase");
        CaseServiceCaseTaskTest.assertNull((Object)subCaseInstance);
        this.caseService.withCaseExecution(caseTaskId).disable();
        this.caseService.withCaseExecution(caseTaskId).reenable();
        CaseExecution caseTask = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        CaseServiceCaseTaskTest.assertTrue((boolean)caseTask.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testReenableAnActiveCaseTask() {
        this.createCaseInstance("oneCaseTaskCase");
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        try {
            this.caseService.withCaseExecution(caseTaskId).reenable();
            CaseServiceCaseTaskTest.fail((String)"It should not be possible to re-enable an active case task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskAndOneHumanTaskCaseWithManualActivation.cmmn"})
    public void testDisableAnEnabledCaseTask() {
        this.createCaseInstance("oneCaseTaskCase");
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        CaseInstance subCaseInstance = this.queryCaseInstanceByKey("oneTaskCase");
        CaseServiceCaseTaskTest.assertNull((Object)subCaseInstance);
        this.caseService.withCaseExecution(caseTaskId).disable();
        CaseExecution caseTask = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        CaseServiceCaseTaskTest.assertTrue((boolean)caseTask.isDisabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskAndOneHumanTaskCaseWithManualActivation.cmmn"})
    public void testDisableADisabledCaseTask() {
        this.createCaseInstance("oneCaseTaskCase");
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        this.caseService.withCaseExecution(caseTaskId).disable();
        try {
            this.caseService.withCaseExecution(caseTaskId).disable();
            CaseServiceCaseTaskTest.fail((String)"It should not be possible to disable a already disabled case task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testDisableAnActiveCaseTask() {
        this.createCaseInstance("oneCaseTaskCase");
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        try {
            this.caseService.withCaseExecution(caseTaskId).disable();
            CaseServiceCaseTaskTest.fail((String)"It should not be possible to disable an active case task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskAndOneHumanTaskCaseWithManualActivation.cmmn"})
    public void testManualStartOfADisabledCaseTask() {
        this.createCaseInstance("oneCaseTaskCase");
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        this.caseService.withCaseExecution(caseTaskId).disable();
        try {
            this.caseService.withCaseExecution(caseTaskId).manualStart();
            CaseServiceCaseTaskTest.fail((String)"It should not be possible to start a disabled case task manually.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testManualStartOfAnActiveCaseTask() {
        this.createCaseInstance("oneCaseTaskCase");
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        try {
            this.caseService.withCaseExecution(caseTaskId).manualStart();
            CaseServiceCaseTaskTest.fail((String)"It should not be possible to start an already active case task manually.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testComplete() {
        this.createCaseInstance("oneCaseTaskCase");
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        try {
            this.caseService.withCaseExecution(caseTaskId).complete();
            CaseServiceCaseTaskTest.fail((String)"It should not be possible to complete a case task, while the process instance is still running.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCloseCaseInstanceShouldCompleteCaseTask() {
        this.createCaseInstance("oneCaseTaskCase");
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.caseService.withCaseExecution(humanTaskId).complete();
        CaseInstance subCaseInstance = this.queryCaseInstanceByKey("oneTaskCase");
        CaseServiceCaseTaskTest.assertTrue((boolean)subCaseInstance.isCompleted());
        this.caseService.withCaseExecution(subCaseInstance.getId()).close();
        CaseExecution caseTask = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        CaseServiceCaseTaskTest.assertNull((Object)caseTask);
        CaseInstance superCaseInstance = this.queryCaseInstanceByKey("oneCaseTaskCase");
        CaseServiceCaseTaskTest.assertNotNull((Object)superCaseInstance);
        CaseServiceCaseTaskTest.assertTrue((boolean)superCaseInstance.isCompleted());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCaseWithManualActivation.cmmn"})
    public void testDisableShouldCompleteCaseInstance() {
        this.createCaseInstance("oneCaseTaskCase");
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        this.caseService.withCaseExecution(caseTaskId).disable();
        CaseExecution caseTask = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        CaseInstance superCaseInstance = this.queryCaseInstanceByKey("oneCaseTaskCase");
        CaseServiceCaseTaskTest.assertNotNull((Object)superCaseInstance);
        CaseServiceCaseTaskTest.assertTrue((boolean)superCaseInstance.isCompleted());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCaseWithManualActivation.cmmn"})
    public void testCompleteAnEnabledCaseTask() {
        this.createCaseInstance("oneCaseTaskCase");
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        try {
            this.caseService.withCaseExecution(caseTaskId).complete();
            CaseServiceCaseTaskTest.fail((String)"Should not be able to complete an enabled case task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskAndOneHumanTaskCaseWithManualActivation.cmmn"})
    public void testCompleteADisabledCaseTask() {
        this.createCaseInstance("oneCaseTaskCase");
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        this.caseService.withCaseExecution(caseTaskId).disable();
        try {
            this.caseService.withCaseExecution(caseTaskId).complete();
            CaseServiceCaseTaskTest.fail((String)"Should not be able to complete a disabled case task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCaseWithManualActivation.cmmn"})
    public void testClose() {
        this.createCaseInstance("oneCaseTaskCase");
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        try {
            this.caseService.withCaseExecution(caseTaskId).close();
            CaseServiceCaseTaskTest.fail((String)"It should not be possible to close a case task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testTerminate() {
        this.createCaseInstance("oneCaseTaskCase");
        CaseExecution caseTaskExecution = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        this.caseService.withCaseExecution(caseTaskExecution.getId()).terminate();
        caseTaskExecution = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        CaseServiceCaseTaskTest.assertNull((Object)caseTaskExecution);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testTerminateNonFluent() {
        this.createCaseInstance("oneCaseTaskCase");
        CaseExecution caseTaskExecution = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        this.caseService.terminateCaseExecution(caseTaskExecution.getId());
        caseTaskExecution = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        CaseServiceCaseTaskTest.assertNull((Object)caseTaskExecution);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCaseWithManualActivation.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testTerminateNonActiveCaseTask() {
        this.createCaseInstance("oneCaseTaskCase");
        CaseExecution caseTaskExecution = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        try {
            this.caseService.terminateCaseExecution(caseTaskExecution.getId());
            CaseServiceCaseTaskTest.fail((String)"It should not be possible to terminate a case task.");
        }
        catch (NotAllowedException e) {
            boolean result = e.getMessage().contains("The case execution must be in state 'active' to terminate");
            CaseServiceCaseTaskTest.assertTrue((boolean)result);
        }
    }

    protected CaseInstance createCaseInstance(String caseDefinitionKey) {
        return this.caseService.withCaseDefinitionByKey(caseDefinitionKey).create();
    }

    protected CaseInstance createCaseInstance(String caseDefinitionKey, Map<String, Object> variables) {
        return this.caseService.withCaseDefinitionByKey(caseDefinitionKey).setVariables(variables).create();
    }

    protected CaseExecution queryCaseExecutionByActivityId(String activityId) {
        return (CaseExecution)this.caseService.createCaseExecutionQuery().activityId(activityId).singleResult();
    }

    protected CaseInstance queryCaseInstanceByKey(String caseDefinitionKey) {
        return (CaseInstance)this.caseService.createCaseInstanceQuery().caseDefinitionKey(caseDefinitionKey).singleResult();
    }

    protected Task queryTask() {
        return (Task)this.taskService.createTaskQuery().singleResult();
    }
}

