/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import java.util.Collection;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.AbstractActivityBuilder;
import org.camunda.bpm.model.bpmn.builder.AbstractBaseElementBuilder;
import org.camunda.bpm.model.bpmn.builder.AbstractFlowNodeBuilder;
import org.camunda.bpm.model.bpmn.builder.CallActivityBuilder;
import org.camunda.bpm.model.bpmn.builder.EndEventBuilder;
import org.camunda.bpm.model.bpmn.builder.IntermediateCatchEventBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.builder.SubProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.camunda.bpm.model.bpmn.instance.Activity;
import org.camunda.bpm.model.bpmn.instance.Association;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.camunda.bpm.model.bpmn.instance.BpmnModelElementInstance;
import org.camunda.bpm.model.bpmn.instance.Definitions;
import org.camunda.bpm.model.bpmn.instance.Documentation;
import org.camunda.bpm.model.bpmn.instance.FlowElement;
import org.camunda.bpm.model.bpmn.instance.FlowNode;
import org.camunda.bpm.model.bpmn.instance.Message;
import org.camunda.bpm.model.bpmn.instance.MultiInstanceLoopCharacteristics;
import org.camunda.bpm.model.bpmn.instance.Process;
import org.camunda.bpm.model.bpmn.instance.SequenceFlow;
import org.camunda.bpm.model.bpmn.instance.Signal;
import org.camunda.bpm.model.bpmn.instance.SubProcess;
import org.camunda.bpm.model.xml.Model;
import org.camunda.bpm.model.xml.instance.DomDocument;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.type.ModelElementType;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResults;

public class ModifiableBpmnModelInstance
implements BpmnModelInstance {
    protected BpmnModelInstance modelInstance;

    public ModifiableBpmnModelInstance(BpmnModelInstance modelInstance) {
        this.modelInstance = modelInstance;
    }

    public static ModifiableBpmnModelInstance modify(BpmnModelInstance modelInstance) {
        return new ModifiableBpmnModelInstance(modelInstance.clone());
    }

    public static ModifiableBpmnModelInstance wrap(BpmnModelInstance modelInstance) {
        return new ModifiableBpmnModelInstance(modelInstance);
    }

    public Definitions getDefinitions() {
        return this.modelInstance.getDefinitions();
    }

    public void setDefinitions(Definitions definitions) {
        this.modelInstance.setDefinitions(definitions);
    }

    public BpmnModelInstance clone() {
        return this.modelInstance.clone();
    }

    public DomDocument getDocument() {
        return this.modelInstance.getDocument();
    }

    public ModelElementInstance getDocumentElement() {
        return this.modelInstance.getDocumentElement();
    }

    public void setDocumentElement(ModelElementInstance documentElement) {
        this.modelInstance.setDocumentElement(documentElement);
    }

    public <T extends ModelElementInstance> T newInstance(Class<T> type) {
        return (T)this.modelInstance.newInstance(type);
    }

    public <T extends ModelElementInstance> T newInstance(ModelElementType type) {
        return (T)this.modelInstance.newInstance(type);
    }

    public Model getModel() {
        return this.modelInstance.getModel();
    }

    public <T extends ModelElementInstance> T getModelElementById(String id) {
        return (T)this.modelInstance.getModelElementById(id);
    }

    public Collection<ModelElementInstance> getModelElementsByType(ModelElementType referencingType) {
        return this.modelInstance.getModelElementsByType(referencingType);
    }

    public <T extends ModelElementInstance> Collection<T> getModelElementsByType(Class<T> referencingClass) {
        return this.modelInstance.getModelElementsByType(referencingClass);
    }

    public <T extends AbstractBaseElementBuilder> T getBuilderForElementById(String id, Class<T> builderClass) {
        BaseElement modelElementById = (BaseElement)this.modelInstance.getModelElementById(id);
        return (T)modelElementById.builder();
    }

    public AbstractActivityBuilder activityBuilder(String activityId) {
        return this.getBuilderForElementById(activityId, AbstractActivityBuilder.class);
    }

    public AbstractFlowNodeBuilder flowNodeBuilder(String flowNodeId) {
        return this.getBuilderForElementById(flowNodeId, AbstractFlowNodeBuilder.class);
    }

    public UserTaskBuilder userTaskBuilder(String userTaskId) {
        return this.getBuilderForElementById(userTaskId, UserTaskBuilder.class);
    }

    public ServiceTaskBuilder serviceTaskBuilder(String serviceTaskId) {
        return this.getBuilderForElementById(serviceTaskId, ServiceTaskBuilder.class);
    }

    public CallActivityBuilder callActivityBuilder(String callActivityId) {
        return this.getBuilderForElementById(callActivityId, CallActivityBuilder.class);
    }

    public IntermediateCatchEventBuilder intermediateCatchEventBuilder(String eventId) {
        return this.getBuilderForElementById(eventId, IntermediateCatchEventBuilder.class);
    }

    public StartEventBuilder startEventBuilder(String eventId) {
        return this.getBuilderForElementById(eventId, StartEventBuilder.class);
    }

    public EndEventBuilder endEventBuilder(String eventId) {
        return this.getBuilderForElementById(eventId, EndEventBuilder.class);
    }

    public ModifiableBpmnModelInstance changeElementId(String oldId, String newId) {
        BaseElement element = (BaseElement)this.getModelElementById(oldId);
        element.setId(newId);
        return this;
    }

    public ModifiableBpmnModelInstance changeElementName(String elementId, String newName) {
        FlowElement flowElement = (FlowElement)this.getModelElementById(elementId);
        flowElement.setName(newName);
        return this;
    }

    public ModifiableBpmnModelInstance removeChildren(String elementId) {
        BaseElement element = (BaseElement)this.getModelElementById(elementId);
        Collection children = element.getChildElementsByType(BaseElement.class);
        for (BaseElement child : children) {
            element.removeChildElement((ModelElementInstance)child);
        }
        return this;
    }

    public ModifiableBpmnModelInstance renameMessage(String oldMessageName, String newMessageName) {
        Collection messages = this.modelInstance.getModelElementsByType(Message.class);
        for (Message message : messages) {
            if (!message.getName().equals(oldMessageName)) continue;
            message.setName(newMessageName);
        }
        return this;
    }

    public ModifiableBpmnModelInstance addDocumentation(String content) {
        Collection processes = this.modelInstance.getModelElementsByType(Process.class);
        Documentation documentation = (Documentation)this.modelInstance.newInstance(Documentation.class);
        documentation.setTextContent(content);
        for (Process process : processes) {
            process.addChildElement((ModelElementInstance)documentation);
        }
        return this;
    }

    public ModifiableBpmnModelInstance renameSignal(String oldSignalName, String newSignalName) {
        Collection signals = this.modelInstance.getModelElementsByType(Signal.class);
        for (Signal signal : signals) {
            if (!signal.getName().equals(oldSignalName)) continue;
            signal.setName(newSignalName);
        }
        return this;
    }

    public ModifiableBpmnModelInstance swapElementIds(String firstElementId, String secondElementId) {
        BaseElement firstElement = (BaseElement)this.getModelElementById(firstElementId);
        BaseElement secondElement = (BaseElement)this.getModelElementById(secondElementId);
        secondElement.setId("___TEMP___ID___");
        firstElement.setId(secondElementId);
        secondElement.setId(firstElementId);
        return this;
    }

    public SubProcessBuilder addSubProcessTo(String parentId) {
        SubProcess eventSubProcess = (SubProcess)this.modelInstance.newInstance(SubProcess.class);
        BpmnModelElementInstance parent = (BpmnModelElementInstance)this.getModelElementById(parentId);
        parent.addChildElement((ModelElementInstance)eventSubProcess);
        return eventSubProcess.builder();
    }

    public ModifiableBpmnModelInstance removeFlowNode(String flowNodeId) {
        FlowNode flowNode = (FlowNode)this.getModelElementById(flowNodeId);
        ModelElementInstance scope = flowNode.getParentElement();
        for (SequenceFlow outgoingFlow : flowNode.getOutgoing()) {
            scope.removeChildElement((ModelElementInstance)outgoingFlow);
        }
        for (SequenceFlow incomingFlow : flowNode.getIncoming()) {
            scope.removeChildElement((ModelElementInstance)incomingFlow);
        }
        Collection associations = scope.getChildElementsByType(Association.class);
        for (Association association : associations) {
            if (!flowNode.equals(association.getSource()) && !flowNode.equals(association.getTarget())) continue;
            scope.removeChildElement((ModelElementInstance)association);
        }
        scope.removeChildElement((ModelElementInstance)flowNode);
        return this;
    }

    public ModifiableBpmnModelInstance asyncBeforeInnerMiActivity(String activityId) {
        Activity activity = (Activity)this.modelInstance.getModelElementById(activityId);
        MultiInstanceLoopCharacteristics miCharacteristics = (MultiInstanceLoopCharacteristics)activity.getUniqueChildElementByType(MultiInstanceLoopCharacteristics.class);
        miCharacteristics.setCamundaAsyncBefore(true);
        return this;
    }

    public ModifiableBpmnModelInstance asyncAfterInnerMiActivity(String activityId) {
        Activity activity = (Activity)this.modelInstance.getModelElementById(activityId);
        MultiInstanceLoopCharacteristics miCharacteristics = (MultiInstanceLoopCharacteristics)activity.getUniqueChildElementByType(MultiInstanceLoopCharacteristics.class);
        miCharacteristics.setCamundaAsyncAfter(true);
        return this;
    }

    public ValidationResults validate(Collection<ModelElementValidator<?>> validators) {
        return null;
    }
}

