/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.List;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstanceQuery;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.HistoricVariableInstanceQueryProperty;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.QueryOperator;
import org.camunda.bpm.engine.impl.QueryVariableValue;
import org.camunda.bpm.engine.impl.cmd.CommandLogger;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.impl.variable.serializer.AbstractTypedValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.VariableSerializers;

public class HistoricVariableInstanceQueryImpl
extends AbstractQuery<HistoricVariableInstanceQuery, HistoricVariableInstance>
implements HistoricVariableInstanceQuery {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    private static final long serialVersionUID = 1L;
    protected String variableId;
    protected String processInstanceId;
    protected String caseInstanceId;
    protected String variableName;
    protected String variableNameLike;
    protected QueryVariableValue queryVariableValue;
    protected String[] taskIds;
    protected String[] executionIds;
    protected String[] caseExecutionIds;
    protected String[] caseActivityIds;
    protected String[] activityInstanceIds;
    protected String[] tenantIds;
    protected String[] processInstanceIds;
    protected boolean isByteArrayFetchingEnabled = true;
    protected boolean isCustomObjectDeserializationEnabled = true;

    public HistoricVariableInstanceQueryImpl() {
    }

    public HistoricVariableInstanceQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public HistoricVariableInstanceQuery variableId(String id) {
        EnsureUtil.ensureNotNull("variableId", (Object)id);
        this.variableId = id;
        return this;
    }

    @Override
    public HistoricVariableInstanceQueryImpl processInstanceId(String processInstanceId) {
        EnsureUtil.ensureNotNull("processInstanceId", (Object)processInstanceId);
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public HistoricVariableInstanceQuery caseInstanceId(String caseInstanceId) {
        EnsureUtil.ensureNotNull("caseInstanceId", (Object)caseInstanceId);
        this.caseInstanceId = caseInstanceId;
        return this;
    }

    @Override
    public HistoricVariableInstanceQuery processInstanceIdIn(String ... processInstanceIds) {
        EnsureUtil.ensureNotNull("Process Instance Ids", processInstanceIds);
        this.processInstanceIds = processInstanceIds;
        return this;
    }

    @Override
    public HistoricVariableInstanceQuery taskIdIn(String ... taskIds) {
        EnsureUtil.ensureNotNull("Task Ids", taskIds);
        this.taskIds = taskIds;
        return this;
    }

    @Override
    public HistoricVariableInstanceQuery executionIdIn(String ... executionIds) {
        EnsureUtil.ensureNotNull("Execution Ids", executionIds);
        this.executionIds = executionIds;
        return this;
    }

    @Override
    public HistoricVariableInstanceQuery caseExecutionIdIn(String ... caseExecutionIds) {
        EnsureUtil.ensureNotNull("Case execution ids", caseExecutionIds);
        this.caseExecutionIds = caseExecutionIds;
        return this;
    }

    @Override
    public HistoricVariableInstanceQuery caseActivityIdIn(String ... caseActivityIds) {
        EnsureUtil.ensureNotNull("Case activity ids", caseActivityIds);
        this.caseActivityIds = caseActivityIds;
        return this;
    }

    @Override
    public HistoricVariableInstanceQuery activityInstanceIdIn(String ... activityInstanceIds) {
        EnsureUtil.ensureNotNull("Activity Instance Ids", activityInstanceIds);
        this.activityInstanceIds = activityInstanceIds;
        return this;
    }

    @Override
    public HistoricVariableInstanceQuery variableName(String variableName) {
        EnsureUtil.ensureNotNull("variableName", (Object)variableName);
        this.variableName = variableName;
        return this;
    }

    @Override
    public HistoricVariableInstanceQuery variableValueEquals(String variableName, Object variableValue) {
        EnsureUtil.ensureNotNull("variableName", (Object)variableName);
        EnsureUtil.ensureNotNull("variableValue", variableValue);
        this.variableName = variableName;
        this.queryVariableValue = new QueryVariableValue(variableName, variableValue, QueryOperator.EQUALS, true);
        return this;
    }

    @Override
    public HistoricVariableInstanceQuery variableNameLike(String variableNameLike) {
        EnsureUtil.ensureNotNull("variableNameLike", (Object)variableNameLike);
        this.variableNameLike = variableNameLike;
        return this;
    }

    protected void ensureVariablesInitialized() {
        if (this.queryVariableValue != null) {
            VariableSerializers variableSerializers = Context.getProcessEngineConfiguration().getVariableSerializers();
            this.queryVariableValue.initialize(variableSerializers);
        }
    }

    @Override
    public HistoricVariableInstanceQuery disableBinaryFetching() {
        this.isByteArrayFetchingEnabled = false;
        return this;
    }

    @Override
    public HistoricVariableInstanceQuery disableCustomObjectDeserialization() {
        this.isCustomObjectDeserializationEnabled = false;
        return this;
    }

    @Override
    public HistoricVariableInstanceQuery tenantIdIn(String ... tenantIds) {
        EnsureUtil.ensureNotNull("tenantIds", tenantIds);
        this.tenantIds = tenantIds;
        return this;
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        this.ensureVariablesInitialized();
        return commandContext.getHistoricVariableInstanceManager().findHistoricVariableInstanceCountByQueryCriteria(this);
    }

    @Override
    public List<HistoricVariableInstance> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        this.ensureVariablesInitialized();
        List<HistoricVariableInstance> historicVariableInstances = commandContext.getHistoricVariableInstanceManager().findHistoricVariableInstancesByQueryCriteria(this, page);
        if (historicVariableInstances != null) {
            for (HistoricVariableInstance historicVariableInstance : historicVariableInstances) {
                HistoricVariableInstanceEntity variableInstanceEntity = (HistoricVariableInstanceEntity)historicVariableInstance;
                if (!this.shouldFetchValue(variableInstanceEntity)) continue;
                try {
                    variableInstanceEntity.getTypedValue(this.isCustomObjectDeserializationEnabled);
                }
                catch (Exception t) {
                    LOG.exceptionWhileGettingValueForVariable(t);
                }
            }
        }
        return historicVariableInstances;
    }

    protected boolean shouldFetchValue(HistoricVariableInstanceEntity entity) {
        return this.isByteArrayFetchingEnabled || !AbstractTypedValueSerializer.BINARY_VALUE_TYPES.contains(entity.getSerializer().getType().getName());
    }

    @Override
    public HistoricVariableInstanceQuery orderByProcessInstanceId() {
        this.orderBy(HistoricVariableInstanceQueryProperty.PROCESS_INSTANCE_ID);
        return this;
    }

    @Override
    public HistoricVariableInstanceQuery orderByVariableName() {
        this.orderBy(HistoricVariableInstanceQueryProperty.VARIABLE_NAME);
        return this;
    }

    @Override
    public HistoricVariableInstanceQuery orderByTenantId() {
        this.orderBy(HistoricVariableInstanceQueryProperty.TENANT_ID);
        return this;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public String[] getActivityInstanceIds() {
        return this.activityInstanceIds;
    }

    public String[] getProcessInstanceIds() {
        return this.processInstanceIds;
    }

    public String[] getTaskIds() {
        return this.taskIds;
    }

    public String[] getExecutionIds() {
        return this.executionIds;
    }

    public String[] getCaseExecutionIds() {
        return this.caseExecutionIds;
    }

    public String[] getCaseActivityIds() {
        return this.caseActivityIds;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String getVariableNameLike() {
        return this.variableNameLike;
    }

    public QueryVariableValue getQueryVariableValue() {
        return this.queryVariableValue;
    }
}

