/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.batch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.authorization.batch.AbstractBatchAuthorizationTest;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationScenarioWithCount;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationSpec;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@RequiredHistoryLevel(value="audit")
public class DeleteHistoricProcessInstancesBatchAuthorizationTest
extends AbstractBatchAuthorizationTest {
    protected static final long BATCH_OPERATIONS = 4L;
    @Rule
    public RuleChain ruleChain;
    @Parameterized.Parameter
    public AuthorizationScenarioWithCount scenario;
    protected HistoryService historyService;

    public DeleteHistoricProcessInstancesBatchAuthorizationTest() {
        this.ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule).around((TestRule)this.testHelper);
    }

    @Before
    public void setupHistoricService() {
        this.historyService = this.engineRule.getHistoryService();
    }

    @Override
    public void cleanBatch() {
        super.cleanBatch();
        List list = this.historyService.createHistoricProcessInstanceQuery().list();
        if (list.size() > 0) {
            ArrayList<String> instances = new ArrayList<String>();
            for (HistoricProcessInstance hpi : list) {
                instances.add(hpi.getId());
            }
            this.historyService.deleteHistoricProcessInstances(instances);
        }
    }

    @Parameterized.Parameters(name="Scenario {index}")
    public static Collection<AuthorizationScenario[]> scenarios() {
        return AuthorizationTestRule.asParameters(AuthorizationScenarioWithCount.scenario().withCount(2L).withAuthorizations(AuthorizationSpec.grant((Resource)Resources.BATCH, "*", "userId", new Permission[]{Permissions.CREATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "Process_1", "userId", new Permission[]{Permissions.READ_HISTORY, Permissions.DELETE_HISTORY}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "Process_2", "userId", new Permission[]{Permissions.READ_HISTORY})).failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "Process_2", "userId", new Permission[]{Permissions.DELETE_HISTORY})), AuthorizationScenarioWithCount.scenario().withCount(0L).withAuthorizations(AuthorizationSpec.grant((Resource)Resources.BATCH, "*", "userId", new Permission[]{Permissions.CREATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "Process_1", "userId", new Permission[]{Permissions.READ_HISTORY, Permissions.DELETE_HISTORY}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "Process_2", "userId", new Permission[]{Permissions.READ_HISTORY, Permissions.DELETE_HISTORY})).succeeds());
    }

    @Test
    public void testWithTwoInvocationsProcessInstancesList() {
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJob(2);
        this.setupAndExecuteHistoricProcessInstancesListTest();
        this.assertScenario();
        Assert.assertThat((Object)this.historyService.createHistoricProcessInstanceQuery().count(), (Matcher)Is.is((Object)this.getScenario().getCount()));
    }

    @Test
    public void testProcessInstancesList() {
        this.setupAndExecuteHistoricProcessInstancesListTest();
        this.assertScenario();
    }

    protected void setupAndExecuteHistoricProcessInstancesListTest() {
        List<String> processInstanceIds = Arrays.asList(this.processInstance.getId(), this.processInstance2.getId());
        this.runtimeService.deleteProcessInstances(processInstanceIds, null, true, false);
        ArrayList<String> historicProcessInstances = new ArrayList<String>();
        for (HistoricProcessInstance hpi : this.historyService.createHistoricProcessInstanceQuery().list()) {
            historicProcessInstances.add(hpi.getId());
        }
        this.authRule.init(this.scenario).withUser("userId").bindResource("Process_1", this.sourceDefinition.getKey()).bindResource("Process_2", this.sourceDefinition2.getKey()).start();
        this.batch = this.historyService.deleteHistoricProcessInstancesAsync(historicProcessInstances, "test reason");
        this.executeSeedAndBatchJobs();
    }

    @Override
    public AuthorizationScenarioWithCount getScenario() {
        return this.scenario;
    }

    protected void assertScenario() {
        if (this.authRule.assertScenario(this.getScenario())) {
            if (this.testHelper.isHistoryLevelFull()) {
                Assert.assertThat((Object)this.engineRule.getHistoryService().createUserOperationLogQuery().count(), (Matcher)Is.is((Object)4L));
            }
            Assert.assertThat((Object)this.historyService.createHistoricProcessInstanceQuery().count(), (Matcher)Is.is((Object)0L));
        }
    }
}

