/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.externaltask;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.externaltask.ExternalTaskQuery;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class SetExternalTasksRetriesTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);
    private static String PROCESS_DEFINITION_KEY = "oneExternalTaskProcess";
    private static String PROCESS_DEFINITION_KEY_2 = "twoExternalTaskWithPriorityProcess";
    protected RuntimeService runtimeService;
    protected RepositoryService repositoryService;
    protected ManagementService managementService;
    protected ExternalTaskService externalTaskService;
    protected List<String> processInstanceIds;

    @Before
    public void initServices() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.externalTaskService = this.engineRule.getExternalTaskService();
        this.managementService = this.engineRule.getManagementService();
    }

    @Before
    public void deployTestProcesses() throws Exception {
        Deployment deployment = this.engineRule.getRepositoryService().createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/test/api/externaltask/externalTaskPriorityExpression.bpmn20.xml").deploy();
        this.engineRule.manageDeployment(deployment);
        RuntimeService runtimeService = this.engineRule.getRuntimeService();
        this.processInstanceIds = new ArrayList<String>();
        for (int i = 0; i < 4; ++i) {
            this.processInstanceIds.add(runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY, i + "").getId());
        }
        this.processInstanceIds.add(runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY_2).getId());
    }

    @After
    public void cleanBatch() {
        HistoricBatch historicBatch;
        Batch batch = (Batch)this.managementService.createBatchQuery().singleResult();
        if (batch != null) {
            this.managementService.deleteBatch(batch.getId(), true);
        }
        if ((historicBatch = (HistoricBatch)this.engineRule.getHistoryService().createHistoricBatchQuery().singleResult()) != null) {
            this.engineRule.getHistoryService().deleteHistoricBatch(historicBatch.getId());
        }
    }

    @Test
    public void shouldSetExternalTaskRetriesSync() {
        List externalTasks = this.externalTaskService.createExternalTaskQuery().list();
        ArrayList<String> externalTaskIds = new ArrayList<String>();
        for (ExternalTask task : externalTasks) {
            externalTaskIds.add(task.getId());
        }
        this.externalTaskService.setRetries(externalTaskIds, 10);
        externalTasks = this.externalTaskService.createExternalTaskQuery().list();
        for (ExternalTask task : externalTasks) {
            Assert.assertEquals((long)10L, (long)task.getRetries().intValue());
        }
    }

    @Test
    public void shouldFailForNonExistingExternalTaskIdSync() {
        List externalTasks = this.externalTaskService.createExternalTaskQuery().list();
        ArrayList<String> externalTaskIds = new ArrayList<String>();
        for (ExternalTask task : externalTasks) {
            externalTaskIds.add(task.getId());
        }
        externalTaskIds.add("nonExistingExternalTaskId");
        try {
            this.externalTaskService.setRetries(externalTaskIds, 10);
            Assert.fail((String)"exception expected");
        }
        catch (NotFoundException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot find external task with id nonExistingExternalTaskId"));
        }
    }

    @Test
    public void shouldFailForNullExternalTaskIdSync() {
        List externalTasks = this.externalTaskService.createExternalTaskQuery().list();
        ArrayList<String> externalTaskIds = new ArrayList<String>();
        for (ExternalTask task : externalTasks) {
            externalTaskIds.add(task.getId());
        }
        externalTaskIds.add(null);
        try {
            this.externalTaskService.setRetries(externalTaskIds, 10);
            Assert.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"External task id cannot be null"));
        }
    }

    @Test
    public void shouldFailForNullExternalTaskIdsSync() {
        try {
            this.externalTaskService.setRetries((List)null, 10);
            Assert.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"externalTaskIds is empty"));
        }
    }

    @Test
    public void shouldFailForNonExistingExternalTaskIdAsync() {
        List externalTasks = this.externalTaskService.createExternalTaskQuery().list();
        ArrayList<String> externalTaskIds = new ArrayList<String>();
        for (ExternalTask task : externalTasks) {
            externalTaskIds.add(task.getId());
        }
        externalTaskIds.add("nonExistingExternalTaskId");
        Batch batch = this.externalTaskService.setRetriesAsync(externalTaskIds, null, 10);
        try {
            this.executeSeedAndBatchJobs(batch);
            Assert.fail((String)"exception expected");
        }
        catch (NotFoundException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot find external task with id nonExistingExternalTaskId"));
        }
    }

    @Test
    public void shouldFailForNullExternalTaskIdAsync() {
        List externalTasks = this.externalTaskService.createExternalTaskQuery().list();
        ArrayList<String> externalTaskIds = new ArrayList<String>();
        for (ExternalTask task : externalTasks) {
            externalTaskIds.add(task.getId());
        }
        externalTaskIds.add(null);
        Batch batch = null;
        try {
            batch = this.externalTaskService.setRetriesAsync(externalTaskIds, null, 10);
            this.executeSeedAndBatchJobs(batch);
            Assert.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"External task id cannot be null"));
        }
    }

    @Test
    public void shouldFailForNullExternalTaskIdsAsync() {
        try {
            this.externalTaskService.setRetriesAsync((List)null, null, 10);
            Assert.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"externalTaskIds is empty"));
        }
    }

    @Test
    public void shouldFailForNegativeRetriesSync() {
        List<String> externalTaskIds = Arrays.asList("externalTaskId");
        try {
            this.externalTaskService.setRetries(externalTaskIds, -10);
            Assert.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"The number of retries cannot be negative"));
        }
    }

    @Test
    public void shouldFailForNegativeRetriesAsync() {
        List<String> externalTaskIds = Arrays.asList("externalTaskId");
        try {
            Batch batch = this.externalTaskService.setRetriesAsync(externalTaskIds, null, -10);
            this.executeSeedAndBatchJobs(batch);
            Assert.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"The number of retries cannot be negative"));
        }
    }

    @Test
    public void shouldSetExternalTaskRetriesWithQueryAsync() {
        ExternalTaskQuery externalTaskQuery = this.engineRule.getExternalTaskService().createExternalTaskQuery();
        Batch batch = this.externalTaskService.setRetriesAsync(null, externalTaskQuery, 5);
        this.executeSeedAndBatchJobs(batch);
        for (ExternalTask task : externalTaskQuery.list()) {
            Assert.assertEquals((long)5L, (long)task.getRetries().intValue());
        }
    }

    @Test
    public void shouldSetExternalTaskRetriesWithListAsync() {
        List externalTasks = this.externalTaskService.createExternalTaskQuery().list();
        ArrayList<String> externalTaskIds = new ArrayList<String>();
        for (ExternalTask task : externalTasks) {
            externalTaskIds.add(task.getId());
        }
        Batch batch = this.externalTaskService.setRetriesAsync(externalTaskIds, null, 5);
        this.executeSeedAndBatchJobs(batch);
        externalTasks = this.externalTaskService.createExternalTaskQuery().list();
        for (ExternalTask task : externalTasks) {
            Assert.assertEquals((long)5L, (long)task.getRetries().intValue());
        }
    }

    @Test
    public void shouldSetExternalTaskRetriesWithListAndQueryAsync() {
        ExternalTaskQuery externalTaskQuery = this.externalTaskService.createExternalTaskQuery();
        List externalTasks = externalTaskQuery.list();
        ArrayList<String> externalTaskIds = new ArrayList<String>();
        for (ExternalTask task : externalTasks) {
            externalTaskIds.add(task.getId());
        }
        Batch batch = this.externalTaskService.setRetriesAsync(externalTaskIds, externalTaskQuery, 5);
        this.executeSeedAndBatchJobs(batch);
        externalTasks = this.externalTaskService.createExternalTaskQuery().list();
        for (ExternalTask task : externalTasks) {
            Assert.assertEquals((long)5L, (long)task.getRetries().intValue());
        }
    }

    @Test
    public void shouldSetExternalTaskRetriesWithDifferentListAndQueryAsync() {
        ExternalTask task2;
        ExternalTaskQuery externalTaskQuery = this.externalTaskService.createExternalTaskQuery().processInstanceId(this.processInstanceIds.get(0));
        List externalTasks = this.externalTaskService.createExternalTaskQuery().processInstanceId(this.processInstanceIds.get(this.processInstanceIds.size() - 1)).list();
        ArrayList<String> externalTaskIds = new ArrayList<String>();
        for (ExternalTask task2 : externalTasks) {
            externalTaskIds.add(task2.getId());
        }
        Batch batch = this.externalTaskService.setRetriesAsync(externalTaskIds, externalTaskQuery, 8);
        this.executeSeedAndBatchJobs(batch);
        task2 = (ExternalTask)this.externalTaskService.createExternalTaskQuery().processInstanceId(this.processInstanceIds.get(0)).singleResult();
        Assert.assertEquals((long)8L, (long)task2.getRetries().intValue());
        List tasks = this.externalTaskService.createExternalTaskQuery().processInstanceId(this.processInstanceIds.get(this.processInstanceIds.size() - 1)).list();
        for (ExternalTask t : tasks) {
            Assert.assertEquals((long)8L, (long)t.getRetries().intValue());
        }
    }

    public void executeSeedAndBatchJobs(Batch batch) {
        Job job = (Job)this.engineRule.getManagementService().createJobQuery().jobDefinitionId(batch.getSeedJobDefinitionId()).singleResult();
        this.managementService.executeJob(job.getId());
        for (Job pending : this.managementService.createJobQuery().jobDefinitionId(batch.getBatchJobDefinitionId()).list()) {
            this.managementService.executeJob(pending.getId());
        }
    }
}

