/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationSpec;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@RequiredHistoryLevel(value="full")
public class BulkHistoryDeleteProcessInstancesAuthorizationTest {
    protected static final String ONE_TASK_PROCESS = "oneTaskProcess";
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    public ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule).around((TestRule)this.testHelper);
    private HistoryService historyService;
    private RuntimeService runtimeService;
    @Parameterized.Parameter
    public AuthorizationScenario scenario;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
        this.authRule.createUserAndGroup("demo", "groupId");
    }

    @Parameterized.Parameters(name="Scenario {index}")
    public static Collection<AuthorizationScenario[]> scenarios() {
        return AuthorizationTestRule.asParameters(AuthorizationScenario.scenario().failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "*", "demo", new Permission[]{Permissions.DELETE_HISTORY})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "someId", "demo", new Permission[]{Permissions.DELETE_HISTORY})).failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "*", "demo", new Permission[]{Permissions.DELETE_HISTORY})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "*", "demo", new Permission[]{Permissions.DELETE_HISTORY})).succeeds());
    }

    @After
    public void tearDown() {
        this.authRule.deleteUsersAndGroups();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testCleanupHistory() {
        List<String> ids = this.prepareHistoricProcesses();
        this.runtimeService.deleteProcessInstances(ids, null, true, true);
        this.authRule.init(this.scenario).withUser("demo").start();
        this.historyService.deleteHistoricProcessInstancesBulk(ids);
        if (this.authRule.assertScenario(this.scenario)) {
            Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        }
    }

    private List<String> prepareHistoricProcesses() {
        return this.prepareHistoricProcesses(ONE_TASK_PROCESS);
    }

    private List<String> prepareHistoricProcesses(String businessKey) {
        return this.prepareHistoricProcesses(businessKey, null);
    }

    private List<String> prepareHistoricProcesses(String businessKey, VariableMap variables) {
        ArrayList<String> processInstanceIds = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(businessKey, (Map)variables);
            processInstanceIds.add(processInstance.getId());
        }
        return processInstanceIds;
    }
}

