/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang.time.DateUtils;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.history.HistoricCaseInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.ExecuteJobHelper;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupJobHandlerConfiguration;
import org.camunda.bpm.engine.impl.metrics.Meter;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricIncidentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.impl.util.ExceptionUtil;
import org.camunda.bpm.engine.impl.util.json.JSONObject;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.dmn.businessruletask.TestPojo;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class HistoryCleanupTest {
    private static final int PROCESS_INSTANCES_COUNT = 3;
    private static final int DECISIONS_IN_PROCESS_INSTANCES = 3;
    private static final int DECISION_INSTANCES_COUNT = 10;
    private static final int CASE_INSTANCES_COUNT = 4;
    private static final int HISTORY_TIME_TO_LIVE = 5;
    private static final int DAYS_IN_THE_PAST = -6;
    protected static final String ONE_TASK_PROCESS = "oneTaskProcess";
    protected static final String DECISION = "decision";
    protected static final String ONE_TASK_CASE = "case";
    protected ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(){

        @Override
        public ProcessEngineConfiguration configureEngine(ProcessEngineConfigurationImpl configuration) {
            configuration.setHistoryCleanupBatchSize(20);
            configuration.setHistoryCleanupBatchThreshold(10);
            return configuration;
        }
    };
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(this.bootstrapRule);
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private HistoryService historyService;
    private RuntimeService runtimeService;
    private ManagementService managementService;
    private CaseService caseService;
    private RepositoryService repositoryService;
    private ProcessEngineConfigurationImpl processEngineConfiguration;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.bootstrapRule).around((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
        this.managementService = this.engineRule.getManagementService();
        this.caseService = this.engineRule.getCaseService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.testRule.deploy("org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/dmn/Example.dmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCaseWithHistoryTimeToLive.cmmn");
    }

    @After
    public void clearDatabase() {
        String defaultStartTime = this.processEngineConfiguration.getHistoryCleanupBatchWindowStartTime();
        String defaultEndTime = this.processEngineConfiguration.getHistoryCleanupBatchWindowEndTime();
        int defaultBatchSize = this.processEngineConfiguration.getHistoryCleanupBatchSize();
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime(defaultStartTime);
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime(defaultEndTime);
        this.processEngineConfiguration.setHistoryCleanupBatchSize(defaultBatchSize);
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                List jobs = HistoryCleanupTest.this.managementService.createJobQuery().list();
                if (jobs.size() > 0) {
                    Assert.assertEquals((long)1L, (long)jobs.size());
                    String jobId = ((Job)jobs.get(0)).getId();
                    commandContext.getJobManager().deleteJob((JobEntity)jobs.get(0));
                    commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(jobId);
                }
                List historicIncidents = HistoryCleanupTest.this.historyService.createHistoricIncidentQuery().list();
                for (HistoricIncident historicIncident : historicIncidents) {
                    commandContext.getDbEntityManager().delete((DbEntity)((HistoricIncidentEntity)historicIncident));
                }
                commandContext.getMeterLogManager().deleteAll();
                return null;
            }
        });
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        for (HistoricProcessInstance historicProcessInstance : historicProcessInstances) {
            this.historyService.deleteHistoricProcessInstance(historicProcessInstance.getId());
        }
        List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        for (HistoricDecisionInstance historicDecisionInstance : historicDecisionInstances) {
            this.historyService.deleteHistoricDecisionInstanceByInstanceId(historicDecisionInstance.getId());
        }
        List historicCaseInstances = this.historyService.createHistoricCaseInstanceQuery().list();
        for (HistoricCaseInstance historicCaseInstance : historicCaseInstances) {
            this.historyService.deleteHistoricCaseInstance(historicCaseInstance.getId());
        }
        this.clearMetrics();
    }

    protected void clearMetrics() {
        Collection meters = this.processEngineConfiguration.getMetricsRegistry().getMeters().values();
        for (Meter meter : meters) {
            meter.getAndClear();
        }
        this.managementService.deleteMetrics(null);
    }

    @Test
    public void testHistoryCleanupManualRun() {
        this.prepareData(15);
        ClockUtil.setCurrentTime((Date)new Date());
        String jobId = this.historyService.cleanUpHistoryAsync(true).getId();
        this.managementService.executeJob(jobId);
        this.assertResult(0L);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRef.bpmn20.xml", "org/camunda/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml", "org/camunda/bpm/engine/test/api/authorization/oneTaskCase.cmmn"})
    public void testHistoryCleanupOnlyDecisionInstancesRemoved() {
        this.prepareInstances(null, 5, null);
        ClockUtil.setCurrentTime((Date)new Date());
        String jobId = this.historyService.cleanUpHistoryAsync(true).getId();
        this.managementService.executeJob(jobId);
        Assert.assertEquals((long)3L, (long)this.historyService.createHistoricProcessInstanceQuery().count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricDecisionInstanceQuery().count());
        Assert.assertEquals((long)4L, (long)this.historyService.createHistoricCaseInstanceQuery().count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRef.bpmn20.xml", "org/camunda/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml", "org/camunda/bpm/engine/test/api/authorization/oneTaskCase.cmmn"})
    public void testHistoryCleanupOnlyProcessInstancesRemoved() {
        this.prepareInstances(5, null, null);
        ClockUtil.setCurrentTime((Date)new Date());
        String jobId = this.historyService.cleanUpHistoryAsync(true).getId();
        this.managementService.executeJob(jobId);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().count());
        Assert.assertEquals((long)13L, (long)this.historyService.createHistoricDecisionInstanceQuery().count());
        Assert.assertEquals((long)4L, (long)this.historyService.createHistoricCaseInstanceQuery().count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRef.bpmn20.xml", "org/camunda/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml", "org/camunda/bpm/engine/test/api/authorization/oneTaskCase.cmmn"})
    public void testHistoryCleanupOnlyCaseInstancesRemoved() {
        this.prepareInstances(null, null, 5);
        ClockUtil.setCurrentTime((Date)new Date());
        String jobId = this.historyService.cleanUpHistoryAsync(true).getId();
        this.managementService.executeJob(jobId);
        Assert.assertEquals((long)3L, (long)this.historyService.createHistoricProcessInstanceQuery().count());
        Assert.assertEquals((long)13L, (long)this.historyService.createHistoricDecisionInstanceQuery().count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricCaseInstanceQuery().count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRef.bpmn20.xml", "org/camunda/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml", "org/camunda/bpm/engine/test/api/authorization/oneTaskCase.cmmn"})
    public void testHistoryCleanupOnlyDecisionInstancesNotRemoved() {
        this.prepareInstances(5, null, 5);
        ClockUtil.setCurrentTime((Date)new Date());
        String jobId = this.historyService.cleanUpHistoryAsync(true).getId();
        this.managementService.executeJob(jobId);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().count());
        Assert.assertEquals((long)13L, (long)this.historyService.createHistoricDecisionInstanceQuery().count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricCaseInstanceQuery().count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRef.bpmn20.xml", "org/camunda/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml", "org/camunda/bpm/engine/test/api/authorization/oneTaskCase.cmmn"})
    public void testHistoryCleanupOnlyProcessInstancesNotRemoved() {
        this.prepareInstances(null, 5, 5);
        ClockUtil.setCurrentTime((Date)new Date());
        String jobId = this.historyService.cleanUpHistoryAsync(true).getId();
        this.managementService.executeJob(jobId);
        Assert.assertEquals((long)3L, (long)this.historyService.createHistoricProcessInstanceQuery().count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricDecisionInstanceQuery().count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricCaseInstanceQuery().count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRef.bpmn20.xml", "org/camunda/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml", "org/camunda/bpm/engine/test/api/authorization/oneTaskCase.cmmn"})
    public void testHistoryCleanupOnlyCaseInstancesNotRemoved() {
        this.prepareInstances(5, 5, null);
        ClockUtil.setCurrentTime((Date)new Date());
        String jobId = this.historyService.cleanUpHistoryAsync(true).getId();
        this.managementService.executeJob(jobId);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricDecisionInstanceQuery().count());
        Assert.assertEquals((long)4L, (long)this.historyService.createHistoricCaseInstanceQuery().count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRef.bpmn20.xml", "org/camunda/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml", "org/camunda/bpm/engine/test/api/authorization/oneTaskCase.cmmn"})
    public void testHistoryCleanupEverythingRemoved() {
        this.prepareInstances(5, 5, 5);
        ClockUtil.setCurrentTime((Date)new Date());
        String jobId = this.historyService.cleanUpHistoryAsync(true).getId();
        this.managementService.executeJob(jobId);
        this.assertResult(0L);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRef.bpmn20.xml", "org/camunda/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml", "org/camunda/bpm/engine/test/api/authorization/oneTaskCase.cmmn"})
    public void testHistoryCleanupNothingRemoved() {
        this.prepareInstances(null, null, null);
        ClockUtil.setCurrentTime((Date)new Date());
        String jobId = this.historyService.cleanUpHistoryAsync(true).getId();
        this.managementService.executeJob(jobId);
        Assert.assertEquals((long)3L, (long)this.historyService.createHistoricProcessInstanceQuery().count());
        Assert.assertEquals((long)13L, (long)this.historyService.createHistoricDecisionInstanceQuery().count());
        Assert.assertEquals((long)4L, (long)this.historyService.createHistoricCaseInstanceQuery().count());
    }

    private void prepareInstances(Integer processInstanceTimeToLive, Integer decisionTimeToLive, Integer caseTimeToLive) {
        int i;
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("testProcess").list();
        Assert.assertEquals((long)1L, (long)processDefinitions.size());
        this.repositoryService.updateProcessDefinitionHistoryTimeToLive(((ProcessDefinition)processDefinitions.get(0)).getId(), processInstanceTimeToLive);
        List decisionDefinitions = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey("testDecision").list();
        Assert.assertEquals((long)1L, (long)decisionDefinitions.size());
        this.repositoryService.updateDecisionDefinitionHistoryTimeToLive(((DecisionDefinition)decisionDefinitions.get(0)).getId(), decisionTimeToLive);
        List caseDefinitions = this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("oneTaskCase").list();
        Assert.assertEquals((long)1L, (long)caseDefinitions.size());
        this.repositoryService.updateCaseDefinitionHistoryTimeToLive(((CaseDefinition)caseDefinitions.get(0)).getId(), caseTimeToLive);
        Date oldCurrentTime = ClockUtil.getCurrentTime();
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)new Date(), (int)-6));
        ArrayList<String> processInstanceIds = new ArrayList<String>();
        VariableMap variables = Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37));
        for (i = 0; i < 3; ++i) {
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables);
            processInstanceIds.add(processInstance.getId());
        }
        this.runtimeService.deleteProcessInstances(processInstanceIds, null, true, true);
        for (i = 0; i < 10; ++i) {
            this.engineRule.getDecisionService().evaluateDecisionByKey("testDecision").variables((Map)variables).evaluate();
        }
        for (i = 0; i < 4; ++i) {
            CaseInstance caseInstance = this.caseService.createCaseInstanceByKey("oneTaskCase", (Map)Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37 + (double)i)));
            this.caseService.terminateCaseExecution(caseInstance.getId());
            this.caseService.closeCaseInstance(caseInstance.getId());
        }
        ClockUtil.setCurrentTime((Date)oldCurrentTime);
    }

    @Test
    public void testHistoryCleanupWithinBatchWindow() {
        this.prepareData(15);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime(new SimpleDateFormat("HH:mm").format(now));
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime(new SimpleDateFormat("HH:mm").format(DateUtils.addHours((Date)now, (int)5)));
        this.processEngineConfiguration.initHistoryCleanup();
        String jobId = this.historyService.cleanUpHistoryAsync(false).getId();
        this.managementService.executeJob(jobId);
        this.assertResult(0L);
    }

    @Test
    public void testHistoryCleanupJobNullTTL() {
        this.removeHistoryTimeToLive();
        this.prepareData(15);
        ClockUtil.setCurrentTime((Date)new Date());
        String jobId = this.historyService.cleanUpHistoryAsync(true).getId();
        this.managementService.executeJob(jobId);
        this.assertResult(15L);
    }

    private void removeHistoryTimeToLive() {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(ONE_TASK_PROCESS).list();
        Assert.assertEquals((long)1L, (long)processDefinitions.size());
        this.repositoryService.updateProcessDefinitionHistoryTimeToLive(((ProcessDefinition)processDefinitions.get(0)).getId(), null);
        List decisionDefinitions = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION).list();
        Assert.assertEquals((long)1L, (long)decisionDefinitions.size());
        this.repositoryService.updateDecisionDefinitionHistoryTimeToLive(((DecisionDefinition)decisionDefinitions.get(0)).getId(), null);
        List caseDefinitions = this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(ONE_TASK_CASE).list();
        Assert.assertEquals((long)1L, (long)caseDefinitions.size());
        this.repositoryService.updateCaseDefinitionHistoryTimeToLive(((CaseDefinition)caseDefinitions.get(0)).getId(), null);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/twoTasksProcess.bpmn20.xml"})
    public void testHistoryCleanupJobDefaultTTL() {
        this.prepareBPMNData(15, "twoTasksProcess");
        ClockUtil.setCurrentTime((Date)new Date());
        String jobId = this.historyService.cleanUpHistoryAsync(true).getId();
        this.managementService.executeJob(jobId);
        this.assertResult(15L);
    }

    @Test
    public void testFindHistoryCleanupJob() {
        String jobId = this.historyService.cleanUpHistoryAsync(true).getId();
        Job historyCleanupJob = this.historyService.findHistoryCleanupJob();
        Assert.assertNotNull((Object)historyCleanupJob);
        Assert.assertEquals((Object)jobId, (Object)historyCleanupJob.getId());
    }

    @Test
    public void testRescheduleForNever() {
        this.historyService.cleanUpHistoryAsync(true);
        JobEntity historyCleanupJob = (JobEntity)this.historyService.findHistoryCleanupJob();
        Assert.assertNotNull((Object)historyCleanupJob);
        Assert.assertNotNull((Object)historyCleanupJob.getDuedate());
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime(null);
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime(null);
        this.processEngineConfiguration.initHistoryCleanup();
        ClockUtil.setCurrentTime((Date)new Date());
        this.historyService.cleanUpHistoryAsync(false);
        historyCleanupJob = (JobEntity)this.historyService.findHistoryCleanupJob();
        Assert.assertEquals((long)SuspensionState.SUSPENDED.getStateCode(), (long)historyCleanupJob.getSuspensionState());
        Assert.assertNull((Object)historyCleanupJob.getDuedate());
    }

    @Test
    public void testHistoryCleanupJobResolveIncident() {
        String jobId = this.historyService.cleanUpHistoryAsync(true).getId();
        this.imitateFailedJob(jobId);
        jobId = this.historyService.cleanUpHistoryAsync(true).getId();
        JobEntity jobEntity = this.getJobEntity(jobId);
        Assert.assertEquals(null, (Object)jobEntity.getExceptionByteArrayId());
        Assert.assertEquals(null, (Object)jobEntity.getExceptionMessage());
    }

    private void imitateFailedJob(final String jobId) {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                JobEntity jobEntity = HistoryCleanupTest.this.getJobEntity(jobId);
                jobEntity.setRetries(0);
                jobEntity.setExceptionMessage("Something bad happened");
                jobEntity.setExceptionStacktrace(ExceptionUtil.getExceptionStacktrace((Throwable)new RuntimeException("Something bad happened")));
                return null;
            }
        });
    }

    @Test
    public void testLessThanThresholdManualRun() {
        this.prepareData(5);
        ClockUtil.setCurrentTime((Date)new Date());
        String jobId = this.historyService.cleanUpHistoryAsync(true).getId();
        this.managementService.executeJob(jobId);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        JobEntity jobEntity = this.getJobEntity(jobId);
        Assert.assertEquals((long)SuspensionState.SUSPENDED.getStateCode(), (long)jobEntity.getSuspensionState());
    }

    @Test
    public void testNotEnoughTimeToDeleteEverything() {
        this.prepareData(40);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime(new SimpleDateFormat("HH:mm").format(now));
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime(new SimpleDateFormat("HH:mm").format(DateUtils.addHours((Date)now, (int)5)));
        this.processEngineConfiguration.initHistoryCleanup();
        String jobId = this.historyService.cleanUpHistoryAsync().getId();
        this.managementService.executeJob(jobId);
        ClockUtil.setCurrentTime((Date)DateUtils.addHours((Date)now, (int)6));
        this.managementService.executeJob(jobId);
        this.assertResult(20L);
    }

    @Test
    public void testManualRunDoesNotRespectBatchWindow() {
        int processInstanceCount = 40;
        this.prepareData(processInstanceCount);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime(new SimpleDateFormat("HH:mm").format(DateUtils.addHours((Date)now, (int)1)));
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime(new SimpleDateFormat("HH:mm").format(DateUtils.addHours((Date)now, (int)5)));
        this.processEngineConfiguration.initHistoryCleanup();
        String jobId = this.historyService.cleanUpHistoryAsync(true).getId();
        this.managementService.executeJob(jobId);
        ClockUtil.setCurrentTime((Date)DateUtils.addHours((Date)now, (int)6));
        this.managementService.executeJob(jobId);
        this.assertResult(0L);
    }

    @Test
    public void testLessThanThresholdWithinBatchWindow() {
        this.prepareData(5);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime(new SimpleDateFormat("HH:mm").format(now));
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime(new SimpleDateFormat("HH:mm").format(DateUtils.addHours((Date)now, (int)5)));
        this.processEngineConfiguration.initHistoryCleanup();
        String jobId = this.historyService.cleanUpHistoryAsync().getId();
        this.managementService.executeJob(jobId);
        JobEntity jobEntity = this.getJobEntity(jobId);
        HistoryCleanupJobHandlerConfiguration configuration = this.getConfiguration(jobEntity);
        Date nextRun = this.getNextRunWithDelay(ClockUtil.getCurrentTime(), 0);
        Assert.assertTrue((jobEntity.getDuedate().equals(nextRun) || jobEntity.getDuedate().after(nextRun) ? 1 : 0) != 0);
        Date nextRunMax = DateUtils.addSeconds((Date)ClockUtil.getCurrentTime(), (int)3600);
        Assert.assertTrue((boolean)jobEntity.getDuedate().before(nextRunMax));
        Assert.assertEquals((long)1L, (long)configuration.getCountEmptyRuns());
        this.assertResult(0L);
    }

    private Date getNextRunWithDelay(Date date, int countEmptyRuns) {
        Date result = DateUtils.setMilliseconds((Date)DateUtils.addSeconds((Date)date, (int)Math.min((int)(Math.pow(2.0, countEmptyRuns) * 10.0), 3600)), (int)0);
        return result;
    }

    private JobEntity getJobEntity(String jobId) {
        return (JobEntity)this.managementService.createJobQuery().jobId(jobId).list().get(0);
    }

    @Test
    public void testLessThanThresholdWithinBatchWindowAgain() {
        this.prepareData(5);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime(new SimpleDateFormat("HH:mm").format(now));
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime(new SimpleDateFormat("HH:mm").format(DateUtils.addHours((Date)now, (int)1)));
        this.processEngineConfiguration.initHistoryCleanup();
        String jobId = this.historyService.cleanUpHistoryAsync().getId();
        for (int i = 1; i <= 6; ++i) {
            this.managementService.executeJob(jobId);
        }
        JobEntity jobEntity = this.getJobEntity(jobId);
        HistoryCleanupJobHandlerConfiguration configuration = this.getConfiguration(jobEntity);
        Date nextRun = this.getNextRunWithDelay(ClockUtil.getCurrentTime(), 5);
        Assert.assertTrue((jobEntity.getDuedate().equals(nextRun) || jobEntity.getDuedate().after(nextRun) ? 1 : 0) != 0);
        Date nextRunMax = DateUtils.addSeconds((Date)ClockUtil.getCurrentTime(), (int)3600);
        Assert.assertTrue((boolean)jobEntity.getDuedate().before(nextRunMax));
        Assert.assertEquals((long)6L, (long)configuration.getCountEmptyRuns());
        this.assertResult(0L);
    }

    @Test
    public void testLessThanThresholdWithinBatchWindowMaxDelayReached() {
        this.prepareData(5);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime(new SimpleDateFormat("HH:mm").format(now));
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime(new SimpleDateFormat("HH:mm").format(DateUtils.addHours((Date)now, (int)2)));
        this.processEngineConfiguration.initHistoryCleanup();
        String jobId = this.historyService.cleanUpHistoryAsync().getId();
        for (int i = 1; i <= 11; ++i) {
            this.managementService.executeJob(jobId);
        }
        JobEntity jobEntity = this.getJobEntity(jobId);
        HistoryCleanupJobHandlerConfiguration configuration = this.getConfiguration(jobEntity);
        Date nextRun = this.getNextRunWithDelay(ClockUtil.getCurrentTime(), 10);
        Assert.assertTrue((jobEntity.getDuedate().equals(nextRun) || jobEntity.getDuedate().after(nextRun) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)jobEntity.getDuedate().before(this.getNextRunWithinBatchWindow(now)));
        Assert.assertEquals((long)11L, (long)configuration.getCountEmptyRuns());
        this.assertResult(0L);
    }

    @Test
    public void testLessThanThresholdCloseToBatchWindowEndTime() {
        this.prepareData(5);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime(new SimpleDateFormat("HH:mm").format(now));
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime(new SimpleDateFormat("HH:mm").format(DateUtils.addMinutes((Date)now, (int)30)));
        this.processEngineConfiguration.initHistoryCleanup();
        String jobId = this.historyService.cleanUpHistoryAsync().getId();
        for (int i = 1; i <= 9; ++i) {
            this.managementService.executeJob(jobId);
        }
        JobEntity jobEntity = this.getJobEntity(jobId);
        HistoryCleanupJobHandlerConfiguration configuration = this.getConfiguration(jobEntity);
        Date nextRun = this.getNextRunWithinBatchWindow(ClockUtil.getCurrentTime());
        Assert.assertTrue((boolean)jobEntity.getDuedate().equals(nextRun));
        Assert.assertEquals((long)0L, (long)configuration.getCountEmptyRuns());
        this.assertResult(0L);
    }

    @Test
    public void testLessThanThresholdOutsideBatchWindow() {
        this.prepareData(5);
        Date twoHoursAgo = new Date();
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime(new SimpleDateFormat("HH:mm").format(twoHoursAgo));
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime(new SimpleDateFormat("HH:mm").format(DateUtils.addHours((Date)twoHoursAgo, (int)1)));
        this.processEngineConfiguration.initHistoryCleanup();
        ClockUtil.setCurrentTime((Date)DateUtils.addHours((Date)twoHoursAgo, (int)2));
        String jobId = this.historyService.cleanUpHistoryAsync().getId();
        for (int i = 1; i <= 3; ++i) {
            this.managementService.executeJob(jobId);
        }
        JobEntity jobEntity = this.getJobEntity(jobId);
        HistoryCleanupJobHandlerConfiguration configuration = this.getConfiguration(jobEntity);
        Date nextRun = this.getNextRunWithinBatchWindow(ClockUtil.getCurrentTime());
        Assert.assertTrue((boolean)jobEntity.getDuedate().equals(nextRun));
        Assert.assertEquals((long)0L, (long)configuration.getCountEmptyRuns());
        this.assertResult(5L);
    }

    @Test
    public void testLessThanThresholdOutsideBatchWindowAfterMidnight() {
        this.prepareData(5);
        Date date = new Date();
        ClockUtil.setCurrentTime((Date)DateUtils.setMinutes((Date)DateUtils.setHours((Date)date, (int)1), (int)10));
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime("23:00");
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime("01:00");
        this.processEngineConfiguration.initHistoryCleanup();
        String jobId = this.historyService.cleanUpHistoryAsync().getId();
        this.managementService.executeJob(jobId);
        JobEntity jobEntity = this.getJobEntity(jobId);
        HistoryCleanupJobHandlerConfiguration configuration = this.getConfiguration(jobEntity);
        Date nextRun = this.getNextRunWithinBatchWindow(ClockUtil.getCurrentTime());
        Assert.assertTrue((boolean)jobEntity.getDuedate().equals(nextRun));
        Assert.assertTrue((boolean)nextRun.after(ClockUtil.getCurrentTime()));
        Assert.assertEquals((long)0L, (long)configuration.getCountEmptyRuns());
        this.assertResult(5L);
    }

    @Test
    public void testLessThanThresholdOutsideBatchWindowBeforeMidnight() {
        this.prepareData(5);
        Date date = new Date();
        ClockUtil.setCurrentTime((Date)DateUtils.setMinutes((Date)DateUtils.setHours((Date)date, (int)22), (int)10));
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime("23:00");
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime("01:00");
        this.processEngineConfiguration.initHistoryCleanup();
        String jobId = this.historyService.cleanUpHistoryAsync().getId();
        this.managementService.executeJob(jobId);
        JobEntity jobEntity = this.getJobEntity(jobId);
        HistoryCleanupJobHandlerConfiguration configuration = this.getConfiguration(jobEntity);
        Date nextRun = this.getNextRunWithinBatchWindow(ClockUtil.getCurrentTime());
        Assert.assertTrue((boolean)jobEntity.getDuedate().equals(nextRun));
        Assert.assertTrue((boolean)nextRun.after(ClockUtil.getCurrentTime()));
        Assert.assertEquals((long)0L, (long)configuration.getCountEmptyRuns());
        this.assertResult(5L);
    }

    @Test
    public void testLessThanThresholdWithinBatchWindowBeforeMidnight() {
        this.prepareData(5);
        Date date = new Date();
        ClockUtil.setCurrentTime((Date)DateUtils.setMinutes((Date)DateUtils.setHours((Date)date, (int)23), (int)10));
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime("23:00");
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime("01:00");
        this.processEngineConfiguration.initHistoryCleanup();
        String jobId = this.historyService.cleanUpHistoryAsync().getId();
        ExecuteJobHelper.executeJob((String)jobId, (CommandExecutor)this.processEngineConfiguration.getCommandExecutorTxRequired());
        JobEntity jobEntity = this.getJobEntity(jobId);
        HistoryCleanupJobHandlerConfiguration configuration = this.getConfiguration(jobEntity);
        Date nextRun = this.getNextRunWithDelay(ClockUtil.getCurrentTime(), 0);
        Assert.assertTrue((jobEntity.getDuedate().equals(nextRun) || jobEntity.getDuedate().after(nextRun) ? 1 : 0) != 0);
        Date nextRunMax = DateUtils.addSeconds((Date)ClockUtil.getCurrentTime(), (int)3600);
        Assert.assertTrue((boolean)jobEntity.getDuedate().before(nextRunMax));
        Assert.assertEquals((long)1L, (long)configuration.getCountEmptyRuns());
        this.assertResult(0L);
    }

    @Test
    public void testLessThanThresholdWithinBatchWindowAfterMidnight() {
        this.prepareData(5);
        Date date = new Date();
        ClockUtil.setCurrentTime((Date)DateUtils.setMinutes((Date)DateUtils.setHours((Date)date, (int)0), (int)10));
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime("23:00");
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime("01:00");
        this.processEngineConfiguration.initHistoryCleanup();
        String jobId = this.historyService.cleanUpHistoryAsync().getId();
        ExecuteJobHelper.executeJob((String)jobId, (CommandExecutor)this.processEngineConfiguration.getCommandExecutorTxRequired());
        JobEntity jobEntity = this.getJobEntity(jobId);
        HistoryCleanupJobHandlerConfiguration configuration = this.getConfiguration(jobEntity);
        Date nextRun = this.getNextRunWithDelay(ClockUtil.getCurrentTime(), 0);
        Assert.assertTrue((jobEntity.getDuedate().equals(nextRun) || jobEntity.getDuedate().after(nextRun) ? 1 : 0) != 0);
        Date nextRunMax = DateUtils.addSeconds((Date)ClockUtil.getCurrentTime(), (int)3600);
        Assert.assertTrue((boolean)jobEntity.getDuedate().before(nextRunMax));
        Assert.assertEquals((long)1L, (long)configuration.getCountEmptyRuns());
        this.assertResult(0L);
    }

    @Test
    public void testConfiguration() {
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime("23:00+0200");
        this.processEngineConfiguration.initHistoryCleanup();
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT+2:00"));
        Date startTime = this.processEngineConfiguration.getHistoryCleanupBatchWindowStartTimeAsDate();
        c.setTime(startTime);
        Assert.assertEquals((long)23L, (long)c.get(11));
        Assert.assertEquals((long)0L, (long)c.get(12));
        Assert.assertEquals((long)0L, (long)c.get(13));
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime("23:00");
        this.processEngineConfiguration.initHistoryCleanup();
        c = Calendar.getInstance();
        startTime = this.processEngineConfiguration.getHistoryCleanupBatchWindowStartTimeAsDate();
        c.setTime(startTime);
        Assert.assertEquals((long)23L, (long)c.get(11));
        Assert.assertEquals((long)0L, (long)c.get(12));
        Assert.assertEquals((long)0L, (long)c.get(13));
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime("01:35-0800");
        this.processEngineConfiguration.initHistoryCleanup();
        c = Calendar.getInstance(TimeZone.getTimeZone("GMT-8:00"));
        Date endTime = this.processEngineConfiguration.getHistoryCleanupBatchWindowEndTimeAsDate();
        c.setTime(endTime);
        Assert.assertEquals((long)1L, (long)c.get(11));
        Assert.assertEquals((long)35L, (long)c.get(12));
        Assert.assertEquals((long)0L, (long)c.get(13));
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime("01:35");
        this.processEngineConfiguration.initHistoryCleanup();
        c = Calendar.getInstance();
        endTime = this.processEngineConfiguration.getHistoryCleanupBatchWindowEndTimeAsDate();
        c.setTime(endTime);
        Assert.assertEquals((long)1L, (long)c.get(11));
        Assert.assertEquals((long)35L, (long)c.get(12));
        Assert.assertEquals((long)0L, (long)c.get(13));
        this.processEngineConfiguration.setHistoryCleanupBatchSize(500);
        this.processEngineConfiguration.initHistoryCleanup();
        Assert.assertEquals((long)this.processEngineConfiguration.getHistoryCleanupBatchSize(), (long)500L);
    }

    @Test
    public void testConfigurationFailureWrongStartTime() {
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime("23");
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime("01:00");
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("historyCleanupBatchWindowStartTime");
        this.processEngineConfiguration.initHistoryCleanup();
    }

    @Test
    public void testConfigurationFailureWrongEndTime() {
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime("23:00");
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime("wrongValue");
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("historyCleanupBatchWindowEndTime");
        this.processEngineConfiguration.initHistoryCleanup();
    }

    @Test
    public void testConfigurationFailureWrongBatchSize() {
        this.processEngineConfiguration.setHistoryCleanupBatchSize(501);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("historyCleanupBatchSize");
        this.processEngineConfiguration.initHistoryCleanup();
    }

    private Date getNextRunWithinBatchWindow(Date currentTime) {
        Date batchWindowStartTime = this.processEngineConfiguration.getHistoryCleanupBatchWindowStartTimeAsDate();
        return this.getNextRunWithinBatchWindow(currentTime, batchWindowStartTime);
    }

    public Date getNextRunWithinBatchWindow(Date date, Date batchWindowStartTime) {
        Date todayPossibleRun = this.updateTime(date, batchWindowStartTime);
        if (todayPossibleRun.after(date)) {
            return todayPossibleRun;
        }
        return DateUtils.addDays((Date)todayPossibleRun, (int)1);
    }

    private Date updateTime(Date now, Date newTime) {
        Date result = now;
        Calendar newTimeCalendar = Calendar.getInstance();
        newTimeCalendar.setTime(newTime);
        result = DateUtils.setHours((Date)result, (int)newTimeCalendar.get(11));
        result = DateUtils.setMinutes((Date)result, (int)newTimeCalendar.get(12));
        result = DateUtils.setSeconds((Date)result, (int)newTimeCalendar.get(13));
        result = DateUtils.setMilliseconds((Date)result, (int)newTimeCalendar.get(14));
        return result;
    }

    private HistoryCleanupJobHandlerConfiguration getConfiguration(JobEntity jobEntity) {
        String jobHandlerConfigurationRaw = jobEntity.getJobHandlerConfigurationRaw();
        return HistoryCleanupJobHandlerConfiguration.fromJson((JSONObject)new JSONObject(jobHandlerConfigurationRaw));
    }

    private void prepareData(int instanceCount) {
        int createdInstances = instanceCount / 3;
        this.prepareBPMNData(createdInstances, ONE_TASK_PROCESS);
        this.prepareDMNData(createdInstances);
        this.prepareCMMNData(instanceCount - 2 * createdInstances);
    }

    private void prepareBPMNData(int instanceCount, String businesskey) {
        Date oldCurrentTime = ClockUtil.getCurrentTime();
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)new Date(), (int)-6));
        List<String> ids = this.prepareHistoricProcesses(businesskey, this.getVariables(), instanceCount);
        this.runtimeService.deleteProcessInstances(ids, null, true, true);
        ClockUtil.setCurrentTime((Date)oldCurrentTime);
    }

    private void prepareDMNData(int instanceCount) {
        Date oldCurrentTime = ClockUtil.getCurrentTime();
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)new Date(), (int)-6));
        for (int i = 0; i < instanceCount; ++i) {
            this.engineRule.getDecisionService().evaluateDecisionByKey(DECISION).variables((Map)this.getDMNVariables()).evaluate();
        }
        ClockUtil.setCurrentTime((Date)oldCurrentTime);
    }

    private void prepareCMMNData(int instanceCount) {
        Date oldCurrentTime = ClockUtil.getCurrentTime();
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)new Date(), (int)-6));
        for (int i = 0; i < instanceCount; ++i) {
            CaseInstance caseInstance = this.caseService.createCaseInstanceByKey(ONE_TASK_CASE);
            this.caseService.terminateCaseExecution(caseInstance.getId());
            this.caseService.closeCaseInstance(caseInstance.getId());
        }
        ClockUtil.setCurrentTime((Date)oldCurrentTime);
    }

    private List<String> prepareHistoricProcesses(String businessKey, VariableMap variables, Integer processInstanceCount) {
        ArrayList<String> processInstanceIds = new ArrayList<String>();
        for (int i = 0; i < processInstanceCount; ++i) {
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(businessKey, (Map)variables);
            processInstanceIds.add(processInstance.getId());
        }
        return processInstanceIds;
    }

    private VariableMap getVariables() {
        return Variables.createVariables().putValue("aVariableName", (Object)"aVariableValue").putValue("anotherVariableName", (Object)"anotherVariableValue");
    }

    protected VariableMap getDMNVariables() {
        return Variables.createVariables().putValue("status", (Object)"silver").putValue("sum", (Object)723);
    }

    private void assertResult(long expectedInstanceCount) {
        long count = this.historyService.createHistoricProcessInstanceQuery().count() + this.historyService.createHistoricDecisionInstanceQuery().count() + this.historyService.createHistoricCaseInstanceQuery().count();
        Assert.assertEquals((long)expectedInstanceCount, (long)count);
    }
}

