/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.FormService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.history.HistoricDecisionInputInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricDecisionOutputInstance;
import org.camunda.bpm.engine.history.HistoricJobLog;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionInputInstanceEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionOutputInstanceEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricExternalTaskLogEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AttachmentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricJobLogEventEntity;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Attachment;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.dmn.businessruletask.TestPojo;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class HistoryDeleteTest {
    protected static final String ONE_TASK_PROCESS = "oneTaskProcess";
    public static final int PROCESS_INSTANCE_COUNT = 5;
    public ProcessEngineRule engineRule = new ProcessEngineRule(true);
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    private HistoryService historyService;
    private TaskService taskService;
    private RuntimeService runtimeService;
    private FormService formService;
    private ExternalTaskService externalTaskService;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
        this.taskService = this.engineRule.getTaskService();
        this.formService = this.engineRule.getFormService();
        this.externalTaskService = this.engineRule.getExternalTaskService();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testCleanupHistoryTaskIdentityLink() {
        List<String> ids = this.prepareHistoricProcesses();
        List taskList = this.taskService.createTaskQuery().list();
        this.taskService.addUserIdentityLink(((Task)taskList.get(0)).getId(), "someUser", "assignee");
        this.runtimeService.deleteProcessInstances(ids, null, true, true);
        this.historyService.deleteHistoricProcessInstances(ids);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricIdentityLinkLogQuery().count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testCleanupHistoryActivityInstances() {
        List<String> ids = this.prepareHistoricProcesses();
        this.runtimeService.deleteProcessInstances(ids, null, true, true);
        this.historyService.deleteHistoricProcessInstances(ids);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testCleanupTaskAttachmentWithContent() {
        List<String> ids = this.prepareHistoricProcesses();
        List taskList = this.taskService.createTaskQuery().list();
        String taskWithAttachmentId = ((Task)taskList.get(0)).getId();
        this.createTaskAttachmentWithContent(taskWithAttachmentId);
        String contentId = this.findAttachmentContentId(this.taskService.getTaskAttachments(taskWithAttachmentId));
        this.runtimeService.deleteProcessInstances(ids, null, true, true);
        this.historyService.deleteHistoricProcessInstances(ids);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        Assert.assertEquals((long)0L, (long)this.taskService.getTaskAttachments(taskWithAttachmentId).size());
        this.verifyByteArraysWereRemoved(contentId);
    }

    private String findAttachmentContentId(List<Attachment> attachments) {
        Assert.assertEquals((long)1L, (long)attachments.size());
        return ((AttachmentEntity)attachments.get(0)).getContentId();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Ignore(value="CAM-7566")
    public void FAILING_testCleanupProcessInstanceAttachmentWithContent() {
        List<String> ids = this.prepareHistoricProcesses();
        String processInstanceWithAttachmentId = ids.get(0);
        this.createProcessInstanceAttachmentWithContent(processInstanceWithAttachmentId);
        String contentId = this.findAttachmentContentId(this.taskService.getProcessInstanceAttachments(processInstanceWithAttachmentId));
        this.runtimeService.deleteProcessInstances(ids, null, true, true);
        this.historyService.deleteHistoricProcessInstances(ids);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        Assert.assertEquals((long)0L, (long)this.taskService.getProcessInstanceAttachments(processInstanceWithAttachmentId).size());
        this.verifyByteArraysWereRemoved(contentId);
    }

    private void createProcessInstanceAttachmentWithContent(String processInstanceId) {
        this.taskService.createAttachment("web page", null, processInstanceId, "weatherforcast", "temperatures and more", (InputStream)new ByteArrayInputStream("someContent".getBytes()));
        List taskAttachments = this.taskService.getProcessInstanceAttachments(processInstanceId);
        Assert.assertEquals((long)1L, (long)taskAttachments.size());
        Assert.assertNotNull((Object)this.taskService.getAttachmentContent(((Attachment)taskAttachments.get(0)).getId()));
    }

    private void createTaskAttachmentWithContent(String taskId) {
        this.taskService.createAttachment("web page", taskId, null, "weatherforcast", "temperatures and more", (InputStream)new ByteArrayInputStream("someContent".getBytes()));
        List taskAttachments = this.taskService.getTaskAttachments(taskId);
        Assert.assertEquals((long)1L, (long)taskAttachments.size());
        Assert.assertNotNull((Object)this.taskService.getAttachmentContent(((Attachment)taskAttachments.get(0)).getId()));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testCleanupTaskComment() {
        List<String> ids = this.prepareHistoricProcesses();
        List taskList = this.taskService.createTaskQuery().list();
        String taskWithCommentId = ((Task)taskList.get(2)).getId();
        this.taskService.createComment(taskWithCommentId, null, "Some comment");
        this.runtimeService.deleteProcessInstances(ids, null, true, true);
        this.historyService.deleteHistoricProcessInstances(ids);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        Assert.assertEquals((long)0L, (long)this.taskService.getTaskComments(taskWithCommentId).size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Ignore(value="CAM-7566")
    public void FAILING_testCleanupProcessInstanceComment() {
        List<String> ids = this.prepareHistoricProcesses();
        String processInstanceWithCommentId = ids.get(0);
        this.taskService.createComment(null, processInstanceWithCommentId, "Some comment");
        this.runtimeService.deleteProcessInstances(ids, null, true, true);
        this.historyService.deleteHistoricProcessInstances(ids);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        Assert.assertEquals((long)0L, (long)this.taskService.getProcessInstanceComments(processInstanceWithCommentId).size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Ignore(value="CAM-7566")
    public void FAILING_testCleanupHistoricVariableInstancesAndHistoricDetails() {
        List<String> ids = this.prepareHistoricProcesses();
        List taskList = this.taskService.createTaskQuery().list();
        this.taskService.setVariables(((Task)taskList.get(0)).getId(), (Map)this.getVariables());
        this.runtimeService.deleteProcessInstances(ids, null, true, true);
        this.historyService.deleteHistoricProcessInstances(ids);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricDetailQuery().count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testCleanupHistoryTaskForm() {
        List<String> ids = this.prepareHistoricProcesses();
        List taskList = this.taskService.createTaskQuery().list();
        this.formService.submitTaskForm(((Task)taskList.get(0)).getId(), (Map)this.getVariables());
        for (ProcessInstance processInstance : this.runtimeService.createProcessInstanceQuery().list()) {
            this.runtimeService.deleteProcessInstance(processInstance.getProcessInstanceId(), null);
        }
        this.historyService.deleteHistoricProcessInstances(ids);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricDetailQuery().count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testCleanupHistoricExternalTaskLog() {
        List<String> ids = this.prepareHistoricProcesses("oneExternalTaskProcess");
        String workerId = "aWrokerId";
        List tasks = this.externalTaskService.fetchAndLock(1, workerId).topic("externalTaskTopic", 10000L).execute();
        this.externalTaskService.handleFailure(((LockedExternalTask)tasks.get(0)).getId(), workerId, "errorMessage", "exceptionStackTrace", 5, 3000L);
        String errorDetailsByteArrayId = this.findErrorDetailsByteArrayId("errorMessage");
        this.runtimeService.deleteProcessInstances(ids, null, true, true);
        this.historyService.deleteHistoricProcessInstances(ids);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricExternalTaskLogQuery().count());
        this.verifyByteArraysWereRemoved(errorDetailsByteArrayId);
    }

    private String findErrorDetailsByteArrayId(String errorMessage) {
        List historicExternalTaskLogs = this.historyService.createHistoricExternalTaskLogQuery().errorMessage(errorMessage).list();
        Assert.assertEquals((long)1L, (long)historicExternalTaskLogs.size());
        return ((HistoricExternalTaskLogEntity)historicExternalTaskLogs.get(0)).getErrorDetailsByteArrayId();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/IncidentTest.testShouldCreateOneIncident.bpmn"})
    public void testCleanupHistoricIncidents() {
        List<String> ids = this.prepareHistoricProcesses("failingProcess");
        this.testRule.executeAvailableJobs();
        this.runtimeService.deleteProcessInstances(ids, null, true, true);
        this.historyService.deleteHistoricProcessInstances(ids);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("failingProcess").count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricIncidentQuery().count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/IncidentTest.testShouldCreateOneIncident.bpmn"})
    public void testCleanupHistoricJobLogs() {
        List<String> ids = this.prepareHistoricProcesses("failingProcess", null, 1);
        this.testRule.executeAvailableJobs();
        this.runtimeService.deleteProcessInstances(ids, null, true, true);
        List<String> byteArrayIds = this.findExceptionByteArrayIds();
        this.historyService.deleteHistoricProcessInstances(ids);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("failingProcess").count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricJobLogQuery().count());
        this.verifyByteArraysWereRemoved(byteArrayIds.toArray(new String[0]));
    }

    private List<String> findExceptionByteArrayIds() {
        ArrayList<String> exceptionByteArrayIds = new ArrayList<String>();
        List historicJobLogs = this.historyService.createHistoricJobLogQuery().list();
        for (HistoricJobLog historicJobLog : historicJobLogs) {
            HistoricJobLogEventEntity historicJobLogEventEntity = (HistoricJobLogEventEntity)historicJobLog;
            if (historicJobLogEventEntity.getExceptionByteArrayId() == null) continue;
            exceptionByteArrayIds.add(historicJobLogEventEntity.getExceptionByteArrayId());
        }
        return exceptionByteArrayIds;
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRef.bpmn20.xml", "org/camunda/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml"})
    @Ignore(value="CAM-7566")
    public void FAILING_testCleanupHistoryDecisionData() {
        List<String> ids = this.prepareHistoricProcesses("testProcess", Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37)));
        this.runtimeService.deleteProcessInstances(ids, null, true, true);
        List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().includeInputs().includeOutputs().list();
        final List<String> historicDecisionInputIds = this.collectHistoricDecisionInputIds(historicDecisionInstances);
        final List<String> historicDecisionOutputIds = this.collectHistoricDecisionOutputIds(historicDecisionInstances);
        this.historyService.deleteHistoricProcessInstances(ids);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("testProcess").count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricDecisionInstanceQuery().count());
        this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                for (String inputId : historicDecisionInputIds) {
                    Assert.assertNull((Object)commandContext.getDbEntityManager().selectById(HistoricDecisionInputInstanceEntity.class, inputId));
                }
                for (String outputId : historicDecisionOutputIds) {
                    Assert.assertNull((Object)commandContext.getDbEntityManager().selectById(HistoricDecisionOutputInstanceEntity.class, outputId));
                }
                return null;
            }
        });
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testCleanupHistoryEmptyProcessIdsException() {
        List<String> ids = this.prepareHistoricProcesses();
        this.runtimeService.deleteProcessInstances(ids, null, true, true);
        try {
            this.historyService.deleteHistoricProcessInstances(null);
            Assert.fail((String)"Empty process instance ids exception was expected");
        }
        catch (BadUserRequestException ex) {
            // empty catch block
        }
        try {
            this.historyService.deleteHistoricProcessInstances(new ArrayList());
            Assert.fail((String)"Empty process instance ids exception was expected");
        }
        catch (BadUserRequestException badUserRequestException) {
            // empty catch block
        }
    }

    private List<String> collectHistoricDecisionInputIds(List<HistoricDecisionInstance> historicDecisionInstances) {
        ArrayList<String> result = new ArrayList<String>();
        for (HistoricDecisionInstance historicDecisionInstance : historicDecisionInstances) {
            for (HistoricDecisionInputInstance inputInstanceEntity : historicDecisionInstance.getInputs()) {
                result.add(inputInstanceEntity.getId());
            }
        }
        Assert.assertEquals((long)5L, (long)result.size());
        return result;
    }

    private List<String> collectHistoricDecisionOutputIds(List<HistoricDecisionInstance> historicDecisionInstances) {
        ArrayList<String> result = new ArrayList<String>();
        for (HistoricDecisionInstance historicDecisionInstance : historicDecisionInstances) {
            for (HistoricDecisionOutputInstance outputInstanceEntity : historicDecisionInstance.getOutputs()) {
                result.add(outputInstanceEntity.getId());
            }
        }
        Assert.assertEquals((long)5L, (long)result.size());
        return result;
    }

    private List<String> prepareHistoricProcesses() {
        return this.prepareHistoricProcesses(ONE_TASK_PROCESS);
    }

    private List<String> prepareHistoricProcesses(String businessKey) {
        return this.prepareHistoricProcesses(businessKey, null);
    }

    private List<String> prepareHistoricProcesses(String businessKey, VariableMap variables) {
        return this.prepareHistoricProcesses(businessKey, variables, 5);
    }

    private List<String> prepareHistoricProcesses(String businessKey, VariableMap variables, Integer processInstanceCount) {
        ArrayList<String> processInstanceIds = new ArrayList<String>();
        for (int i = 0; i < processInstanceCount; ++i) {
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(businessKey, (Map)variables);
            processInstanceIds.add(processInstance.getId());
        }
        return processInstanceIds;
    }

    private void verifyByteArraysWereRemoved(final String ... errorDetailsByteArrayIds) {
        this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                for (String errorDetailsByteArrayId : errorDetailsByteArrayIds) {
                    Assert.assertNull((Object)commandContext.getDbEntityManager().selectOne("selectByteArray", (Object)errorDetailsByteArrayId));
                }
                return null;
            }
        });
    }

    private VariableMap getVariables() {
        return Variables.createVariables().putValue("aVariableName", (Object)"aVariableValue").putValue("pojoVariableName", (Object)new TestPojo("someValue", 111.0));
    }
}

