/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.identity;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.digest.PasswordEncryptionException;
import org.camunda.bpm.engine.impl.digest.PasswordEncryptor;
import org.camunda.bpm.engine.impl.digest.PasswordManager;
import org.camunda.bpm.engine.impl.digest.SaltGenerator;
import org.camunda.bpm.engine.impl.digest.ShaHashDigest;
import org.camunda.bpm.engine.test.api.identity.util.MyConstantSaltGenerator;
import org.camunda.bpm.engine.test.api.identity.util.MyCustomPasswordEncryptor;
import org.camunda.bpm.engine.test.api.identity.util.MyCustomPasswordEncryptorCreatingPrefixThatCannotBeResolved;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class PasswordHashingTest {
    protected static ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected static ProcessEngineTestRule testRule = new ProcessEngineTestRule(engineRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)engineRule).around((TestRule)testRule);
    protected static final String PASSWORD = "password";
    protected static final String USER_NAME = "johndoe";
    protected static final String ALGORITHM_NAME = "awesome";
    protected IdentityService identityService;
    protected RuntimeService runtimeService;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected PasswordEncryptor camundaDefaultEncryptor;
    protected List<PasswordEncryptor> camundaDefaultPasswordChecker;
    protected SaltGenerator camundaDefaultSaltGenerator;

    @Before
    public void initialize() {
        this.runtimeService = engineRule.getRuntimeService();
        this.identityService = engineRule.getIdentityService();
        this.processEngineConfiguration = engineRule.getProcessEngineConfiguration();
        this.camundaDefaultEncryptor = this.processEngineConfiguration.getPasswordEncryptor();
        this.camundaDefaultPasswordChecker = this.processEngineConfiguration.getCustomPasswordChecker();
        this.camundaDefaultSaltGenerator = this.processEngineConfiguration.getSaltGenerator();
    }

    @After
    public void cleanUp() {
        this.removeAllUser();
        this.resetEngineConfiguration();
    }

    protected void removeAllUser() {
        List list = this.identityService.createUserQuery().list();
        for (User user : list) {
            this.identityService.deleteUser(user.getId());
        }
    }

    protected void resetEngineConfiguration() {
        this.setEncryptors(this.camundaDefaultEncryptor, this.camundaDefaultPasswordChecker);
        this.processEngineConfiguration.setSaltGenerator(this.camundaDefaultSaltGenerator);
    }

    @Test
    public void saltHashingOnHashedPasswordWithoutSaltThrowsNoError() {
        this.processEngineConfiguration.setSaltGenerator((SaltGenerator)new MyConstantSaltGenerator(null));
        User user = this.identityService.newUser(USER_NAME);
        user.setPassword(PASSWORD);
        this.identityService.saveUser(user);
        MatcherAssert.assertThat((Object)this.identityService.checkPassword(USER_NAME, PASSWORD), (Matcher)Is.is((Object)true));
    }

    @Test
    public void enteringTheSamePasswordShouldProduceTwoDifferentEncryptedPassword() {
        User user1 = this.identityService.newUser(USER_NAME);
        user1.setPassword(PASSWORD);
        this.identityService.saveUser(user1);
        User user2 = this.identityService.newUser("kermit");
        user2.setPassword(PASSWORD);
        this.identityService.saveUser(user2);
        MatcherAssert.assertThat((Object)user1.getPassword(), (Matcher)Is.is((Matcher)IsNot.not((Object)user2.getPassword())));
    }

    @Test
    public void ensurePasswordIsCorrectlyHashedWithSHA1() {
        this.setDefaultEncryptor((PasswordEncryptor)new ShaHashDigest());
        this.processEngineConfiguration.setSaltGenerator((SaltGenerator)new MyConstantSaltGenerator("12345678910"));
        User user = this.identityService.newUser(USER_NAME);
        user.setPassword(PASSWORD);
        this.identityService.saveUser(user);
        user = (User)this.identityService.createUserQuery().userId(USER_NAME).singleResult();
        MatcherAssert.assertThat((Object)user.getPassword(), (Matcher)Is.is((Object)"{SHA}n3fE9/7XOmgD3BkeJlC+JLyb/Qg="));
    }

    @Test
    public void ensurePasswordIsCorrectlyHashedWithSHA512() {
        this.processEngineConfiguration.setSaltGenerator((SaltGenerator)new MyConstantSaltGenerator("12345678910"));
        User user = this.identityService.newUser(USER_NAME);
        user.setPassword(PASSWORD);
        this.identityService.saveUser(user);
        user = (User)this.identityService.createUserQuery().userId(USER_NAME).singleResult();
        MatcherAssert.assertThat((Object)user.getPassword(), (Matcher)Is.is((Object)"{SHA-512}sM1U4nCzoDbdUugvJ7dJ6rLc7t1ZPPsnAbUpTqi5nXCYp7PTZCHExuzjoxLLYoUKGd637jKqT8d9tpsZs3K5+g=="));
    }

    @Test
    public void twoEncryptorsWithSamePrefixThrowError() {
        LinkedList<PasswordEncryptor> additionalEncryptorsForPasswordChecking = new LinkedList<PasswordEncryptor>();
        additionalEncryptorsForPasswordChecking.add((PasswordEncryptor)new ShaHashDigest());
        ShaHashDigest defaultEncryptor = new ShaHashDigest();
        this.thrown.expect(PasswordEncryptionException.class);
        this.thrown.expectMessage("Hash algorithm with the name 'SHA' was already added");
        this.setEncryptors((PasswordEncryptor)defaultEncryptor, additionalEncryptorsForPasswordChecking);
    }

    @Test
    public void prefixThatCannotBeResolvedThrowsError() {
        this.setDefaultEncryptor(new MyCustomPasswordEncryptorCreatingPrefixThatCannotBeResolved());
        User user = this.identityService.newUser(USER_NAME);
        user.setPassword(PASSWORD);
        this.identityService.saveUser(user);
        user = (User)this.identityService.createUserQuery().userId(USER_NAME).singleResult();
        this.thrown.expect(PasswordEncryptionException.class);
        this.thrown.expectMessage("Could not resolve hash algorithm name of a hashed password");
        this.identityService.checkPassword(user.getId(), PASSWORD);
    }

    @Test
    public void plugInCustomPasswordEncryptor() {
        this.setEncryptors(new MyCustomPasswordEncryptor(PASSWORD, ALGORITHM_NAME), Collections.<PasswordEncryptor>emptyList());
        User user = this.identityService.newUser(USER_NAME);
        user.setPassword(PASSWORD);
        this.identityService.saveUser(user);
        user = (User)this.identityService.createUserQuery().userId(USER_NAME).singleResult();
        MatcherAssert.assertThat((Object)user.getPassword(), (Matcher)Is.is((Object)"{awesome}xxx"));
    }

    @Test
    public void useSeveralCustomEncryptors() {
        this.processEngineConfiguration.setSaltGenerator((SaltGenerator)new MyConstantSaltGenerator("12345678910"));
        String userName1 = "Kermit";
        this.createUserWithEncryptor(userName1, new MyCustomPasswordEncryptor(PASSWORD, ALGORITHM_NAME));
        String userName2 = "Fozzie";
        String anotherAlgorithmName = "marvelousAlgorithm";
        this.createUserWithEncryptor(userName2, new MyCustomPasswordEncryptor(PASSWORD, anotherAlgorithmName));
        String userName3 = "Gonzo";
        this.createUserWithEncryptor(userName3, (PasswordEncryptor)new ShaHashDigest());
        LinkedList<PasswordEncryptor> additionalEncryptorsForPasswordChecking = new LinkedList<PasswordEncryptor>();
        additionalEncryptorsForPasswordChecking.add(new MyCustomPasswordEncryptor(PASSWORD, ALGORITHM_NAME));
        additionalEncryptorsForPasswordChecking.add(new MyCustomPasswordEncryptor(PASSWORD, anotherAlgorithmName));
        ShaHashDigest defaultEncryptor = new ShaHashDigest();
        this.setEncryptors((PasswordEncryptor)defaultEncryptor, additionalEncryptorsForPasswordChecking);
        User user1 = (User)this.identityService.createUserQuery().userId(userName1).singleResult();
        User user2 = (User)this.identityService.createUserQuery().userId(userName2).singleResult();
        User user3 = (User)this.identityService.createUserQuery().userId(userName3).singleResult();
        MatcherAssert.assertThat((Object)user1.getPassword(), (Matcher)Is.is((Object)"{awesome}xxx"));
        MatcherAssert.assertThat((Object)user2.getPassword(), (Matcher)Is.is((Object)("{" + anotherAlgorithmName + "}xxx")));
        MatcherAssert.assertThat((Object)user3.getPassword(), (Matcher)Is.is((Object)"{SHA}n3fE9/7XOmgD3BkeJlC+JLyb/Qg="));
    }

    protected void createUserWithEncryptor(String userName, PasswordEncryptor encryptor) {
        this.setEncryptors(encryptor, Collections.<PasswordEncryptor>emptyList());
        User user = this.identityService.newUser(userName);
        user.setPassword(PASSWORD);
        this.identityService.saveUser(user);
    }

    protected void setDefaultEncryptor(PasswordEncryptor defaultEncryptor) {
        this.setEncryptors(defaultEncryptor, Collections.<PasswordEncryptor>emptyList());
    }

    protected void setEncryptors(PasswordEncryptor defaultEncryptor, List<PasswordEncryptor> additionalEncryptorsForPasswordChecking) {
        this.processEngineConfiguration.setPasswordManager(new PasswordManager(defaultEncryptor, additionalEncryptorsForPasswordChecking));
    }
}

