/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BusinessRuleTaskBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyBusinessRuleTaskTest
extends PluggableProcessEngineTestCase {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final String DMN_FILE = "org/camunda/bpm/engine/test/api/multitenancy/simpleDecisionTable.dmn";
    protected static final String DMN_FILE_VERSION_TWO = "org/camunda/bpm/engine/test/api/multitenancy/simpleDecisionTable_v2.dmn";
    protected static final String RESULT_OF_VERSION_ONE = "A";
    protected static final String RESULT_OF_VERSION_TWO = "C";

    public void testEvaluateDecisionWithDeploymentBinding() {
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefBinding("deployment")).camundaMapDecisionResult("singleEntry")).camundaResultVariable("decisionVar")).camundaAsyncAfter()).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, DMN_FILE, process);
        this.deploymentForTenant(TENANT_TWO, DMN_FILE_VERSION_TWO, process);
        ProcessInstance processInstanceOne = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).processDefinitionTenantId(TENANT_ONE).execute();
        ProcessInstance processInstanceTwo = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).processDefinitionTenantId(TENANT_TWO).execute();
        Assert.assertThat((Object)((String)this.runtimeService.getVariable(processInstanceOne.getId(), "decisionVar")), (Matcher)CoreMatchers.is((Object)RESULT_OF_VERSION_ONE));
        Assert.assertThat((Object)((String)this.runtimeService.getVariable(processInstanceTwo.getId(), "decisionVar")), (Matcher)CoreMatchers.is((Object)RESULT_OF_VERSION_TWO));
    }

    public void testEvaluateDecisionWithLatestBindingSameVersion() {
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefBinding("latest")).camundaMapDecisionResult("singleEntry")).camundaResultVariable("decisionVar")).camundaAsyncAfter()).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, DMN_FILE, process);
        this.deploymentForTenant(TENANT_TWO, DMN_FILE_VERSION_TWO, process);
        ProcessInstance processInstanceOne = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).processDefinitionTenantId(TENANT_ONE).execute();
        ProcessInstance processInstanceTwo = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).processDefinitionTenantId(TENANT_TWO).execute();
        Assert.assertThat((Object)((String)this.runtimeService.getVariable(processInstanceOne.getId(), "decisionVar")), (Matcher)CoreMatchers.is((Object)RESULT_OF_VERSION_ONE));
        Assert.assertThat((Object)((String)this.runtimeService.getVariable(processInstanceTwo.getId(), "decisionVar")), (Matcher)CoreMatchers.is((Object)RESULT_OF_VERSION_TWO));
    }

    public void testEvaluateDecisionWithLatestBindingDifferentVersions() {
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefBinding("latest")).camundaMapDecisionResult("singleEntry")).camundaResultVariable("decisionVar")).camundaAsyncAfter()).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, DMN_FILE, process);
        this.deploymentForTenant(TENANT_TWO, DMN_FILE, process);
        this.deploymentForTenant(TENANT_TWO, new String[]{DMN_FILE_VERSION_TWO});
        ProcessInstance processInstanceOne = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).processDefinitionTenantId(TENANT_ONE).execute();
        ProcessInstance processInstanceTwo = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).processDefinitionTenantId(TENANT_TWO).execute();
        Assert.assertThat((Object)((String)this.runtimeService.getVariable(processInstanceOne.getId(), "decisionVar")), (Matcher)CoreMatchers.is((Object)RESULT_OF_VERSION_ONE));
        Assert.assertThat((Object)((String)this.runtimeService.getVariable(processInstanceTwo.getId(), "decisionVar")), (Matcher)CoreMatchers.is((Object)RESULT_OF_VERSION_TWO));
    }

    public void testEvaluateDecisionWithVersionBinding() {
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefBinding("version")).camundaDecisionRefVersion("1")).camundaMapDecisionResult("singleEntry")).camundaResultVariable("decisionVar")).camundaAsyncAfter()).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, DMN_FILE, process);
        this.deploymentForTenant(TENANT_ONE, new String[]{DMN_FILE_VERSION_TWO});
        this.deploymentForTenant(TENANT_TWO, DMN_FILE_VERSION_TWO, process);
        this.deploymentForTenant(TENANT_TWO, new String[]{DMN_FILE});
        ProcessInstance processInstanceOne = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).processDefinitionTenantId(TENANT_ONE).execute();
        ProcessInstance processInstanceTwo = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).processDefinitionTenantId(TENANT_TWO).execute();
        Assert.assertThat((Object)((String)this.runtimeService.getVariable(processInstanceOne.getId(), "decisionVar")), (Matcher)CoreMatchers.is((Object)RESULT_OF_VERSION_ONE));
        Assert.assertThat((Object)((String)this.runtimeService.getVariable(processInstanceTwo.getId(), "decisionVar")), (Matcher)CoreMatchers.is((Object)RESULT_OF_VERSION_TWO));
    }

    public void testFailEvaluateDecisionFromOtherTenantWithDeploymentBinding() {
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefBinding("deployment")).camundaAsyncAfter()).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{process});
        this.deploymentForTenant(TENANT_TWO, new String[]{DMN_FILE});
        try {
            this.runtimeService.createProcessInstanceByKey("process").processDefinitionTenantId(TENANT_ONE).execute();
            MultiTenancyBusinessRuleTaskTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no decision definition deployed with key = 'decision'"));
        }
    }

    public void testFailEvaluateDecisionFromOtherTenantWithLatestBinding() {
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefBinding("latest")).camundaAsyncAfter()).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{process});
        this.deploymentForTenant(TENANT_TWO, new String[]{DMN_FILE});
        try {
            this.runtimeService.createProcessInstanceByKey("process").processDefinitionTenantId(TENANT_ONE).execute();
            MultiTenancyBusinessRuleTaskTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no decision definition deployed with key 'decision'"));
        }
    }

    public void testFailEvaluateDecisionFromOtherTenantWithVersionBinding() {
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefBinding("version")).camundaDecisionRefVersion("2")).camundaAsyncAfter()).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, DMN_FILE, process);
        this.deploymentForTenant(TENANT_TWO, new String[]{DMN_FILE});
        this.deploymentForTenant(TENANT_TWO, new String[]{DMN_FILE});
        try {
            this.runtimeService.createProcessInstanceByKey("process").processDefinitionTenantId(TENANT_ONE).execute();
            MultiTenancyBusinessRuleTaskTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no decision definition deployed with key = 'decision', version = '2' and tenant-id 'tenant1'"));
        }
    }

    public void testEvaluateDecisionTenantIdConstant() {
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefBinding("latest")).camundaDecisionRefTenantId(TENANT_ONE)).camundaMapDecisionResult("singleEntry")).camundaResultVariable("decisionVar")).camundaAsyncAfter()).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, new String[]{DMN_FILE});
        this.deploymentForTenant(TENANT_TWO, new String[]{DMN_FILE_VERSION_TWO});
        this.deployment(new BpmnModelInstance[]{process});
        ProcessInstance processInstanceOne = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).execute();
        Assert.assertThat((Object)((String)this.runtimeService.getVariable(processInstanceOne.getId(), "decisionVar")), (Matcher)CoreMatchers.is((Object)RESULT_OF_VERSION_ONE));
    }

    public void testEvaluateDecisionWithoutTenantIdConstant() {
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefBinding("latest")).camundaDecisionRefTenantId("${null}")).camundaMapDecisionResult("singleEntry")).camundaResultVariable("decisionVar")).camundaAsyncAfter()).endEvent().done();
        this.deployment(new String[]{DMN_FILE});
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{process});
        this.deploymentForTenant(TENANT_TWO, new String[]{DMN_FILE_VERSION_TWO});
        ProcessInstance processInstanceOne = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).execute();
        Assert.assertThat((Object)((String)this.runtimeService.getVariable(processInstanceOne.getId(), "decisionVar")), (Matcher)CoreMatchers.is((Object)RESULT_OF_VERSION_ONE));
    }

    public void testEvaluateDecisionTenantIdExpression() {
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefBinding("latest")).camundaDecisionRefTenantId("${'tenant1'}")).camundaMapDecisionResult("singleEntry")).camundaResultVariable("decisionVar")).camundaAsyncAfter()).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, new String[]{DMN_FILE});
        this.deploymentForTenant(TENANT_TWO, new String[]{DMN_FILE_VERSION_TWO});
        this.deployment(new BpmnModelInstance[]{process});
        ProcessInstance processInstanceOne = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).execute();
        Assert.assertThat((Object)((String)this.runtimeService.getVariable(processInstanceOne.getId(), "decisionVar")), (Matcher)CoreMatchers.is((Object)RESULT_OF_VERSION_ONE));
    }

    public void testEvaluateDecisionTenantIdCompositeExpression() {
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefBinding("latest")).camundaDecisionRefTenantId("tenant${'1'}")).camundaMapDecisionResult("singleEntry")).camundaResultVariable("decisionVar")).camundaAsyncAfter()).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, new String[]{DMN_FILE});
        this.deploymentForTenant(TENANT_TWO, new String[]{DMN_FILE_VERSION_TWO});
        this.deployment(new BpmnModelInstance[]{process});
        ProcessInstance processInstanceOne = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).execute();
        Assert.assertThat((Object)((String)this.runtimeService.getVariable(processInstanceOne.getId(), "decisionVar")), (Matcher)CoreMatchers.is((Object)RESULT_OF_VERSION_ONE));
    }
}

