/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.tenantcheck;

import java.util.Arrays;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.task.DelegationState;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyTaskServiceCmdsTenantCheckTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String PROCESS_DEFINITION_KEY = "oneTaskProcess";
    protected static final BpmnModelInstance ONE_TASK_PROCESS = Bpmn.createExecutableProcess((String)"oneTaskProcess").startEvent().userTask().endEvent().done();
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected TaskService taskService;
    protected IdentityService identityService;
    protected Task task;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void init() {
        this.testRule.deployForTenant(TENANT_ONE, ONE_TASK_PROCESS);
        this.engineRule.getRuntimeService().startProcessInstanceByKey(PROCESS_DEFINITION_KEY).getId();
        this.task = (Task)this.engineRule.getTaskService().createTaskQuery().singleResult();
        this.taskService = this.engineRule.getTaskService();
        this.identityService = this.engineRule.getIdentityService();
    }

    @Test
    public void saveTaskWithAuthenticatedTenant() {
        this.task = this.taskService.newTask("newTask");
        this.task.setTenantId(TENANT_ONE);
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.taskService.saveTask(this.task);
        Assert.assertThat((Object)this.taskService.createTaskQuery().taskId(this.task.getId()).count(), (Matcher)CoreMatchers.is((Object)1L));
        this.taskService.deleteTask(this.task.getId(), true);
    }

    @Test
    public void saveTaskWithNoAuthenticatedTenant() {
        this.task = this.taskService.newTask("newTask");
        this.task.setTenantId(TENANT_ONE);
        this.identityService.setAuthentication("aUserId", null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot create the task '" + this.task.getId() + "' because it belongs to no authenticated tenant.");
        this.taskService.saveTask(this.task);
    }

    @Test
    public void saveTaskWithDisabledTenantCheck() {
        this.task = this.taskService.newTask("newTask");
        this.task.setTenantId(TENANT_ONE);
        this.identityService.setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.taskService.saveTask(this.task);
        Assert.assertThat((Object)this.taskService.createTaskQuery().taskId(this.task.getId()).count(), (Matcher)CoreMatchers.is((Object)1L));
        this.taskService.deleteTask(this.task.getId(), true);
    }

    @Test
    public void updateTaskWithAuthenticatedTenant() {
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.task.setAssignee("aUser");
        this.taskService.saveTask(this.task);
        Assert.assertThat((Object)this.taskService.createTaskQuery().taskAssignee("aUser").count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void updateTaskWithNoAuthenticatedTenant() {
        this.task.setAssignee("aUser");
        this.identityService.setAuthentication("aUserId", null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot assign the task '" + this.task.getId() + "' because it belongs to no authenticated tenant.");
        this.taskService.saveTask(this.task);
    }

    @Test
    public void updateTaskWithDisabledTenantCheck() {
        this.task.setAssignee("aUser");
        this.identityService.setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.taskService.saveTask(this.task);
        Assert.assertThat((Object)this.taskService.createTaskQuery().taskAssignee("aUser").count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void claimTaskWithAuthenticatedTenant() {
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.taskService.claim(this.task.getId(), "bUser");
        Assert.assertThat((Object)this.taskService.createTaskQuery().taskAssignee("bUser").count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void claimTaskWithNoAuthenticatedTenant() {
        this.identityService.setAuthentication("aUserId", null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot work on task '" + this.task.getId() + "' because it belongs to no authenticated tenant.");
        this.taskService.claim(this.task.getId(), "bUser");
    }

    @Test
    public void claimTaskWithDisableTenantCheck() {
        this.identityService.setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.taskService.claim(this.task.getId(), "bUser");
        Assert.assertThat((Object)this.taskService.createTaskQuery().taskAssignee("bUser").count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void completeTaskWithAuthenticatedTenant() {
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.taskService.complete(this.task.getId());
        Assert.assertThat((Object)this.taskService.createTaskQuery().taskId(this.task.getId()).active().count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void completeTaskWithNoAuthenticatedTenant() {
        this.identityService.setAuthentication("aUserId", null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot work on task '" + this.task.getId() + "' because it belongs to no authenticated tenant.");
        this.taskService.complete(this.task.getId());
    }

    @Test
    public void completeWithDisabledTenantCheck() {
        this.identityService.setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.taskService.complete(this.task.getId());
        Assert.assertThat((Object)this.taskService.createTaskQuery().taskId(this.task.getId()).active().count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void delegateTaskWithAuthenticatedTenant() {
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.taskService.delegateTask(this.task.getId(), "demo");
        Assert.assertThat((Object)this.taskService.createTaskQuery().taskAssignee("demo").count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void delegateTaskWithNoAuthenticatedTenant() {
        this.identityService.setAuthentication("aUserId", null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot assign the task '" + this.task.getId() + "' because it belongs to no authenticated tenant.");
        this.taskService.delegateTask(this.task.getId(), "demo");
    }

    @Test
    public void delegateTaskWithDisabledTenantCheck() {
        this.identityService.setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.taskService.delegateTask(this.task.getId(), "demo");
        Assert.assertThat((Object)this.taskService.createTaskQuery().taskAssignee("demo").count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void resolveTaskWithAuthenticatedTenant() {
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.taskService.resolveTask(this.task.getId());
        Assert.assertThat((Object)this.taskService.createTaskQuery().taskDelegationState(DelegationState.RESOLVED).taskId(this.task.getId()).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void resolveTaskWithNoAuthenticatedTenant() {
        this.identityService.setAuthentication("aUserId", null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot work on task '" + this.task.getId() + "' because it belongs to no authenticated tenant.");
        this.taskService.resolveTask(this.task.getId());
    }

    @Test
    public void resolveTaskWithDisableTenantCheck() {
        this.identityService.setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.taskService.resolveTask(this.task.getId());
        Assert.assertThat((Object)this.taskService.createTaskQuery().taskDelegationState(DelegationState.RESOLVED).taskId(this.task.getId()).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void setPriorityForTaskWithAuthenticatedTenant() {
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.taskService.setPriority(this.task.getId(), 1);
        Assert.assertThat((Object)this.taskService.createTaskQuery().taskPriority(Integer.valueOf(1)).taskId(this.task.getId()).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void setPriorityForTaskWithNoAuthenticatedTenant() {
        this.identityService.setAuthentication("aUserId", null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot assign the task '" + this.task.getId() + "' because it belongs to no authenticated tenant.");
        this.taskService.setPriority(this.task.getId(), 1);
    }

    @Test
    public void setPriorityForTaskWithDisabledTenantCheck() {
        this.identityService.setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.taskService.setPriority(this.task.getId(), 1);
        Assert.assertThat((Object)this.taskService.createTaskQuery().taskPriority(Integer.valueOf(1)).taskId(this.task.getId()).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void deleteTaskWithAuthenticatedTenant() {
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.task = this.createTaskforTenant();
        Assert.assertThat((Object)this.taskService.createTaskQuery().taskId(this.task.getId()).count(), (Matcher)CoreMatchers.is((Object)1L));
        this.taskService.deleteTask(this.task.getId(), true);
        Assert.assertThat((Object)this.taskService.createTaskQuery().taskId(this.task.getId()).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void deleteTaskWithNoAuthenticatedTenant() {
        try {
            this.task = this.createTaskforTenant();
            this.identityService.setAuthentication("aUserId", null);
            this.thrown.expect(ProcessEngineException.class);
            this.thrown.expectMessage("Cannot delete the task '" + this.task.getId() + "' because it belongs to no authenticated tenant.");
            this.taskService.deleteTask(this.task.getId(), true);
        }
        finally {
            this.identityService.clearAuthentication();
            this.taskService.deleteTask(this.task.getId(), true);
        }
    }

    @Test
    public void deleteTaskWithDisabledTenantCheck() {
        this.identityService.setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.task = this.createTaskforTenant();
        Assert.assertThat((Object)this.taskService.createTaskQuery().taskId(this.task.getId()).count(), (Matcher)CoreMatchers.is((Object)1L));
        this.taskService.deleteTask(this.task.getId(), true);
        Assert.assertThat((Object)this.taskService.createTaskQuery().taskId(this.task.getId()).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    protected Task createTaskforTenant() {
        Task newTask = this.taskService.newTask("newTask");
        newTask.setTenantId(TENANT_ONE);
        this.taskService.saveTask(newTask);
        return newTask;
    }
}

