/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.IncidentQuery;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.FailingDelegate;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class IncidentQueryTest {
    public static String PROCESS_DEFINITION_KEY = "oneFailingServiceTaskProcess";
    public static BpmnModelInstance FAILING_SERVICE_TASK_MODEL = ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent("start").serviceTask("task").camundaAsyncBefore()).camundaClass(FailingDelegate.class.getName())).endEvent("end").done();
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);
    private List<String> processInstanceIds;
    protected RuntimeService runtimeService;
    protected ManagementService managementService;

    @Before
    public void initServices() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
    }

    @Before
    public void startProcessInstances() throws Exception {
        this.testHelper.deploy(FAILING_SERVICE_TASK_MODEL);
        this.processInstanceIds = new ArrayList<String>();
        for (int i = 0; i < 4; ++i) {
            this.processInstanceIds.add(this.engineRule.getRuntimeService().startProcessInstanceByKey(PROCESS_DEFINITION_KEY, i + "").getId());
        }
        this.testHelper.executeAvailableJobs();
    }

    @Test
    public void testQuery() {
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        Assert.assertEquals((long)4L, (long)query.count());
        List incidents = query.list();
        Assert.assertFalse((boolean)incidents.isEmpty());
        Assert.assertEquals((long)4L, (long)incidents.size());
    }

    @Test
    public void testQueryByIncidentType() {
        IncidentQuery query = this.runtimeService.createIncidentQuery().incidentType("failedJob");
        Assert.assertEquals((long)4L, (long)query.count());
        List incidents = query.list();
        Assert.assertFalse((boolean)incidents.isEmpty());
        Assert.assertEquals((long)4L, (long)incidents.size());
    }

    @Test
    public void testQueryByInvalidIncidentType() {
        IncidentQuery query = this.runtimeService.createIncidentQuery().incidentType("invalid");
        Assert.assertEquals((long)0L, (long)query.count());
        List incidents = query.list();
        Assert.assertTrue((boolean)incidents.isEmpty());
        Incident incident = (Incident)query.singleResult();
        Assert.assertNull((Object)incident);
    }

    @Test
    public void testQueryByIncidentMessage() {
        IncidentQuery query = this.runtimeService.createIncidentQuery().incidentMessage("Expected_exception.");
        Assert.assertEquals((long)4L, (long)query.count());
        List incidents = query.list();
        Assert.assertFalse((boolean)incidents.isEmpty());
        Assert.assertEquals((long)4L, (long)incidents.size());
    }

    @Test
    public void testQueryByInvalidIncidentMessage() {
        IncidentQuery query = this.runtimeService.createIncidentQuery().incidentMessage("invalid");
        Assert.assertEquals((long)0L, (long)query.count());
        List incidents = query.list();
        Assert.assertTrue((boolean)incidents.isEmpty());
        Incident incident = (Incident)query.singleResult();
        Assert.assertNull((Object)incident);
    }

    public void testQueryByProcessDefinitionId() {
        String processDefinitionId = ((ProcessDefinition)this.engineRule.getRepositoryService().createProcessDefinitionQuery().singleResult()).getId();
        IncidentQuery query = this.runtimeService.createIncidentQuery().processDefinitionId(processDefinitionId);
        Assert.assertEquals((long)4L, (long)query.count());
        List incidents = query.list();
        Assert.assertFalse((boolean)incidents.isEmpty());
        Assert.assertEquals((long)4L, (long)incidents.size());
    }

    @Test
    public void testQueryByInvalidProcessDefinitionId() {
        IncidentQuery query = this.runtimeService.createIncidentQuery().processDefinitionId("invalid");
        Assert.assertEquals((long)0L, (long)query.count());
        List incidents = query.list();
        Assert.assertTrue((boolean)incidents.isEmpty());
        Incident incident = (Incident)query.singleResult();
        Assert.assertNull((Object)incident);
    }

    public void testQueryByProcessInstanceId() {
        IncidentQuery query = this.runtimeService.createIncidentQuery().processInstanceId(this.processInstanceIds.get(0));
        Assert.assertEquals((long)1L, (long)query.count());
        List incidents = query.list();
        Assert.assertFalse((boolean)incidents.isEmpty());
        Assert.assertEquals((long)1L, (long)incidents.size());
        Incident incident = (Incident)query.singleResult();
        Assert.assertNotNull((Object)incident);
    }

    @Test
    public void testQueryByInvalidProcessInstanceId() {
        IncidentQuery query = this.runtimeService.createIncidentQuery().processInstanceId("invalid");
        Assert.assertEquals((long)0L, (long)query.count());
        List incidents = query.list();
        Assert.assertTrue((boolean)incidents.isEmpty());
        Incident incident = (Incident)query.singleResult();
        Assert.assertNull((Object)incident);
    }

    @Test
    public void testQueryByIncidentId() {
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(this.processInstanceIds.get(0)).singleResult();
        Assert.assertNotNull((Object)incident);
        IncidentQuery query = this.runtimeService.createIncidentQuery().incidentId(incident.getId());
        Assert.assertEquals((long)1L, (long)query.count());
        List incidents = query.list();
        Assert.assertFalse((boolean)incidents.isEmpty());
        Assert.assertEquals((long)1L, (long)incidents.size());
    }

    @Test
    public void testQueryByInvalidIncidentId() {
        IncidentQuery query = this.runtimeService.createIncidentQuery().incidentId("invalid");
        Assert.assertEquals((long)0L, (long)query.count());
        List incidents = query.list();
        Assert.assertTrue((boolean)incidents.isEmpty());
        Incident incident = (Incident)query.singleResult();
        Assert.assertNull((Object)incident);
    }

    public void testQueryByExecutionId() {
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(this.processInstanceIds.get(0)).singleResult();
        Assert.assertNotNull((Object)execution);
        IncidentQuery query = this.runtimeService.createIncidentQuery().executionId(execution.getId());
        Assert.assertEquals((long)1L, (long)query.count());
        List incidents = query.list();
        Assert.assertFalse((boolean)incidents.isEmpty());
        Assert.assertEquals((long)1L, (long)incidents.size());
    }

    @Test
    public void testQueryByInvalidExecutionId() {
        IncidentQuery query = this.runtimeService.createIncidentQuery().executionId("invalid");
        Assert.assertEquals((long)0L, (long)query.count());
        List incidents = query.list();
        Assert.assertTrue((boolean)incidents.isEmpty());
        Incident incident = (Incident)query.singleResult();
        Assert.assertNull((Object)incident);
    }

    public void testQueryByActivityId() {
        IncidentQuery query = this.runtimeService.createIncidentQuery().activityId("theServiceTask");
        Assert.assertEquals((long)4L, (long)query.count());
        List incidents = query.list();
        Assert.assertFalse((boolean)incidents.isEmpty());
        Assert.assertEquals((long)4L, (long)incidents.size());
    }

    @Test
    public void testQueryByInvalidActivityId() {
        IncidentQuery query = this.runtimeService.createIncidentQuery().activityId("invalid");
        Assert.assertEquals((long)0L, (long)query.count());
        List incidents = query.list();
        Assert.assertTrue((boolean)incidents.isEmpty());
        Incident incident = (Incident)query.singleResult();
        Assert.assertNull((Object)incident);
    }

    @Test
    public void testQueryByConfiguration() {
        String jobId = ((Job)this.managementService.createJobQuery().processInstanceId(this.processInstanceIds.get(0)).singleResult()).getId();
        IncidentQuery query = this.runtimeService.createIncidentQuery().configuration(jobId);
        Assert.assertEquals((long)1L, (long)query.count());
        List incidents = query.list();
        Assert.assertFalse((boolean)incidents.isEmpty());
        Assert.assertEquals((long)1L, (long)incidents.size());
    }

    @Test
    public void testQueryByInvalidConfiguration() {
        IncidentQuery query = this.runtimeService.createIncidentQuery().configuration("invalid");
        Assert.assertEquals((long)0L, (long)query.count());
        List incidents = query.list();
        Assert.assertTrue((boolean)incidents.isEmpty());
        Incident incident = (Incident)query.singleResult();
        Assert.assertNull((Object)incident);
    }

    @Test
    public void testQueryByCauseIncidentIdEqualsNull() {
        IncidentQuery query = this.runtimeService.createIncidentQuery().causeIncidentId(null);
        Assert.assertEquals((long)4L, (long)query.count());
        List incidents = query.list();
        Assert.assertFalse((boolean)incidents.isEmpty());
        Assert.assertEquals((long)4L, (long)incidents.size());
    }

    @Test
    public void testQueryByInvalidCauseIncidentId() {
        IncidentQuery query = this.runtimeService.createIncidentQuery().causeIncidentId("invalid");
        Assert.assertEquals((long)0L, (long)query.count());
        List incidents = query.list();
        Assert.assertTrue((boolean)incidents.isEmpty());
        Assert.assertEquals((long)0L, (long)incidents.size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/IncidentQueryTest.testQueryByCauseIncidentId.bpmn"})
    public void testQueryByCauseIncidentId() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callFailingProcess");
        this.testHelper.executeAvailableJobs();
        ProcessInstance subProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)subProcessInstance);
        Incident causeIncident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(subProcessInstance.getId()).singleResult();
        Assert.assertNotNull((Object)causeIncident);
        IncidentQuery query = this.runtimeService.createIncidentQuery().causeIncidentId(causeIncident.getId());
        Assert.assertEquals((long)2L, (long)query.count());
        List incidents = query.list();
        Assert.assertFalse((boolean)incidents.isEmpty());
        Assert.assertEquals((long)2L, (long)incidents.size());
    }

    @Test
    public void testQueryByRootCauseIncidentIdEqualsNull() {
        IncidentQuery query = this.runtimeService.createIncidentQuery().rootCauseIncidentId(null);
        Assert.assertEquals((long)4L, (long)query.count());
        List incidents = query.list();
        Assert.assertFalse((boolean)incidents.isEmpty());
        Assert.assertEquals((long)4L, (long)incidents.size());
    }

    @Test
    public void testQueryByRootInvalidCauseIncidentId() {
        IncidentQuery query = this.runtimeService.createIncidentQuery().rootCauseIncidentId("invalid");
        Assert.assertEquals((long)0L, (long)query.count());
        List incidents = query.list();
        Assert.assertTrue((boolean)incidents.isEmpty());
        Assert.assertEquals((long)0L, (long)incidents.size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/IncidentQueryTest.testQueryByRootCauseIncidentId.bpmn", "org/camunda/bpm/engine/test/api/runtime/IncidentQueryTest.testQueryByCauseIncidentId.bpmn"})
    public void testQueryByRootCauseIncidentId() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callFailingCallActivity");
        this.testHelper.executeAvailableJobs();
        ProcessInstance subProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)subProcessInstance);
        ProcessInstance failingSubProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(subProcessInstance.getId()).singleResult();
        Assert.assertNotNull((Object)subProcessInstance);
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(failingSubProcessInstance.getId()).singleResult();
        Assert.assertNotNull((Object)incident);
        IncidentQuery query = this.runtimeService.createIncidentQuery().rootCauseIncidentId(incident.getId());
        Assert.assertEquals((long)3L, (long)query.count());
        List incidents = query.list();
        Assert.assertFalse((boolean)incidents.isEmpty());
        Assert.assertEquals((long)3L, (long)incidents.size());
        try {
            query.singleResult();
            Assert.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByJobDefinitionId() {
        String processDefinitionId1 = this.testHelper.deployAndGetDefinition(FAILING_SERVICE_TASK_MODEL).getId();
        String processDefinitionId2 = this.testHelper.deployAndGetDefinition(FAILING_SERVICE_TASK_MODEL).getId();
        this.runtimeService.startProcessInstanceById(processDefinitionId1);
        this.runtimeService.startProcessInstanceById(processDefinitionId2);
        this.testHelper.executeAvailableJobs();
        String jobDefinitionId1 = ((Job)this.managementService.createJobQuery().processDefinitionId(processDefinitionId1).singleResult()).getJobDefinitionId();
        String jobDefinitionId2 = ((Job)this.managementService.createJobQuery().processDefinitionId(processDefinitionId2).singleResult()).getJobDefinitionId();
        IncidentQuery query = this.runtimeService.createIncidentQuery().jobDefinitionIdIn(new String[]{jobDefinitionId1, jobDefinitionId2});
        Assert.assertEquals((long)2L, (long)query.list().size());
        Assert.assertEquals((long)2L, (long)query.count());
        query = this.runtimeService.createIncidentQuery().jobDefinitionIdIn(new String[]{jobDefinitionId1});
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
        query = this.runtimeService.createIncidentQuery().jobDefinitionIdIn(new String[]{jobDefinitionId2});
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Test
    public void testQueryByUnknownJobDefinitionId() {
        IncidentQuery query = this.runtimeService.createIncidentQuery().jobDefinitionIdIn(new String[]{"unknown"});
        Assert.assertEquals((long)0L, (long)query.count());
        List incidents = query.list();
        Assert.assertEquals((long)0L, (long)incidents.size());
    }

    @Test
    public void testQueryByNullJobDefinitionId() {
        try {
            this.runtimeService.createIncidentQuery().jobDefinitionIdIn(new String[]{null});
            Assert.fail((String)"Should fail");
        }
        catch (NullValueException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"jobDefinitionIds contains null value"));
        }
    }

    @Test
    public void testQueryByNullJobDefinitionIds() {
        try {
            this.runtimeService.createIncidentQuery().jobDefinitionIdIn((String[])null);
            Assert.fail((String)"Should fail");
        }
        catch (NullValueException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"jobDefinitionIds is null"));
        }
    }

    @Test
    public void testQueryPaging() {
        Assert.assertEquals((long)4L, (long)this.runtimeService.createIncidentQuery().listPage(0, 4).size());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createIncidentQuery().listPage(2, 1).size());
        Assert.assertEquals((long)2L, (long)this.runtimeService.createIncidentQuery().listPage(1, 2).size());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createIncidentQuery().listPage(1, 4).size());
    }

    @Test
    public void testQuerySorting() {
        Assert.assertEquals((long)4L, (long)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByIncidentId().asc()).list().size());
        Assert.assertEquals((long)4L, (long)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByIncidentTimestamp().asc()).list().size());
        Assert.assertEquals((long)4L, (long)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByIncidentType().asc()).list().size());
        Assert.assertEquals((long)4L, (long)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByExecutionId().asc()).list().size());
        Assert.assertEquals((long)4L, (long)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByActivityId().asc()).list().size());
        Assert.assertEquals((long)4L, (long)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByProcessInstanceId().asc()).list().size());
        Assert.assertEquals((long)4L, (long)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByProcessDefinitionId().asc()).list().size());
        Assert.assertEquals((long)4L, (long)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByCauseIncidentId().asc()).list().size());
        Assert.assertEquals((long)4L, (long)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByRootCauseIncidentId().asc()).list().size());
        Assert.assertEquals((long)4L, (long)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByConfiguration().asc()).list().size());
        Assert.assertEquals((long)4L, (long)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByIncidentId().desc()).list().size());
        Assert.assertEquals((long)4L, (long)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByIncidentTimestamp().desc()).list().size());
        Assert.assertEquals((long)4L, (long)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByIncidentType().desc()).list().size());
        Assert.assertEquals((long)4L, (long)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByExecutionId().desc()).list().size());
        Assert.assertEquals((long)4L, (long)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByActivityId().desc()).list().size());
        Assert.assertEquals((long)4L, (long)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByProcessInstanceId().desc()).list().size());
        Assert.assertEquals((long)4L, (long)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByProcessDefinitionId().desc()).list().size());
        Assert.assertEquals((long)4L, (long)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByCauseIncidentId().desc()).list().size());
        Assert.assertEquals((long)4L, (long)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByRootCauseIncidentId().desc()).list().size());
        Assert.assertEquals((long)4L, (long)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByConfiguration().desc()).list().size());
    }
}

