/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class SetExternalTaskRetriesUserOperationLogTest {
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testRule);
    private static String PROCESS_DEFINITION_KEY = "oneExternalTaskProcess";
    private static String PROCESS_DEFINITION_KEY_2 = "twoExternalTaskWithPriorityProcess";
    protected RuntimeService runtimeService;
    protected ManagementService managementService;
    protected ExternalTaskService externalTaskService;
    protected static final Date START_DATE = new Date(1457326800000L);
    protected List<String> processInstanceIds;

    @Before
    public void initServices() {
        this.runtimeService = this.rule.getRuntimeService();
        this.externalTaskService = this.rule.getExternalTaskService();
        this.managementService = this.rule.getManagementService();
    }

    @Before
    public void deployTestProcesses() throws Exception {
        Deployment deployment = this.rule.getRepositoryService().createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/test/api/externaltask/externalTaskPriorityExpression.bpmn20.xml").deploy();
        this.rule.manageDeployment(deployment);
        RuntimeService runtimeService = this.rule.getRuntimeService();
        this.processInstanceIds = new ArrayList<String>();
        for (int i = 0; i < 4; ++i) {
            this.processInstanceIds.add(runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY, i + "").getId());
        }
        this.processInstanceIds.add(runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY_2).getId());
    }

    @Before
    public void setClock() {
        ClockUtil.setCurrentTime((Date)START_DATE);
    }

    @After
    public void resetClock() {
        ClockUtil.reset();
    }

    @After
    public void removeAllRunningAndHistoricBatches() {
        HistoryService historyService = this.rule.getHistoryService();
        ManagementService managementService = this.rule.getManagementService();
        for (Batch batch : managementService.createBatchQuery().list()) {
            managementService.deleteBatch(batch.getId(), true);
        }
        for (HistoricBatch historicBatch : historyService.createHistoricBatchQuery().list()) {
            historyService.deleteHistoricBatch(historicBatch.getId());
        }
    }

    @Test
    public void testLogCreationForOneExternalTaskId() {
        this.rule.getIdentityService().setAuthenticatedUserId("userId");
        ExternalTask externalTask = (ExternalTask)this.externalTaskService.createExternalTaskQuery().processInstanceId(this.processInstanceIds.get(0)).singleResult();
        this.externalTaskService.setRetries(externalTask.getId(), 5);
        this.rule.getIdentityService().clearAuthentication();
        List opLogEntries = this.rule.getHistoryService().createUserOperationLogQuery().list();
        Assert.assertEquals((long)1L, (long)opLogEntries.size());
        Map<String, UserOperationLogEntry> entries = this.asMap(opLogEntries);
        UserOperationLogEntry retriesEntry = entries.get("retries");
        Assert.assertNotNull((Object)retriesEntry);
        Assert.assertEquals((Object)"ProcessInstance", (Object)retriesEntry.getEntityType());
        Assert.assertEquals((Object)"SetExternalTaskRetries", (Object)retriesEntry.getOperationType());
        Assert.assertEquals((Object)externalTask.getProcessInstanceId(), (Object)retriesEntry.getProcessInstanceId());
        Assert.assertEquals((Object)externalTask.getProcessDefinitionId(), (Object)retriesEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)externalTask.getProcessDefinitionKey(), (Object)retriesEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)retriesEntry.getOrgValue());
        Assert.assertEquals((Object)"5", (Object)retriesEntry.getNewValue());
    }

    @Test
    public void testLogCreationSync() {
        this.rule.getIdentityService().setAuthenticatedUserId("userId");
        List list = this.externalTaskService.createExternalTaskQuery().list();
        ArrayList<String> externalTaskIds = new ArrayList<String>();
        for (ExternalTask task : list) {
            externalTaskIds.add(task.getId());
        }
        this.externalTaskService.setRetries(externalTaskIds, 5);
        this.rule.getIdentityService().clearAuthentication();
        List opLogEntries = this.rule.getHistoryService().createUserOperationLogQuery().list();
        Assert.assertEquals((long)3L, (long)opLogEntries.size());
        Map<String, UserOperationLogEntry> entries = this.asMap(opLogEntries);
        UserOperationLogEntry asyncEntry = entries.get("async");
        Assert.assertNotNull((Object)asyncEntry);
        Assert.assertEquals((Object)"ProcessInstance", (Object)asyncEntry.getEntityType());
        Assert.assertEquals((Object)"SetExternalTaskRetries", (Object)asyncEntry.getOperationType());
        Assert.assertNull((Object)asyncEntry.getProcessDefinitionId());
        Assert.assertNull((Object)asyncEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)asyncEntry.getProcessInstanceId());
        Assert.assertNull((Object)asyncEntry.getOrgValue());
        Assert.assertEquals((Object)"false", (Object)asyncEntry.getNewValue());
        UserOperationLogEntry numInstancesEntry = entries.get("nrOfInstances");
        Assert.assertNotNull((Object)numInstancesEntry);
        Assert.assertEquals((Object)"ProcessInstance", (Object)numInstancesEntry.getEntityType());
        Assert.assertEquals((Object)"SetExternalTaskRetries", (Object)numInstancesEntry.getOperationType());
        Assert.assertNull((Object)numInstancesEntry.getProcessDefinitionId());
        Assert.assertNull((Object)numInstancesEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)numInstancesEntry.getProcessInstanceId());
        Assert.assertNull((Object)numInstancesEntry.getOrgValue());
        Assert.assertEquals((Object)"6", (Object)numInstancesEntry.getNewValue());
        UserOperationLogEntry retriesEntry = entries.get("retries");
        Assert.assertNotNull((Object)retriesEntry);
        Assert.assertEquals((Object)"ProcessInstance", (Object)retriesEntry.getEntityType());
        Assert.assertEquals((Object)"SetExternalTaskRetries", (Object)retriesEntry.getOperationType());
        Assert.assertNull((Object)retriesEntry.getProcessDefinitionId());
        Assert.assertNull((Object)retriesEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)retriesEntry.getProcessInstanceId());
        Assert.assertNull((Object)retriesEntry.getOrgValue());
        Assert.assertEquals((Object)"5", (Object)retriesEntry.getNewValue());
        Assert.assertEquals((Object)asyncEntry.getOperationId(), (Object)retriesEntry.getOperationId());
    }

    @Test
    public void testLogCreationAsync() {
        this.rule.getIdentityService().setAuthenticatedUserId("userId");
        this.externalTaskService.setRetriesAsync(null, this.externalTaskService.createExternalTaskQuery(), 5);
        this.rule.getIdentityService().clearAuthentication();
        List opLogEntries = this.rule.getHistoryService().createUserOperationLogQuery().list();
        Assert.assertEquals((long)3L, (long)opLogEntries.size());
        Map<String, UserOperationLogEntry> entries = this.asMap(opLogEntries);
        UserOperationLogEntry asyncEntry = entries.get("async");
        Assert.assertNotNull((Object)asyncEntry);
        Assert.assertEquals((Object)"ProcessInstance", (Object)asyncEntry.getEntityType());
        Assert.assertEquals((Object)"SetExternalTaskRetries", (Object)asyncEntry.getOperationType());
        Assert.assertNull((Object)asyncEntry.getProcessDefinitionId());
        Assert.assertNull((Object)asyncEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)asyncEntry.getProcessInstanceId());
        Assert.assertNull((Object)asyncEntry.getOrgValue());
        Assert.assertEquals((Object)"true", (Object)asyncEntry.getNewValue());
        UserOperationLogEntry numInstancesEntry = entries.get("nrOfInstances");
        Assert.assertNotNull((Object)numInstancesEntry);
        Assert.assertEquals((Object)"ProcessInstance", (Object)numInstancesEntry.getEntityType());
        Assert.assertEquals((Object)"SetExternalTaskRetries", (Object)numInstancesEntry.getOperationType());
        Assert.assertNull((Object)numInstancesEntry.getProcessDefinitionId());
        Assert.assertNull((Object)numInstancesEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)numInstancesEntry.getProcessInstanceId());
        Assert.assertNull((Object)numInstancesEntry.getOrgValue());
        Assert.assertEquals((Object)"6", (Object)numInstancesEntry.getNewValue());
        UserOperationLogEntry retriesEntry = entries.get("retries");
        Assert.assertNotNull((Object)retriesEntry);
        Assert.assertEquals((Object)"ProcessInstance", (Object)retriesEntry.getEntityType());
        Assert.assertEquals((Object)"SetExternalTaskRetries", (Object)retriesEntry.getOperationType());
        Assert.assertNull((Object)retriesEntry.getProcessDefinitionId());
        Assert.assertNull((Object)retriesEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)retriesEntry.getProcessInstanceId());
        Assert.assertNull((Object)retriesEntry.getOrgValue());
        Assert.assertEquals((Object)"5", (Object)retriesEntry.getNewValue());
        Assert.assertEquals((Object)asyncEntry.getOperationId(), (Object)retriesEntry.getOperationId());
    }

    protected Map<String, UserOperationLogEntry> asMap(List<UserOperationLogEntry> logEntries) {
        HashMap<String, UserOperationLogEntry> map = new HashMap<String, UserOperationLogEntry>();
        for (UserOperationLogEntry entry : logEntries) {
            UserOperationLogEntry previousValue = map.put(entry.getProperty(), entry);
            if (previousValue == null) continue;
            Assert.fail((String)"expected only entry for every property");
        }
        return map;
    }
}

