/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.common;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineServices;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ScriptTaskBuilder;
import org.camunda.bpm.model.bpmn.instance.Task;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.junit.Assert;

public abstract class AbstractProcessEngineServicesAccessTest
extends PluggableProcessEngineTestCase {
    private static final String TASK_DEF_KEY = "someTask";
    private static final String PROCESS_DEF_KEY = "testProcess";
    private static final String CALLED_PROCESS_DEF_ID = "calledProcess";
    protected List<String> deploymentIds = new ArrayList<String>();

    protected void tearDown() throws Exception {
        for (String deploymentId : this.deploymentIds) {
            this.repositoryService.deleteDeployment(deploymentId, true);
        }
        super.tearDown();
    }

    public void testServicesAccessible() {
        this.createAndDeployModelForClass(this.getTestServiceAccessibleClass());
        this.runtimeService.startProcessInstanceByKey(PROCESS_DEF_KEY);
    }

    public void testQueryAccessible() {
        this.createAndDeployModelForClass(this.getQueryClass());
        this.runtimeService.startProcessInstanceByKey(PROCESS_DEF_KEY);
    }

    public void testStartProcessInstance() {
        this.createAndDeployModelForClass(this.getStartProcessInstanceClass());
        this.deployModel(Bpmn.createExecutableProcess((String)CALLED_PROCESS_DEF_ID).startEvent().userTask(TASK_DEF_KEY).endEvent().done());
        this.runtimeService.startProcessInstanceByKey(PROCESS_DEF_KEY);
        AbstractProcessEngineServicesAccessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey(TASK_DEF_KEY).count());
    }

    public void testStartProcessInstanceFails() {
        this.createAndDeployModelForClass(this.getStartProcessInstanceClass());
        BpmnModelInstance modelInstance = ((ScriptTaskBuilder)((ScriptTaskBuilder)Bpmn.createExecutableProcess((String)CALLED_PROCESS_DEF_ID).startEvent().scriptTask("scriptTask").scriptFormat("groovy")).scriptText("throw new RuntimeException(\"BOOOM!\")")).endEvent().done();
        this.deployModel(modelInstance);
        try {
            this.runtimeService.startProcessInstanceByKey(PROCESS_DEF_KEY);
            AbstractProcessEngineServicesAccessTest.fail((String)"exception expected");
        }
        catch (RuntimeException e) {
            this.assertTextPresent("BOOOM", e.getMessage());
        }
        AbstractProcessEngineServicesAccessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
    }

    protected abstract Class<?> getTestServiceAccessibleClass();

    protected abstract Class<?> getQueryClass();

    protected abstract Class<?> getStartProcessInstanceClass();

    protected abstract Task createModelAccessTask(BpmnModelInstance var1, Class<?> var2);

    private void createAndDeployModelForClass(Class<?> delegateClass) {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)PROCESS_DEF_KEY).startEvent().manualTask("templateTask").endEvent().done();
        modelInstance.getModelElementById("templateTask").replaceWithElement((ModelElementInstance)this.createModelAccessTask(modelInstance, delegateClass));
        this.deployModel(modelInstance);
    }

    private void deployModel(BpmnModelInstance model) {
        Deployment deployment = this.repositoryService.createDeployment().addModelInstance("testProcess.bpmn", model).deploy();
        this.deploymentIds.add(deployment.getId());
    }

    public static void assertCanAccessServices(ProcessEngineServices services) {
        Assert.assertNotNull((Object)services.getAuthorizationService());
        Assert.assertNotNull((Object)services.getFormService());
        Assert.assertNotNull((Object)services.getHistoryService());
        Assert.assertNotNull((Object)services.getIdentityService());
        Assert.assertNotNull((Object)services.getManagementService());
        Assert.assertNotNull((Object)services.getRepositoryService());
        Assert.assertNotNull((Object)services.getRuntimeService());
        Assert.assertNotNull((Object)services.getTaskService());
    }

    public static void assertCanPerformQuery(ProcessEngineServices services) {
        services.getRepositoryService().createProcessDefinitionQuery().count();
    }

    public static void assertCanStartProcessInstance(ProcessEngineServices services) {
        services.getRuntimeService().startProcessInstanceByKey(CALLED_PROCESS_DEF_ID);
    }
}

