/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.el;

import java.util.HashMap;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.el.ExecutionTestVariable;

public class ExpressionManagerTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testMethodExpressions() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("aString", "abcdefgh");
        this.runtimeService.startProcessInstanceByKey("methodExpressionProcess", vars);
        ExpressionManagerTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("methodExpressionProcess").count());
    }

    @Deployment
    public void testExecutionAvailable() {
        HashMap<String, ExecutionTestVariable> vars = new HashMap<String, ExecutionTestVariable>();
        vars.put("myVar", new ExecutionTestVariable());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testExecutionAvailableProcess", vars);
        String value = (String)this.runtimeService.getVariable(processInstance.getId(), "testVar");
        ExpressionManagerTest.assertNotNull((Object)value);
        ExpressionManagerTest.assertEquals((String)"myValue", (String)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deployment
    public void testAuthenticatedUserIdAvailable() {
        try {
            this.identityService.setAuthenticatedUserId("frederik");
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testAuthenticatedUserIdAvailableProcess");
            String value = (String)this.runtimeService.getVariable(processInstance.getId(), "theUser");
            ExpressionManagerTest.assertNotNull((Object)value);
            ExpressionManagerTest.assertEquals((String)"frederik", (String)value);
        }
        finally {
            this.identityService.clearAuthentication();
        }
    }

    @Deployment
    public void testResolvesVariablesFromDifferentScopes() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("assignee", "michael");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        ExpressionManagerTest.assertEquals((String)"michael", (String)task.getAssignee());
        variables.put("assignee", "johnny");
        ProcessInstance secondInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        task = (Task)this.taskService.createTaskQuery().processInstanceId(secondInstance.getId()).singleResult();
        ExpressionManagerTest.assertEquals((String)"johnny", (String)task.getAssignee());
    }
}

