/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.tasklistener;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.tasklistener.util.RecorderTaskListener;
import org.camunda.bpm.engine.test.bpmn.tasklistener.util.TaskDeleteListener;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.CallActivityBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class TaskListenerTest {
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected HistoryService historyService;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    @Before
    public void setUp() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
        this.historyService = this.engineRule.getHistoryService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/tasklistener/TaskListenerTest.bpmn20.xml"})
    public void testTaskCreateListener() {
        this.runtimeService.startProcessInstanceByKey("taskListenerProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"Schedule meeting", (Object)task.getName());
        Assert.assertEquals((Object)"TaskCreateListener is listening!", (Object)task.getDescription());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/tasklistener/TaskListenerTest.bpmn20.xml"})
    public void testTaskCompleteListener() {
        TaskDeleteListener.clear();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("taskListenerProcess");
        Assert.assertEquals(null, (Object)this.runtimeService.getVariable(processInstance.getId(), "greeting"));
        Assert.assertEquals(null, (Object)this.runtimeService.getVariable(processInstance.getId(), "expressionValue"));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)0L, (long)TaskDeleteListener.eventCounter);
        Assert.assertNull((Object)TaskDeleteListener.lastTaskDefinitionKey);
        Assert.assertNull((Object)TaskDeleteListener.lastDeleteReason);
        Assert.assertEquals((Object)"Hello from The Process", (Object)this.runtimeService.getVariable(processInstance.getId(), "greeting"));
        Assert.assertEquals((Object)"Act", (Object)this.runtimeService.getVariable(processInstance.getId(), "shortName"));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/tasklistener/TaskListenerTest.bpmn20.xml"})
    public void testTaskDeleteListenerByProcessDeletion() {
        TaskDeleteListener.clear();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("taskListenerProcess");
        Assert.assertEquals((long)0L, (long)TaskDeleteListener.eventCounter);
        Assert.assertNull((Object)TaskDeleteListener.lastTaskDefinitionKey);
        Assert.assertNull((Object)TaskDeleteListener.lastDeleteReason);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.runtimeService.deleteProcessInstance(processInstance.getProcessInstanceId(), "test delete task listener");
        Assert.assertEquals((long)1L, (long)TaskDeleteListener.eventCounter);
        Assert.assertEquals((Object)task.getTaskDefinitionKey(), (Object)TaskDeleteListener.lastTaskDefinitionKey);
        Assert.assertEquals((Object)"test delete task listener", (Object)TaskDeleteListener.lastDeleteReason);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/tasklistener/TaskListenerTest.bpmn20.xml"})
    public void testTaskDeleteListenerByBoundaryEvent() {
        TaskDeleteListener.clear();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("taskListenerProcess");
        Assert.assertEquals((long)0L, (long)TaskDeleteListener.eventCounter);
        Assert.assertNull((Object)TaskDeleteListener.lastTaskDefinitionKey);
        Assert.assertNull((Object)TaskDeleteListener.lastDeleteReason);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.runtimeService.correlateMessage("message");
        Assert.assertEquals((long)1L, (long)TaskDeleteListener.eventCounter);
        Assert.assertEquals((Object)task.getTaskDefinitionKey(), (Object)TaskDeleteListener.lastTaskDefinitionKey);
        Assert.assertEquals((Object)"deleted", (Object)TaskDeleteListener.lastDeleteReason);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/tasklistener/TaskListenerTest.bpmn20.xml"})
    public void testTaskListenerWithExpression() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("taskListenerProcess");
        Assert.assertEquals(null, (Object)this.runtimeService.getVariable(processInstance.getId(), "greeting2"));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        Assert.assertEquals((Object)"Write meeting notes", (Object)this.runtimeService.getVariable(processInstance.getId(), "greeting2"));
    }

    @Test
    @Deployment
    public void testScriptListener() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(processInstance.getId(), "create")));
        this.taskService.setAssignee(task.getId(), "test");
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(processInstance.getId(), "assignment")));
        this.taskService.complete(task.getId());
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(processInstance.getId(), "complete")));
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("delete").singleResult();
            Assert.assertNotNull((Object)variable);
            Assert.assertTrue((boolean)((Boolean)variable.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/tasklistener/TaskListenerTest.testScriptResourceListener.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/tasklistener/taskListener.groovy"})
    public void testScriptResourceListener() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(processInstance.getId(), "create")));
        this.taskService.setAssignee(task.getId(), "test");
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(processInstance.getId(), "assignment")));
        this.taskService.complete(task.getId());
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(processInstance.getId(), "complete")));
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("delete").singleResult();
            Assert.assertNotNull((Object)variable);
            Assert.assertTrue((boolean)((Boolean)variable.getValue()));
        }
    }

    @Test
    public void testCompleteTaskInCreateTaskListener() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"startToEnd").startEvent().userTask().camundaTaskListenerClass("create", TaskCreateListener.class.getName())).name("userTask")).endEvent().done();
        this.testRule.deploy(modelInstance);
        this.runtimeService.startProcessInstanceByKey("startToEnd");
        Assert.assertNull((Object)this.taskService.createTaskQuery().singleResult());
    }

    @Test
    public void testCompleteTaskInCreateTaskListenerWithIdentityLinks() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"startToEnd").startEvent().userTask().camundaTaskListenerClass("create", TaskCreateListener.class.getName())).name("userTask")).camundaCandidateUsers(Arrays.asList("users1", "user2"))).camundaCandidateGroups(Arrays.asList("group1", "group2"))).endEvent().done();
        this.testRule.deploy(modelInstance);
        this.runtimeService.startProcessInstanceByKey("startToEnd");
        Assert.assertNull((Object)this.taskService.createTaskQuery().singleResult());
    }

    @Ignore(value="CAM-7562")
    @Test
    public void testActivityInstanceIdOnDeleteInCalledProcess() {
        RecorderTaskListener.clear();
        BpmnModelInstance callActivityProcess = ((CallActivityBuilder)Bpmn.createExecutableProcess((String)"calling").startEvent().callActivity().calledElement("called")).endEvent().done();
        BpmnModelInstance calledProcess = ((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"called").startEvent().userTask().camundaTaskListenerClass("create", RecorderTaskListener.class.getName())).camundaTaskListenerClass("delete", RecorderTaskListener.class.getName())).endEvent().done();
        this.testRule.deploy(callActivityProcess, calledProcess);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("calling");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
        List<RecorderTaskListener.RecordedTaskEvent> recordedEvents = RecorderTaskListener.getRecordedEvents();
        Assert.assertEquals((long)2L, (long)recordedEvents.size());
        String createActivityInstanceId = recordedEvents.get(0).getActivityInstanceId();
        String deleteActivityInstanceId = recordedEvents.get(1).getActivityInstanceId();
        Assert.assertEquals((Object)createActivityInstanceId, (Object)deleteActivityInstanceId);
    }

    @Ignore(value="CAM-7562")
    @Test
    public void testVariableAccessOnDeleteInCalledProcess() {
        VariablesCollectingListener.reset();
        BpmnModelInstance callActivityProcess = ((CallActivityBuilder)Bpmn.createExecutableProcess((String)"calling").startEvent().callActivity().calledElement("called")).endEvent().done();
        BpmnModelInstance calledProcess = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"called").startEvent().userTask().camundaTaskListenerClass("delete", VariablesCollectingListener.class.getName())).endEvent().done();
        this.testRule.deploy(callActivityProcess, calledProcess);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("calling", (Map)Variables.createVariables().putValue("foo", (Object)"bar"));
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
        VariableMap collectedVariables = VariablesCollectingListener.getCollectedVariables();
        Assert.assertNotNull((Object)collectedVariables);
        Assert.assertEquals((long)1L, (long)collectedVariables.size());
        Assert.assertEquals((Object)"bar", (Object)collectedVariables.get((Object)"foo"));
    }

    public static class VariablesCollectingListener
    implements TaskListener {
        protected static VariableMap collectedVariables;

        public static VariableMap getCollectedVariables() {
            return collectedVariables;
        }

        public static void reset() {
            collectedVariables = null;
        }

        public void notify(DelegateTask delegateTask) {
            collectedVariables = delegateTask.getVariablesTyped();
        }
    }

    public static class TaskCreateListener
    implements TaskListener {
        public void notify(DelegateTask delegateTask) {
            delegateTask.complete();
        }
    }
}

