/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cmd.SignalCmd;
import org.camunda.bpm.engine.impl.cmd.SuspendProcessDefinitionCmd;
import org.camunda.bpm.engine.impl.repository.UpdateProcessDefinitionSuspensionStateBuilderImpl;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.concurrency.ControllableThread;
import org.camunda.bpm.engine.test.concurrency.ControlledCommand;
import org.slf4j.Logger;

public class CompetingSuspensionTest
extends PluggableProcessEngineTestCase {
    private static Logger LOG = ProcessEngineLogger.TEST_LOGGER.getLogger();
    static ControllableThread activeThread;

    @Deployment
    public void testCompetingSuspension() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("CompetingSuspensionProcess").singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId()).activityId("wait1").singleResult();
        SuspendProcessDefinitionThread suspensionThread = new SuspendProcessDefinitionThread(processDefinition.getId());
        suspensionThread.startAndWaitUntilControlIsReturned();
        SignalThread signalExecutionThread = new SignalThread(execution.getId());
        signalExecutionThread.startAndWaitUntilControlIsReturned();
        suspensionThread.proceedAndWaitTillDone();
        CompetingSuspensionTest.assertNull((Object)((Object)suspensionThread.exception));
        signalExecutionThread.proceedAndWaitTillDone();
        CompetingSuspensionTest.assertNotNull((Object)((Object)signalExecutionThread.exception));
    }

    class SignalThread
    extends ControllableThread {
        private String executionId;
        OptimisticLockingException exception;

        public SignalThread(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public synchronized void startAndWaitUntilControlIsReturned() {
            activeThread = this;
            super.startAndWaitUntilControlIsReturned();
        }

        @Override
        public void run() {
            try {
                CompetingSuspensionTest.this.processEngineConfiguration.getCommandExecutorTxRequired().execute(new ControlledCommand(activeThread, new SignalCmd(this.executionId, null, null, null)));
            }
            catch (OptimisticLockingException e) {
                this.exception = e;
            }
            LOG.debug(this.getName() + " ends");
        }
    }

    class SuspendProcessDefinitionThread
    extends ControllableThread {
        private String processDefinitionId;
        OptimisticLockingException exception;

        public SuspendProcessDefinitionThread(String processDefinitionId) {
            this.processDefinitionId = processDefinitionId;
        }

        @Override
        public synchronized void startAndWaitUntilControlIsReturned() {
            activeThread = this;
            super.startAndWaitUntilControlIsReturned();
        }

        @Override
        public void run() {
            try {
                CompetingSuspensionTest.this.processEngineConfiguration.getCommandExecutorTxRequired().execute(new ControlledCommand(activeThread, this.createSuspendCommand()));
            }
            catch (OptimisticLockingException e) {
                this.exception = e;
            }
            LOG.debug(this.getName() + " ends");
        }

        protected SuspendProcessDefinitionCmd createSuspendCommand() {
            UpdateProcessDefinitionSuspensionStateBuilderImpl builder = new UpdateProcessDefinitionSuspensionStateBuilderImpl().byProcessDefinitionId(this.processDefinitionId).includeProcessInstances(true);
            return new SuspendProcessDefinitionCmd(builder);
        }
    }
}

