/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history.useroperationlog;

import org.camunda.bpm.engine.history.UserOperationLogQuery;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class UserOperationLogWithoutUserTest
extends PluggableProcessEngineTestCase {
    protected static final String PROCESS_PATH = "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml";
    protected static final String PROCESS_KEY = "oneTaskProcess";

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testCompleteTask() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        this.verifyNoUserOperationLogged();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testAssignTask() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setAssignee(taskId, "demo");
        this.verifyNoUserOperationLogged();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testClaimTask() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.claim(taskId, "demo");
        this.verifyNoUserOperationLogged();
    }

    public void testCreateTask() {
        Task task = this.taskService.newTask("a-task-id");
        this.taskService.saveTask(task);
        this.verifyNoUserOperationLogged();
        this.taskService.deleteTask("a-task-id", true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testDelegateTask() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.delegateTask(taskId, "demo");
        this.verifyNoUserOperationLogged();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testResolveTask() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.resolveTask(taskId);
        this.verifyNoUserOperationLogged();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSetOwnerTask() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setOwner(taskId, "demo");
        this.verifyNoUserOperationLogged();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSetPriorityTask() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setPriority(taskId, 60);
        this.verifyNoUserOperationLogged();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testUpdateTask() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        task.setCaseInstanceId("a-case-instance-id");
        this.taskService.saveTask(task);
        this.verifyNoUserOperationLogged();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testActivateProcessInstance() {
        String id = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.runtimeService.activateProcessInstanceById(id);
        this.verifyNoUserOperationLogged();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSuspendProcessInstance() {
        String id = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.runtimeService.suspendProcessInstanceById(id);
        this.verifyNoUserOperationLogged();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testActivateJobDefinition() {
        this.runtimeService.startProcessInstanceByKey("oneFailingServiceTaskProcess");
        String id = ((JobDefinition)this.managementService.createJobDefinitionQuery().singleResult()).getId();
        this.managementService.activateJobByJobDefinitionId(id);
        this.verifyNoUserOperationLogged();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testSuspendJobDefinition() {
        this.runtimeService.startProcessInstanceByKey("oneFailingServiceTaskProcess");
        String id = ((JobDefinition)this.managementService.createJobDefinitionQuery().singleResult()).getId();
        this.managementService.suspendJobByJobDefinitionId(id);
        this.verifyNoUserOperationLogged();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testActivateJob() {
        this.runtimeService.startProcessInstanceByKey("oneFailingServiceTaskProcess");
        String id = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.activateJobById(id);
        this.verifyNoUserOperationLogged();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testSuspendJob() {
        this.runtimeService.startProcessInstanceByKey("oneFailingServiceTaskProcess");
        String id = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.suspendJobById(id);
        this.verifyNoUserOperationLogged();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testSetJobRetries() {
        this.runtimeService.startProcessInstanceByKey("oneFailingServiceTaskProcess");
        String id = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(id, 5);
        this.verifyNoUserOperationLogged();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testActivateProcessDefinition() {
        this.repositoryService.activateProcessDefinitionByKey(PROCESS_KEY);
        this.verifyNoUserOperationLogged();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSuspendProcessDefinition() {
        this.repositoryService.suspendProcessDefinitionByKey(PROCESS_KEY);
        this.verifyNoUserOperationLogged();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testModifyProcessInstance() {
        String id = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.runtimeService.createProcessInstanceModification(id).cancelAllForActivity("theTask").execute();
        this.verifyNoUserOperationLogged();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSetVariable() {
        String id = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.runtimeService.setVariable(id, "aVariable", (Object)"aValue");
        this.verifyNoUserOperationLogged();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testRemoveVariable() {
        String id = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.runtimeService.setVariable(id, "aVariable", (Object)"aValue");
        this.runtimeService.removeVariable(id, "aVariable");
        this.verifyNoUserOperationLogged();
    }

    protected void verifyNoUserOperationLogged() {
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        UserOperationLogWithoutUserTest.assertEquals((long)0L, (long)query.count());
    }
}

