/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.charset.Charset;
import org.camunda.bpm.engine.impl.digest._apacheCommonsCodec.Base64;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.ObjectValue;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.junit.Assert;

public class TypedValueAssert {
    public static void assertObjectValueDeserializedNull(ObjectValue typedValue) {
        Assert.assertNotNull((Object)typedValue);
        Assert.assertTrue((boolean)typedValue.isDeserialized());
        Assert.assertNotNull((Object)typedValue.getSerializationDataFormat());
        Assert.assertNull((Object)typedValue.getValue());
        Assert.assertNull((Object)typedValue.getValueSerialized());
        Assert.assertNull((Object)typedValue.getObjectType());
        Assert.assertNull((Object)typedValue.getObjectTypeName());
    }

    public static void assertObjectValueSerializedNull(ObjectValue typedValue) {
        Assert.assertNotNull((Object)typedValue);
        Assert.assertFalse((boolean)typedValue.isDeserialized());
        Assert.assertNotNull((Object)typedValue.getSerializationDataFormat());
        Assert.assertNull((Object)typedValue.getValueSerialized());
        Assert.assertNull((Object)typedValue.getObjectTypeName());
    }

    public static void assertObjectValueDeserialized(ObjectValue typedValue, Object value) {
        Class<?> expectedObjectType = value.getClass();
        Assert.assertTrue((boolean)typedValue.isDeserialized());
        Assert.assertEquals((Object)ValueType.OBJECT, (Object)typedValue.getType());
        Assert.assertEquals((Object)value, (Object)typedValue.getValue());
        Assert.assertEquals((Object)value, (Object)typedValue.getValue(expectedObjectType));
        Assert.assertEquals(expectedObjectType, (Object)typedValue.getObjectType());
        Assert.assertEquals((Object)expectedObjectType.getName(), (Object)typedValue.getObjectTypeName());
    }

    public static void assertObjectValueSerializedJava(ObjectValue typedValue, Object value) {
        Assert.assertEquals((Object)Variables.SerializationDataFormats.JAVA.getName(), (Object)typedValue.getSerializationDataFormat());
        try {
            String valueSerialized = typedValue.getValueSerialized();
            byte[] decodedObject = Base64.decodeBase64((byte[])valueSerialized.getBytes(Charset.forName("UTF-8")));
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(decodedObject));
            Assert.assertEquals((Object)value, (Object)objectInputStream.readObject());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static void assertUntypedNullValue(TypedValue nullValue) {
        Assert.assertNotNull((Object)nullValue);
        Assert.assertNull((Object)nullValue.getValue());
        Assert.assertEquals((Object)ValueType.NULL, (Object)nullValue.getType());
    }
}

