/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization;

import java.util.Collections;
import java.util.Map;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.management.TableMetaData;
import org.camunda.bpm.engine.management.TablePage;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;

public class ManagementAuthorizationTest
extends AuthorizationTest {
    public void testGetTableCountWithoutAuthorization() {
        try {
            this.managementService.getTableCount();
            ManagementAuthorizationTest.fail((String)"Exception expected: It should not be possible to get the table count");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent("ENGINE-03029 Required authenticated group 'camunda-admin'", message);
        }
    }

    public void testGetTableCountAsCamundaAdmin() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        Map tableCount = this.managementService.getTableCount();
        ManagementAuthorizationTest.assertFalse((boolean)tableCount.isEmpty());
    }

    public void testGetTableNameWithoutAuthorization() {
        try {
            this.managementService.getTableName(ProcessDefinitionEntity.class);
            ManagementAuthorizationTest.fail((String)"Exception expected: It should not be possible to get the table name");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent("ENGINE-03029 Required authenticated group 'camunda-admin'", message);
        }
    }

    public void testGetTableNameAsCamundaAdmin() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        String tablePrefix = this.processEngineConfiguration.getDatabaseTablePrefix();
        String tableName = this.managementService.getTableName(ProcessDefinitionEntity.class);
        ManagementAuthorizationTest.assertEquals((String)(tablePrefix + "ACT_RE_PROCDEF"), (String)tableName);
    }

    public void testGetTableMetaDataWithoutAuthorization() {
        try {
            this.managementService.getTableMetaData("ACT_RE_PROCDEF");
            ManagementAuthorizationTest.fail((String)"Exception expected: It should not be possible to get the table meta data");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent("ENGINE-03029 Required authenticated group 'camunda-admin'", message);
        }
    }

    public void testGetTableMetaDataAsCamundaAdmin() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        TableMetaData tableMetaData = this.managementService.getTableMetaData("ACT_RE_PROCDEF");
        ManagementAuthorizationTest.assertNotNull((Object)tableMetaData);
    }

    public void testTablePageQueryWithoutAuthorization() {
        try {
            this.managementService.createTablePageQuery().tableName("ACT_RE_PROCDEF").listPage(0, Integer.MAX_VALUE);
            ManagementAuthorizationTest.fail((String)"Exception expected: It should not be possible to get a table page");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent("ENGINE-03029 Required authenticated group 'camunda-admin'", message);
        }
    }

    public void testTablePageQueryAsCamundaAdmin() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        String tablePrefix = this.processEngineConfiguration.getDatabaseTablePrefix();
        TablePage page = this.managementService.createTablePageQuery().tableName(tablePrefix + "ACT_RE_PROCDEF").listPage(0, Integer.MAX_VALUE);
        ManagementAuthorizationTest.assertNotNull((Object)page);
    }

    public void testGetHistoryLevelWithoutAuthorization() {
        try {
            this.managementService.getHistoryLevel();
            ManagementAuthorizationTest.fail((String)"Exception expected: It should not be possible to get the history level");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent("ENGINE-03029 Required authenticated group 'camunda-admin'", message);
        }
    }

    public void testGetHistoryLevelAsCamundaAdmin() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        int historyLevel = this.managementService.getHistoryLevel();
        ManagementAuthorizationTest.assertEquals((int)this.processEngineConfiguration.getHistoryLevel().getId(), (int)historyLevel);
    }

    public void testDataSchemaUpgradeWithoutAuthorization() {
        try {
            this.managementService.databaseSchemaUpgrade(null, null, null);
            ManagementAuthorizationTest.fail((String)"Exception expected: It should not be possible to upgrade the database schema");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent("ENGINE-03029 Required authenticated group 'camunda-admin'", message);
        }
    }
}

