/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.externaltask;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.externaltask.ExternalTaskQuery;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationSpec;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ExternalTaskModels;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SetExternalTasksRetriesBatchAuthorizationTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule).around((TestRule)this.testRule);
    @Parameterized.Parameter
    public AuthorizationScenario scenario;

    @Parameterized.Parameters(name="Scenario {index}")
    public static Collection<AuthorizationScenario[]> scenarios() {
        return AuthorizationTestRule.asParameters(AuthorizationScenario.scenario().withoutAuthorizations().failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.BATCH, "batchId", "userId", new Permission[]{Permissions.CREATE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.BATCH, "batchId", "userId", new Permission[]{Permissions.CREATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "processDefinition", "userId", new Permission[]{Permissions.UPDATE_INSTANCE})).succeeds(), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.BATCH, "batchId", "userId", new Permission[]{Permissions.CREATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstance1", "userId", new Permission[]{Permissions.UPDATE})).succeeds(), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.BATCH, "batchId", "userId", new Permission[]{Permissions.CREATE})).failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "processDefinition", "userId", new Permission[]{Permissions.UPDATE_INSTANCE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstance1", "userId", new Permission[]{Permissions.UPDATE})));
    }

    @Before
    public void setUp() {
        this.authRule.createUserAndGroup("userId", "groupId");
    }

    @After
    public void tearDown() {
        this.authRule.deleteUsersAndGroups();
    }

    @After
    public void cleanBatch() {
        HistoricBatch historicBatch;
        Batch batch = (Batch)this.engineRule.getManagementService().createBatchQuery().singleResult();
        if (batch != null) {
            this.engineRule.getManagementService().deleteBatch(batch.getId(), true);
        }
        if ((historicBatch = (HistoricBatch)this.engineRule.getHistoryService().createHistoricBatchQuery().singleResult()) != null) {
            this.engineRule.getHistoryService().deleteHistoricBatch(historicBatch.getId());
        }
    }

    @Test
    public void testSetRetriesAsync() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ExternalTaskModels.ONE_EXTERNAL_TASK_PROCESS);
        ProcessInstance processInstance1 = this.engineRule.getRuntimeService().startProcessInstanceByKey("Process");
        List externalTasks = this.engineRule.getExternalTaskService().createExternalTaskQuery().list();
        ArrayList<String> externalTaskIds = new ArrayList<String>();
        for (ExternalTask task : externalTasks) {
            externalTaskIds.add(task.getId());
        }
        this.authRule.init(this.scenario).withUser("userId").bindResource("batchId", "*").bindResource("processInstance1", processInstance1.getId()).bindResource("processDefinition", processDefinition.getKey()).start();
        Batch batch = this.engineRule.getExternalTaskService().setRetriesAsync(externalTaskIds, null, 5);
        if (batch != null) {
            this.executeSeedAndBatchJobs(batch);
        }
        if (this.authRule.assertScenario(this.scenario)) {
            externalTasks = this.engineRule.getExternalTaskService().createExternalTaskQuery().list();
            for (ExternalTask task : externalTasks) {
                Assert.assertEquals((long)5L, (long)task.getRetries().intValue());
            }
        }
    }

    @Test
    public void testSetRetriesWithQueryAsync() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ExternalTaskModels.ONE_EXTERNAL_TASK_PROCESS);
        ProcessInstance processInstance1 = this.engineRule.getRuntimeService().startProcessInstanceByKey("Process");
        ExternalTaskQuery externalTaskQuery = this.engineRule.getExternalTaskService().createExternalTaskQuery();
        this.authRule.init(this.scenario).withUser("userId").bindResource("batchId", "*").bindResource("processInstance1", processInstance1.getId()).bindResource("processDefinition", processDefinition.getKey()).start();
        Batch batch = this.engineRule.getExternalTaskService().setRetriesAsync(null, externalTaskQuery, 5);
        if (batch != null) {
            this.executeSeedAndBatchJobs(batch);
        }
        if (this.authRule.assertScenario(this.scenario)) {
            List externalTasks = this.engineRule.getExternalTaskService().createExternalTaskQuery().list();
            for (ExternalTask task : externalTasks) {
                Assert.assertEquals((long)5L, (long)task.getRetries().intValue());
            }
        }
    }

    public void executeSeedAndBatchJobs(Batch batch) {
        Job job = (Job)this.engineRule.getManagementService().createJobQuery().jobDefinitionId(batch.getSeedJobDefinitionId()).singleResult();
        this.engineRule.getManagementService().executeJob(job.getId());
        for (Job pending : this.engineRule.getManagementService().createJobQuery().jobDefinitionId(batch.getBatchJobDefinitionId()).list()) {
            this.engineRule.getManagementService().executeJob(pending.getId());
        }
    }
}

