/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.form;

import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.form.FormProperty;
import org.camunda.bpm.engine.form.StartFormData;
import org.camunda.bpm.engine.form.TaskFormData;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class FormPropertyDefaultValueTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testDefaultValue() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("FormPropertyDefaultValueTest.testDefaultValue");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        TaskFormData formData = this.formService.getTaskFormData(task.getId());
        List formProperties = formData.getFormProperties();
        FormPropertyDefaultValueTest.assertEquals((int)4, (int)formProperties.size());
        for (FormProperty prop : formProperties) {
            if ("booleanProperty".equals(prop.getId())) {
                FormPropertyDefaultValueTest.assertEquals((String)"true", (String)prop.getValue());
                continue;
            }
            if ("stringProperty".equals(prop.getId())) {
                FormPropertyDefaultValueTest.assertEquals((String)"someString", (String)prop.getValue());
                continue;
            }
            if ("longProperty".equals(prop.getId())) {
                FormPropertyDefaultValueTest.assertEquals((String)"42", (String)prop.getValue());
                continue;
            }
            if ("longExpressionProperty".equals(prop.getId())) {
                FormPropertyDefaultValueTest.assertEquals((String)"23", (String)prop.getValue());
                continue;
            }
            FormPropertyDefaultValueTest.assertTrue((String)("Invalid form property: " + prop.getId()), (boolean)false);
        }
        HashMap<String, String> formDataUpdate = new HashMap<String, String>();
        formDataUpdate.put("longExpressionProperty", "1");
        formDataUpdate.put("booleanProperty", "false");
        this.formService.submitTaskFormData(task.getId(), formDataUpdate);
        FormPropertyDefaultValueTest.assertEquals((Object)false, (Object)this.runtimeService.getVariable(processInstance.getId(), "booleanProperty"));
        FormPropertyDefaultValueTest.assertEquals((Object)"someString", (Object)this.runtimeService.getVariable(processInstance.getId(), "stringProperty"));
        FormPropertyDefaultValueTest.assertEquals((Object)42L, (Object)this.runtimeService.getVariable(processInstance.getId(), "longProperty"));
        FormPropertyDefaultValueTest.assertEquals((Object)1L, (Object)this.runtimeService.getVariable(processInstance.getId(), "longExpressionProperty"));
    }

    @Deployment
    public void testStartFormDefaultValue() throws Exception {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("FormPropertyDefaultValueTest.testDefaultValue").latestVersion().singleResult()).getId();
        StartFormData startForm = this.formService.getStartFormData(processDefinitionId);
        List formProperties = startForm.getFormProperties();
        FormPropertyDefaultValueTest.assertEquals((int)4, (int)formProperties.size());
        for (FormProperty prop : formProperties) {
            if ("booleanProperty".equals(prop.getId())) {
                FormPropertyDefaultValueTest.assertEquals((String)"true", (String)prop.getValue());
                continue;
            }
            if ("stringProperty".equals(prop.getId())) {
                FormPropertyDefaultValueTest.assertEquals((String)"someString", (String)prop.getValue());
                continue;
            }
            if ("longProperty".equals(prop.getId())) {
                FormPropertyDefaultValueTest.assertEquals((String)"42", (String)prop.getValue());
                continue;
            }
            if ("longExpressionProperty".equals(prop.getId())) {
                FormPropertyDefaultValueTest.assertEquals((String)"23", (String)prop.getValue());
                continue;
            }
            FormPropertyDefaultValueTest.assertTrue((String)("Invalid form property: " + prop.getId()), (boolean)false);
        }
        HashMap<String, String> formDataUpdate = new HashMap<String, String>();
        formDataUpdate.put("longExpressionProperty", "1");
        formDataUpdate.put("booleanProperty", "false");
        ProcessInstance processInstance = this.formService.submitStartFormData(processDefinitionId, formDataUpdate);
        FormPropertyDefaultValueTest.assertEquals((Object)false, (Object)this.runtimeService.getVariable(processInstance.getId(), "booleanProperty"));
        FormPropertyDefaultValueTest.assertEquals((Object)"someString", (Object)this.runtimeService.getVariable(processInstance.getId(), "stringProperty"));
        FormPropertyDefaultValueTest.assertEquals((Object)42L, (Object)this.runtimeService.getVariable(processInstance.getId(), "longProperty"));
        FormPropertyDefaultValueTest.assertEquals((Object)1L, (Object)this.runtimeService.getVariable(processInstance.getId(), "longExpressionProperty"));
    }
}

