/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt.metrics;

import java.util.Collection;
import java.util.Date;
import java.util.Random;
import java.util.Set;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.metrics.Meter;
import org.camunda.bpm.engine.impl.metrics.MetricsRegistry;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.joda.time.DateTime;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public abstract class AbstractMetricsIntervalTest {
    protected final ProcessEngineRule ENGINE_RULE = new ProvidedProcessEngineRule();
    protected final ProcessEngineTestRule TEST_RULE = new ProcessEngineTestRule(this.ENGINE_RULE);
    protected final String REPORTER_ID = "REPORTER_ID";
    protected static final int DEFAULT_INTERVAL = 15;
    protected static final int DEFAULT_INTERVAL_MILLIS = 900000;
    protected static final int MIN_OCCURENCE = 1;
    protected static final int MAX_OCCURENCE = 250;
    @Rule
    public RuleChain RULE_CHAIN = RuleChain.outerRule((TestRule)this.ENGINE_RULE).around((TestRule)this.TEST_RULE);
    @Rule
    public final ExpectedException exception = ExpectedException.none();
    protected RuntimeService runtimeService;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected ManagementService managementService;
    protected String lastReporterId;
    protected DateTime firstInterval;
    protected int metricsCount;
    protected MetricsRegistry metricsRegistry;
    protected Random rand;

    private void generateMeterData(long dataCount, long interval) {
        Set metricNames = this.metricsRegistry.getMeters().keySet();
        this.metricsCount = metricNames.size();
        long startDate = 900000L;
        this.firstInterval = new DateTime(startDate);
        int dataPerInterval = 5;
        int i = 0;
        while ((long)i < dataCount) {
            long diff = interval / (long)dataPerInterval;
            for (int j = 0; j < dataPerInterval; ++j) {
                ClockUtil.setCurrentTime((Date)new Date(startDate));
                this.reportMetrics();
                startDate += diff;
            }
            ++i;
        }
    }

    protected void reportMetrics() {
        for (String metricName : this.metricsRegistry.getMeters().keySet()) {
            long occurence = this.rand.nextInt(250) + 1;
            this.metricsRegistry.markOccurrence(metricName, occurence);
        }
        this.processEngineConfiguration.getDbMetricsReporter().reportNow();
    }

    protected void clearMetrics() {
        this.clearLocalMetrics();
        this.managementService.deleteMetrics(null);
    }

    protected void clearLocalMetrics() {
        Collection meters = this.processEngineConfiguration.getMetricsRegistry().getMeters().values();
        for (Meter meter : meters) {
            meter.getAndClear();
        }
    }

    @Before
    public void initMetrics() throws Exception {
        this.runtimeService = this.ENGINE_RULE.getRuntimeService();
        this.processEngineConfiguration = this.ENGINE_RULE.getProcessEngineConfiguration();
        this.managementService = this.ENGINE_RULE.getManagementService();
        this.clearMetrics();
        this.processEngineConfiguration.setDbMetricsReporterActivate(true);
        this.lastReporterId = this.processEngineConfiguration.getDbMetricsReporter().getMetricsCollectionTask().getReporter();
        this.processEngineConfiguration.getDbMetricsReporter().setReporterId("REPORTER_ID");
        this.metricsRegistry = this.processEngineConfiguration.getMetricsRegistry();
        this.rand = new Random(new Date().getTime());
        this.generateMeterData(3L, 900000L);
    }

    @After
    public void cleanUp() {
        ClockUtil.reset();
        this.processEngineConfiguration.setDbMetricsReporterActivate(false);
        this.processEngineConfiguration.getDbMetricsReporter().setReporterId(this.lastReporterId);
        this.clearMetrics();
    }
}

